/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.stomp.port.eventcenter;

import com.tplink.smb.eventcenter.api.Event;
import com.tplink.smb.eventcenter.api.EventCenter;
import com.tplink.smb.eventcenter.api.EventHandler;
import com.tplink.smb.eventcenter.api.util.JsonUtils;
import com.tplink.smb.omada.apigateway.cache.OmadacMacFormatCache;
import com.tplink.smb.omada.global.subsystem.api.internal.dto.event.GlobalSettingMacFormatChangedDTO;
import jakarta.annotation.PostConstruct;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class OmadacMacFormatUpdateEventSubscriber
implements EventHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OmadacMacFormatUpdateEventSubscriber.class);
    public static final String MAC_FORMAT_EVENT_FILTER = "macformat";
    @Autowired
    private OmadacMacFormatCache macFormatCache;
    @Autowired
    private EventCenter eventCenter;
    @Qualifier(value="macFormatEventWorkGroup")
    @Autowired
    private ExecutorService macFormatEventWorkGroup;

    @PostConstruct
    public void register() {
        log.info("Register topic {} for {}.", (Object)"omadacentral.settings.organization.event", (Object)this.getClass().getName());
        this.eventCenter.registerBroadcast("omadacentral.settings.organization.event", (EventHandler)this, this.macFormatEventWorkGroup);
    }

    public void handleEvent(Event event) {
        if (Objects.equals(event.getFilterKey(), MAC_FORMAT_EVENT_FILTER)) {
            log.debug("clear omada type cache by mac format event dto {} ", (Object)event);
            GlobalSettingMacFormatChangedDTO result = (GlobalSettingMacFormatChangedDTO)JsonUtils.json2bean((String)((String)event.getMessage()), GlobalSettingMacFormatChangedDTO.class);
            if (Objects.isNull(result) || Objects.isNull(result.getCentralId())) {
                log.error("clear omada type cache by mac format event dto error {} ", (Object)event);
                return;
            }
            this.macFormatCache.setMacFormat(result.getCentralId(), result.getNewMacFormat());
        }
    }
}

