/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.stomp.port.eventcenter;

import com.tplink.smb.eventcenter.api.Event;
import com.tplink.smb.eventcenter.api.EventCenter;
import com.tplink.smb.eventcenter.api.EventHandler;
import com.tplink.smb.omada.apigateway.dispatch.cache.IpAccessCache;
import com.tplink.smb.omada.apigateway.dispatch.configuration.EventCenterProperties;
import com.tplink.smb.omada.apigateway.dispatch.stomp.port.eventcenter.dto.IPAccessRuleEventDTO;
import com.tplink.smb.omada.common.concurrent.thread.b;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.x;
import jakarta.annotation.PostConstruct;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class IpAccessEventSubscriber
implements EventHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IpAccessEventSubscriber.class);
    private static final String OMADA_API_GATEWAY_GROUP = "api-gateway-ip-access-group";
    @Autowired
    private IpAccessCache ipAccessCache;
    @Autowired
    private EventCenter eventCenter;
    @Autowired
    private EventCenterProperties eventCenterProperties;

    @PostConstruct
    public void register() {
        String businessGroupIdPrefix = this.eventCenterProperties.getBusinessGroupIdPrefix();
        String groupId = businessGroupIdPrefix + "-api-gateway-ip-access-group";
        String commonBusinessTopicPrefix = this.eventCenterProperties.getCommonBusinessTopicPrefix();
        Object topic = "omadacentral.settings.ipaccessrule.event";
        if (!T.c((String)commonBusinessTopicPrefix)) {
            topic = commonBusinessTopicPrefix + "omadacentral.settings.ipaccessrule.event";
        }
        log.info("Register topic {} with groupId {} for {}.", new Object[]{topic, groupId, this.getClass().getName()});
        this.eventCenter.registerUnicast((String)topic, groupId, (EventHandler)this, b.e());
    }

    public void handleEvent(Event event) {
        IPAccessRuleEventDTO result = (IPAccessRuleEventDTO)x.a((String)((String)event.getMessage()), IPAccessRuleEventDTO.class);
        if (Objects.isNull(result) || CollectionUtils.isEmpty(result.getCentralIdList())) {
            log.error("clear ip access rule cache by event dto error {} ", (Object)event);
            return;
        }
        List<String> idList = result.getCentralIdList();
        for (String id : idList) {
            String omadacId = id.toString();
            this.ipAccessCache.remove(omadacId);
        }
    }
}

