/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.stomp.port.cache;

import com.tplink.smb.omada.common.util.T;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.socket.WebSocketSession;

public class StompSessionCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StompSessionCache.class);
    private static final Map<String, List<String>> HTTP_ID_INDEX = new ConcurrentHashMap<String, List<String>>();
    private static final Map<String, WebSocketSession> SESSION_MAP = new ConcurrentHashMap<String, WebSocketSession>();
    private static final Map<String, List<String>> SESSION_MAC = new ConcurrentHashMap<String, List<String>>();

    public static void addSession(String httpSessionId, WebSocketSession wsSession) {
        if (T.a((String)httpSessionId) || wsSession == null) {
            return;
        }
        Object omadacId = wsSession.getAttributes().get("TP_OMADAC_ID");
        if (omadacId == null) {
            return;
        }
        List list = HTTP_ID_INDEX.computeIfAbsent(httpSessionId, k -> new CopyOnWriteArrayList());
        list.add(wsSession.getId());
        SESSION_MAP.put(wsSession.getId(), wsSession);
    }

    @Nullable
    public static WebSocketSession getSession(String wsSessionId) {
        return SESSION_MAP.get(wsSessionId);
    }

    public static void removeSession(String wsSessionId, boolean closeSession) {
        WebSocketSession wsSession = SESSION_MAP.remove(wsSessionId);
        if (wsSession == null) {
            return;
        }
        StompSessionCache.removeMacList(wsSessionId);
        String httpSessionId = (String)wsSession.getAttributes().get("TP_SESSION_ID");
        HTTP_ID_INDEX.computeIfPresent(httpSessionId, (k, list) -> {
            list.remove(wsSession.getId());
            return list;
        });
        if (closeSession) {
            StompSessionCache.closeSession(wsSession);
        }
    }

    public static void removeAndCloseSessionByHttpSessionId(String httpSessionId) {
        if (T.a((String)httpSessionId)) {
            return;
        }
        List<String> sessionIdList = HTTP_ID_INDEX.remove(httpSessionId);
        if (CollectionUtils.isEmpty(sessionIdList)) {
            return;
        }
        for (String wsSessionId : sessionIdList) {
            WebSocketSession wsSession = SESSION_MAP.remove(wsSessionId);
            StompSessionCache.closeSession(wsSession);
        }
        sessionIdList.clear();
    }

    public static void removeAndCloseSessionByOmadacId(String omadacId) {
        Iterator<WebSocketSession> iterator = SESSION_MAP.values().iterator();
        while (iterator.hasNext()) {
            WebSocketSession webSocketSession = iterator.next();
            Object omadacIdInSession = webSocketSession.getAttributes().get("TP_OMADAC_ID");
            if (omadacIdInSession == null || !Objects.equals(omadacId, omadacIdInSession)) continue;
            iterator.remove();
            StompSessionCache.closeSession(webSocketSession);
        }
    }

    public static void limit(String httpSessionId, int limit) {
        String wsSessionId;
        List<String> list = HTTP_ID_INDEX.get(httpSessionId);
        if (list == null) {
            return;
        }
        if (list.size() >= limit && (wsSessionId = list.remove(0)) != null) {
            log.debug("<STOMP> remove oldest WebSocketSession {}, httpSessionId={}", (Object)wsSessionId, (Object)httpSessionId);
            WebSocketSession wsSession = SESSION_MAP.remove(wsSessionId);
            StompSessionCache.closeSession(wsSession);
        }
    }

    private static void closeSession(@Nullable WebSocketSession session) {
        if (session == null || !session.isOpen()) {
            return;
        }
        try {
            session.close();
        }
        catch (IOException e) {
            log.error(e.toString(), (Throwable)e);
        }
    }

    public static void putMacList(String wsSessionId, List<String> macList) {
        if (T.a((String)wsSessionId) || macList == null || macList.isEmpty()) {
            return;
        }
        SESSION_MAC.put(wsSessionId, macList);
    }

    public static List<String> getMacList(String wsSessionId) {
        if (T.a((String)wsSessionId)) {
            return Collections.EMPTY_LIST;
        }
        return SESSION_MAC.get(wsSessionId);
    }

    public static void removeMacList(String wsSessionId) {
        if (T.a((String)wsSessionId)) {
            return;
        }
        SESSION_MAC.remove(wsSessionId);
    }

    @Generated
    private StompSessionCache() {
    }
}

