/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.stomp.interceptor.outbound;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tplink.smb.omada.apigateway.dispatch.stomp.dto.StompMessageDTO;
import com.tplink.smb.omada.apigateway.dispatch.stomp.port.cache.StompSessionCache;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.k;
import com.tplink.smb.omada.common.q.a;
import com.tplink.smb.omada.common.q.c;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.identityaccess.api.internal.dto.CurrentDetailDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.GetCurrentInfoDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.RoleDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.UserDTO;
import com.tplink.smb.omada.identityaccess.api.internal.g;
import com.tplink.smb.omada.identityaccess.api.shared.RoleEnumDTO;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.SimpMessageType;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.GenericMessage;
import org.springframework.util.CollectionUtils;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.util.UriTemplate;

public class MessageOutboundInterceptor
implements ChannelInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageOutboundInterceptor.class);
    private final UriTemplate siteUriTemplate = new UriTemplate(a.l);
    private final UriTemplate omadacUriTemplate = new UriTemplate(a.g);
    private final UriTemplate globalUriTemplate = new UriTemplate(a.k);
    private final UriTemplate mspUriTemplate = new UriTemplate(a.h);
    private final UriTemplate globalUserQueueUriTemplate = new UriTemplate(a.j);
    private final UriTemplate siteToolsUriTemplate = new UriTemplate(a.n);
    private ObjectMapper objectMapper;
    private g identityAccessService;

    public Message<?> preSend(@Nonnull Message<?> message, MessageChannel channel) {
        log.debug("<STOMP> preSend");
        StompHeaderAccessor accessor = StompHeaderAccessor.wrap(message);
        SimpMessageType messageType = accessor.getMessageType();
        if (messageType == null) {
            log.error("<STOMP> send message fail. messageType is null");
            return null;
        }
        if (messageType != SimpMessageType.MESSAGE || Objects.equals(accessor.getCommand(), StompCommand.SEND)) {
            log.debug("<STOMP> message type is {}, no send", (Object)messageType.name());
            return message;
        }
        WebSocketSession wsSession = StompSessionCache.getSession(accessor.getSessionId());
        if (wsSession == null || !wsSession.isOpen()) {
            log.warn("<STOMP> send message fail. wsSession is null or is closed");
            return null;
        }
        String omadacId = (String)wsSession.getAttributes().get("TP_OMADAC_ID");
        String httpSessionId = (String)wsSession.getAttributes().get("TP_SESSION_ID");
        if (T.a((String)omadacId) || T.a((String)httpSessionId)) {
            log.warn("<STOMP> send message fail. omadacId or httpSessionId is null");
            return null;
        }
        StompMessageDTO<?> data = this.getOriginData(message);
        String destination = accessor.getDestination();
        if (data == null) {
            log.info("<STOMP> send message fail. data is null");
            return null;
        }
        if (destination == null) {
            log.warn("<STOMP> send message fail. destination  is null");
        }
        log.debug("<STOMP> preSend destination is {}", (Object)destination);
        GetCurrentInfoDTO requestDTO = GetCurrentInfoDTO.builder().omadacId(omadacId).sessionId(httpSessionId).build();
        OperationResponse userRes = this.identityAccessService.c(requestDTO);
        if (!userRes.success() || userRes.getResult() == null) {
            log.warn("<STOMP> send message fail. userInfo is null, res error code {}", (Object)userRes.getErrorCode());
            return null;
        }
        UserDTO userDTO = ((CurrentDetailDTO)userRes.getResult()).getCurrentUser();
        String roleName = userDTO.getRole().map(RoleEnumDTO::getTypeName).orElse("");
        Set permissions = userDTO.getPermissions();
        Set<String> roleRequires = data.getRoleNames();
        Set<String> permissionRequires = data.getRequires();
        if (!this.checkRole(roleRequires, roleName) || !this.checkUserPermissions(permissionRequires, ((CurrentDetailDTO)userRes.getResult()).getRole())) {
            log.warn("<STOMP> ws user does not meet requirement [permission: {} {}, role: {} {}].", new Object[]{permissionRequires, permissions, roleRequires, ((CurrentDetailDTO)userRes.getResult()).getRole().getName()});
            return null;
        }
        if (Objects.equals(data.getType(), c.a.b())) {
            log.debug("<STOMP> device list message, filter device cache, omadacId={}", (Object)omadacId);
            data = this.filterMacList(c.a, wsSession.getId(), data);
            data = this.filterSiteMacList(c.a, userDTO, data);
        } else if (Objects.equals(data.getType(), c.b.b())) {
            data = this.filterMacList(c.b, wsSession.getId(), data);
            data = this.filterSiteMacList(c.b, userDTO, data);
        }
        log.debug("<STOMP> preSend data {}, omadacId={}", data, (Object)omadacId);
        if (this.omadacUriTemplate.matches(destination)) {
            return this.transToOmadacMessage(message, omadacId, data, destination);
        }
        if (this.siteUriTemplate.matches(destination)) {
            return this.transToSiteMessage(message, omadacId, data, destination, userDTO);
        }
        if (this.globalUriTemplate.matches(destination)) {
            return this.transToGlobalMessage(message, omadacId, data, destination);
        }
        if (this.mspUriTemplate.matches(destination)) {
            return this.transToMspMessage(message, omadacId, data, destination);
        }
        if (this.siteToolsUriTemplate.matches(destination)) {
            return this.transToTerminalSessionMessage(message, omadacId, data, destination, userDTO);
        }
        if (this.globalUserQueueUriTemplate.matches(destination)) {
            return this.transToGlobalUserQueueSessionMessage(message, omadacId, data, destination);
        }
        log.warn("<STOMP> illegal destination {}", (Object)destination);
        return null;
    }

    private StompMessageDTO<?> filterMacList(c type, String wsSessionId, StompMessageDTO<?> stompMessageDTO) {
        try {
            List deviceDataList = (List)stompMessageDTO.getData();
            log.debug("<STOMP> device list cache ={}", (Object)deviceDataList);
            ArrayList subDevices = new ArrayList();
            if (deviceDataList != null && !deviceDataList.isEmpty()) {
                deviceDataList.forEach(deviceData -> {
                    List<String> macList = StompSessionCache.getMacList(wsSessionId);
                    if (deviceData.containsKey("mac") && macList != null && macList.contains(deviceData.get("mac"))) {
                        subDevices.add(deviceData);
                    }
                });
                return stompMessageDTO.setData(type, subDevices);
            }
        }
        catch (Exception e2) {
            log.warn("Fail to filter mac list, wsSessionId={},data={}", (Object)wsSessionId, (Object)stompMessageDTO.getData().toString());
        }
        return stompMessageDTO;
    }

    private StompMessageDTO<?> filterSiteMacList(c type, UserDTO userDTO, StompMessageDTO<?> stompMessageDTO) {
        try {
            List deviceDataList = (List)stompMessageDTO.getData();
            ArrayList subDevices = new ArrayList();
            if (deviceDataList != null && !deviceDataList.isEmpty()) {
                deviceDataList.forEach(deviceData -> {
                    if (!deviceData.containsKey("siteId") || userDTO.isMspUser() || Boolean.TRUE.equals(userDTO.getAllSite())) {
                        subDevices.add(deviceData);
                    } else if (userDTO.getSiteIds() != null && userDTO.getSiteIds().contains(deviceData.get("siteId"))) {
                        subDevices.add(deviceData);
                    }
                });
                return stompMessageDTO.setData(type, subDevices);
            }
        }
        catch (Exception e2) {
            log.warn("Fail to filter mac list with user site, data={}", (Object)stompMessageDTO.getData().toString(), (Object)e2);
        }
        return stompMessageDTO;
    }

    @Nullable
    private Message<?> transToGlobalMessage(@Nonnull Message<?> message, String omadacId, StompMessageDTO<?> data, String destination) {
        String omadacIdInDestination = (String)this.globalUriTemplate.match(destination).get("omadacId");
        if (Objects.equals(omadacIdInDestination, omadacId)) {
            log.debug("<STOMP> Sending matched omadacId {} , continue sending.", (Object)omadacId);
            return this.transToMsg(data, message);
        }
        log.debug("<STOMP> send message fail. illegal omadacId, omadacId:{}, omadacIdInDestination:{}", (Object)omadacId, (Object)omadacIdInDestination);
        return null;
    }

    @Nullable
    private Message<?> transToMspMessage(@Nonnull Message<?> message, String mspId, StompMessageDTO<?> data, String destination) {
        log.debug("<STOMP> Sending matched mspId {} , continue sending.", (Object)mspId);
        return this.transToMsg(data, message);
    }

    @Nullable
    private Message<?> transToTerminalSessionMessage(@Nonnull Message<?> message, String omadacId, StompMessageDTO<?> data, String destination, @Nonnull UserDTO userDTO) {
        Map match = this.siteToolsUriTemplate.match(destination);
        String omadacIdInDestination = (String)match.get("omadacId");
        String siteId = (String)match.get("siteId");
        Set sitePermissions = userDTO.getSiteIds();
        if (Boolean.TRUE.equals(userDTO.getAllSite()) || sitePermissions.contains(siteId)) {
            log.debug("<STOMP> Sending matched site {} , continue sending.", (Object)siteId);
            return this.transToMsg(data, message);
        }
        log.debug("<STOMP> Sending not match any site, return null.");
        return null;
    }

    @Nullable
    private Message<?> transToGlobalUserQueueSessionMessage(@Nonnull Message<?> message, String omadacId, StompMessageDTO<?> data, String destination) {
        log.debug("<STOMP> Sending matched omadacId {} , continue sending.", (Object)omadacId);
        return this.transToMsg(data, message);
    }

    @Nullable
    private Message<?> transToOmadacMessage(@Nonnull Message<?> message, String omadacId, StompMessageDTO<?> data, String destination) {
        log.debug("<STOMP> Sending matched omadacId {} , continue sending.", (Object)omadacId);
        return this.transToMsg(data, message);
    }

    @Nullable
    private Message<?> transToSiteMessage(@Nonnull Message<?> message, String omadacId, StompMessageDTO<?> data, String destination, @Nonnull UserDTO userDTO) {
        Map match = this.siteUriTemplate.match(destination);
        String siteId = (String)match.get("siteId");
        Set sitePermissions = userDTO.getSiteIds();
        if (Boolean.TRUE.equals(userDTO.getAllSite()) || sitePermissions.contains(siteId)) {
            log.debug("<STOMP> Sending matched site {} , continue sending.", (Object)siteId);
            return this.transToMsg(data, message);
        }
        log.debug("<STOMP> Sending not match any site, return null.");
        return null;
    }

    private Message<?> transToMsg(StompMessageDTO<?> data, @Nonnull Message<?> message) {
        StompMessageDTO newModel = new StompMessageDTO(data);
        newModel.setRequires(null);
        newModel.setRoleNames(null);
        try {
            return new GenericMessage((Object)this.objectMapper.writeValueAsBytes(newModel), message.getHeaders());
        }
        catch (IOException e2) {
            return message;
        }
    }

    @Nullable
    private StompMessageDTO<?> getOriginData(@Nonnull Message<?> message) {
        try {
            return (StompMessageDTO)this.objectMapper.readValue((byte[])message.getPayload(), StompMessageDTO.class);
        }
        catch (IOException e2) {
            log.debug("<STOMP> Failed to convert data to StompMessageModel", (Throwable)e2);
            return null;
        }
    }

    private boolean checkRole(Set<String> roleRequires, String roleName) {
        if (CollectionUtils.isEmpty(roleRequires)) {
            return true;
        }
        return roleRequires.contains(roleName);
    }

    private boolean checkUserPermissions(Set<String> requires, RoleDTO roleDTO) {
        if (CollectionUtils.isEmpty(requires)) {
            return true;
        }
        if (CollectionUtils.isEmpty((Map)roleDTO.getPrivilege())) {
            return false;
        }
        for (String require : requires) {
            String key = k.c((String)require);
            Integer value = k.b((String)require);
            if (!roleDTO.getPrivilege().containsKey(key) || (Integer)roleDTO.getPrivilege().get(key) < value) continue;
            return true;
        }
        return false;
    }

    private boolean checkPermissions(Set<String> requires, Set<String> permissions) {
        if (CollectionUtils.isEmpty(requires)) {
            return true;
        }
        if (CollectionUtils.isEmpty(permissions)) {
            return false;
        }
        for (String require : requires) {
            if (permissions.contains(require)) continue;
            return false;
        }
        return true;
    }

    @Generated
    public MessageOutboundInterceptor(ObjectMapper objectMapper, g identityAccessService) {
        this.objectMapper = objectMapper;
        this.identityAccessService = identityAccessService;
    }
}

