/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.stomp.interceptor.inbound;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tplink.smb.ecsp.common.util.JacksonUtils;
import com.tplink.smb.omada.apigateway.dispatch.stomp.dto.MessageVO;
import com.tplink.smb.omada.apigateway.dispatch.stomp.dto.UserPrincipal;
import com.tplink.smb.omada.apigateway.dispatch.stomp.port.cache.StompSessionCache;
import com.tplink.smb.omada.common.q.b;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.manager.stomp.dto.WebSocketFilterKeyDTO;
import com.tplink.smb.omada.manager.terminal.a;
import com.tplink.smb.omada.manager.terminal.api.internal.dto.TermDataRequestDTO;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.security.Principal;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.SimpMessageHeaderAccessor;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.web.socket.WebSocketSession;

public class MessageInboundInterceptor
implements ChannelInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MessageInboundInterceptor.class);
    private ObjectMapper objectMapper;
    private com.tplink.smb.omada.manager.terminal.api.internal.a terminalInternalApiService;

    public Message<?> preSend(@Nonnull Message<?> message, MessageChannel channel) {
        StompHeaderAccessor accessor = (StompHeaderAccessor)MessageHeaderAccessor.getAccessor(message, StompHeaderAccessor.class);
        Principal principal = accessor.getUser();
        if (principal == null) {
            log.debug("<STOMP> stomp message from unknown user. payload: {}", message.getPayload());
            return null;
        }
        StompCommand command = accessor.getCommand();
        if (command == null) {
            return null;
        }
        String wsSessionId = accessor.getSessionId();
        WebSocketSession wsSession = StompSessionCache.getSession(accessor.getSessionId());
        if (wsSession == null) {
            if (command != StompCommand.DISCONNECT) {
                log.error("<STOMP> receive message fail. wsSession is null, wsSessionId={}, command={}", (Object)wsSessionId, (Object)command);
            }
            return null;
        }
        if (!wsSession.isOpen() && command != StompCommand.DISCONNECT) {
            log.error("<STOMP> receive message fail. wsSession is closed, wsSessionId={}, command={}", (Object)wsSessionId, (Object)command);
            return null;
        }
        String omadacId = (String)wsSession.getAttributes().get("TP_OMADAC_ID");
        if (T.a((String)omadacId)) {
            log.error("<STOMP> receive message fail. omadacId is null");
            return null;
        }
        switch (command) {
            case CONNECT: {
                String webCSRFToken = accessor.getFirstNativeHeader("Csrf-Token");
                if (T.a((String)webCSRFToken)) {
                    log.warn("<STOMP> Csrf-Token is null, close session. wsSessionId is {}", (Object)wsSessionId);
                    StompSessionCache.removeSession(wsSessionId, true);
                    return null;
                }
                log.debug("<STOMP> Csrf-Token is {}", (Object)webCSRFToken);
                String sessionCSRFToken = Optional.of(accessor).map(SimpMessageHeaderAccessor::getSessionAttributes).map(attributes -> (String)attributes.get("Csrf-Token")).orElse(null);
                if (!Objects.equals(webCSRFToken, sessionCSRFToken)) {
                    log.warn("<STOMP> Csrf-Token is error, close session. wsSessionId is {}", (Object)wsSessionId);
                    StompSessionCache.removeSession(wsSessionId, true);
                    return null;
                }
                String httpSessionId = (String)wsSession.getAttributes().get("TP_SESSION_ID");
                UserPrincipal userPrincipal = new UserPrincipal(omadacId, httpSessionId);
                accessor.setUser((Principal)userPrincipal);
                break;
            }
            case SUBSCRIBE: {
                String destination = accessor.getDestination();
                b resolvedDest = b.a((String)destination);
                if (resolvedDest == null) {
                    log.warn("<STOMP> ignore illegal subscribe destination : {}", (Object)destination);
                    return null;
                }
                log.debug("<STOMP> WebSocket session:{} subscribe destination:{}", (Object)wsSessionId, (Object)destination);
                break;
            }
            case SEND: {
                MessageVO messageVO;
                String destination = accessor.getDestination();
                if (destination == null || (messageVO = this.resolveSendMsg(message)) == null) break;
                if (a.b.equals((Object)a.a((String)messageVO.getType()))) {
                    List<String> macList = this.getMacList(messageVO);
                    if (macList == null || macList.isEmpty()) break;
                    StompSessionCache.putMacList(wsSessionId, macList);
                    return null;
                }
                if (!a.a.equals((Object)a.a((String)messageVO.getType()))) break;
                WebSocketFilterKeyDTO webSocketEventFilterKey = new WebSocketFilterKeyDTO();
                webSocketEventFilterKey.setType(messageVO.getType());
                webSocketEventFilterKey.setDestination(destination);
                String data = JacksonUtils.pojo2Json((Object)messageVO.getData());
                String evenFilterKey = JacksonUtils.pojo2Json((Object)webSocketEventFilterKey);
                TermDataRequestDTO termDataRequestDTO = new TermDataRequestDTO();
                termDataRequestDTO.setFilterKey(evenFilterKey);
                termDataRequestDTO.setData(data);
                this.terminalInternalApiService.a(termDataRequestDTO);
                break;
            }
            case DISCONNECT: {
                StompSessionCache.removeSession(wsSessionId, false);
                log.debug("<STOMP> WebSocket session disconnected : {}", (Object)wsSessionId);
                break;
            }
        }
        return message;
    }

    private MessageVO resolveSendMsg(@Nonnull Message<?> message) {
        try {
            return (MessageVO)this.objectMapper.readValue((byte[])message.getPayload(), MessageVO.class);
        }
        catch (IOException e2) {
            log.debug("<STOMP> Failed to convert data to StompMessageModel", (Throwable)e2);
            return null;
        }
    }

    private List<String> getMacList(@Nonnull MessageVO message) {
        try {
            return (List)message.getData();
        }
        catch (Exception e2) {
            log.debug("<STOMP> Failed to convert data to StompMessageModel", (Throwable)e2);
            return null;
        }
    }

    @Generated
    public MessageInboundInterceptor(ObjectMapper objectMapper, com.tplink.smb.omada.manager.terminal.api.internal.a terminalInternalApiService) {
        this.objectMapper = objectMapper;
        this.terminalInternalApiService = terminalInternalApiService;
    }
}

