/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.stomp.interceptor;

import com.tplink.smb.omada.apigateway.dispatch.stomp.port.cache.StompSessionCache;
import com.tplink.smb.omada.ratelimit.c.a;
import com.tplink.smb.omada.ratelimit.configuration.LimiterRuleConfig;
import java.util.regex.Pattern;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.simp.stomp.StompHeaderAccessor;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.MessageHeaderAccessor;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.WebSocketSession;

@Component
public class LimiterWsMessageInterceptor
implements ChannelInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LimiterWsMessageInterceptor.class);
    private static final String SEND = "SEND";
    private static final String RECEIVE = "RECEIVE";
    private static final Pattern SITE_PATTERN = Pattern.compile("/sites/([^/]+)/");
    private static final String SITE_PATTERN_STRING = "/sites/siteId/";
    @Value(value="${limiter.ws.switch:false}")
    public boolean isOpen;
    @Autowired
    private a limiterService;
    @Autowired
    private LimiterRuleConfig limiterRuleConfig;

    public Message<?> preSend(Message<?> message, MessageChannel channel) {
        try {
            if (!this.isOpen) {
                return message;
            }
            StompHeaderAccessor accessor = (StompHeaderAccessor)MessageHeaderAccessor.getAccessor(message, StompHeaderAccessor.class);
            String url = accessor.getDestination();
            WebSocketSession wsSession = StompSessionCache.getSession(accessor.getSessionId());
            String omadacId = (String)wsSession.getAttributes().get("TP_OMADAC_ID");
            url = url.replace(omadacId, "omadacId");
            if (StringUtils.isEmpty((Object)(url = this.siteIdConvert(url)))) {
                return message;
            }
            String resourceKey = url + SEND;
            if (this.limiterRuleConfig.getResourceKeySet().contains(resourceKey) && this.limiterService.a(resourceKey)) {
                log.warn("ws message send too much, message: {}", message);
                return null;
            }
        }
        catch (Exception e2) {
            log.error("ws send interceptor exception, message :{}", message, (Object)e2);
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message<?> postReceive(Message<?> message, MessageChannel channel) {
        try {
            if (!this.isOpen) {
                Message<?> message2 = message;
                return message2;
            }
            StompHeaderAccessor accessor = (StompHeaderAccessor)MessageHeaderAccessor.getAccessor(message, StompHeaderAccessor.class);
            String url = accessor.getDestination();
            WebSocketSession wsSession = StompSessionCache.getSession(accessor.getSessionId());
            String omadacId = (String)wsSession.getAttributes().get("TP_OMADAC_ID");
            url = url.replace(omadacId, "omadacId");
            if (StringUtils.isEmpty((Object)(url = this.siteIdConvert(url)))) {
                Message<?> message3 = message;
                return message3;
            }
            String resourceKey = url + RECEIVE;
            if (this.limiterService.a(resourceKey)) {
                log.warn("ws message receive too much, message: {}", message);
                Object var8_11 = null;
                return var8_11;
            }
        }
        catch (Exception e2) {
            log.error("ws receive interceptor exception, message :{}", message, (Object)e2);
        }
        finally {
            return message;
        }
    }

    public String siteIdConvert(String path) {
        return SITE_PATTERN.matcher(path).replaceAll(SITE_PATTERN_STRING);
    }
}

