/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.stomp.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tplink.smb.omada.apigateway.dispatch.stomp.configuration.StompProperties;
import com.tplink.smb.omada.apigateway.dispatch.stomp.interceptor.LimiterWsMessageInterceptor;
import com.tplink.smb.omada.apigateway.dispatch.stomp.interceptor.inbound.MessageInboundInterceptor;
import com.tplink.smb.omada.apigateway.dispatch.stomp.interceptor.outbound.MessageOutboundInterceptor;
import com.tplink.smb.omada.apigateway.dispatch.stomp.port.cache.StompSessionCache;
import com.tplink.smb.omada.apigateway.dispatch.util.WebUtils;
import com.tplink.smb.omada.common.concurrent.thread.c;
import com.tplink.smb.omada.common.spring.a;
import com.tplink.smb.omada.common.util.ad;
import com.tplink.smb.omada.identityaccess.api.internal.dto.GetSessionRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.TenantDTO;
import com.tplink.smb.omada.identityaccess.api.internal.g;
import com.tplink.smb.omada.identityaccess.api.internal.h;
import com.tplink.smb.omada.manager.configuration.api.internal.omadac.b;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpSession;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.RequestEntity;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.converter.ByteArrayMessageConverter;
import org.springframework.messaging.converter.ContentTypeResolver;
import org.springframework.messaging.converter.DefaultContentTypeResolver;
import org.springframework.messaging.converter.MappingJackson2MessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.converter.StringMessageConverter;
import org.springframework.messaging.handler.invocation.HandlerMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.HandlerMethodReturnValueHandler;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.messaging.support.AbstractSubscribableChannel;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MimeTypeUtils;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.config.annotation.SockJsServiceRegistration;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.StompWebSocketEndpointRegistration;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurationSupport;
import org.springframework.web.socket.config.annotation.WebSocketTransportRegistration;
import org.springframework.web.socket.messaging.SubProtocolWebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;
import org.springframework.web.util.UriTemplate;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={StompProperties.class})
public class StompConfiguration
extends WebSocketMessageBrokerConfigurationSupport {
    public static final String HTTP_OMADAC_KEY = "TP_OMADAC_ID";
    public static final String HTTP_SESSION_KEY = "TP_SESSION_ID";
    private static final UriTemplate omadacTemplate = new UriTemplate(com.tplink.smb.omada.common.q.a.f);
    @Qualifier(value="customObjectMapper")
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    @Lazy
    private b omadacInternalApiService;
    @Autowired
    @Lazy
    private h identityAccessService;
    @Autowired
    @Lazy
    private g identityAccessInternalApiService;
    @Autowired
    @Lazy
    private com.tplink.smb.omada.manager.terminal.api.internal.a terminalInternalApiService;
    @Autowired
    private StompProperties stompProperties;
    @Autowired
    @Lazy
    private MeterRegistry meterRegistry;
    @Autowired
    @Qualifier(value="heartbeatSchedulerWorkGroup")
    @Lazy
    private ThreadPoolTaskScheduler threadPoolTaskScheduler;

    public void configureMessageBroker(MessageBrokerRegistry registry) {
        super.configureMessageBroker(registry);
        registry.enableSimpleBroker(new String[]{"/topic", "/queue"}).setHeartbeatValue(new long[]{this.stompProperties.getHeartBeatSchedulerSetting().getHeartbeatInterval(), 0L}).setTaskScheduler((TaskScheduler)this.threadPoolTaskScheduler);
        registry.setApplicationDestinationPrefixes(new String[]{"/app"});
        registry.setUserDestinationPrefix("/user");
    }

    public void registerStompEndpoints(@Nonnull StompEndpointRegistry registry) {
        StompWebSocketEndpointRegistration registration = registry.addEndpoint(new String[]{com.tplink.smb.omada.common.q.a.f}).addInterceptors(new HandshakeInterceptor[]{new HttpSessionInterceptor(this.omadacInternalApiService, this.identityAccessService)}).setAllowedOriginPatterns(new String[]{"*"});
        SockJsServiceRegistration sockJs = registration.withSockJS();
        sockJs.setDisconnectDelay(TimeUnit.SECONDS.toMillis(30L));
    }

    public void configureClientInboundChannel(@Nonnull ChannelRegistration registration) {
        registration.interceptors(new ChannelInterceptor[]{new MessageInboundInterceptor(this.objectMapper, this.terminalInternalApiService)});
        registration.interceptors(new ChannelInterceptor[]{new LimiterWsMessageInterceptor()});
    }

    public void configureClientOutboundChannel(@Nonnull ChannelRegistration registration) {
        registration.interceptors(new ChannelInterceptor[]{new MessageOutboundInterceptor(this.objectMapper, this.identityAccessInternalApiService)});
        registration.interceptors(new ChannelInterceptor[]{new LimiterWsMessageInterceptor()});
    }

    @Bean
    @Nonnull
    @Lazy(value=false)
    public WebSocketHandler subProtocolWebSocketHandler(@Qualifier(value="clientInboundChannel") AbstractSubscribableChannel clientInboundChannel, @Qualifier(value="clientOutboundChannel") AbstractSubscribableChannel clientOutboundChannel) {
        return new SessionHolderWebSocketHandler((MessageChannel)clientInboundChannel, (SubscribableChannel)clientOutboundChannel);
    }

    public boolean configureMessageConverters(List<MessageConverter> messageConverters) {
        if (CollectionUtils.isEmpty(messageConverters)) {
            messageConverters.add((MessageConverter)new StringMessageConverter());
            messageConverters.add((MessageConverter)new ByteArrayMessageConverter());
            messageConverters.add((MessageConverter)this.createJacksonConverter());
        }
        return false;
    }

    @Nonnull
    protected MappingJackson2MessageConverter createJacksonConverter() {
        DefaultContentTypeResolver resolver = new DefaultContentTypeResolver();
        resolver.setDefaultMimeType(MimeTypeUtils.APPLICATION_JSON);
        MappingJackson2MessageConverter converter = new MappingJackson2MessageConverter();
        converter.setContentTypeResolver((ContentTypeResolver)resolver);
        converter.setObjectMapper(this.objectMapper);
        return converter;
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> argumentResolvers) {
        super.addArgumentResolvers(argumentResolvers);
    }

    public void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> returnValueHandlers) {
        super.addReturnValueHandlers(returnValueHandlers);
    }

    public void configureWebSocketTransport(WebSocketTransportRegistration registry) {
    }

    @Lazy
    @Bean(name={"macFormatEventWorkGroup"})
    @ConditionalOnMissingBean(name={"macFormatEventWorkGroup"})
    public ExecutorService macFormatEventWorkGroup() {
        String executorName = "mac-format-event-work-group";
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(this.stompProperties.getThread().getCorePoolSize(), this.stompProperties.getThread().getMaximumPoolSize(), this.stompProperties.getThread().getKeepAliveTime(), TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(this.stompProperties.getThread().getQueueCapacity()), new ThreadFactoryBuilder().setNameFormat(executorName + "-%d").build(), new ThreadPoolExecutor.DiscardOldestPolicy(){
            private final Logger log = LoggerFactory.getLogger(ThreadPoolExecutor.DiscardOldestPolicy.class);

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor e2) {
                this.log.warn("<MACFORMAT> api-gateway macFormat event queue is full.");
                super.rejectedExecution(r, e2);
            }
        });
        return c.a((MeterRegistry)this.meterRegistry, (ExecutorService)threadPoolExecutor, (String)executorName, (String)"executor_metric", (Tag[])new Tag[0]);
    }

    @Lazy
    @Bean(name={"stompEventWorkGroup"})
    @ConditionalOnMissingBean(name={"stompEventWorkGroup"})
    public ExecutorService stompEventWorkGroup() {
        String executorName = "stomp-event-work-group";
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(this.stompProperties.getThread().getCorePoolSize(), this.stompProperties.getThread().getMaximumPoolSize(), this.stompProperties.getThread().getKeepAliveTime(), TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(this.stompProperties.getThread().getQueueCapacity()), new ThreadFactoryBuilder().setNameFormat(executorName + "-%d").build(), new ThreadPoolExecutor.DiscardOldestPolicy(){
            private final Logger log = LoggerFactory.getLogger(ThreadPoolExecutor.DiscardOldestPolicy.class);

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor e2) {
                this.log.warn("<STOMP> stomp event queue is full.");
                super.rejectedExecution(r, e2);
            }
        });
        return c.a((MeterRegistry)this.meterRegistry, (ExecutorService)threadPoolExecutor, (String)executorName, (String)"executor_metric", (Tag[])new Tag[0]);
    }

    @Lazy
    @Bean(name={"heartbeatSchedulerWorkGroup"})
    @ConditionalOnMissingBean(name={"heartbeatSchedulerWorkGroup"})
    public ThreadPoolTaskScheduler initHeartbeatSchedulerWorkGroup() {
        final String heartBeatExecutorName = "wss-heartbeat-thread";
        ThreadPoolTaskScheduler te = new ThreadPoolTaskScheduler(){

            @Nonnull
            protected ScheduledExecutorService createExecutor(int poolSize, @Nonnull ThreadFactory threadFactory, @Nonnull RejectedExecutionHandler rejectedExecutionHandler) {
                return c.a((MeterRegistry)StompConfiguration.this.meterRegistry, (ScheduledExecutorService)super.createExecutor(poolSize, threadFactory, rejectedExecutionHandler), (String)heartBeatExecutorName, (String)"executor_metric", (Tag[])new Tag[0]);
            }
        };
        te.setPoolSize(this.stompProperties.getHeartBeatSchedulerSetting().getCorePoolSize().intValue());
        te.setThreadNamePrefix(heartBeatExecutorName + "-");
        te.setRejectedExecutionHandler((RejectedExecutionHandler)new ThreadPoolExecutor.DiscardOldestPolicy(){
            private final Logger log = LoggerFactory.getLogger(ThreadPoolExecutor.DiscardOldestPolicy.class);

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor e2) {
                this.log.warn("<STOMP> stomp heart-beat queue is full, discard oldest");
                super.rejectedExecution(r, e2);
            }
        });
        te.initialize();
        return te;
    }

    public static class HttpSessionInterceptor
    implements HandshakeInterceptor {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(HttpSessionInterceptor.class);
        private b omadacInternalApiService;
        private h identityAccessService;

        public boolean beforeHandshake(@Nonnull ServerHttpRequest request, @Nonnull ServerHttpResponse response, @Nonnull WebSocketHandler wsHandler, @Nonnull Map<String, Object> attributes) {
            if (!(request instanceof ServletServerHttpRequest)) {
                return true;
            }
            ServletServerHttpRequest serverHttpRequest = (ServletServerHttpRequest)request;
            RequestEntity<String> requestEntity = WebUtils.getStringRequestEntity(null, serverHttpRequest.getServletRequest());
            if (ad.a(requestEntity)) {
                log.warn("Omada Controller websocket request parameter contain xss attack.");
                return false;
            }
            HttpSession session = serverHttpRequest.getServletRequest().getSession(false);
            if (session == null) {
                log.info("<STOMP> WebSocket beforeHandshake session is null, refuse");
                return false;
            }
            String path = request.getURI().getPath();
            Map omadacUriMap = omadacTemplate.match(path);
            String sessionCSRFToken = (String)session.getAttribute("Csrf-Token");
            String omadacId = null;
            if (omadacUriMap.containsKey("omadacId")) {
                omadacId = (String)omadacUriMap.get("omadacId");
            }
            if (omadacId == null || sessionCSRFToken == null) {
                log.warn("<STOMP> WebSocket beforeHandshake omadacId or csrfToken is null, refuse");
                return false;
            }
            String sessionId = session.getId();
            GetSessionRequestDTO requestDTO = GetSessionRequestDTO.builder().omadacId(omadacId).sessionId(sessionId).build();
            TenantDTO tenantDTO = (TenantDTO)this.identityAccessService.b(requestDTO).getResult();
            if (tenantDTO == null) {
                log.info("<STOMP> WebSocket beforeHandshake user is null, refuse");
                return false;
            }
            log.debug("<STOMP> user {} start connect to WebSocket, sessionId={} ,omadacId={}", new Object[]{tenantDTO.getName(), sessionId, omadacId});
            attributes.put(StompConfiguration.HTTP_OMADAC_KEY, omadacId);
            attributes.put(StompConfiguration.HTTP_SESSION_KEY, sessionId);
            attributes.put("Csrf-Token", sessionCSRFToken);
            return true;
        }

        public void afterHandshake(@Nonnull ServerHttpRequest request, @Nonnull ServerHttpResponse response, @Nonnull WebSocketHandler wsHandler, Exception exception) {
        }

        @Generated
        public HttpSessionInterceptor(b omadacInternalApiService, h identityAccessService) {
            this.omadacInternalApiService = omadacInternalApiService;
            this.identityAccessService = identityAccessService;
        }
    }

    public static class SessionHolderWebSocketHandler
    extends SubProtocolWebSocketHandler {
        @Generated
        private static final Logger log = LoggerFactory.getLogger(SessionHolderWebSocketHandler.class);

        SessionHolderWebSocketHandler(MessageChannel clientInboundChannel, SubscribableChannel clientOutboundChannel) {
            super(clientInboundChannel, clientOutboundChannel);
        }

        public void afterConnectionEstablished(@Nonnull WebSocketSession session) throws Exception {
            String httpSessionId = (String)session.getAttributes().get(StompConfiguration.HTTP_SESSION_KEY);
            String omadacId = (String)session.getAttributes().get(StompConfiguration.HTTP_OMADAC_KEY);
            log.debug("<STOMP> Established new WebSocket connection, WS session ID is: {}, HTTP session ID is: {}, omadacId is: {}", new Object[]{session.getId(), httpSessionId, omadacId});
            StompSessionCache.addSession(httpSessionId, session);
            b omadacInternalApiService = (b)a.b(b.class);
            if (omadacInternalApiService == null) {
                log.error("<STOMP> get bean omadacInternalApiService fail.");
                StompSessionCache.removeAndCloseSessionByHttpSessionId(httpSessionId);
                return;
            }
            StompSessionCache.limit(httpSessionId, 20);
            super.afterConnectionEstablished(session);
        }
    }
}

