/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.stat;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.tplink.smb.omada.common.h.c;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import lombok.Generated;
import org.springframework.web.multipart.MultipartFile;

public class ApiStatContext {
    private static final Cache<Long, ApiStatContext> CONTEXT_CACHE = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofHours(1L)).initialCapacity(1000).maximumSize(20000L).build();
    @Nullable
    private Long requestStartNanos;
    @Nullable
    private String userId;
    @Nullable
    private String role;
    @Nullable
    private String accountId;
    @Nullable
    private String operatorId;
    @Nullable
    private String requestBy;
    @Nullable
    private Map<String, Long> fileSizeInByte;

    @Nonnull
    public static ApiStatContext getOrInitByReqId(Long reqId) {
        try {
            return (ApiStatContext)CONTEXT_CACHE.get((Object)reqId, ApiStatContext::new);
        }
        catch (ExecutionException e2) {
            throw new c((Throwable)e2);
        }
    }

    @Nullable
    public static ApiStatContext getAndInvalidateByReqId(Long reqId) {
        ApiStatContext result = (ApiStatContext)CONTEXT_CACHE.getIfPresent((Object)reqId);
        if (result != null) {
            CONTEXT_CACHE.invalidate((Object)reqId);
        }
        return result;
    }

    public ApiStatContext setFileSizeInByte(Map<String, ? extends MultipartFile> multipartFiles) {
        HashMap<String, Long> sizeMap = new HashMap<String, Long>();
        for (Map.Entry<String, ? extends MultipartFile> entry : multipartFiles.entrySet()) {
            sizeMap.put(entry.getKey(), entry.getValue().getSize());
        }
        this.fileSizeInByte = sizeMap;
        return this;
    }

    @Nullable
    @Generated
    public Long getRequestStartNanos() {
        return this.requestStartNanos;
    }

    @Nullable
    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Nullable
    @Generated
    public String getRole() {
        return this.role;
    }

    @Nullable
    @Generated
    public String getAccountId() {
        return this.accountId;
    }

    @Nullable
    @Generated
    public String getOperatorId() {
        return this.operatorId;
    }

    @Nullable
    @Generated
    public String getRequestBy() {
        return this.requestBy;
    }

    @Nullable
    @Generated
    public Map<String, Long> getFileSizeInByte() {
        return this.fileSizeInByte;
    }

    @Generated
    public ApiStatContext setRequestStartNanos(@Nullable Long requestStartNanos) {
        this.requestStartNanos = requestStartNanos;
        return this;
    }

    @Generated
    public ApiStatContext setUserId(@Nullable String userId) {
        this.userId = userId;
        return this;
    }

    @Generated
    public ApiStatContext setRole(@Nullable String role) {
        this.role = role;
        return this;
    }

    @Generated
    public ApiStatContext setAccountId(@Nullable String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Generated
    public ApiStatContext setOperatorId(@Nullable String operatorId) {
        this.operatorId = operatorId;
        return this;
    }

    @Generated
    public ApiStatContext setRequestBy(@Nullable String requestBy) {
        this.requestBy = requestBy;
        return this;
    }

    @Generated
    private ApiStatContext() {
    }
}

