/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.shiro.session;

import com.tplink.smb.omada.apigateway.dispatch.shiro.session.ShiroSessionCacheRepository;
import java.io.Serializable;
import lombok.Generated;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.ValidatingSession;
import org.apache.shiro.session.mgt.eis.EnterpriseCacheSessionDAO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomShiroSessionDAO
extends EnterpriseCacheSessionDAO {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CustomShiroSessionDAO.class);
    private static final long TIMEOUT_REFRESH_INTERVAL = 600L;
    @Autowired
    private ShiroSessionCacheRepository shiroSessionCacheRepository;

    protected Serializable doCreate(Session session) {
        Serializable sessionId = super.doCreate(session);
        log.debug("create session={}.", (Object)session.getId());
        this.shiroSessionCacheRepository.saveSession(session);
        return sessionId;
    }

    protected Session doReadSession(Serializable sessionId) {
        log.debug("read session={}.", (Object)sessionId);
        Session session = super.doReadSession(sessionId);
        if (session == null) {
            log.debug("read session from redis");
            session = this.shiroSessionCacheRepository.getSession(sessionId);
            if (session != null) {
                log.debug("cache session when read session from redis");
                if (session instanceof ValidatingSession) {
                    if (((ValidatingSession)session).isValid()) {
                        this.cache(session, session.getId());
                    } else {
                        this.uncache(session);
                    }
                } else {
                    this.cache(session, session.getId());
                }
            }
        }
        return session;
    }

    protected void doDelete(Session session) {
        log.trace("delete session={}", (Object)session.getId());
        if (session == null || session.getId() == null) {
            log.error("session or sessionId is null");
            return;
        }
        super.doDelete(session);
        this.shiroSessionCacheRepository.deleteSession(session.getId());
    }

    protected void doUpdate(Session session) {
        log.debug("update session={}", (Object)session.getId());
        if (session == null || session.getId() == null) {
            log.error("session or sessionId is null");
            return;
        }
        super.doUpdate(session);
        this.shiroSessionCacheRepository.updateSession(session);
    }
}

