/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.meter;

import com.tplink.smb.omada.central.components.common.g.c;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import jakarta.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ApiMeters {
    @Autowired
    private MeterRegistry meterRegistry;

    public void incApiExceedLimit() {
        this.meterRegistry.counter("api_rate_limit_exceed", new String[0]).increment();
    }

    public void loginFailCount(LoginFailureReason cause) {
        this.meterRegistry.counter("login_failure_times_total", (Iterable)Tags.of((String)"reason", (String)cause.reason)).increment();
    }

    public void ipIsBlockedFailCount() {
        this.meterRegistry.counter("ip_is_blocked_count", new String[0]).increment();
    }

    public void summaryRequestsSeconds(@Nonnull String httpMethod, @Nonnull String path, int errorCode, double timeSec, String importance, String timeCost) {
        String errorCodeStr = ApiMeters.valueOfErrCode(errorCode);
        this.meterRegistry.summary("omada_controller_requests_seconds", (Iterable)Tags.of((String[])new String[]{"method", httpMethod, "path", path, "err_code", errorCodeStr, "importance", importance, "time_cost_level", timeCost})).record(timeSec);
    }

    public static String valueOfErrCode(int errorCode) {
        if (errorCode == c.b.getErrCode() || errorCode == c.k.getErrCode() || errorCode == c.q.getErrCode() || errorCode == c.r.getErrCode() || errorCode == c.s.getErrCode() || errorCode == c.B.getErrCode() || errorCode == c.a.getErrCode()) {
            return String.valueOf(errorCode);
        }
        return "others";
    }

    private static abstract class Names {
        private static final String API_EXCEED = "api_rate_limit_exceed";
        private static final String LOGIN_FAILURE = "login_failure_times_total";
        private static final String IP_IS_BLOCKED_COUNT = "ip_is_blocked_count";
        private static final String OMADA_CUSTOMERS_REQUEST_SECONDS = "omada_controller_requests_seconds";

        private Names() {
        }
    }

    private static abstract class Labels {
        private static final String REASON = "reason";

        private Labels() {
        }
    }

    public static enum LoginFailureReason {
        INVALID_USERNAME_OR_PASSWORD("invalid_username_or_password"),
        FROZEN("account_frozen"),
        TOKEN_INVALID("token_invalid"),
        SERVICE_ERROR("service_error");

        private final String reason;

        private LoginFailureReason(String reason) {
            this.reason = reason;
        }
    }
}

