/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.log;

import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.f.c;
import com.tplink.smb.omada.dispatcher.common.util.UserIpUtils;
import com.tplink.smb.omada.identityaccess.api.internal.dto.OmadaRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.OmadacDTO;
import com.tplink.smb.omada.identityaccess.api.internal.l;
import com.tplink.smb.omada.logmanager.api.internal.a;
import com.tplink.smb.omada.logmanager.api.internal.dto.audit.AuditLogKeyEnumDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.audit.OperateResultEnumDTO;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Component
public class SendAuditLogService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SendAuditLogService.class);
    @Autowired
    private a auditLogApiService;
    @Autowired
    @Lazy
    private l omadacInternalApiService;

    public void sendAuditLog(String omadacId, String siteId, String auditLogKey, String operator, Boolean isSuccess, Integer sourceType, String ... params) {
        if (!this.check(omadacId, auditLogKey, operator)) {
            return;
        }
        Optional localUserIp = UserIpUtils.getLocalUserIp();
        if (!localUserIp.isPresent()) {
            log.warn("Cannot getLocalUserIp, omadacId {}, logkey: {}", (Object)omadacId, (Object)auditLogKey);
            return;
        }
        Integer resCode = Boolean.TRUE.equals(isSuccess) ? OperateResultEnumDTO.SUCCEED.getResultCode() : OperateResultEnumDTO.FAILED.getResultCode();
        this.auditLogApiService.a(omadacId, siteId, auditLogKey, operator, sourceType, (String)localUserIp.get(), Long.valueOf(System.currentTimeMillis()), resCode, params);
    }

    public void sendMspAuditLog(String mspId, String auditLogKey, String operator, Boolean isSuccess, Integer sourceType, String ... params) {
        Optional localUserIp = UserIpUtils.getLocalUserIp();
        if (!localUserIp.isPresent()) {
            log.warn("Cannot getLocalUserIp, mspId {}, logkey: {}", (Object)mspId, (Object)auditLogKey);
            return;
        }
        String ip = (String)localUserIp.get();
        if (!this.check(mspId, auditLogKey, operator)) {
            return;
        }
        Integer resCode = Boolean.TRUE.equals(isSuccess) ? OperateResultEnumDTO.SUCCEED.getResultCode() : OperateResultEnumDTO.FAILED.getResultCode();
        this.auditLogApiService.a(mspId, auditLogKey, operator, sourceType, ip, Long.valueOf(System.currentTimeMillis()), resCode, params);
    }

    public void sendMspOrGlobalAuditLog(String omadacId, AuditLogKeyEnumDTO auditLogKey, AuditLogKeyEnumDTO mspAuditLogKey, String userName, Boolean isSuccess, Integer sourceType, String ... params) {
        OperationResponse omadac = this.omadacInternalApiService.a(OmadaRequestDTO.builder().omadacId(omadacId).build());
        if (!omadac.success()) {
            log.warn("failed to send sso auditLog. omadac not exists. omadacId: {}", (Object)omadacId);
            return;
        }
        if (Objects.equals(c.b.a(), ((OmadacDTO)omadac.getResult()).getPattern())) {
            this.sendMspAuditLog(omadacId, mspAuditLogKey.name(), userName, isSuccess, sourceType, params);
        } else {
            this.sendAuditLog(omadacId, null, auditLogKey.name(), userName, isSuccess, sourceType, params);
        }
    }

    private boolean check(String omadacId, String auditLogKey, String operator) {
        if (omadacId == null || auditLogKey == null || operator == null) {
            log.warn("Audit Log send failed Error.OmadacId {}, auditLogKey {}, operator {}", new Object[]{omadacId, auditLogKey, operator});
            return false;
        }
        return true;
    }
}

