/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.interceptor;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.tplink.nbu.common.utils.CollectionUtil;
import com.tplink.smb.omada.apigateway.dispatch.configuration.ControllerUpgradeProperties;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.dispatcher.cache.ServiceMethodInfo;
import com.tplink.smb.omada.dispatcher.chain.HandlerChain;
import com.tplink.smb.omada.dispatcher.common.access.HttpMethod;
import com.tplink.smb.omada.dispatcher.common.access.ServiceType;
import com.tplink.smb.omada.dispatcher.common.response.ApiResponseWrapper;
import com.tplink.smb.omada.dispatcher.interceptor.impl.AbstractRequestInterceptor;
import com.tplink.smb.omada.identityaccess.api.internal.dto.UpgradeToCentralStatusDTO;
import com.tplink.smb.omada.identityaccess.api.internal.l;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.http.RequestEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
@Order(value=130)
public class UpgradeToCentralStatusHandler
extends AbstractRequestInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UpgradeToCentralStatusHandler.class);
    @Autowired
    @Lazy
    private l omadacInternalApiService;
    @Autowired
    @Lazy
    private ControllerUpgradeProperties upgradeProperties;
    private Cache<String, Boolean> cache = CacheBuilder.newBuilder().expireAfterWrite(3000L, TimeUnit.MILLISECONDS).build();

    public OperationResponse<?> preHandle(RequestEntity<String> request, Map<String, MultipartFile> multipartFileMap, ApiResponseWrapper<?> response, ServiceMethodInfo method, HandlerChain chain) {
        log.debug("UpgradeToCentralStatusHandler preHandle start.");
        if (this.isAccessAllowedMethod(method)) {
            return OperationResponse.SUCCESS;
        }
        List<String> access = this.upgradeProperties.getAccess();
        if (this.isAccessAllowedPath(method, access)) {
            return OperationResponse.SUCCESS;
        }
        if (this.isUpgrading(chain.getOmadacId())) {
            return new OperationResponse(b.bO);
        }
        return OperationResponse.SUCCESS;
    }

    private boolean isAccessAllowedPath(ServiceMethodInfo method, List<String> patterns) {
        if (CollectionUtil.isEmpty(patterns)) {
            return false;
        }
        boolean access = false;
        for (String pattern : patterns) {
            if (!method.getPath().equals(pattern)) continue;
            access = true;
            break;
        }
        return access;
    }

    private boolean isAccessAllowedMethod(ServiceMethodInfo method) {
        HttpMethod[] httpMethod = method.getHttpMethod();
        if (HttpMethod.GET.equals((Object)httpMethod[0])) {
            return true;
        }
        if (ServiceType.ANON.equals((Object)method.getServiceType()) || ServiceType.HOTSPOT.equals((Object)method.getServiceType())) {
            return true;
        }
        Set permissions = method.getPermissions();
        if (CollectionUtil.isEmpty((Collection)permissions)) {
            return true;
        }
        for (String permission : permissions) {
            if (!permission.contains("READ")) continue;
            return true;
        }
        return false;
    }

    private boolean isUpgrading(String omadacId) {
        boolean result = false;
        try {
            result = (Boolean)this.cache.get((Object)omadacId, () -> {
                Boolean isRestoring = false;
                try {
                    OperationResponse ops = this.omadacInternalApiService.f(omadacId);
                    if (!ops.success() || ops.getResult() == null) {
                        log.warn("Fail to get upgrade status of omadacId= {}, error {}", (Object)omadacId, (Object)ops.getMsg());
                    }
                    if (ops.getResult() != null) {
                        UpgradeToCentralStatusDTO upgradeToCentralStatus = (UpgradeToCentralStatusDTO)ops.getResult();
                        isRestoring = Boolean.TRUE.equals(upgradeToCentralStatus.getUpgrading());
                        this.cache.put((Object)omadacId, (Object)isRestoring);
                    }
                }
                catch (Exception e2) {
                    log.warn("Fail to get upgrade status of omadacId= {},  error {}", (Object)omadacId, (Object)e2.getMessage());
                }
                return isRestoring;
            });
        }
        catch (ExecutionException e2) {
            log.warn("Fail to get upgrade status of omadacId= {}", (Object)omadacId, (Object)e2);
        }
        return result;
    }
}

