/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.interceptor;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.tplink.nbu.common.utils.CollectionUtil;
import com.tplink.smb.omada.apigateway.dispatch.cache.OmadacTypeCache;
import com.tplink.smb.omada.apigateway.dispatch.configuration.SubSystemInterfaceProperties;
import com.tplink.smb.omada.central.components.common.g.c;
import com.tplink.smb.omada.dispatcher.cache.ServiceMethodInfo;
import com.tplink.smb.omada.dispatcher.chain.HandlerChain;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.common.error.ErrorCode;
import com.tplink.smb.omada.dispatcher.common.response.ApiResponseWrapper;
import com.tplink.smb.omada.dispatcher.interceptor.impl.AbstractRequestInterceptor;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
@Order(value=140)
public class SubSystemInterfaceHandler
extends AbstractRequestInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SubSystemInterfaceHandler.class);
    @Autowired
    @Lazy
    private OmadacTypeCache omadacTypeCache;
    @Autowired
    @Lazy
    private SubSystemInterfaceProperties interfaceProperties;
    private Cache<String, Boolean> cache = CacheBuilder.newBuilder().expireAfterWrite(3000L, TimeUnit.MILLISECONDS).build();

    public OperationResponse<?> preHandle(RequestEntity<String> request, Map<String, MultipartFile> multipartFileMap, ApiResponseWrapper<?> response, ServiceMethodInfo method, HandlerChain chain) {
        log.debug("SubSystemInterfaceHandler preHandle start.");
        if (this.isSubSystem(chain.getOmadacId())) {
            if (HttpMethod.GET.equals((Object)request.getMethod())) {
                return OperationResponse.SUCCESS;
            }
            List<String> patterns = this.interfaceProperties.getBlock();
            if (this.isAccessRefused(method, patterns)) {
                log.info("central and global request path:{}, interface intercepted.", (Object)method.getPath());
                return new OperationResponse((ErrorCode)c.h);
            }
        }
        return OperationResponse.SUCCESS;
    }

    private boolean isAccessRefused(ServiceMethodInfo method, List<String> patterns) {
        if (CollectionUtil.isEmpty(patterns)) {
            return false;
        }
        for (String pattern : patterns) {
            if (!Objects.equals(method.getPath(), pattern)) continue;
            return true;
        }
        return false;
    }

    private boolean isSubSystem(String omadacId) {
        boolean result = false;
        try {
            result = (Boolean)this.cache.get((Object)omadacId, () -> {
                Boolean isSubSystem = this.omadacTypeCache.isSubSystem(omadacId);
                this.cache.put((Object)omadacId, (Object)Boolean.TRUE.equals(isSubSystem));
                return isSubSystem;
            });
        }
        catch (Exception e2) {
            log.warn("omadacId:{}, Fail to get omadac is SubSystem occur exception", (Object)omadacId, (Object)e2);
        }
        return result;
    }
}

