/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.interceptor;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.tplink.smb.omada.apigateway.dispatch.configuration.RestoreProperties;
import com.tplink.smb.omada.backup.api.internal.b.a.a;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.dispatcher.cache.ServiceMethodInfo;
import com.tplink.smb.omada.dispatcher.chain.HandlerChain;
import com.tplink.smb.omada.dispatcher.common.response.ApiResponseWrapper;
import com.tplink.smb.omada.dispatcher.interceptor.impl.AbstractRequestInterceptor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.http.RequestEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
@Order(value=120)
public class RestoreStatusHandler
extends AbstractRequestInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RestoreStatusHandler.class);
    @Autowired
    @Lazy
    private com.tplink.smb.omada.backup.api.internal.b.a restoreStatusInternalApiService;
    @Autowired
    private RestoreProperties restoreProperties;
    private Cache<String, a> cache = CacheBuilder.newBuilder().expireAfterWrite(3000L, TimeUnit.MILLISECONDS).build();

    public OperationResponse<?> preHandle(RequestEntity<String> request, Map<String, MultipartFile> multipartFileMap, ApiResponseWrapper<?> response, ServiceMethodInfo method, HandlerChain chain) {
        log.debug("RestoreStatusHandler preHandle start.");
        boolean restoringAccess = this.restoreProperties.isEnable();
        List<String> patterns = this.restoreProperties.getAccess();
        if (this.isAccessAllowed(method, patterns)) {
            return OperationResponse.SUCCESS;
        }
        if (restoringAccess && this.isRestoring(chain.getOmadacId())) {
            OperationResponse operationResponse = new OperationResponse(b.br);
            if (OmadacType.s()) {
                return operationResponse;
            }
            if (com.tplink.smb.omada.common.util.system.a.b()) {
                operationResponse = new OperationResponse(b.QV);
            }
            return operationResponse;
        }
        return OperationResponse.SUCCESS;
    }

    private boolean isAccessAllowed(ServiceMethodInfo method, List<String> patterns) {
        boolean access = false;
        for (String pattern : patterns) {
            if (!method.getPath().equals(pattern)) continue;
            access = true;
            break;
        }
        return access;
    }

    private boolean isRestoring(String omadacId) {
        boolean isRestoring = false;
        try {
            isRestoring = ((a)this.cache.get((Object)omadacId, () -> {
                a restoreStatus = new a();
                restoreStatus.a(Boolean.valueOf(false));
                restoreStatus.b(Boolean.valueOf(false));
                try {
                    OperationResponse ops = this.restoreStatusInternalApiService.a(omadacId);
                    if (!ops.success() || ops.getResult() == null) {
                        log.warn("Fail to get restore status of omadacId= {}, error {}", (Object)omadacId, (Object)ops.getMsg());
                    }
                    a result = (a)ops.getResult();
                    restoreStatus.a(Boolean.valueOf(Boolean.TRUE.equals(result.b())));
                    restoreStatus.b(Boolean.valueOf(Boolean.TRUE.equals(result.c())));
                    this.cache.put((Object)omadacId, (Object)restoreStatus);
                }
                catch (Exception e2) {
                    log.warn("Fail to get restore status of omadacId= {}", (Object)omadacId, (Object)e2);
                }
                return restoreStatus;
            })).b();
        }
        catch (ExecutionException e2) {
            log.warn("Fail to get restore status of omadacId= {}", (Object)omadacId, (Object)e2);
        }
        return isRestoring;
    }
}

