/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.interceptor;

import com.tplink.smb.omada.apigateway.dispatch.meter.ApiMeters;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.identityaccess.api.internal.dto.GetSessionRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.UserDTO;
import com.tplink.smb.omada.identityaccess.api.internal.h;
import com.tplink.smb.omada.ratelimit.b.e;
import com.tplink.smb.omada.ratelimit.c.a;
import com.tplink.smb.omada.ratelimit.configuration.LimiterRuleConfig;
import jakarta.servlet.http.HttpServletRequest;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class RateLimiterHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RateLimiterHandler.class);
    @Value(value="${ratelimit.http.switch:false}")
    public boolean isOpen;
    @Value(value="${ratelimit.http.urlSwitch:false}")
    public boolean urlSwitchIsOpen;
    @Value(value="${ratelimit.http.userSwitch:false}")
    public boolean userSwitchIsOpen;
    @Value(value="${ratelimit.http.omadaIdUrlSwitch:false}")
    public boolean omadaIdUrlSwitchIsOpen;
    private static final Pattern SITE_PATTERN = Pattern.compile("/sites/([^/]+)/");
    private static final String SITE_PATTERN_STRING = "/sites/siteId/";
    @Autowired
    private a limiterService;
    @Autowired
    private LimiterRuleConfig limiterRuleConfig;
    private final h identityAccessWebInternalApiService;
    private final ApiMeters apiMeters;
    private final com.tplink.smb.omada.ratelimit.b.a webApiRateLimiter;

    @Autowired
    public RateLimiterHandler(h identityAccessWebInternalApiService, ApiMeters apiMeters, e omadaRateLimiterFactory) {
        this.identityAccessWebInternalApiService = identityAccessWebInternalApiService;
        this.apiMeters = apiMeters;
        this.webApiRateLimiter = omadaRateLimiterFactory.a("web-api");
    }

    public boolean preHandle(HttpServletRequest httpServletRequest, String omadacId) {
        if (!OmadacType.s()) {
            return true;
        }
        Subject subject = SecurityUtils.getSubject();
        Session session = subject.getSession(false);
        if (session == null) {
            return true;
        }
        String sessionId = String.valueOf(session.getId());
        GetSessionRequestDTO getSessionRequest = GetSessionRequestDTO.builder().omadacId(omadacId).sessionId(sessionId).build();
        OperationResponse optRes = this.identityAccessWebInternalApiService.a(getSessionRequest);
        if (!optRes.success()) {
            log.debug("session is not exist.");
            return true;
        }
        if (!this.webApiRateLimiter.a("user.id:" + ((UserDTO)optRes.getResult()).getId())) {
            this.apiMeters.incApiExceedLimit();
            log.warn("Failed to handle {} request for omadacId {} as reached rate limit, rateLimiter {}", new Object[]{httpServletRequest.getRequestURI(), omadacId, this.webApiRateLimiter});
            return false;
        }
        try {
            if (!this.isOpen) {
                return true;
            }
            String path = httpServletRequest.getServletPath();
            path = path.replace(omadacId, "omadacId");
            path = this.siteIdConvert(path);
            if (this.urlSwitchIsOpen) {
                String urlResourceKey = httpServletRequest.getMethod() + path;
                if (this.limiterRuleConfig.getResourceKeySet().contains(urlResourceKey) && this.limiterService.a(urlResourceKey)) {
                    log.warn("request too much, urlResourceKey:{}, url: {}", (Object)urlResourceKey, (Object)httpServletRequest.getPathInfo());
                    return false;
                }
            }
            if (this.omadaIdUrlSwitchIsOpen) {
                String omadacUrlResourceKey = omadacId + httpServletRequest.getMethod() + path;
                if (this.limiterRuleConfig.getResourceKeySet().contains(omadacUrlResourceKey) && this.limiterService.a(omadacUrlResourceKey)) {
                    log.warn("request too much, omadacUrlResourceKey:{}, url: {}", (Object)omadacUrlResourceKey, (Object)httpServletRequest.getServletPath());
                    return false;
                }
            }
            if (this.userSwitchIsOpen) {
                String userResourceKey = ((UserDTO)optRes.getResult()).getId();
                if (this.limiterRuleConfig.getResourceKeySet().contains(userResourceKey) && this.limiterService.a(userResourceKey)) {
                    log.warn("request too much, userResourceKey:{}, url: {}", (Object)userResourceKey, (Object)httpServletRequest.getServletPath());
                    return false;
                }
            }
        }
        catch (Exception e2) {
            log.error("RateLimiterHandler preHandle error: ", (Throwable)e2);
            this.apiMeters.incApiExceedLimit();
            return true;
        }
        return true;
    }

    public String siteIdConvert(String path) {
        return SITE_PATTERN.matcher(path).replaceAll(SITE_PATTERN_STRING);
    }
}

