/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.interceptor;

import com.tplink.smb.omada.apigateway.dispatch.stat.ApiStat;
import com.tplink.smb.omada.apigateway.dispatch.util.WebUtils;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.UserInfoBriefDTO;
import com.tplink.smb.omada.common.access.UserLevelEnumDTO;
import com.tplink.smb.omada.common.access.e;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.system.a;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.dispatcher.cache.ServiceMethodInfo;
import com.tplink.smb.omada.dispatcher.chain.AttributeRequestEntity;
import com.tplink.smb.omada.dispatcher.chain.HandlerChain;
import com.tplink.smb.omada.dispatcher.common.access.ServiceType;
import com.tplink.smb.omada.dispatcher.common.response.ApiResponseWrapper;
import com.tplink.smb.omada.dispatcher.interceptor.impl.AbstractRequestInterceptor;
import com.tplink.smb.omada.identityaccess.api.internal.dto.CheckPermissionForSessionIdDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.CurrentDetailDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.GetCurrentInfoDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.GetRoleInfoDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.ListCustomersBriefDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.OmadacDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.QueryTenantByIdRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.RoleDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.TenantDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.UserDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.openapi.GetCurrentInfoForOpenApiDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.openapi.GlobalClientModeInfo;
import com.tplink.smb.omada.identityaccess.api.internal.dto.openapi.MspClientModeInfo;
import com.tplink.smb.omada.identityaccess.api.internal.dto.openapi.OauthTokenCacheDTO;
import com.tplink.smb.omada.identityaccess.api.internal.g;
import com.tplink.smb.omada.identityaccess.api.internal.l;
import com.tplink.smb.omada.identityaccess.api.internal.m;
import com.tplink.smb.omada.identityaccess.api.shared.c;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.QuerySiteDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.site.dto.QuerySiteIdListDTO;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriTemplate;

@Component
@Order(value=210)
public class PermissionCheckHandler
extends AbstractRequestInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PermissionCheckHandler.class);
    private static final UriTemplate SITE_TEMPLATE = new UriTemplate("/{omadacId}/api/v2/sites/{siteId}");
    private static final UriTemplate MSP_CUSTOMER_SITE_TEMPLATE = new UriTemplate("/api/v2/msp/{mspId}/customers/{customerId}/sites/{siteId}");
    private static final UriTemplate SITE_HOTSPOT_TEMPLATE = new UriTemplate("/{omadacId}/api/v2/hotspot/sites/{siteId}");
    private static final UriTemplate SITE_FILE_TEMPLATE = new UriTemplate("/{omadacId}/api/v2/files/sites/{siteId}");
    private static final UriTemplate APP_SITE_TEMPLATE = new UriTemplate("/{omadacId}/api/v2/app/sites/{siteId}");
    private static final UriTemplate MSP_APP_CUSTOMER_SITE_TEMPLATE = new UriTemplate("/api/v2/app/msp/{mspId}/customers/{customerId}/sites/{siteId}");
    private static final UriTemplate OPEN_API_SITE_TEMPLATE = new UriTemplate("/openapi/v1/{omadacId}/sites/{siteId}");
    private static final UriTemplate OPEN_API_V2_SITE_TEMPLATE = new UriTemplate("/openapi/v2/{omadacId}/sites/{siteId}");
    private static final UriTemplate OPEN_API_SITE_TEMPLATE_PATH_TEMPLATE = new UriTemplate("/openapi/v1/{omadacId}/sitetemplates/{siteTemplateId}");
    private static final UriTemplate OPEN_API_V2_SITE_TEMPLATE_PATH_TEMPLATE = new UriTemplate("/openapi/v2/{omadacId}/sitetemplates/{siteTemplateId}");
    private static final UriTemplate SITE_TEMPLATE_PATH_TEMPLATE = new UriTemplate("/{omadacId}/api/v2/sitetemplates/{siteTemplateId}");
    private g identityAccessInternalApiService;
    private com.tplink.smb.omada.identityaccess.api.internal.x tenantInternalApiService;
    private m openApiInternalApiService;
    private com.tplink.smb.omada.manager.configuration.api.internal.site.a siteInternalApiService;
    private l omadacInternalApiService;
    private List<UserInfoConsumer> userInfoConsumers;
    private final UriTemplate openApiOmadacTemplate = new UriTemplate("/openapi/v1/{omadacId}");
    private final UriTemplate openApiV2OmadacTemplate = new UriTemplate("/openapi/v2/{omadacId}");
    private final UriTemplate openApiMspTemplate = new UriTemplate("/openapi/v1/msp/{mspId}");
    public static final String PATH_SITE_KEY = "/{site";

    public OperationResponse<?> preHandle(RequestEntity<String> request, Map<String, MultipartFile> multipartFileMap, ApiResponseWrapper<?> response, ServiceMethodInfo method, HandlerChain chain) {
        log.debug("PermissionCheckHandler preHandle start.");
        ServiceType serviceType = method.getServiceType();
        if (serviceType == ServiceType.ANON) {
            return OperationResponse.SUCCESS;
        }
        e controlType = e.a(request);
        String path = request.getUrl().getPath();
        if (chain.isOpenApiRequest() && !WebUtils.isRequestFromApp(request) && !WebUtils.isRequestFromWeb(request)) {
            OperationResponse currentInfo = this.identityAccessInternalApiService.b(new GetCurrentInfoDTO(chain.getSessionId(), controlType, chain.getOmadacId(), chain.getAccessToken()));
            if (!currentInfo.success() || currentInfo.getResult() == null) {
                log.warn("Fail to find current user, omadacId={}", (Object)chain.getOmadacId());
                if (a.b()) {
                    return new OperationResponse(b.j);
                }
                return new OperationResponse(b.h);
            }
            UserDTO currentUser = ((CurrentDetailDTO)currentInfo.getResult()).getCurrentUser();
            if (Boolean.TRUE.equals(currentUser.getTemporaryEnable()) && !currentUser.verifyTemporaryUser()) {
                log.warn("temporary user is not valid. omadacId: {}, userId: {}.", (Object)chain.getOmadacId(), (Object)currentUser.getId());
                return new OperationResponse(b.dL);
            }
            boolean isViewerPermission = this.checkViewerPermission(((CurrentDetailDTO)currentInfo.getResult()).getRole(), method);
            log.debug("method {} isViewerPermission {}", (Object)method.getMethodName(), (Object)isViewerPermission);
            this.setUserInfoBrief(request, ((CurrentDetailDTO)currentInfo.getResult()).getCurrentUser(), chain, method, isViewerPermission);
            return this.checkPermissionByOpenApi(chain, method, path, request, serviceType);
        }
        String siteId = this.getSiteIdByAnnotation(path, method);
        String siteTemplateId = this.getSiteTemplateIdByAnnotation(path, method);
        CheckPermissionForSessionIdDTO checkPermissionForSessionIdDTO = new CheckPermissionForSessionIdDTO();
        checkPermissionForSessionIdDTO.setRequestOmadacId(chain.getOmadacId());
        checkPermissionForSessionIdDTO.setRequestPath(path);
        checkPermissionForSessionIdDTO.setRequestMethod(request.getMethod() == null ? null : request.getMethod().name());
        checkPermissionForSessionIdDTO.setRequiredPermissions(method.getPermissions());
        checkPermissionForSessionIdDTO.setSessionId(chain.getSessionId());
        checkPermissionForSessionIdDTO.setSiteId(siteId);
        checkPermissionForSessionIdDTO.setSiteTemplateId(siteTemplateId);
        checkPermissionForSessionIdDTO.setAutoRequest(Boolean.valueOf(WebUtils.isAutoRefreshRequest(request)));
        log.debug("check permission. path:{}, method:{}, session:{}, omadacId:{}.", new Object[]{path, request.getMethod(), chain.getSessionId(), chain.getOmadacId()});
        OperationResponse checkResp = this.identityAccessInternalApiService.a(checkPermissionForSessionIdDTO);
        if (!checkResp.success()) {
            log.warn("check permission failed. omadacId:{}, path:{}, errorCode:{}", new Object[]{chain.getOmadacId(), path, checkResp.getErrorCode()});
            return checkResp;
        }
        this.setUserInfoBrief(request, (UserInfoBriefDTO)checkResp.getResult(), method, chain.getOmadacId());
        return OperationResponse.SUCCESS;
    }

    private <T> void setUserInfoBrief(RequestEntity<T> request, UserInfoBriefDTO userInfoBriefDTO, ServiceMethodInfo method, String omadacId) {
        if (userInfoBriefDTO == null) {
            return;
        }
        userInfoBriefDTO.setEncryptFields(method.getEncryptFields());
        log.debug("set userInfoBrief. omadacId:{}, url:{}, isAttributeRequestEntity:{}.", new Object[]{omadacId, request.getUrl().getPath(), request instanceof AttributeRequestEntity});
        if (request instanceof AttributeRequestEntity) {
            if (OmadacType.s()) {
                try {
                    String serviceMethodPath = method.getPath();
                    ApiStat apiStat = new ApiStat().setStatName("OmadaAPIStat").setPath(com.tplink.smb.omada.common.util.e.a.a((String)request.getUrl().getPath(), (String)serviceMethodPath)).setMethod(Optional.ofNullable(request.getMethod()).map(HttpMethod::name).orElse(null)).setUriTemplate(serviceMethodPath).setRequestHeaders(request.getHeaders()).setQueryString(com.tplink.smb.omada.common.util.e.a.b((String)request.getUrl().getRawQuery())).setRequestBody((String)request.getBody()).setUserId(userInfoBriefDTO.getId()).setAccountId(userInfoBriefDTO.getAccountId()).setRole(userInfoBriefDTO.getRoleId()).setOmadacId(userInfoBriefDTO.getOmadacId());
                    log.info("[STAT] {}", (Object)apiStat);
                }
                catch (Exception e2) {
                    log.error("record cloud user failed.", (Throwable)e2);
                }
            }
            ((AttributeRequestEntity)request).getAttributes().put("currentUserInfoBrief", userInfoBriefDTO);
        }
    }

    private <T> void setUserInfoBrief(RequestEntity<T> request, UserDTO userDTO, HandlerChain chain, ServiceMethodInfo method, boolean isViewerPermission) {
        UserInfoBriefDTO userInfoBriefDTO = UserInfoBriefDTO.builder().id(userDTO.getId()).tenantId(userDTO.getTenantId()).omadacId(userDTO.getOmadacId()).name(userDTO.getName()).email(userDTO.getEmail()).openApiRequest(Boolean.valueOf(chain.isOpenApiRequest() && !WebUtils.isRequestFromApp(request) && !WebUtils.isRequestFromWeb(request))).sessionId(chain.getSessionId()).accessToken(chain.getAccessToken()).roleId(userDTO.getRoleId()).roleTypeName(userDTO.getRoleTypeName()).userLevel(userDTO.getUserLevel()).temporaryUser(userDTO.getTemporaryEnable()).allSite(Boolean.valueOf(userDTO.getAllSite() != null && userDTO.getAllSite() != false)).sites(userDTO.getSiteIds()).userType(userDTO.getUserType()).accountId(userDTO.getAccountId()).allCustomer(userDTO.getAllCustomer()).customers(userDTO.getCustomerIds()).customerRoleId(userDTO.getCustomerRoleId()).viewerPermission(Boolean.valueOf(isViewerPermission)).encryptFields(method.getEncryptFields()).build();
        log.debug("set userInfoBrief. omadacId:{}, url:{}, isAttributeRequestEntity:{}.", new Object[]{chain.getOmadacId(), request.getUrl().getPath(), request instanceof AttributeRequestEntity});
        if (request instanceof AttributeRequestEntity) {
            if (OmadacType.s()) {
                try {
                    String serviceMethodPath = method.getPath();
                    ApiStat apiStat = new ApiStat().setStatName("OmadaAPIStat").setPath(com.tplink.smb.omada.common.util.e.a.a((String)request.getUrl().getPath(), (String)serviceMethodPath)).setMethod(Optional.ofNullable(request.getMethod()).map(HttpMethod::name).orElse(null)).setUriTemplate(serviceMethodPath).setRequestHeaders(request.getHeaders()).setQueryString(com.tplink.smb.omada.common.util.e.a.b((String)request.getUrl().getRawQuery())).setRequestBody((String)request.getBody()).setUserId(userDTO.getId()).setAccountId(userDTO.getAccountId()).setRole(userDTO.getRoleId()).setOmadacId(userDTO.getOmadacId());
                    log.info("[STAT] {}", (Object)apiStat);
                }
                catch (Exception e2) {
                    log.error("record cloud user failed.", (Throwable)e2);
                }
            }
            ((AttributeRequestEntity)request).getAttributes().put("currentUserInfoBrief", userInfoBriefDTO);
        }
    }

    private OperationResponse checkPermissionByOpenApi(HandlerChain chain, ServiceMethodInfo method, String path, RequestEntity<String> request, ServiceType serviceType) {
        String accessToken = chain.getAccessToken();
        OperationResponse accessResp = this.openApiInternalApiService.c(accessToken);
        if (!accessResp.success() || Objects.isNull(accessResp.getResult())) {
            return new OperationResponse(b.NB);
        }
        OauthTokenCacheDTO oauthTokenCacheDTO = (OauthTokenCacheDTO)accessResp.getResult();
        Integer grantType = oauthTokenCacheDTO.getGrantType();
        if (Objects.equals(0, grantType)) {
            return this.checkPermissionByCodeMode(chain, method, path, request, serviceType, oauthTokenCacheDTO);
        }
        if (Objects.equals(1, grantType)) {
            return this.checkPermissionByClientMode(method, path, request, serviceType, oauthTokenCacheDTO);
        }
        return new OperationResponse(b.NA);
    }

    private OperationResponse checkPermissionByCodeMode(HandlerChain chain, ServiceMethodInfo method, String path, RequestEntity<String> request, ServiceType serviceType, OauthTokenCacheDTO oauthTokenCacheDTO) {
        if (Boolean.TRUE.equals(oauthTokenCacheDTO.getMsp())) {
            return this.checkMspPermissionByCodeMode(chain, method, path, request, serviceType, oauthTokenCacheDTO);
        }
        return this.checkGlobalPermissionByCodeMode(chain, method, path, request, serviceType, oauthTokenCacheDTO);
    }

    private OperationResponse checkMspPermissionByCodeMode(HandlerChain chain, ServiceMethodInfo method, String path, RequestEntity<String> request, ServiceType serviceType, OauthTokenCacheDTO oauthTokenCacheDTO) {
        String requestOmadacId;
        if (Objects.isNull(oauthTokenCacheDTO.getCodeMode()) || Objects.isNull(oauthTokenCacheDTO.getCodeMode().getTenantId())) {
            log.warn("Fail to find oauthTokenCache role in code mode");
            return new OperationResponse(b.h);
        }
        String requestMspId = this.resolveOpenApiMspId(path);
        String cacheOmadacId = oauthTokenCacheDTO.getOmadacId();
        QueryTenantByIdRequestDTO queryTenantRequest = QueryTenantByIdRequestDTO.builder().tenantId(oauthTokenCacheDTO.getCodeMode().getTenantId()).build();
        OperationResponse optRes = this.tenantInternalApiService.a(queryTenantRequest);
        if (!T.a((String)requestMspId)) {
            if (!T.a((String)requestMspId, (String)cacheOmadacId)) {
                log.warn("mspId ={} in request not match application mspId={} in code mode,", (Object)requestMspId, (Object)cacheOmadacId);
                return new OperationResponse(b.h);
            }
            if (optRes.getResult() != null && !((TenantDTO)optRes.getResult()).getMsps().contains(requestMspId)) {
                log.warn("current user has no access to this controller, mspId={}, request {}", (Object)requestMspId, (Object)path);
                return new OperationResponse(b.h);
            }
        }
        if (!T.a((String)(requestOmadacId = this.resolveOpenApiOmadacId(path))) && optRes.getResult() != null && !((TenantDTO)optRes.getResult()).getOmadacs().contains(requestOmadacId)) {
            log.warn("current user has no access to this controller, omadacId={}, request {}", (Object)requestOmadacId, (Object)path);
            return new OperationResponse(b.h);
        }
        String cacheTenantId = oauthTokenCacheDTO.getCodeMode().getTenantId();
        String mspId = oauthTokenCacheDTO.getMspId();
        OperationResponse currentInfo = this.identityAccessInternalApiService.a(new GetCurrentInfoForOpenApiDTO(cacheOmadacId, mspId, cacheTenantId, requestOmadacId, requestMspId));
        if (!currentInfo.success() || currentInfo.getResult() == null) {
            log.warn("Fail to find current user, omadacId={}", (Object)chain.getOmadacId());
            return new OperationResponse(b.h);
        }
        if (currentInfo.success() && currentInfo.getResult() != null && !CollectionUtils.isEmpty(this.userInfoConsumers)) {
            this.userInfoConsumers.forEach(consumer -> consumer.accept(chain.getRequestId(), ((CurrentDetailDTO)currentInfo.getResult()).getCurrentUser()));
        }
        if (!this.checkSitePermissions(path, method, ((CurrentDetailDTO)currentInfo.getResult()).getCurrentUser(), chain.getOmadacId())) {
            log.warn("Current user does not has permission to access this site. path:{}, method:{}", (Object)path, (Object)request.getMethod());
            return new OperationResponse(b.t);
        }
        if (!this.checkUserPermissions(request, ((CurrentDetailDTO)currentInfo.getResult()).getCurrentUser(), ((CurrentDetailDTO)currentInfo.getResult()).getRole(), serviceType, method)) {
            log.warn("Current user does not has permission to access this site. path:{}, method:{}", (Object)path, (Object)request.getMethod());
            return new OperationResponse(b.i);
        }
        OperationResponse checkSiteTemplateResp = this.checkSiteTemplatePermission(method, chain.getOmadacId());
        if (!checkSiteTemplateResp.success()) {
            return checkSiteTemplateResp;
        }
        if (!this.checkSiteTemplateId(path, method, chain.getOmadacId())) {
            log.warn("Invalid site templateId. path:{}, method:{}", (Object)path, (Object)request.getMethod());
            return new OperationResponse(b.fn);
        }
        return OperationResponse.SUCCESS;
    }

    private OperationResponse checkGlobalPermissionByCodeMode(HandlerChain chain, ServiceMethodInfo method, String path, RequestEntity<String> request, ServiceType serviceType, OauthTokenCacheDTO oauthTokenCacheDTO) {
        if (Objects.isNull(oauthTokenCacheDTO.getCodeMode()) || Objects.isNull(oauthTokenCacheDTO.getCodeMode().getTenantId())) {
            log.warn("Fail to find oauthTokenCache role in code mode");
            return new OperationResponse(b.h);
        }
        String requestMspId = this.resolveOpenApiMspId(path);
        if (requestMspId != null) {
            log.debug("Global open api application has no permission to any msp api, path:{}, oauth:{}.", (Object)path, (Object)x.a((Object)oauthTokenCacheDTO));
            return new OperationResponse(b.h);
        }
        String requestOmadacId = this.resolveOpenApiOmadacId(path);
        String cacheOmadacId = oauthTokenCacheDTO.getOmadacId();
        if (requestOmadacId != null) {
            if (!T.a((String)cacheOmadacId, (String)requestOmadacId)) {
                log.warn("omadacId ={} in request not match application omadacId={} in code mode,", (Object)requestOmadacId, (Object)cacheOmadacId);
                return new OperationResponse(b.h);
            }
            QueryTenantByIdRequestDTO queryTenantRequest = QueryTenantByIdRequestDTO.builder().tenantId(oauthTokenCacheDTO.getCodeMode().getTenantId()).build();
            OperationResponse optRes = this.tenantInternalApiService.a(queryTenantRequest);
            if (optRes.getResult() != null && !((TenantDTO)optRes.getResult()).getOmadacs().contains(requestOmadacId)) {
                log.warn("current user has no access to this controller, omadacId={}, request {}", (Object)requestOmadacId, (Object)path);
                return new OperationResponse(b.h);
            }
        }
        String cacheTenantId = oauthTokenCacheDTO.getCodeMode().getTenantId();
        String mspId = oauthTokenCacheDTO.getMspId();
        OperationResponse currentInfo = this.identityAccessInternalApiService.a(new GetCurrentInfoForOpenApiDTO(cacheOmadacId, mspId, cacheTenantId, requestOmadacId, requestMspId));
        if (!currentInfo.success() || currentInfo.getResult() == null) {
            log.warn("Fail to find current user, omadacId={}", (Object)chain.getOmadacId());
            return new OperationResponse(b.h);
        }
        if (currentInfo.success() && currentInfo.getResult() != null && !CollectionUtils.isEmpty(this.userInfoConsumers)) {
            this.userInfoConsumers.forEach(consumer -> consumer.accept(chain.getRequestId(), ((CurrentDetailDTO)currentInfo.getResult()).getCurrentUser()));
        }
        if (!this.checkSitePermissions(path, method, ((CurrentDetailDTO)currentInfo.getResult()).getCurrentUser(), chain.getOmadacId())) {
            log.warn("Current user does not has permission to access this site. path:{}, method:{}", (Object)path, (Object)request.getMethod());
            return new OperationResponse(b.t);
        }
        if (!this.checkUserPermissions(request, ((CurrentDetailDTO)currentInfo.getResult()).getCurrentUser(), ((CurrentDetailDTO)currentInfo.getResult()).getRole(), serviceType, method)) {
            log.warn("Current user does not has permission to access this site. path:{}, method:{}", (Object)path, (Object)request.getMethod());
            return new OperationResponse(b.i);
        }
        OperationResponse checkSiteTemplateResp = this.checkSiteTemplatePermission(method, chain.getOmadacId());
        if (!checkSiteTemplateResp.success()) {
            return checkSiteTemplateResp;
        }
        if (!this.checkSiteTemplateId(path, method, chain.getOmadacId())) {
            log.warn("Invalid site templateId. path:{}, method:{}", (Object)path, (Object)request.getMethod());
            return new OperationResponse(b.fn);
        }
        return OperationResponse.SUCCESS;
    }

    private OperationResponse checkPermissionByClientMode(ServiceMethodInfo method, String path, RequestEntity<String> request, ServiceType serviceType, OauthTokenCacheDTO oauthTokenCacheDTO) {
        if (Boolean.TRUE.equals(oauthTokenCacheDTO.getMsp())) {
            return this.checkMspPermissionByClientMode(method, path, request, serviceType, oauthTokenCacheDTO);
        }
        return this.checkGlobalPermissionByClientMode(method, path, request, serviceType, oauthTokenCacheDTO);
    }

    private OperationResponse checkMspPermissionByClientMode(ServiceMethodInfo method, String path, RequestEntity<String> request, ServiceType serviceType, OauthTokenCacheDTO oauthTokenCacheDTO) {
        OperationResponse checkCustomerResp;
        if (Objects.isNull(oauthTokenCacheDTO.getMspClientMode()) || Objects.isNull(oauthTokenCacheDTO.getMspClientMode().getMspRoleId())) {
            log.warn("Fail to find oauthTokenCache role in client mode");
            return new OperationResponse(b.h);
        }
        String requestMspId = this.resolveOpenApiMspId(path);
        String cacheOmadacId = oauthTokenCacheDTO.getOmadacId();
        if (!T.a((String)requestMspId)) {
            if (!T.a((String)requestMspId, (String)cacheOmadacId)) {
                log.warn("mspId ={} in request not match application  mspId={}, in client mode", (Object)requestMspId, (Object)cacheOmadacId);
                return new OperationResponse(b.h);
            }
            String mspRoleId = oauthTokenCacheDTO.getMspClientMode().getMspRoleId();
            OperationResponse mspRoleResp = this.identityAccessInternalApiService.a(GetRoleInfoDTO.builder().omadacId(cacheOmadacId).roleId(mspRoleId).build());
            if (!mspRoleResp.success() || mspRoleResp.getResult() == null) {
                log.warn("Fail to find msp role, mspId={}, roleId={} in client mode", (Object)cacheOmadacId, (Object)mspRoleId);
                return new OperationResponse(b.h);
            }
            RoleDTO mspRoleDTO = (RoleDTO)mspRoleResp.getResult();
            if (!this.checkUserPermissionsByClientMode(request, mspRoleDTO, serviceType, method)) {
                log.warn("Current user does not has permission to access this site. path:{}, method:{}", (Object)path, (Object)request.getMethod());
                return new OperationResponse(b.i);
            }
            String requestCustomerId = this.resolveOpenApiCustomerId(path);
            if (!T.a((String)requestCustomerId)) {
                return this.checkMspCustomerPermissionByClientMode(requestCustomerId, oauthTokenCacheDTO.getMspClientMode(), cacheOmadacId);
            }
            return OperationResponse.SUCCESS;
        }
        String requestOmadacId = this.resolveOpenApiOmadacId(path);
        if (!T.a((String)requestOmadacId) && !(checkCustomerResp = this.checkMspCustomerPermissionByClientMode(requestOmadacId, oauthTokenCacheDTO.getMspClientMode(), cacheOmadacId)).success()) {
            return checkCustomerResp;
        }
        String customerRoleId = oauthTokenCacheDTO.getMspClientMode().getCustomerRoleId();
        OperationResponse customerRoleResp = this.identityAccessInternalApiService.a(GetRoleInfoDTO.builder().omadacId(requestOmadacId).roleId(customerRoleId).build());
        if (!customerRoleResp.success() || customerRoleResp.getResult() == null) {
            log.warn("Fail to find customer role, omadacId={}, roleId={}", (Object)requestOmadacId, (Object)customerRoleId);
            return new OperationResponse(b.h);
        }
        RoleDTO customerRoleDTO = (RoleDTO)customerRoleResp.getResult();
        if (!this.checkUserPermissionsByClientMode(request, customerRoleDTO, serviceType, method)) {
            log.warn("Current user does not has permission to access this site. path:{}, method:{}", (Object)path, (Object)request.getMethod());
            return new OperationResponse(b.i);
        }
        OperationResponse checkSiteTemplateResp = this.checkSiteTemplatePermission(method, requestOmadacId);
        if (!checkSiteTemplateResp.success()) {
            return checkSiteTemplateResp;
        }
        if (!this.checkSiteTemplateId(path, method, requestOmadacId)) {
            log.warn("Invalid site templateId. path:{}, method:{}", (Object)path, (Object)request.getMethod());
            return new OperationResponse(b.fn);
        }
        return OperationResponse.SUCCESS;
    }

    private OperationResponse checkGlobalPermissionByClientMode(ServiceMethodInfo method, String path, RequestEntity<String> request, ServiceType serviceType, OauthTokenCacheDTO oauthTokenCacheDTO) {
        if (Objects.isNull(oauthTokenCacheDTO.getGlobalClientMode()) || Objects.isNull(oauthTokenCacheDTO.getGlobalClientMode().getRoleId())) {
            log.warn("Fail to find oauthTokenCache role ");
            return new OperationResponse(b.h);
        }
        String requestMspId = this.resolveOpenApiMspId(path);
        if (requestMspId != null) {
            log.debug("Global open api application has no permission to any msp api, path:{}, oauth:{}.", (Object)path, (Object)x.a((Object)oauthTokenCacheDTO));
            return new OperationResponse(b.h);
        }
        String requestOmadacId = this.resolveOpenApiOmadacId(path);
        String cacheOmadacId = oauthTokenCacheDTO.getOmadacId();
        if (!T.a((String)cacheOmadacId, (String)requestOmadacId)) {
            log.warn("omadacId ={} in request not match application omadacId={},", (Object)requestOmadacId, (Object)cacheOmadacId);
            return new OperationResponse(b.h);
        }
        String roleId = oauthTokenCacheDTO.getGlobalClientMode().getRoleId();
        OperationResponse roleRes = this.identityAccessInternalApiService.a(GetRoleInfoDTO.builder().omadacId(cacheOmadacId).roleId(roleId).build());
        if (!roleRes.success() || roleRes.getResult() == null) {
            log.warn("Fail to find customer role, omadacId={}, roleId={}", (Object)cacheOmadacId, (Object)roleId);
            return new OperationResponse(b.h);
        }
        RoleDTO roleDTO = (RoleDTO)roleRes.getResult();
        if (!this.checkSitePermissionsByClientMode(path, method, oauthTokenCacheDTO.getGlobalClientMode(), requestOmadacId)) {
            log.warn("Current user does not has permission to access this site. path:{}, method:{}", (Object)path, (Object)request.getMethod());
            return new OperationResponse(b.t);
        }
        if (!this.checkUserPermissionsByClientMode(request, roleDTO, serviceType, method)) {
            log.warn("Current user does not has permission to access this. path:{}, method:{}", (Object)path, (Object)request.getMethod());
            return new OperationResponse(b.i);
        }
        OperationResponse checkSiteTemplateResp = this.checkSiteTemplatePermission(method, requestOmadacId);
        if (!checkSiteTemplateResp.success()) {
            return checkSiteTemplateResp;
        }
        if (!this.checkSiteTemplateId(path, method, requestOmadacId)) {
            log.warn("Invalid site templateId. path:{}, method:{}", (Object)path, (Object)request.getMethod());
            return new OperationResponse(b.fn);
        }
        return OperationResponse.SUCCESS;
    }

    private String resolveOpenApiOmadacId(String path) {
        Map omadacUriMap = WebUtils.OPENAPI_OMADAC_TEMPLATE.match(path);
        String omadacId = null;
        if (omadacUriMap.containsKey("omadacId")) {
            omadacId = (String)omadacUriMap.get("omadacId");
        }
        if (T.a(omadacId, (String)"msp")) {
            return null;
        }
        return omadacId;
    }

    private String resolveOpenApiMspId(String path) {
        Map mspUriMap = WebUtils.OPENAPI_MSP_TEMPLATE.match(path);
        String mspId = null;
        if (mspUriMap.containsKey("mspId")) {
            mspId = (String)mspUriMap.get("mspId");
        }
        return mspId;
    }

    private String resolveOpenApiCustomerId(String path) {
        Map mspUriMap = WebUtils.OPENAPI_MSP_TEMPLATE.match(path);
        String customerId = null;
        if (mspUriMap.containsKey("customerId")) {
            customerId = (String)mspUriMap.get("customerId");
        }
        return customerId;
    }

    private boolean checkSitePermissions(String path, ServiceMethodInfo serviceMethodInfo, UserDTO currentUser, String omadacId) {
        String site = this.getSiteIdByAnnotation(path, serviceMethodInfo);
        if (site == null || Objects.equals("PENDING-SITE", site)) {
            return true;
        }
        HashSet sitePermissions = new HashSet();
        if (Boolean.TRUE.equals(currentUser.getAllSite()) || Objects.equals(UserLevelEnumDTO.MSP_USER.getLevel(), currentUser.getUserLevel())) {
            OperationResponse siteRes = this.siteInternalApiService.d(new QuerySiteDTO().setOmadacId(omadacId).setSiteId(site).setSiteSettingType(Integer.valueOf(com.tplink.smb.omada.manager.c.x.a.a())));
            if (!siteRes.success()) {
                log.warn("Find site list for omadacId={} error {}", (Object)omadacId, (Object)siteRes.getMsg());
                return false;
            }
            return Boolean.TRUE.equals(siteRes.getResult());
        }
        return currentUser.getSiteIds().contains(site);
    }

    private boolean checkSiteTemplateId(String path, ServiceMethodInfo serviceMethodInfo, String omadacId) {
        String siteTemplateId = this.getSiteTemplateIdByAnnotation(path, serviceMethodInfo);
        if (siteTemplateId == null) {
            return true;
        }
        OperationResponse response = this.siteInternalApiService.a(QuerySiteIdListDTO.builder().omadacIds(Collections.singleton(omadacId)).siteSettingType(Integer.valueOf(com.tplink.smb.omada.manager.c.x.b.a())).build());
        if (response.getResult() == null || ((Map)response.getResult()).get(omadacId) == null) {
            return false;
        }
        Set siteTemplateIds = (Set)((Map)response.getResult()).get(omadacId);
        return siteTemplateIds.contains(siteTemplateId);
    }

    private OperationResponse checkSiteTemplatePermission(ServiceMethodInfo serviceMethodInfo, String omadacId) {
        if (!this.needCheckedSiteTemplatePath(serviceMethodInfo)) {
            return OperationResponse.SUCCESS;
        }
        if (!OmadacType.r()) {
            return OperationResponse.SUCCESS;
        }
        log.warn("Hardware controller not support site template url");
        return new OperationResponse(b.h);
    }

    private boolean needCheckedSiteTemplatePath(ServiceMethodInfo serviceMethodInfo) {
        String registeredPath = serviceMethodInfo.getPath();
        return registeredPath.startsWith("/{omadacId}/api/v2/sitetemplates/{siteTemplateId}") || registeredPath.startsWith("/openapi/v1/{omadacId}/sitetemplates") || registeredPath.startsWith("/openapi/v2/{omadacId}/sitetemplates");
    }

    private boolean checkUserPermissions(RequestEntity request, UserDTO currentUser, RoleDTO role, ServiceType serviceType, ServiceMethodInfo method) {
        if (Objects.isNull(currentUser)) {
            return true;
        }
        if (role == null) {
            if (currentUser.getHotspotRoleType() != null || currentUser.getRoleName() != null) {
                role = new RoleDTO();
                int permission = currentUser.getHotspotRoleType() == null ? 2 : (c.a.b() == currentUser.getHotspotRoleType().intValue() ? 2 : 1);
                HashMap<String, Integer> permissionMap = new HashMap<String, Integer>();
                permissionMap.put("hotspot", permission);
                role.setPrivilege(permissionMap);
            } else {
                log.warn("current user has no permission to any web api, omadacId={}", (Object)currentUser.getOmadacId());
                return false;
            }
        }
        if (currentUser.isRoot()) {
            return true;
        }
        if (!this.checkPermission(role, serviceType, method)) {
            log.warn("Invalid user permission. path:{}, method:{}, user role id{}, required {}", new Object[]{request.getUrl().getPath(), request.getMethod(), role.getId(), method.getPermissions().toString()});
            return false;
        }
        return true;
    }

    private boolean checkViewerPermission(RoleDTO roleDTO, ServiceMethodInfo apiMethod) {
        if (Objects.isNull(roleDTO)) {
            return false;
        }
        Set permissionRequired = apiMethod.getPermissions();
        if (CollectionUtils.isEmpty((Collection)permissionRequired)) {
            return false;
        }
        for (String permission : permissionRequired) {
            String key = this.getPermissionKey(permission);
            log.debug("checkViewerPermission key {}", (Object)key);
            if (roleDTO.isViewerRole(key, Integer.valueOf(1))) continue;
            return false;
        }
        return true;
    }

    private boolean checkPermission(RoleDTO roleDTO, ServiceType serviceType, ServiceMethodInfo apiMethod) {
        if (serviceType == ServiceType.ANON) {
            return true;
        }
        if (roleDTO == null) {
            return false;
        }
        Map permissionMap = roleDTO.getPrivilege();
        Set permissionRequired = apiMethod.getPermissions();
        boolean access = false;
        if (permissionRequired.isEmpty()) {
            return true;
        }
        for (String permission : permissionRequired) {
            String key = this.getPermissionKey(permission);
            int require = this.resolvePermissionRequire(permission);
            if (permissionMap.get(key) == null || (Integer)permissionMap.get(key) < require) continue;
            access = true;
            break;
        }
        return access;
    }

    private String getPermissionKey(String permission) {
        String per = permission.toLowerCase(Locale.ROOT);
        if (per.contains("write") || per.contains("read")) {
            int i2 = permission.lastIndexOf("_");
            return per.substring(0, i2);
        }
        return per;
    }

    private int resolvePermissionRequire(String permission) {
        String per = permission.toLowerCase(Locale.ROOT);
        if (per.endsWith("write")) {
            return 2;
        }
        if (per.endsWith("read")) {
            return 1;
        }
        return 2;
    }

    public String getSiteIdByAnnotation(String path, ServiceMethodInfo methodInfo) {
        Set apiTypes = methodInfo.getApiType();
        for (String apiType : apiTypes) {
            String registeredPath;
            if (apiType.equals("webApi")) {
                registeredPath = methodInfo.getPath();
                if (!registeredPath.contains(PATH_SITE_KEY)) continue;
                if (registeredPath.startsWith("/{omadacId}/api/v2/sites/{siteId}")) {
                    return (String)WebUtils.OMADAC_SITE_API_TEMPLATE.match(path).get("siteId");
                }
                if (registeredPath.startsWith("/{omadacId}/api/v2/files/sites/{siteId}")) {
                    return (String)WebUtils.SITE_FILE_API_TEMPLATE.match(path).get("siteId");
                }
                if (registeredPath.startsWith("/{omadacId}/api/v2/hotspot/sites/{siteId}")) {
                    return (String)WebUtils.SITE_HOTSPOT_API_TEMPLATE.match(path).get("siteId");
                }
                if (!WebUtils.OPEN_API_SITE_ID_API_TEMPLATE.match(registeredPath).isEmpty() && !((String)WebUtils.OPEN_API_SITE_ID_API_TEMPLATE.match(registeredPath).get("siteId")).isBlank()) {
                    return (String)WebUtils.OPEN_API_SITE_ID_API_TEMPLATE.match(path).get("siteId");
                }
                if (!WebUtils.OPEN_API_SITE_FILE_API_TEMPLATE.match(registeredPath).isEmpty() && !((String)WebUtils.OPEN_API_SITE_FILE_API_TEMPLATE.match(registeredPath).get("siteId")).isBlank()) {
                    return (String)WebUtils.OPEN_API_SITE_FILE_API_TEMPLATE.match(path).get("siteId");
                }
            }
            if (!apiType.equals("appApi") || !(registeredPath = methodInfo.getPath()).contains(PATH_SITE_KEY)) continue;
            if (registeredPath.startsWith("/{omadacId}/api/v2/app/sites/{siteId}")) {
                return (String)WebUtils.APP_SITE_API_TEMPLATE.match(path).get("siteId");
            }
            if (WebUtils.APP_SITE_FILE_API_TEMPLATE.match(registeredPath).isEmpty() || ((String)WebUtils.APP_SITE_FILE_API_TEMPLATE.match(registeredPath).get("siteId")).isBlank()) continue;
            return (String)WebUtils.APP_SITE_FILE_API_TEMPLATE.match(path).get("siteId");
        }
        return null;
    }

    public String getSiteIdByAnnotationForNodeDispatch(String path, ServiceMethodInfo methodInfo) {
        String siteId = this.getSiteIdByAnnotation(path, methodInfo);
        if (siteId != null) {
            return siteId;
        }
        Set apiTypes = methodInfo.getApiType();
        for (String apiType : apiTypes) {
            String registeredPath;
            if (apiType.equals("webApi") && (registeredPath = methodInfo.getPath()).startsWith("/api/v2/msp/{mspId}/customers/{customerId}/sites/{siteId}")) {
                return (String)WebUtils.MSP_CUSTOMER_SITE_API_TEMPLATE.match(path).get("siteId");
            }
            if (!apiType.equals("appApi") || !(registeredPath = methodInfo.getPath()).startsWith("/api/v2/app/msp/{mspId}/customers/{customerId}/sites/{siteId}")) continue;
            return (String)WebUtils.MSP_APP_CUSTOMER_SITE_API_TEMPLATE.match(path).get("siteId");
        }
        return null;
    }

    private String getSiteTemplateIdByAnnotation(String path, ServiceMethodInfo methodInfo) {
        Set apiTypes = methodInfo.getApiType();
        for (String apiType : apiTypes) {
            String registeredPath;
            if (!apiType.equals("webApi") || !(registeredPath = methodInfo.getPath()).contains(PATH_SITE_KEY)) continue;
            if (registeredPath.startsWith("/{omadacId}/api/v2/sitetemplates/{siteTemplateId}")) {
                return (String)WebUtils.SITE_TEMPLATE_PATH_API_TEMPLATE.match(path).get("siteTemplateId");
            }
            if (WebUtils.OPEN_API_SITE_TEMPLATE_API_PATH_TEMPLATE.match(registeredPath).isEmpty() || ((String)WebUtils.OPEN_API_SITE_TEMPLATE_API_PATH_TEMPLATE.match(registeredPath).get("siteTemplateId")).isBlank()) continue;
            return (String)WebUtils.OPEN_API_SITE_TEMPLATE_API_PATH_TEMPLATE.match(path).get("siteTemplateId");
        }
        return null;
    }

    private boolean checkSitePermissionsByClientMode(String path, ServiceMethodInfo serviceMethodInfo, GlobalClientModeInfo globalClientModeInfo, String requestOmadacId) {
        String requestSiteId = this.getSiteIdByAnnotation(path, serviceMethodInfo);
        if (requestSiteId == null || Objects.equals("PENDING-SITE", requestSiteId)) {
            return true;
        }
        if (Objects.equals(0, globalClientModeInfo.getSitePrivilege())) {
            OperationResponse checkSiteResp = this.siteInternalApiService.d(new QuerySiteDTO(requestOmadacId, requestSiteId));
            return checkSiteResp.success() && Boolean.TRUE.equals(checkSiteResp.getResult());
        }
        if (Objects.equals(1, globalClientModeInfo.getSitePrivilege())) {
            List sitePermissions = globalClientModeInfo.getSiteIds();
            if (CollectionUtils.isEmpty((Collection)sitePermissions)) {
                return false;
            }
            return sitePermissions.contains(requestSiteId);
        }
        return false;
    }

    private boolean checkUserPermissionsByClientMode(RequestEntity request, RoleDTO role, ServiceType serviceType, ServiceMethodInfo method) {
        if (!this.checkPermission(role, serviceType, method)) {
            log.warn("Invalid user permission. path:{}, method:{}", (Object)request.getUrl().getPath(), (Object)request.getMethod());
            return false;
        }
        return true;
    }

    private OperationResponse checkMspCustomerPermissionByClientMode(String requestCustomerId, MspClientModeInfo mspClientModeInfo, String mspId) {
        Integer customerPrivilege = mspClientModeInfo.getCustomerPrivilege();
        if (Objects.equals(0, customerPrivilege)) {
            OperationResponse customersOpt = this.omadacInternalApiService.a(mspId);
            if (!customersOpt.success()) {
                return customersOpt;
            }
            List allCustomerIds = Optional.ofNullable((ListCustomersBriefDTO)customersOpt.getResult()).map(ListCustomersBriefDTO::getOmadacs).map(omadacDTOS -> omadacDTOS.stream().map(OmadacDTO::getId).collect(Collectors.toList())).orElse(Collections.emptyList());
            if (!allCustomerIds.contains(requestCustomerId)) {
                return new OperationResponse(b.h);
            }
            return new OperationResponse(b.a);
        }
        if (Objects.equals(1, customerPrivilege)) {
            List customers = mspClientModeInfo.getCustomers();
            if (CollectionUtils.isEmpty((Collection)customers) || !customers.contains(requestCustomerId)) {
                return new OperationResponse(b.h);
            }
            return new OperationResponse(b.a);
        }
        if (Objects.equals(2, customerPrivilege)) {
            return new OperationResponse(b.h);
        }
        return new OperationResponse(b.h);
    }

    @Autowired
    @Lazy
    public void setIdentityAccessInternalApiService(g identityAccessInternalApiService) {
        this.identityAccessInternalApiService = identityAccessInternalApiService;
    }

    @Autowired
    @Lazy
    public void setTenantInternalApiService(com.tplink.smb.omada.identityaccess.api.internal.x tenantInternalApiService) {
        this.tenantInternalApiService = tenantInternalApiService;
    }

    @Autowired
    @Lazy
    public void setOpenApiInternalApiService(m openApiInternalApiService) {
        this.openApiInternalApiService = openApiInternalApiService;
    }

    @Autowired
    @Lazy
    public void setSiteInternalApiService(com.tplink.smb.omada.manager.configuration.api.internal.site.a siteInternalApiService) {
        this.siteInternalApiService = siteInternalApiService;
    }

    @Autowired
    @Lazy
    public void setOmadacInternalApiService(l omadacInternalApiService) {
        this.omadacInternalApiService = omadacInternalApiService;
    }

    @Lazy
    @Autowired(required=false)
    public void setUserInfoConsumers(List<UserInfoConsumer> userInfoConsumers) {
        this.userInfoConsumers = userInfoConsumers;
    }

    public static interface UserInfoConsumer {
        public void accept(long var1, @Nonnull UserDTO var3);
    }
}

