/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.interceptor;

import com.tplink.smb.omada.apigateway.cache.OmadacMacFormatCache;
import com.tplink.smb.omada.dispatcher.cache.ServiceMethodInfo;
import com.tplink.smb.omada.dispatcher.chain.HandlerChain;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.common.response.ApiResponseWrapper;
import com.tplink.smb.omada.dispatcher.interceptor.impl.AbstractRequestInterceptor;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.http.RequestEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
@Order(value=320)
public class MacFormatInterceptor
extends AbstractRequestInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MacFormatInterceptor.class);
    private final OmadacMacFormatCache macFormatCache;

    @Autowired
    public MacFormatInterceptor(OmadacMacFormatCache macFormatCache) {
        this.macFormatCache = macFormatCache;
    }

    public OperationResponse<?> preHandle(RequestEntity<String> request, Map<String, MultipartFile> multipartFileMap, ApiResponseWrapper<?> response, ServiceMethodInfo method, HandlerChain chain) {
        if (this.isRequestFromApp(request) && !this.needHandleForApp(request)) {
            return OperationResponse.SUCCESS;
        }
        Integer macFormat = this.macFormatCache.getMacFormatByOmadacId(chain.getOmadacId());
        if (log.isDebugEnabled()) {
            log.debug("Prehandle response, add x-mac-format {} to header for response of {}", (Object)macFormat, (Object)request.getUrl());
        }
        if (macFormat != null) {
            response.setHeader("x-mac-format", macFormat.toString());
        }
        return OperationResponse.SUCCESS;
    }

    private boolean isRequestFromApp(RequestEntity<String> request) {
        List headerValues = request.getHeaders().get((Object)"requestByApp");
        return headerValues != null && !headerValues.isEmpty() && Objects.equals("true", headerValues.get(0));
    }

    private boolean needHandleForApp(RequestEntity<String> request) {
        List headerValues = request.getHeaders().get((Object)"support-mac-formatter");
        return headerValues != null && !headerValues.isEmpty() && Objects.equals("true", headerValues.get(0));
    }
}

