/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.interceptor;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.tplink.smb.omada.apigateway.dispatch.cache.BusySiteCache;
import com.tplink.smb.omada.apigateway.dispatch.cache.OmadacCache;
import com.tplink.smb.omada.apigateway.dispatch.configuration.BusySiteProperties;
import com.tplink.smb.omada.apigateway.dispatch.meter.ApiMeters;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.dispatcher.cache.ServiceMethodInfo;
import com.tplink.smb.omada.dispatcher.chain.HandlerChain;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.common.response.ApiResponseWrapper;
import com.tplink.smb.omada.dispatcher.interceptor.impl.AbstractRequestInterceptor;
import com.tplink.smb.omada.dispatcher.interceptor.impl.MetersRequestInterceptor;
import com.tplink.smb.omada.judgement.a.e;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.http.RequestEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.util.UriTemplate;

@Component
@Order(value=310)
public class BusySiteHandler
extends AbstractRequestInterceptor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BusySiteHandler.class);
    private final UriTemplate omadacTemplate = new UriTemplate("/{omadacId}/api/v2");
    private final UriTemplate mspCustomerTemplate = new UriTemplate("/api/v2/msp/{mspId}/customers/{customerId}");
    private BusySiteCache busySiteCache;
    private BusySiteProperties busySiteProperties;
    private e judgeService;
    private ApiMeters apiMeters;
    private OmadacCache omadacCache;
    private final Cache<Long, Long> startNanoCache = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofHours(1L)).initialCapacity(1000).maximumSize(20000L).build();

    public com.tplink.smb.omada.common.access.OperationResponse<?> preHandle(RequestEntity<String> request, Map<String, MultipartFile> multipartFileMap, ApiResponseWrapper<?> response, ServiceMethodInfo method, HandlerChain chain) {
        log.debug("BusySiteHandler preHandle start.");
        String path = request.getUrl().getPath();
        String registerPath = method.getPath();
        log.trace("busy site handler path: {}, register path: {}", (Object)path, (Object)registerPath);
        String omadacId = this.getOmadacId(path, method);
        this.handleStrategicOmadac(omadacId, chain.getRequestId());
        try {
            if (this.judgeService.a("partial_busy") && !this.busySiteProperties.getBusyPath().contains(registerPath)) {
                log.trace("path: {} is not in busy path.", (Object)registerPath);
                return com.tplink.smb.omada.common.access.OperationResponse.SUCCESS;
            }
        }
        catch (Exception e2) {
            log.error("check busy path error: {}", (Object)e2.getMessage());
        }
        if (Objects.nonNull(omadacId)) {
            this.busySiteCache.put(omadacId);
        }
        log.trace("omada controller: {} will change to busy", (Object)omadacId);
        return com.tplink.smb.omada.common.access.OperationResponse.SUCCESS;
    }

    public void postHandle(RequestEntity<String> request, OperationResponse<?> result, ApiResponseWrapper<?> response, ServiceMethodInfo method, HandlerChain chain) {
        try {
            if (!this.busySiteProperties.getControllerMonitorEnabled().booleanValue()) {
                return;
            }
            Long start = (Long)this.startNanoCache.getIfPresent((Object)chain.getRequestId());
            if (start == null) {
                return;
            }
            String httpMethod = Optional.ofNullable(request.getMethod()).map(HttpMethod::name).orElse("unknown");
            String serviceMethodPath = method.getPath();
            int errorCode = result.getErrorCode();
            String importance = method.getImportance();
            String timeCostLevel = method.getTimeCostLevel();
            this.startNanoCache.invalidate((Object)chain.getRequestId());
            double delta = (double)(System.nanoTime() - start) / MetersRequestInterceptor.SECOND_TO_NANOS;
            this.apiMeters.summaryRequestsSeconds(httpMethod, serviceMethodPath, errorCode, delta, importance, timeCostLevel);
            if (log.isDebugEnabled()) {
                log.debug("successfully monitor strategic customer interface. serviceMethodPath: {}, httpMethod: {}, errorCode:{}, latency(s): {}", new Object[]{serviceMethodPath, httpMethod, errorCode, delta});
            }
        }
        catch (Exception e2) {
            log.error("monitor strategic customer interface failed", (Throwable)e2);
        }
    }

    private String getOmadacId(String path, ServiceMethodInfo methodInfo) {
        if (Objects.isNull(path)) {
            return null;
        }
        String registeredPath = methodInfo.getPath();
        if (registeredPath.startsWith("/api/v2/msp")) {
            Map uriMap = this.mspCustomerTemplate.match(path);
            return (String)uriMap.get("customerId");
        }
        if (registeredPath.startsWith("/{omadacId}/api/v2")) {
            Map uriMap = this.omadacTemplate.match(path);
            return (String)uriMap.get("omadacId");
        }
        return null;
    }

    private void handleStrategicOmadac(String omadacId, Long requestId) {
        try {
            if (!this.busySiteProperties.getControllerMonitorEnabled().booleanValue() || T.a((String)omadacId)) {
                return;
            }
            if (!this.omadacCache.isStrategicController(omadacId) || this.omadacCache.inBlackListStrategicController(omadacId)) {
                if (log.isDebugEnabled()) {
                    log.debug("{} is not a strategic customer", (Object)omadacId);
                }
                return;
            }
            this.startNanoCache.put((Object)requestId, (Object)System.nanoTime());
            if (log.isDebugEnabled()) {
                log.debug("{} is a strategic customer, start monitor, requestId: {}", (Object)omadacId, (Object)requestId);
            }
        }
        catch (Exception e2) {
            log.error("get omadacId failed", (Throwable)e2);
        }
    }

    @Autowired
    @Lazy
    public void setBusySiteCache(BusySiteCache busySiteCache) {
        this.busySiteCache = busySiteCache;
    }

    @Autowired
    @Lazy
    public void setBusySiteProperties(BusySiteProperties busySiteProperties) {
        this.busySiteProperties = busySiteProperties;
    }

    @Autowired
    @Lazy
    public void setJudgeService(e judgeService) {
        this.judgeService = judgeService;
    }

    @Autowired
    @Lazy
    public void setOmadacCache(OmadacCache omadacCache) {
        this.omadacCache = omadacCache;
    }

    @Autowired
    @Lazy
    public void setApiMeters(ApiMeters apiMeters) {
        this.apiMeters = apiMeters;
    }
}

