/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.filter;

import com.google.common.collect.Sets;
import com.tplink.smb.omada.common.obfuscate.KeepClassNameAndSetter;
import com.tplink.smb.omada.common.omadac.OmadacType;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.shiro.config.ConfigurationException;
import org.apache.shiro.web.filter.authz.AuthorizationFilter;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;

@KeepClassNameAndSetter
public class PortFilter
extends AuthorizationFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PortFilter.class);
    private Map<String, Integer> portMap;
    private static final String INTERNAL_SERVER_PORT = "internalHttpPort";
    private static final String CLUSTER_SERVER_PORT = "clusterHttpsPort";

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws ConfigurationException {
        Set<String> keys = this.getKeys(mappedValue);
        if (keys.isEmpty()) {
            return true;
        }
        if (CollectionUtils.isEmpty(this.portMap)) {
            log.debug("portMap is not configured, cannot filter request.");
            return true;
        }
        int port = this.getPort(request);
        if (log.isTraceEnabled()) {
            log.trace("Access Port is {}, request is {}", (Object)port, (Object)((HttpServletRequest)request).getServletPath());
        }
        for (String key : keys) {
            Integer value = this.portMap.get(key);
            if (value == null) {
                throw new ConfigurationException("The key: " + key + " is not exist in portMap.");
            }
            if (port != value) continue;
            return true;
        }
        if (OmadacType.s() && request.getLocalPort() == this.portMap.get(INTERNAL_SERVER_PORT).intValue()) {
            return true;
        }
        return request.getLocalPort() == this.portMap.get(CLUSTER_SERVER_PORT).intValue() && (Objects.equals("1", System.getProperty("hiability.mode")) || Objects.equals("2", System.getProperty("hiability.mode")));
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) {
        WebUtils.toHttp((ServletResponse)response).setStatus(HttpStatus.NOT_FOUND.value());
        return false;
    }

    private int getPort(ServletRequest request) {
        return request.getLocalPort();
    }

    private Set<String> getKeys(Object mappedValue) {
        Object[] keys = (String[])mappedValue;
        if (keys == null) {
            return Collections.emptySet();
        }
        return Sets.newHashSet((Object[])keys);
    }

    public void setPortMap(Map<String, Integer> portMap) {
        this.portMap = portMap;
    }
}

