/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.filter;

import com.tplink.smb.omada.apigateway.dispatch.filter.CustomAccessControlFilter;
import com.tplink.smb.omada.apigateway.dispatch.util.WebUtils;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.obfuscate.KeepClassNameAndSetter;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.identityaccess.api.internal.dto.GetSessionRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.h;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

@KeepClassNameAndSetter
public class OpenApiLoginFilter
extends CustomAccessControlFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OpenApiLoginFilter.class);
    @Lazy
    @Autowired
    private h identityAccessInternalApiService;

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (httpRequest.getContentType() != null && httpRequest.getContentType().contains("multipart/form-data")) {
            return true;
        }
        String responseType = httpRequest.getParameter("response_type");
        if (T.a((String)responseType, (String)"code") || WebUtils.isRequestFromApp(httpRequest) || WebUtils.isRequestFromWeb(httpRequest)) {
            return this.checkCsrfTokenAndSessionByCode(request, response);
        }
        String requestGrantType = request.getParameter("grant_type");
        if (T.a((String)"client_credentials", (String)requestGrantType) || T.a((String)"authorization_code", (String)requestGrantType) || T.a((String)"refresh_token", (String)requestGrantType)) {
            return true;
        }
        String requestAccessToken = httpRequest.getHeader("Authorization");
        return !T.a((String)requestAccessToken);
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) {
        log.debug("Just perform the normal redirection.");
        HttpServletResponse servletResponse = (HttpServletResponse)response;
        servletResponse.setHeader("Cache-Control", "no-cache");
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (WebUtils.isRequestFromApp(httpRequest) || WebUtils.isRequestFromWeb(httpRequest)) {
            WebUtils.buildAccessDeniedResponse(response);
        } else {
            WebUtils.buildOpenApiAccessDeniedResponse(response);
        }
        return false;
    }

    private boolean checkCsrfTokenAndSessionByCode(ServletRequest request, ServletResponse response) {
        Session currentSession;
        try {
            Subject currentSub = this.getSubject(request, response);
            if (currentSub.getPrincipal() == null) {
                return false;
            }
            currentSession = currentSub.getSession(false);
        }
        catch (Exception e2) {
            log.warn(" get session from http request failed", (Throwable)e2);
            return false;
        }
        if (currentSession == null) {
            return false;
        }
        String sessionId = String.valueOf(currentSession.getId());
        GetSessionRequestDTO getSessionRequest = GetSessionRequestDTO.builder().sessionId(sessionId).build();
        OperationResponse optRes = this.identityAccessInternalApiService.b(getSessionRequest);
        if (!optRes.success()) {
            log.debug("session is not exist.");
            return false;
        }
        boolean valid = WebUtils.isVaildToken(request);
        if (valid) {
            // empty if block
        }
        return valid;
    }
}

