/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.filter;

import com.tplink.smb.omada.apigateway.dispatch.shiro.security.CloudUserToken;
import com.tplink.smb.omada.apigateway.dispatch.shiro.security.HotspotToken;
import com.tplink.smb.omada.apigateway.dispatch.shiro.security.LocalUserToken;
import com.tplink.smb.omada.apigateway.dispatch.shiro.security.SsoToken;
import com.tplink.smb.omada.common.obfuscate.KeepClassNameAndSetter;
import java.util.Collection;
import lombok.Generated;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.pam.ModularRealmAuthenticator;
import org.apache.shiro.realm.Realm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KeepClassNameAndSetter
public class MultiLoginAuthenticator
extends ModularRealmAuthenticator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MultiLoginAuthenticator.class);

    protected AuthenticationInfo doAuthenticate(AuthenticationToken authenticationToken) throws AuthenticationException {
        log.debug("do authenticate");
        if (authenticationToken instanceof HotspotToken) {
            Realm hotspotRealm = this.lookupRealm(((HotspotToken)authenticationToken).getRealmName());
            return this.doSingleRealmAuthentication(hotspotRealm, authenticationToken);
        }
        if (authenticationToken instanceof CloudUserToken) {
            Realm cloudbaseRealm = this.lookupRealm(((CloudUserToken)authenticationToken).getRealmName());
            return this.doSingleRealmAuthentication(cloudbaseRealm, authenticationToken);
        }
        if (authenticationToken instanceof SsoToken) {
            Realm ssoRealm = this.lookupRealm(((SsoToken)authenticationToken).getRealmName());
            return this.doSingleRealmAuthentication(ssoRealm, authenticationToken);
        }
        if (authenticationToken instanceof LocalUserToken) {
            Realm localUserRealm = this.lookupRealm(((LocalUserToken)authenticationToken).getRealmName());
            return this.doSingleRealmAuthentication(localUserRealm, authenticationToken);
        }
        return super.doAuthenticate(authenticationToken);
    }

    protected Realm lookupRealm(String realmName) throws AuthenticationException {
        Collection realms = this.getRealms();
        for (Realm realm : realms) {
            if (!realm.getName().equalsIgnoreCase(realmName)) continue;
            return realm;
        }
        throw new AuthenticationException("No realm configured for Client " + realmName);
    }
}

