/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.filter;

import com.tplink.smb.omada.apigateway.dispatch.filter.CustomAccessControlFilter;
import com.tplink.smb.omada.apigateway.dispatch.stomp.port.cache.StompSessionCache;
import com.tplink.smb.omada.apigateway.dispatch.util.WebUtils;
import com.tplink.smb.omada.common.obfuscate.KeepClassNameAndSetter;
import com.tplink.smb.omada.common.omadac.OmadacType;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import lombok.Generated;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KeepClassNameAndSetter
public class LoginFilter
extends CustomAccessControlFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoginFilter.class);

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        Session currentSession;
        Object obj = request.getAttribute("OMADA_REST_DISPATCHER_ATTRIBUTES");
        if (obj instanceof Map) {
            Map map = (Map)obj;
            boolean filtered = Boolean.TRUE.equals(map.get("login.filtered"));
            log.trace("Find DISPATCHER_ATTR: {}, filtered: {}", (Object)map, (Object)filtered);
            return true;
        }
        try {
            Subject currentSub = this.getSubject(request, response);
            if (currentSub.getPrincipal() == null) {
                log.info("get no current subject from request.");
                return false;
            }
            currentSession = currentSub.getSession(false);
        }
        catch (Exception e2) {
            log.warn(" get session from http request failed", (Throwable)e2);
            return false;
        }
        if (currentSession == null) {
            log.info("get no session from http request");
            return false;
        }
        return WebUtils.isVaildToken(request);
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        try {
            Subject subject = this.getSubject(request, response);
            if (subject != null) {
                subject.logout();
                WebUtils.setClearCookiePath(WebUtils.getOmadacIdFromRequest(request), response);
                log.info("request check login failed. omadacId:{}, url:{}", (Object)WebUtils.getOmadacIdFromRequest(request), (Object)((HttpServletRequest)request).getRequestURI());
            }
        }
        catch (UnknownSessionException e2) {
            log.warn("Fail to get session ", (Throwable)e2);
            return false;
        }
        if (WebUtils.isAjax((HttpServletRequest)request) || WebUtils.isRequestFromApp((HttpServletRequest)request)) {
            log.debug("Request is app {}", (Object)WebUtils.isRequestFromApp((HttpServletRequest)request));
            log.debug("This is ajax/app request, no redirection, but add header.");
            WebUtils.buildAccessDeniedResponse(response);
            this.closeWsSession(request);
            return false;
        }
        log.debug("Just perform the normal redirection.");
        HttpServletResponse servletResponse = (HttpServletResponse)response;
        servletResponse.setHeader("Cache-Control", "no-cache");
        if (OmadacType.s()) {
            this.saveRequestAndRedirectToHttpsLogin(request, (ServletResponse)servletResponse, "/login");
        } else {
            String omadacId = System.getProperty("eap.omadac.id");
            String loginUrl = "/" + omadacId + "/login";
            org.apache.shiro.web.util.WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)servletResponse, (String)loginUrl);
        }
        this.closeWsSession(request);
        return false;
    }

    private void closeWsSession(ServletRequest request) {
        String sessionId = WebUtils.getSessionId((HttpServletRequest)request);
        StompSessionCache.removeAndCloseSessionByHttpSessionId(sessionId);
    }
}

