/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.filter;

import com.tplink.smb.omada.apigateway.dispatch.cache.IpAccessCache;
import com.tplink.smb.omada.apigateway.dispatch.cache.IpAccessStatusBO;
import com.tplink.smb.omada.apigateway.dispatch.configuration.IpAccessFilterProperties;
import com.tplink.smb.omada.apigateway.dispatch.util.IpFilterUtils;
import com.tplink.smb.omada.apigateway.dispatch.util.WebUtils;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.obfuscate.KeepClassNameAndSetter;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import lombok.Generated;
import org.apache.shiro.web.filter.authc.AnonymousFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;

@KeepClassNameAndSetter
public class IpAccessRuleFilter
extends AnonymousFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IpAccessRuleFilter.class);
    private IpAccessCache ipAccessCache;
    private IpAccessFilterProperties properties;
    private static String EXECUTED = "executed";

    public boolean onPreHandle(ServletRequest request, ServletResponse response, Object mappedValue) {
        log.debug(" ip access rule filter has already executed {}", request.getAttribute(EXECUTED));
        if (request.getAttribute(EXECUTED) != null) {
            return true;
        }
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        String userIp = WebUtils.getRemoteAddress(servletRequest);
        request.setAttribute(EXECUTED, (Object)Boolean.TRUE);
        if (OmadacType.s() && !this.properties.getEnable().booleanValue()) {
            return true;
        }
        if (T.a((String)userIp)) {
            log.warn("Path ={}, UserIp is not exist.", (Object)servletRequest.getRequestURI());
            return false;
        }
        if (IpFilterUtils.isAddressNeedOpen(userIp, servletRequest)) {
            return true;
        }
        OperationResponse resultResponse = this.checkIpAddress(userIp, servletRequest);
        if (resultResponse.success()) {
            return true;
        }
        WebUtils.buildIpAccessDeniedResponse(response, resultResponse);
        return false;
    }

    private OperationResponse checkIpAddress(String userIp, HttpServletRequest servletRequest) {
        OperationResponse<String> omadacIdResponse = this.getOmadacIdRequest(servletRequest);
        String omadacId = (String)omadacIdResponse.getResult();
        if (T.a((String)omadacId) && OmadacType.s()) {
            log.error("Path= {} does not contain OmadacId", (Object)servletRequest.getRequestURI());
            return new OperationResponse(b.aA);
        }
        OperationResponse<IpAccessStatusBO> operationResponseStatus = this.ipAccessCache.getIpAccessStatusBO(omadacId);
        if (!operationResponseStatus.success() || Objects.isNull(operationResponseStatus.getResult())) {
            log.error("Path= {} does not find OmadacId", (Object)servletRequest.getRequestURI());
            return new OperationResponse(b.aA);
        }
        if (((IpAccessStatusBO)operationResponseStatus.getResult()).getEnable().booleanValue()) {
            if (!IpFilterUtils.isIpv4OrLoopbackAddress(userIp)) {
                log.warn("IPV6 address not supported, omadacId {}", (Object)omadacId);
                return new OperationResponse(b.n);
            }
            OperationResponse response = this.ipAccessCache.inIpAccessWhiteIp(omadacId, userIp);
            return response;
        }
        return OperationResponse.SUCCESS;
    }

    private OperationResponse<String> getOmadacIdRequest(HttpServletRequest servletRequest) {
        String mspId = WebUtils.getMspId((ServletRequest)servletRequest);
        if (mspId != null) {
            return OperationResponse.success((Object)mspId);
        }
        String omadacId = WebUtils.getOmadacId((ServletRequest)servletRequest);
        return OperationResponse.success((Object)omadacId);
    }

    @Autowired
    public void setIpAccessCache(IpAccessCache ipAccessCache) {
        this.ipAccessCache = ipAccessCache;
    }

    @Autowired
    @Lazy
    public void setProperties(IpAccessFilterProperties properties) {
        this.properties = properties;
    }
}

