/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.filter;

import com.tplink.smb.omada.common.obfuscate.KeepClassNameAndSetter;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.shiro.web.filter.authc.AnonymousFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@KeepClassNameAndSetter
public class HttpHeaderSecurityFilter
extends AnonymousFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpHeaderSecurityFilter.class);
    private static final String CSP_PATH = "/csp/contentSecurityPolicy";
    private String contentSecurityPolicy = this.getFileString("/csp/contentSecurityPolicy");

    public boolean onPreHandle(ServletRequest request, ServletResponse response, Object mappedValue) {
        HttpServletRequest servletRequest = (HttpServletRequest)request;
        HttpServletResponse servletResponse = (HttpServletResponse)response;
        this.addSecurityHeader(servletResponse);
        return true;
    }

    public void destroy() {
    }

    private String getFileString(String path) {
        InputStream inputStream = HttpHeaderSecurityFilter.class.getResourceAsStream(path);
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
            }
        }
        catch (IOException e2) {
            log.error("File loading failed.", (Throwable)e2);
        }
        return stringBuilder.toString();
    }

    private void addSecurityHeader(HttpServletResponse response) {
        response.setHeader("X-Frame-Options", "SAMEORIGIN");
        response.setHeader("X-Content-Type-Options", "nosniff");
        response.setHeader("Content-Security-Policy", this.contentSecurityPolicy);
        response.setHeader("Strict-Transport-Security", "max-age=0; includeSubDomains");
        response.setHeader("Referrer-Policy", "strict-origin-when-cross-origin");
    }
}

