/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.filter;

import com.tplink.smb.omada.apigateway.dispatch.filter.CustomAccessControlFilter;
import com.tplink.smb.omada.apigateway.dispatch.util.WebUtils;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.obfuscate.KeepClassNameAndSetter;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.identityaccess.api.internal.dto.HotspotSessionRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.h;
import com.tplink.smb.omada.identityaccess.api.internal.i;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import lombok.Generated;
import org.apache.shiro.subject.Subject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.util.UriTemplate;

@KeepClassNameAndSetter
public class HotspotLoginFilter
extends CustomAccessControlFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HotspotLoginFilter.class);
    private final UriTemplate uriTemplate = new UriTemplate("/{omadacId}");
    @Lazy
    @Autowired
    private i identityHotspotInternalApiService;
    @Lazy
    @Autowired
    private h identityAccessInternalApiService;

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        Map uriMap = this.uriTemplate.match(httpRequest.getRequestURI());
        if (!uriMap.containsKey("omadacId")) {
            log.warn("http request url not exist omadacId.");
            return false;
        }
        Subject currentSub = this.getSubject(request, response);
        if (currentSub.getPrincipal() == null) {
            return false;
        }
        HotspotSessionRequestDTO hotspotSessionRequestDTO = HotspotSessionRequestDTO.builder().omadacId((String)uriMap.get("omadacId")).name(String.valueOf(currentSub.getPrincipal())).sessionId(String.valueOf(currentSub.getSession().getId())).build();
        OperationResponse optHotspotRes = this.identityHotspotInternalApiService.b(hotspotSessionRequestDTO);
        if (!Boolean.TRUE.equals(optHotspotRes.getResult())) {
            log.debug("session is not exist.");
            return false;
        }
        OperationResponse optRefreshRes = this.identityHotspotInternalApiService.c(hotspotSessionRequestDTO);
        if (Boolean.TRUE.equals(optRefreshRes.getResult()) && !((HttpServletRequest)request).getRequestURI().contains("print")) {
            WebUtils.toHttp(response).addHeader("sessionStatus", "refresh");
            this.identityHotspotInternalApiService.d(hotspotSessionRequestDTO);
        }
        return WebUtils.isVaildToken(request);
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        Subject subject = this.getSubject(request, response);
        if (subject != null) {
            subject.logout();
            WebUtils.setHotspotCookiePath(WebUtils.getOmadacIdFromRequest(request), response);
            log.info("request check login failed. omadacId:{}, url:{}", (Object)WebUtils.getOmadacIdFromRequest(request), (Object)((HttpServletRequest)request).getRequestURI());
        }
        if (WebUtils.isAjax((HttpServletRequest)request) || WebUtils.isRequestFromApp((HttpServletRequest)request)) {
            log.debug("Request is app {}", (Object)WebUtils.isRequestFromApp((HttpServletRequest)request));
            log.debug("This is ajax/app request, no redirection, but add header.");
            WebUtils.buildAccessDeniedResponse(response);
        } else {
            log.debug("Just perform the normal redirection.");
            HttpServletResponse servletResponse = (HttpServletResponse)response;
            servletResponse.setHeader("Cache-Control", "no-cache");
            if (OmadacType.s()) {
                this.saveRequestAndRedirectToHttpsLogin(request, (ServletResponse)servletResponse, "/hotspot/login");
            } else {
                String omadacId = System.getProperty("eap.omadac.id");
                String loginUrl = "/" + omadacId + "/hotspot/login";
                org.apache.shiro.web.util.WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)servletResponse, (String)loginUrl);
            }
        }
        return false;
    }
}

