/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.filter;

import com.tplink.smb.omada.apigateway.dispatch.configuration.CorsProperties;
import com.tplink.smb.omada.common.obfuscate.KeepClassNameAndSetter;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.shiro.web.filter.authc.AnonymousFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestMethod;

@KeepClassNameAndSetter
public class FrontCorsFilter
extends AnonymousFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FrontCorsFilter.class);
    @Autowired
    private CorsProperties corsProperties;
    public static final String ALLOW_METHODS = "OPTIONS,GET,POST,DELETE,PUT,PATCH";

    public boolean onPreHandle(ServletRequest request, ServletResponse response, Object mappedValue) {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String origin = httpRequest.getHeader("Origin");
        if (origin != null) {
            origin = origin.trim();
        }
        if (!CollectionUtils.isEmpty(this.corsProperties.getAllowedOrigins()) && this.corsProperties.getAllowedOrigins().contains(origin)) {
            httpResponse.setHeader("Access-Control-Allow-Origin", origin);
            httpResponse.setHeader("Access-Control-Allow-Methods", ALLOW_METHODS);
            httpResponse.setHeader("Access-Control-Allow-Headers", httpRequest.getHeader("Access-Control-Request-Headers"));
            httpResponse.setHeader("Access-Control-Allow-Credentials", "true");
            httpResponse.setHeader("Access-Control-Expose-Headers", "content-disposition");
            httpResponse.setHeader("Access-Control-Max-Age", "86400");
            httpResponse.setStatus(HttpStatus.OK.value());
        }
        if (httpRequest.getMethod().equals(RequestMethod.OPTIONS.name())) {
            return false;
        }
        return super.onPreHandle(request, response, mappedValue);
    }
}

