/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.filter;

import com.tplink.smb.omada.apigateway.dispatch.util.WebUtils;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.springframework.web.util.UriTemplate;

public abstract class CustomAccessControlFilter
extends AccessControlFilter {
    private final UriTemplate uriTemplate = new UriTemplate("/{omadacId}");
    private int httpsPort;

    protected void saveRequestAndRedirectToHttpsLogin(ServletRequest request, ServletResponse response, String url) throws IOException {
        StringBuilder redirectUrl = new StringBuilder();
        if (request instanceof HttpServletRequest) {
            Map<String, String> param;
            HttpServletRequest httpServletRequest = (HttpServletRequest)request;
            Map uriMap = this.uriTemplate.match(httpServletRequest.getRequestURI());
            WebUtils.appendSchemeHostPort(redirectUrl, "https", request.getServerName(), this.httpsPort);
            if (uriMap.containsKey("omadacId")) {
                redirectUrl.append("/").append((String)uriMap.get("omadacId")).append(url);
            }
            if (this.isCloudBaseAutoLogin((HttpServletRequest)request, param = this.getParameter(request))) {
                this.buildCloudbaseLoginUrl(redirectUrl, param);
            }
        }
        org.apache.shiro.web.util.WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)redirectUrl.toString());
    }

    public void setHttpsPort(int httpsPort) {
        this.httpsPort = httpsPort;
    }

    protected void buildCloudbaseLoginUrl(StringBuilder redirectUrl, Map<String, String> param) {
        redirectUrl.append("?token=").append(param.get("token"));
        if (!StringUtils.isEmpty((CharSequence)param.get("siteKey"))) {
            redirectUrl.append("&siteKey=").append(param.get("siteKey"));
        }
    }

    protected boolean isCloudBaseAutoLogin(HttpServletRequest request, Map<String, String> paramMap) {
        String url = request.getRequestURL().toString();
        return url.endsWith("loginWithToken") && !StringUtils.isEmpty((CharSequence)paramMap.get("token"));
    }

    protected Map<String, String> getParameter(ServletRequest request) {
        Map params = request.getParameterMap();
        HashMap<String, String> newParamMap = new HashMap<String, String>(8);
        for (Map.Entry param : params.entrySet()) {
            newParamMap.put((String)param.getKey(), StringUtils.join((Object[])((String[])param.getValue())));
        }
        return newParamMap;
    }
}

