/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.filter;

import com.tplink.smb.omada.common.obfuscate.KeepClassNameAndSetter;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.shiro.web.filter.authc.AnonymousFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.RequestMethod;

@KeepClassNameAndSetter
public class CORSFilter
extends AnonymousFilter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CORSFilter.class);

    public boolean onPreHandle(ServletRequest request, ServletResponse response, Object mappedValue) {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (httpRequest.getMethod().equals(RequestMethod.OPTIONS.name())) {
            log.debug("Handle option reqeust.");
            this.setHeader(httpRequest, httpResponse);
            return true;
        }
        return super.onPreHandle(request, response, mappedValue);
    }

    private void setHeader(HttpServletRequest request, HttpServletResponse response) {
        response.setHeader("Access-Control-Allow-Origin", "*");
        response.setHeader("Access-Control-Allow-Methods", request.getMethod());
        response.setHeader("Access-Control-Allow-Headers", request.getHeader("Access-Control-Request-Headers"));
        response.setStatus(HttpStatus.OK.value());
    }
}

