/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.tplink.smb.omada.apigateway.dispatch.filter.HttpTraceFilter;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.dispatcher.resolver.impl.MacFormatterAware;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.http.CacheControl;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.converter.HttpMessageNotWritableException;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.AsyncSupportConfigurer;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class SpringWebConfiguration
implements WebMvcConfigurer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpringWebConfiguration.class);
    public static final int ONE_MONTH_SEC = 2592000;

    public void configureAsyncSupport(AsyncSupportConfigurer configurer) {
        configurer.setDefaultTimeout(TimeUnit.MINUTES.toMillis(90L));
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new NoCacheHandlerInterceptor());
    }

    public void addResourceHandlers(@Nonnull ResourceHandlerRegistry registry) {
        String staticFolderPath = "file:" + System.getProperty("eap.home") + File.separator + "data" + File.separator + "static" + File.separator;
        if (OmadacType.r()) {
            String webPath = "file:" + System.getProperty("eap.home") + File.separator + "lib" + File.separator + "static" + File.separator;
            log.debug("webPath : {}", (Object)webPath);
            registry.addResourceHandler(new String[]{"/*.html"}).addResourceLocations(new String[]{webPath}).setCacheControl(CacheControl.noCache());
            registry.addResourceHandler(new String[]{"/static/portal/*.html"}).addResourceLocations(new String[]{webPath}).setCacheControl(CacheControl.noCache());
            registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{staticFolderPath}).addResourceLocations(new String[]{webPath}).setCacheControl(CacheControl.maxAge((Duration)Duration.ofSeconds(2592000L)));
        } else if (OmadacType.s()) {
            registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{"classpath:/static/"});
        } else {
            registry.addResourceHandler(new String[]{"/*.html"}).addResourceLocations(new String[]{"classpath:/static/"}).setCacheControl(CacheControl.noCache());
            registry.addResourceHandler(new String[]{"/static/portal/*.html"}).addResourceLocations(new String[]{"classpath:/static/"}).setCacheControl(CacheControl.noCache());
            registry.addResourceHandler(new String[]{"/**"}).addResourceLocations(new String[]{staticFolderPath}).addResourceLocations(new String[]{"classpath:/static/"}).setCacheControl(CacheControl.maxAge((Duration)Duration.ofSeconds(2592000L)));
        }
        if (!OmadacType.r()) {
            registry.addResourceHandler(new String[]{"doc.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
            registry.addResourceHandler(new String[]{"swagger-ui.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
            registry.addResourceHandler(new String[]{"/webjars/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/webjars/"});
        }
    }

    @Primary
    @Bean(value={"customObjectMapper"})
    public ObjectMapper customObjectMapper() {
        return x.a();
    }

    @Bean
    @Primary
    public MappingJackson2HttpMessageConverter mappingJackson2HttpMessageConverter(@Qualifier(value="customObjectMapper") ObjectMapper objectMapper) {
        return new MappingJackson2HttpMessageConverter(objectMapper){

            protected void writeInternal(@Nonnull Object object, Type type, @Nonnull HttpOutputMessage outputMessage) throws IOException, HttpMessageNotWritableException {
                MacFormatterAware.wrap(() -> Optional.ofNullable(((ServletServerHttpResponse)outputMessage).getServletResponse().getHeaders("x-mac-format")).filter(collection -> !collection.isEmpty()).map(collection -> (String)collection.iterator().next()).map(Integer::parseInt).orElse(1), () -> super.writeInternal(object, type, outputMessage));
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public HttpTraceFilter httpTraceFilter() {
        return new HttpTraceFilter();
    }

    static class NoCacheHandlerInterceptor
    implements HandlerInterceptor {
        NoCacheHandlerInterceptor() {
        }

        public boolean preHandle(@Nonnull HttpServletRequest request, @Nonnull HttpServletResponse response, @Nonnull Object handler) {
            response.setHeader("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate");
            return true;
        }
    }
}

