/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.configuration;

import com.tplink.smb.omada.apigateway.dispatch.cookie.ShiroCookieFactory;
import com.tplink.smb.omada.apigateway.dispatch.filter.CORSFilter;
import com.tplink.smb.omada.apigateway.dispatch.filter.FrontCorsFilter;
import com.tplink.smb.omada.apigateway.dispatch.filter.HotspotLoginFilter;
import com.tplink.smb.omada.apigateway.dispatch.filter.HttpHeaderSecurityFilter;
import com.tplink.smb.omada.apigateway.dispatch.filter.IpAccessRuleFilter;
import com.tplink.smb.omada.apigateway.dispatch.filter.LoginFilter;
import com.tplink.smb.omada.apigateway.dispatch.filter.MultiLoginAuthenticator;
import com.tplink.smb.omada.apigateway.dispatch.filter.OpenApiHospotLoginFilter;
import com.tplink.smb.omada.apigateway.dispatch.filter.OpenApiLoginFilter;
import com.tplink.smb.omada.apigateway.dispatch.filter.PortFilter;
import com.tplink.smb.omada.apigateway.dispatch.filter.RejectFilter;
import com.tplink.smb.omada.apigateway.dispatch.filter.ServiceSecretFilter;
import com.tplink.smb.omada.apigateway.dispatch.filter.SessionExpireListener;
import com.tplink.smb.omada.apigateway.dispatch.filter.SslFilter;
import com.tplink.smb.omada.apigateway.dispatch.filter.UpgradeContentLengthFilter;
import com.tplink.smb.omada.apigateway.dispatch.shiro.security.CloudUserRealm;
import com.tplink.smb.omada.apigateway.dispatch.shiro.security.HotspotRealm;
import com.tplink.smb.omada.apigateway.dispatch.shiro.security.LocalUserRealm;
import com.tplink.smb.omada.apigateway.dispatch.shiro.security.SsoRealm;
import com.tplink.smb.omada.apigateway.dispatch.shiro.session.CustomSessionIdGenerator;
import com.tplink.smb.omada.apigateway.dispatch.shiro.session.CustomShiroSessionDAO;
import com.tplink.smb.omada.common.omadac.OmadacType;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.shiro.authc.Authenticator;
import org.apache.shiro.authc.credential.DefaultPasswordService;
import org.apache.shiro.authc.credential.PasswordMatcher;
import org.apache.shiro.authc.credential.PasswordService;
import org.apache.shiro.crypto.hash.DefaultHashService;
import org.apache.shiro.crypto.hash.HashService;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.session.SessionListener;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.session.mgt.eis.SessionIdGenerator;
import org.apache.shiro.spring.LifecycleBeanPostProcessor;
import org.apache.shiro.spring.security.interceptor.AuthorizationAttributeSourceAdvisor;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.servlet.Cookie;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.springframework.aop.framework.autoproxy.DefaultAdvisorAutoProxyCreator;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.context.support.PropertySourcesPlaceholderConfigurer;
import org.springframework.web.filter.DelegatingFilterProxy;

@Configuration(proxyBeanMethods=false)
public class ShiroFilterConfiguration {
    @Value(value="${manage.http.port}")
    int httpPort;
    @Value(value="${manage.https.port}")
    int httpsPort;
    @Value(value="${portal.http.port}")
    int portalHttpPort;
    @Value(value="${portal.https.port}")
    int portalHttpsPort;
    @Value(value="${upgrade.https.port:8043}")
    int upgradeHttpsPort;
    @Value(value="${server.internalHttpPort:8089}")
    int internalHttpPort;
    @Value(value="${internal.cluster.https.port:8090}")
    int clusterInternalHttpsPort;
    @Value(value="${shiro.filter.chains}")
    private String filterChainDefinitions;
    @Value(value="${shiro.session.cookie.httpOnly}")
    private boolean cookieHttpOnly;
    @Value(value="${shiro.session.cookie.name}")
    private String cookieName;
    @Value(value="${shiro.session.cookie.secure}")
    private boolean cookieSecure;
    @Value(value="${shiro.session.cookie.maxAge}")
    private int cookieMaxAge;
    @Value(value="${shiro.session.timeout}")
    private long sessionTimeout;
    @Value(value="${shiro.filter.login.url}")
    private String loginUrl;
    @Value(value="${shiro.filter.hlogin.url}")
    private String hloginUrl;
    @Value(value="${internal.service.secret:default}")
    private String serviceSecret;

    @Bean
    public static PropertySourcesPlaceholderConfigurer propertySourcesPlaceholderConfigurer() {
        return new PropertySourcesPlaceholderConfigurer();
    }

    @Bean
    public FilterRegistrationBean<Filter> registrationLoginFilter(LoginFilter loginFilter) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)loginFilter);
        filterRegistrationBean.setEnabled(false);
        filterRegistrationBean.setAsyncSupported(true);
        filterRegistrationBean.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ASYNC});
        return filterRegistrationBean;
    }

    @Bean
    public FilterRegistrationBean<Filter> registrationRejectFilter(RejectFilter rejectFilter) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)rejectFilter);
        filterRegistrationBean.setEnabled(false);
        filterRegistrationBean.setAsyncSupported(true);
        filterRegistrationBean.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ASYNC});
        return filterRegistrationBean;
    }

    @Bean
    public FilterRegistrationBean<Filter> registrationSslFilter(SslFilter sslFilter) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)sslFilter);
        filterRegistrationBean.setEnabled(false);
        filterRegistrationBean.setAsyncSupported(true);
        filterRegistrationBean.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ASYNC});
        return filterRegistrationBean;
    }

    @Bean
    public FilterRegistrationBean<Filter> registrationPortFilter(PortFilter portFilter) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)portFilter);
        registration.setEnabled(false);
        registration.setAsyncSupported(true);
        registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ASYNC});
        return registration;
    }

    @Bean
    public FilterRegistrationBean<Filter> registrationCORSFilter(CORSFilter corsFilter) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)corsFilter);
        registration.setEnabled(false);
        registration.setAsyncSupported(true);
        registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ASYNC});
        return registration;
    }

    @Bean
    public FilterRegistrationBean<Filter> registrationServiceSecretFilter(ServiceSecretFilter serviceSecretFilter) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)serviceSecretFilter);
        registration.setEnabled(false);
        registration.setAsyncSupported(true);
        registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ASYNC});
        return registration;
    }

    @Bean
    public FilterRegistrationBean<Filter> registrationHotPortFilter(HotspotLoginFilter hotspotLoginFilter) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)hotspotLoginFilter);
        registration.setEnabled(false);
        registration.setAsyncSupported(true);
        registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ASYNC});
        return registration;
    }

    @Bean
    public FilterRegistrationBean<Filter> registrationFrontCorsFilter(FrontCorsFilter frontCorsFilter) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)frontCorsFilter);
        registration.setEnabled(false);
        registration.setAsyncSupported(true);
        registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ASYNC});
        return registration;
    }

    @Bean
    public FilterRegistrationBean<Filter> registrationOpenApiFilter(OpenApiLoginFilter openApiLoginFilter) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)openApiLoginFilter);
        filterRegistrationBean.setEnabled(false);
        filterRegistrationBean.setAsyncSupported(true);
        filterRegistrationBean.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ASYNC});
        return filterRegistrationBean;
    }

    @Bean
    public FilterRegistrationBean<Filter> registrationHotspotOpenApiFilter(OpenApiHospotLoginFilter openApiHospotLoginFilter) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)openApiHospotLoginFilter);
        filterRegistrationBean.setEnabled(false);
        filterRegistrationBean.setAsyncSupported(true);
        filterRegistrationBean.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ASYNC});
        return filterRegistrationBean;
    }

    @Bean
    public FilterRegistrationBean<Filter> registrationUpgradeContentLengthFilter(UpgradeContentLengthFilter upgradeContentLengthFilter) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)upgradeContentLengthFilter);
        filterRegistrationBean.setEnabled(false);
        filterRegistrationBean.setAsyncSupported(true);
        filterRegistrationBean.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ASYNC});
        return filterRegistrationBean;
    }

    @Bean
    public FilterRegistrationBean<Filter> registrationShiroFilter() {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new DelegatingFilterProxy("shiroFilter"));
        registration.addInitParameter("targetFilterLifecycle", "true");
        registration.setEnabled(true);
        registration.setOrder(0x7FFFFFFE);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setAsyncSupported(true);
        registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ASYNC});
        return registration;
    }

    @Bean(name={"shiroFilter"})
    public ShiroFilterFactoryBean shiroFilter(SecurityManager securityManager, SslFilter sslFilter, PortFilter portFilter, CORSFilter corsFilter, ServiceSecretFilter serviceSecretFilter, LoginFilter loginFilter, HotspotLoginFilter hotspotLoginFilter, HttpHeaderSecurityFilter httpHeaderSecurityFilter, FrontCorsFilter frontCorsFilter, OpenApiLoginFilter openApiLoginFilter, OpenApiHospotLoginFilter openApiHospotLoginFilter, RejectFilter rejectFilter, IpAccessRuleFilter ipAccessRuleFilter, UpgradeContentLengthFilter upgradeContentLengthFilter) {
        ShiroFilterFactoryBean shiroFilterFactoryBean = new ShiroFilterFactoryBean();
        shiroFilterFactoryBean.setFilterChainDefinitions(this.filterChainDefinitions);
        HashMap<String, Object> filterMap = new HashMap<String, Object>(8);
        filterMap.put("httpHeaderSecurityFilter", (Object)httpHeaderSecurityFilter);
        filterMap.put("ipAccessRuleFilter", (Object)ipAccessRuleFilter);
        filterMap.put("ssl", (Object)sslFilter);
        filterMap.put("port", (Object)portFilter);
        filterMap.put("serviceSecretFilter", (Object)serviceSecretFilter);
        filterMap.put("cors", (Object)corsFilter);
        filterMap.put("loginFilter", (Object)loginFilter);
        filterMap.put("hlogin", (Object)hotspotLoginFilter);
        filterMap.put("frontCros", (Object)frontCorsFilter);
        filterMap.put("openapiloginFilter", (Object)openApiLoginFilter);
        filterMap.put("openapihlogin", (Object)openApiHospotLoginFilter);
        filterMap.put("rejectFilter", (Object)rejectFilter);
        filterMap.put("upgradeFileFilter", (Object)upgradeContentLengthFilter);
        shiroFilterFactoryBean.setFilters(filterMap);
        shiroFilterFactoryBean.setSecurityManager(securityManager);
        org.apache.shiro.web.config.ShiroFilterConfiguration shiroFilterConfiguration = new org.apache.shiro.web.config.ShiroFilterConfiguration();
        shiroFilterConfiguration.setFilterOncePerRequest(true);
        shiroFilterFactoryBean.setShiroFilterConfiguration(shiroFilterConfiguration);
        return shiroFilterFactoryBean;
    }

    @Bean
    public PortFilter portFilter() {
        PortFilter portFilter = new PortFilter();
        HashMap<String, Integer> portMap = new HashMap<String, Integer>(8);
        portMap.put("httpPort", this.httpPort);
        portMap.put("httpsPort", this.httpsPort);
        if (Objects.equals("1", System.getProperty("hiability.mode")) || Objects.equals("2", System.getProperty("hiability.mode"))) {
            portMap.put("clusterHttpsPort", this.clusterInternalHttpsPort);
        }
        portMap.put("portalHttpPort", this.portalHttpPort);
        portMap.put("portalHttpsPort", this.portalHttpsPort);
        if (OmadacType.s()) {
            portMap.put("internalHttpPort", this.internalHttpPort);
        } else {
            portMap.put("upgradeHttpsPort", this.upgradeHttpsPort);
        }
        portFilter.setPortMap(portMap);
        return portFilter;
    }

    @Bean
    public SslFilter sslFilter() {
        SslFilter sslFilter = new SslFilter();
        sslFilter.setPort(this.httpsPort);
        return sslFilter;
    }

    @Bean
    public LoginFilter loginFilter() {
        LoginFilter loginFilter = new LoginFilter();
        loginFilter.setLoginUrl(this.loginUrl);
        loginFilter.setHttpsPort(this.httpsPort);
        return loginFilter;
    }

    @Bean
    public RejectFilter rejectFilter() {
        RejectFilter rejectFilter = new RejectFilter();
        rejectFilter.setLoginUrl(this.loginUrl);
        rejectFilter.setHttpsPort(this.httpsPort);
        return rejectFilter;
    }

    @Bean
    public HotspotLoginFilter hotspotLoginFilter() {
        HotspotLoginFilter hotspotLoginFilter = new HotspotLoginFilter();
        hotspotLoginFilter.setLoginUrl(this.hloginUrl);
        hotspotLoginFilter.setHttpsPort(this.httpsPort);
        return hotspotLoginFilter;
    }

    @Bean
    public ServiceSecretFilter serviceSecretFilter() {
        ServiceSecretFilter serviceSecretFilter = new ServiceSecretFilter();
        serviceSecretFilter.setServiceSecret(this.serviceSecret);
        return serviceSecretFilter;
    }

    @Bean
    public OpenApiLoginFilter openApiLoginFilter() {
        OpenApiLoginFilter openApiLoginFilter = new OpenApiLoginFilter();
        openApiLoginFilter.setLoginUrl(this.loginUrl);
        openApiLoginFilter.setHttpsPort(this.httpsPort);
        return openApiLoginFilter;
    }

    @Bean
    public OpenApiHospotLoginFilter openApiHospotLoginFilter() {
        OpenApiHospotLoginFilter openApiHospotLoginFilter = new OpenApiHospotLoginFilter();
        openApiHospotLoginFilter.setLoginUrl(this.hloginUrl);
        openApiHospotLoginFilter.setHttpsPort(this.httpsPort);
        return openApiHospotLoginFilter;
    }

    @Bean
    public SessionExpireListener sessionExpireListener() {
        return new SessionExpireListener();
    }

    @Bean
    public CORSFilter corsFilter() {
        return new CORSFilter();
    }

    @Bean
    public FrontCorsFilter frontCorsFilter() {
        return new FrontCorsFilter();
    }

    @Bean
    public UpgradeContentLengthFilter upgradeContentLengthFilter() {
        return new UpgradeContentLengthFilter();
    }

    @Bean
    public SecurityManager securityManager(Authenticator authenticator, LocalUserRealm localUserRealm, CloudUserRealm cloudUserRealm, HotspotRealm hotspotRealm, SsoRealm ssoRealm, SessionManager sessionManager) {
        DefaultWebSecurityManager webSecurityManager = new DefaultWebSecurityManager();
        webSecurityManager.setAuthenticator(authenticator);
        webSecurityManager.setRealms(Arrays.asList(new Realm[]{localUserRealm, cloudUserRealm, hotspotRealm, ssoRealm}));
        webSecurityManager.setSessionManager(sessionManager);
        return webSecurityManager;
    }

    @Bean
    public SessionManager sessionManager(List<SessionListener> sessionListeners, CustomShiroSessionDAO customShiroSession) {
        DefaultWebSessionManager sessionManager = new DefaultWebSessionManager();
        sessionManager.setSessionListeners(sessionListeners);
        sessionManager.setDeleteInvalidSessions(true);
        sessionManager.setGlobalSessionTimeout(this.sessionTimeout);
        sessionManager.setSessionIdUrlRewritingEnabled(false);
        sessionManager.setSessionIdCookieEnabled(true);
        sessionManager.setSessionIdCookie(this.cookie());
        customShiroSession.setSessionIdGenerator(this.sessionIdGenerator());
        sessionManager.setSessionDAO((SessionDAO)customShiroSession);
        return sessionManager;
    }

    @Bean
    public FilterRegistrationBean<Filter> registrationHttpHeaderSecurityFilter(HttpHeaderSecurityFilter httpHeaderSecurityFilter) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)httpHeaderSecurityFilter);
        registration.setEnabled(false);
        registration.setAsyncSupported(true);
        registration.addUrlPatterns(new String[]{"/*"});
        registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ASYNC});
        return registration;
    }

    @Bean
    public HttpHeaderSecurityFilter httpHeaderSecurityFilter() {
        return new HttpHeaderSecurityFilter();
    }

    @Bean
    public FilterRegistrationBean<Filter> registrationIpAccessRuleFilter(IpAccessRuleFilter IpAccessRuleFilter2) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)IpAccessRuleFilter2);
        registration.setEnabled(false);
        registration.setAsyncSupported(true);
        registration.setDispatcherTypes(DispatcherType.REQUEST, new DispatcherType[]{DispatcherType.ASYNC});
        return registration;
    }

    @Bean
    public IpAccessRuleFilter ipAccessRuleFilter() {
        return new IpAccessRuleFilter();
    }

    @Bean
    public SessionIdGenerator sessionIdGenerator() {
        return new CustomSessionIdGenerator();
    }

    public Cookie cookie() {
        Cookie cookie = ShiroCookieFactory.getCookie();
        cookie.setHttpOnly(this.cookieHttpOnly);
        cookie.setName(this.cookieName);
        cookie.setSecure(this.cookieSecure);
        cookie.setMaxAge(this.cookieMaxAge);
        return cookie;
    }

    @Bean
    public LocalUserRealm localUserRealm(PasswordMatcher passwordMatcher) {
        LocalUserRealm localUserRealm = new LocalUserRealm();
        return localUserRealm;
    }

    @Bean
    public PasswordMatcher passwordMatcher() {
        DefaultHashService hashService = new DefaultHashService();
        hashService.setGeneratePublicSalt(false);
        hashService.setHashAlgorithmName("SHA-256");
        hashService.setHashIterations(500000);
        DefaultPasswordService passwordService = new DefaultPasswordService();
        passwordService.setHashService((HashService)hashService);
        PasswordMatcher passwordMatcher = new PasswordMatcher();
        passwordMatcher.setPasswordService((PasswordService)passwordService);
        return passwordMatcher;
    }

    @Bean
    public Authenticator authenticator() {
        return new MultiLoginAuthenticator();
    }

    @Bean
    public HotspotRealm hotspotRealm() {
        return new HotspotRealm();
    }

    @Bean
    public CloudUserRealm cloudbaseRealm() {
        return new CloudUserRealm();
    }

    @Bean
    public SsoRealm ssoRealm() {
        return new SsoRealm();
    }

    @Bean
    public AuthorizationAttributeSourceAdvisor authorizationAttributeSourceAdvisor(SecurityManager securityManager) {
        AuthorizationAttributeSourceAdvisor advisor = new AuthorizationAttributeSourceAdvisor();
        advisor.setSecurityManager(securityManager);
        return advisor;
    }

    @Configuration
    public static class LifeCycleBeanPostConfiguration {
        @Bean
        public LifecycleBeanPostProcessor lifecycleBeanPostProcessor() {
            return new LifecycleBeanPostProcessor();
        }

        @Bean
        @DependsOn(value={"lifecycleBeanPostProcessor"})
        public DefaultAdvisorAutoProxyCreator advisorAutoProxyCreator() {
            return new DefaultAdvisorAutoProxyCreator();
        }
    }
}

