/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.cache;

import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.constant.w;
import com.tplink.smb.omada.common.spring.b;
import com.tplink.smb.omada.identityaccess.api.internal.dto.OmadaRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.OmadacDTO;
import com.tplink.smb.omada.identityaccess.api.internal.l;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@b
@Component
public class OmadacTypeCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OmadacTypeCache.class);
    @Autowired
    @Lazy
    private l omadacInternalApiService;
    @Autowired
    @Lazy
    private CacheService cacheService;
    private static final Integer TWO_HOURS_IN_SECONDS = 7200;
    public static final String STATUS_SUFFIX = ":org:type";
    public static final String CACHE_NAME = "apigateway:omadac:type";

    public Boolean isSubSystem(String omadacId) {
        Boolean result = false;
        try {
            result = Optional.of(omadacId + STATUS_SUFFIX).map(value -> (Boolean)this.cacheService.get(CACHE_NAME, value, Boolean.class)).orElse(null);
            if (result == null) {
                OperationResponse omadacRes = this.omadacInternalApiService.a(OmadaRequestDTO.builder().omadacId(omadacId).build());
                if (!omadacRes.success()) {
                    log.warn("omadacId:{}, OmadacTypeCache get omadac Info failed Invalid omadacId.", (Object)omadacId);
                    return Boolean.FALSE;
                }
                OmadacDTO omadacDTO = (OmadacDTO)omadacRes.getResult();
                log.debug("omadacId:{}, OmadacTypeCache get omadac Info result={}", (Object)omadacId, (Object)omadacDTO);
                Boolean finalResult = result = Boolean.valueOf(Objects.equals(w.a.a(), omadacDTO.getOrgType()));
                Optional.of(omadacId + STATUS_SUFFIX).ifPresent(value -> this.cacheService.set(CACHE_NAME, value, (Object)finalResult, (long)TWO_HOURS_IN_SECONDS.intValue(), TimeUnit.SECONDS));
            }
        }
        catch (Exception e) {
            log.warn("omadacId:{}, Fail to get oamdac type occur exception.", (Object)omadacId, (Object)e);
            return result;
        }
        return result;
    }

    public void remove(String omadacId) {
        Optional.of(omadacId + STATUS_SUFFIX).ifPresent(value -> this.cacheService.deleteKey(CACHE_NAME, value));
    }
}

