/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.tplink.smb.omada.apigateway.dispatch.configuration.BusySiteProperties;
import com.tplink.smb.omada.apigateway.dispatch.dto.OmadacBasicDTO;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.spring.b;
import com.tplink.smb.omada.identityaccess.api.internal.dto.OmadaRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.OmadacDTO;
import com.tplink.smb.omada.identityaccess.api.internal.l;
import com.tplink.smb.omada.manager.configuration.api.internal.omadac.d;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@b
@Component
public class OmadacCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OmadacCache.class);
    @Autowired
    @Lazy
    private l omadacInternalApiService;
    @Autowired
    private d strategicControllerInternalApiService;
    @Autowired
    private BusySiteProperties busySiteProperties;
    private Cache<String, OmadacBasicDTO> cache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.SECONDS).build();
    private Cache<String, Long> strategicOmadacId = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.DAYS).build();
    private Set<String> blackListStrategicOmadacId = ConcurrentHashMap.newKeySet();
    private long refreshTime = 0L;

    @Nullable
    public OmadacBasicDTO findOmadacById(String omadacId) {
        OmadacBasicDTO omadacBasicDTO;
        try {
            omadacBasicDTO = (OmadacBasicDTO)this.cache.get((Object)omadacId, () -> {
                try {
                    OperationResponse omadacDTORes = this.omadacInternalApiService.a(OmadaRequestDTO.builder().omadacId(omadacId).build());
                    if (!omadacDTORes.success()) {
                        log.warn("Invalid omadacId={}", (Object)omadacId);
                        return null;
                    }
                    OmadacBasicDTO basicDTO = new OmadacBasicDTO();
                    basicDTO.setOmadacId(omadacId);
                    basicDTO.setMspId(((OmadacDTO)omadacDTORes.getResult()).getMspId());
                    basicDTO.setPattern(((OmadacDTO)omadacDTORes.getResult()).getPattern());
                    this.cache.put((Object)omadacId, (Object)basicDTO);
                    return basicDTO;
                }
                catch (Exception e) {
                    log.warn("Fail to findOmadacById omadacId= {}", (Object)omadacId, (Object)e);
                    return null;
                }
            });
        }
        catch (ExecutionException e) {
            log.warn("Fail to findOmadacById omadacId= {}", (Object)omadacId, (Object)e);
            return null;
        }
        return omadacBasicDTO;
    }

    public boolean isStrategicController(String omadacId) {
        if (System.currentTimeMillis() - this.refreshTime > this.busySiteProperties.getRefreshInterval()) {
            com.tplink.smb.omada.common.concurrent.thread.b.a(() -> {
                this.strategicOmadacId.putAll(this.getStrategicControllers());
                this.refreshTime = System.currentTimeMillis();
            });
        }
        return this.strategicOmadacId.getIfPresent((Object)omadacId) != null;
    }

    public boolean inBlackListStrategicController(String omadacId) {
        return this.blackListStrategicOmadacId.contains(omadacId);
    }

    private Map<String, Long> getStrategicControllers() {
        Set strategicControllerSet = this.strategicControllerInternalApiService.a();
        long time = System.currentTimeMillis();
        Map<String, Long> strategicControllerMap = strategicControllerSet.stream().collect(Collectors.toMap(omadacId -> omadacId, omadacId -> time));
        log.debug("get {} Strategic Customers from manager redis", (Object)strategicControllerMap.size());
        return strategicControllerMap;
    }

    public void removeBlackListStrategicController(String omadacId) {
        this.blackListStrategicOmadacId.remove(omadacId);
    }

    public void addBlackListStrategicController(String omadacId) {
        this.blackListStrategicOmadacId.add(omadacId);
    }

    public void addStrategicOmadacId(String omadacId) {
        this.strategicOmadacId.put((Object)omadacId, (Object)System.currentTimeMillis());
    }

    public Set<String> getStrategicOmadacIds() {
        return this.strategicOmadacId.asMap().keySet();
    }
}

