/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.cache;

import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.omada.apigateway.dispatch.cache.LoginBO;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LoginCache {
    private static final Integer TWO_HOURS_IN_SECONDS = 7200;
    private static final Long TWO_HOURS_IN_MILLIS = 0x6DDD00L;
    private static final Integer LOCK_TIMES = 30;
    private static final Integer REMIND_TIMES = 26;
    private static final int CONVERT_TO_HOUR = 3600000;
    private static final int CONVERT_TO_MINUTE = 60000;
    private static final int CONVERT_TO_SECOND = 1000;
    public static final int MAX_LOGIN_NUM = 500;
    public static final String CACHE_NAME = "apigateway:logincache";
    private CacheService cacheService;

    public LoginBO get(String username) {
        return Optional.ofNullable(username).map(value -> (LoginBO)this.cacheService.get(CACHE_NAME, value, LoginBO.class)).orElse(null);
    }

    public void set(String username, LoginBO loginBO) {
        Optional.ofNullable(username).ifPresent(value -> this.cacheService.set(CACHE_NAME, value, (Object)loginBO, (long)TWO_HOURS_IN_SECONDS.intValue(), TimeUnit.SECONDS));
    }

    public void remove(String username) {
        Optional.ofNullable(username).ifPresent(value -> this.cacheService.deleteKey(CACHE_NAME, value));
    }

    public OperationResponse checkLockStatus(String username, Map<String, Object> result) {
        LoginBO freezeLogin = this.get(username);
        if (freezeLogin != null && freezeLogin.getLoginTimes() != null && freezeLogin.getLoginTimes() >= LOCK_TIMES) {
            long lastLogin = freezeLogin.getLastLoginReqTime();
            long unlockTime = lastLogin + TWO_HOURS_IN_MILLIS;
            if (System.currentTimeMillis() - unlockTime >= 0L) {
                this.remove(username);
                return OperationResponse.SUCCESS;
            }
            long leftTime = unlockTime - System.currentTimeMillis();
            int leftHour = (int)leftTime / 3600000;
            int leftMin = (int)leftTime % 3600000 / 60000;
            int leftSecond = (int)leftTime % 3600000 % 60000 / 1000;
            result.put("freezeTime", leftTime / 1000L);
            String msg = leftHour > 0 ? "Too many unsuccessful login attempts. Please retry after " + leftHour + "hours and" + leftMin + " minutes." : "Too many unsuccessful login attempts. Please retry after " + leftMin + "minutes and" + leftSecond + " seconds.";
            return new OperationResponse(b.cm, msg, result);
        }
        return OperationResponse.SUCCESS;
    }

    public OperationResponse checkLoginLimit(String username, Map<String, Object> result) {
        LoginBO cacheLogin = this.get(username);
        if (cacheLogin == null) {
            LoginBO loginBO = new LoginBO();
            loginBO.setLoginTimes(1);
            loginBO.setLastLoginReqTime(System.currentTimeMillis());
            this.set(username, loginBO);
            return new OperationResponse(b.cc);
        }
        if (cacheLogin.getLoginTimes() + 1 <= REMIND_TIMES) {
            cacheLogin.setLoginTimes(cacheLogin.getLoginTimes() + 1);
            cacheLogin.setLastLoginReqTime(System.currentTimeMillis());
            this.set(username, cacheLogin);
            return new OperationResponse(b.cc);
        }
        if (cacheLogin.getLoginTimes() + 1 > REMIND_TIMES && cacheLogin.getLoginTimes() + 1 < LOCK_TIMES) {
            cacheLogin.setLoginTimes(cacheLogin.getLoginTimes() + 1);
            cacheLogin.setLastLoginReqTime(System.currentTimeMillis());
            this.set(username, cacheLogin);
            int leftAttempts = LOCK_TIMES - cacheLogin.getLoginTimes();
            result.put("errorCount", leftAttempts);
            String msg = "Incorrect password. Attempts left: " + leftAttempts;
            return new OperationResponse(b.cs, msg, result);
        }
        cacheLogin.setLoginTimes(cacheLogin.getLoginTimes() + 1);
        cacheLogin.setLastLoginReqTime(System.currentTimeMillis());
        this.set(username, cacheLogin);
        result.put("freezeTime", TWO_HOURS_IN_SECONDS);
        String msg = "Incorrect password. Retry waiting time: 2 hours.";
        return new OperationResponse(b.ct, msg, result);
    }

    @Autowired
    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }
}

