/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.cache;

import com.fasterxml.jackson.core.type.TypeReference;
import com.tplink.nbu.common.utils.CollectionUtil;
import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.omada.apigateway.dispatch.cache.IpAccessRuleLongListBO;
import com.tplink.smb.omada.apigateway.dispatch.cache.IpAccessStatusBO;
import com.tplink.smb.omada.apigateway.dispatch.cache.IpRange;
import com.tplink.smb.omada.apigateway.dispatch.configuration.IpAccessFilterProperties;
import com.tplink.smb.omada.apigateway.dispatch.meter.ApiMeters;
import com.tplink.smb.omada.apigateway.dispatch.util.IpFilterUtils;
import com.tplink.smb.omada.apigateway.dispatch.util.WebUtils;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.obfuscate.KeepMethod;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.system.a;
import com.tplink.smb.omada.common.util.system.c;
import com.tplink.smb.omada.common.util.v;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.OmadaClusterUniversalMethodResolveClient;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.OmadaClusterUniversalRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.OmadaRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.OmadacDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.ipaccessrule.IpAccessRuleLongListDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.ipaccessrule.IpAccessRuleSetRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.ipaccessrule.IpFilterOmadaRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.h;
import com.tplink.smb.omada.identityaccess.api.internal.l;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class IpAccessCache {
    @Generated
    private static final Logger log = LogManager.getLogger(IpAccessCache.class);
    private static final Integer TWO_HOURS_IN_SECONDS = 7200;
    public static final String CACHE_NAME = "apigateway:ipaccessrulecache";
    public static final String STATUS_SUFFIX = ":status";
    public static final String WHITE_IP_SUFFIX = ":whiteIpSet";
    public static final String IP_RULE_LIST_SUFFIX = ":IpAccessRuleLong";
    private CacheService cacheService;
    private l omadacInternalApiService;
    private h identityAccessInternalApiService;
    private IpAccessFilterProperties properties;
    private ApiMeters apiMeters;
    @Autowired
    private OmadaClusterUniversalMethodResolveClient omadaClusterUniversalMethodResolveClient;

    public OperationResponse<IpAccessStatusBO> getIpAccessStatusBO(String omadacId) {
        if (T.a((String)omadacId)) {
            IpAccessStatusBO ipAccessStatusBO;
            OperationResponse operationResponse = this.omadacInternalApiService.a(IpFilterOmadaRequestDTO.builder().omadacId(null).build());
            if (!operationResponse.success()) {
                log.error("Local controller failed to obtain the highest level OmadacId");
            }
            if (Objects.isNull(ipAccessStatusBO = this.getIpAccessStatus((String)operationResponse.getResult()))) {
                return OperationResponse.success((Object)this.setIpAccessStatus((String)operationResponse.getResult(), (String)operationResponse.getResult()));
            }
            return OperationResponse.success((Object)ipAccessStatusBO);
        }
        IpAccessStatusBO ipAccessStatusBO = this.getIpAccessStatus(omadacId);
        if (Objects.isNull(ipAccessStatusBO)) {
            OperationResponse operationResponse = this.omadacInternalApiService.a(IpFilterOmadaRequestDTO.builder().omadacId(omadacId).build());
            if (!operationResponse.success()) {
                log.error("cloud controller failed to obtain the highest level OmadacId");
                return new OperationResponse(b.a((int)operationResponse.getErrorCode()));
            }
            return OperationResponse.success((Object)this.setIpAccessStatus(omadacId, (String)operationResponse.getResult()));
        }
        return OperationResponse.success((Object)ipAccessStatusBO);
    }

    private IpAccessStatusBO setIpAccessStatus(String omadacIdKey, String highestOmadacId) {
        OperationResponse omadacRes = this.omadacInternalApiService.a(OmadaRequestDTO.builder().omadacId(highestOmadacId).build());
        if (!omadacRes.success()) {
            log.warn("omadacId={} is not exist.", (Object)highestOmadacId);
            return null;
        }
        IpAccessStatusBO ipAccessStatus = new IpAccessStatusBO();
        OmadacDTO omadacDTO = (OmadacDTO)omadacRes.getResult();
        ipAccessStatus.setEnable(Boolean.TRUE.equals(omadacDTO.getIpAccessEnable()));
        Optional.of(omadacIdKey + STATUS_SUFFIX).ifPresent(value -> this.cacheService.set(CACHE_NAME, value, (Object)ipAccessStatus, (long)TWO_HOURS_IN_SECONDS.intValue(), TimeUnit.SECONDS));
        OmadaClusterUniversalRequestDTO requestDTO = new OmadaClusterUniversalRequestDTO(IpAccessCache.class, (TypeReference)new TypeReference<Void>(){}, "setCacheCluster", new Class[]{String.class, IpAccessStatusBO.class}, new Object[]{omadacIdKey, ipAccessStatus});
        this.handleLocalCluster(requestDTO);
        return ipAccessStatus;
    }

    @KeepMethod
    public void setCacheCluster(String omadacIdKey, IpAccessStatusBO ipAccessStatus) {
        log.debug("Node id: " + a.h() + "\u2014\u2014> setCacheCluster");
        Optional.of(omadacIdKey + STATUS_SUFFIX).ifPresent(value -> this.cacheService.set(CACHE_NAME, value, (Object)ipAccessStatus, (long)TWO_HOURS_IN_SECONDS.intValue(), TimeUnit.SECONDS));
    }

    public <T> void handleLocalCluster(OmadaClusterUniversalRequestDTO<?, T> requestDTO) {
        if (!a.b() || CollectionUtil.isEmpty(c.a().keySet())) {
            return;
        }
        Set nodeIds = c.a().keySet();
        for (String nodeId : nodeIds) {
            if (Objects.equals(nodeId, a.h())) continue;
            this.omadaClusterUniversalMethodResolveClient.resolveSpringBeanCall(nodeId, requestDTO);
        }
    }

    private IpAccessStatusBO getIpAccessStatus(String omadacId) {
        return Optional.of(omadacId + STATUS_SUFFIX).map(value -> (IpAccessStatusBO)this.cacheService.get(CACHE_NAME, value, IpAccessStatusBO.class)).orElse(null);
    }

    public Boolean getIpAccessWhiteIpHashValue(String omadacId, String ip) {
        if (T.a((String)omadacId)) {
            OperationResponse operationResponse = this.omadacInternalApiService.a(IpFilterOmadaRequestDTO.builder().omadacId(omadacId).build());
            if (!operationResponse.success()) {
                log.warn("Failed to obtain the OmadacId");
            }
            omadacId = (String)operationResponse.getResult();
        }
        return this.getWhiteIpHashValue(omadacId, ip);
    }

    public void setIpAccessWhiteIpHashValue(String omadacId, String ip, boolean isWhite) {
        Optional.of(omadacId + WHITE_IP_SUFFIX).map(value -> (Boolean)this.cacheService.putHashValue(CACHE_NAME, value, ip, (Object)isWhite)).orElse(null);
        Optional.of(omadacId + WHITE_IP_SUFFIX).map(value -> this.cacheService.expireKey(CACHE_NAME, value, (long)TWO_HOURS_IN_SECONDS.intValue(), TimeUnit.SECONDS)).orElse(null);
        OmadaClusterUniversalRequestDTO requestDTO = new OmadaClusterUniversalRequestDTO(IpAccessCache.class, (TypeReference)new TypeReference<Void>(){}, "setIpAccessWhiteIpHashValueCluster", new Class[]{String.class, String.class, Boolean.TYPE}, new Object[]{omadacId, ip, isWhite});
        this.handleLocalCluster(requestDTO);
    }

    @KeepMethod
    public void setIpAccessWhiteIpHashValueCluster(String omadacId, String ip, boolean isWhite) {
        log.debug("Node id: " + a.h() + "\u2014\u2014> setIpAccessWhiteIpHashValueCluster");
        Optional.of(omadacId + WHITE_IP_SUFFIX).map(value -> (Boolean)this.cacheService.putHashValue(CACHE_NAME, value, ip, (Object)isWhite)).orElse(null);
        Optional.of(omadacId + WHITE_IP_SUFFIX).map(value -> this.cacheService.expireKey(CACHE_NAME, value, (long)TWO_HOURS_IN_SECONDS.intValue(), TimeUnit.SECONDS)).orElse(null);
    }

    private Boolean getWhiteIpHashValue(String omadacId, String ip) {
        return Optional.of(omadacId + WHITE_IP_SUFFIX).map(value -> (Boolean)this.cacheService.getHashValue(CACHE_NAME, value, ip, Boolean.class)).orElse(null);
    }

    public IpAccessRuleLongListBO getIpAccessRuleLongListBO(String omadacId) {
        if (T.a((String)omadacId)) {
            IpAccessRuleLongListBO ipAccessRuleLongListBO;
            OperationResponse operationResponse = this.omadacInternalApiService.a(IpFilterOmadaRequestDTO.builder().omadacId(null).build());
            if (!operationResponse.success()) {
                log.warn("Failed to obtain the OmadacId");
            }
            if (Objects.isNull(ipAccessRuleLongListBO = this.getIpAccessRuleLongList((String)operationResponse.getResult()))) {
                return this.setIpAccessRuleLongList((String)operationResponse.getResult(), (String)operationResponse.getResult());
            }
            return ipAccessRuleLongListBO;
        }
        IpAccessRuleLongListBO ipAccessRuleLongListBO = this.getIpAccessRuleLongList(omadacId);
        if (Objects.isNull(ipAccessRuleLongListBO)) {
            OperationResponse operationResponse = this.omadacInternalApiService.a(IpFilterOmadaRequestDTO.builder().omadacId(omadacId).build());
            if (!operationResponse.success()) {
                log.warn("Failed to obtain the OmadacId");
            }
            return this.setIpAccessRuleLongList(omadacId, (String)operationResponse.getResult());
        }
        return ipAccessRuleLongListBO;
    }

    private IpAccessRuleLongListBO setIpAccessRuleLongList(String omadacIdKsy, String highestOmadacId) {
        OperationResponse ipAccessRuleSetResponse = this.identityAccessInternalApiService.a(new IpAccessRuleSetRequestDTO(highestOmadacId));
        if (!ipAccessRuleSetResponse.success()) {
            log.warn("IpAccess Rule Set get fail.");
        }
        IpAccessRuleLongListDTO dto = (IpAccessRuleLongListDTO)ipAccessRuleSetResponse.getResult();
        this.mergeIpRanges(dto);
        IpAccessRuleLongListBO ipAccessRuleLongListBO = new IpAccessRuleLongListBO();
        ipAccessRuleLongListBO.setSingleIpSet(dto.getSingleIpSet());
        ipAccessRuleLongListBO.setStartIpList(dto.getStartIpList());
        ipAccessRuleLongListBO.setEndIpList(dto.getEndIpList());
        Optional.of(omadacIdKsy + IP_RULE_LIST_SUFFIX).ifPresent(value -> this.cacheService.set(CACHE_NAME, value, (Object)ipAccessRuleLongListBO, (long)TWO_HOURS_IN_SECONDS.intValue(), TimeUnit.SECONDS));
        OmadaClusterUniversalRequestDTO requestDTO = new OmadaClusterUniversalRequestDTO(IpAccessCache.class, (TypeReference)new TypeReference<Void>(){}, "setIpAccessRuleLongListCluster", new Class[]{String.class, IpAccessRuleLongListBO.class}, new Object[]{omadacIdKsy, ipAccessRuleLongListBO});
        this.handleLocalCluster(requestDTO);
        return ipAccessRuleLongListBO;
    }

    @KeepMethod
    public void setIpAccessRuleLongListCluster(String omadacIdKsy, IpAccessRuleLongListBO ipAccessRuleLongListBO) {
        log.debug("Node id: " + a.h() + "\u2014\u2014> setIpAccessRuleLongListCluster");
        Optional.of(omadacIdKsy + IP_RULE_LIST_SUFFIX).ifPresent(value -> this.cacheService.set(CACHE_NAME, value, (Object)ipAccessRuleLongListBO, (long)TWO_HOURS_IN_SECONDS.intValue(), TimeUnit.SECONDS));
    }

    private IpAccessRuleLongListBO getIpAccessRuleLongList(String omadacId) {
        return Optional.of(omadacId + IP_RULE_LIST_SUFFIX).map(value -> (IpAccessRuleLongListBO)this.cacheService.get(CACHE_NAME, value, IpAccessRuleLongListBO.class)).orElse(null);
    }

    public void mergeIpRanges(IpAccessRuleLongListDTO vo) {
        List startIpList = vo.getStartIpList();
        List endIpList = vo.getEndIpList();
        ArrayList<Long> mergedStartIpList = new ArrayList<Long>();
        ArrayList<Long> mergedEndIpList = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)startIpList) && !CollectionUtils.isEmpty((Collection)endIpList) && startIpList.size() == endIpList.size()) {
            ArrayList<IpRange> ipRanges = new ArrayList<IpRange>();
            for (int i = 0; i < startIpList.size(); ++i) {
                ipRanges.add(new IpRange((Long)startIpList.get(i), (Long)endIpList.get(i)));
            }
            ipRanges.sort(Comparator.comparing(IpRange::getStart));
            ArrayList<IpRange> mergedRanges = new ArrayList<IpRange>();
            mergedRanges.add((IpRange)ipRanges.get(0));
            for (int i = 1; i < ipRanges.size(); ++i) {
                IpRange current = (IpRange)ipRanges.get(i);
                IpRange previous = (IpRange)mergedRanges.get(mergedRanges.size() - 1);
                if (current.getStart() <= previous.getEnd()) {
                    previous.setEnd(Math.max(current.getEnd(), previous.getEnd()));
                    continue;
                }
                mergedRanges.add(current);
            }
            for (IpRange mergedRange : mergedRanges) {
                mergedStartIpList.add(mergedRange.getStart());
                mergedEndIpList.add(mergedRange.getEnd());
            }
            vo.setStartIpList(mergedStartIpList);
            vo.setEndIpList(mergedEndIpList);
        }
    }

    public void remove(String omadacId) {
        Optional.of(omadacId + STATUS_SUFFIX).ifPresent(value -> this.cacheService.deleteKey(CACHE_NAME, value));
        Optional.of(omadacId + WHITE_IP_SUFFIX).ifPresent(value -> this.cacheService.deleteKey(CACHE_NAME, value));
        Optional.of(omadacId + IP_RULE_LIST_SUFFIX).ifPresent(value -> this.cacheService.deleteKey(CACHE_NAME, value));
        OmadaClusterUniversalRequestDTO requestDTO = new OmadaClusterUniversalRequestDTO(IpAccessCache.class, (TypeReference)new TypeReference<Void>(){}, "removeIpAccessRuleCluster", new Class[]{String.class}, new Object[]{omadacId});
        this.handleLocalCluster(requestDTO);
    }

    @KeepMethod
    public void removeIpAccessRuleCluster(String omadacId) {
        log.debug("Node id: " + a.h() + "\u2014\u2014> removeIpAccessRuleCluster");
        Optional.of(omadacId + STATUS_SUFFIX).ifPresent(value -> this.cacheService.deleteKey(CACHE_NAME, value));
        Optional.of(omadacId + WHITE_IP_SUFFIX).ifPresent(value -> this.cacheService.deleteKey(CACHE_NAME, value));
        Optional.of(omadacId + IP_RULE_LIST_SUFFIX).ifPresent(value -> this.cacheService.deleteKey(CACHE_NAME, value));
    }

    public OperationResponse inIpAccessWhiteIp(String omadacId, String ip) {
        Boolean whiteIpHashValue = this.getIpAccessWhiteIpHashValue(omadacId, ip);
        if (!Objects.isNull(whiteIpHashValue)) {
            if (Boolean.TRUE.equals(whiteIpHashValue)) {
                return OperationResponse.SUCCESS;
            }
            if (Boolean.FALSE.equals(whiteIpHashValue)) {
                log.info("The current IP={} address does not have permission to access the system, contact the administrator.", new Supplier[]{() -> com.tplink.smb.omada.common.util.e.a.c((String)ip)});
                this.apiMeters.ipIsBlockedFailCount();
                return new OperationResponse(b.n);
            }
        }
        IpAccessRuleLongListBO ipAccessRuleLongListBO = this.getIpAccessRuleLongListBO(omadacId);
        long longIp = v.b((String)ip);
        if (!CollectionUtils.isEmpty(ipAccessRuleLongListBO.getSingleIpSet()) && ipAccessRuleLongListBO.getSingleIpSet().contains(longIp)) {
            this.setIpAccessWhiteIpHashValue(omadacId, ip, true);
            return OperationResponse.SUCCESS;
        }
        List<Long> startIpList = ipAccessRuleLongListBO.getStartIpList();
        List<Long> endIpList = ipAccessRuleLongListBO.getEndIpList();
        if (!CollectionUtils.isEmpty(startIpList) && !CollectionUtils.isEmpty(endIpList) && startIpList.size() == endIpList.size()) {
            for (int i = 0; i < startIpList.size(); ++i) {
                if (startIpList.get(i) > longIp || endIpList.get(i) < longIp) continue;
                this.setIpAccessWhiteIpHashValue(omadacId, ip, true);
                return OperationResponse.SUCCESS;
            }
        }
        this.setIpAccessWhiteIpHashValue(omadacId, ip, false);
        log.info("The current IP={} address does not have permission to access the system, contact the administrator.", new Supplier[]{() -> com.tplink.smb.omada.common.util.e.a.c((String)ip)});
        this.apiMeters.ipIsBlockedFailCount();
        return new OperationResponse(b.n);
    }

    public OperationResponse isOpenIpFilterOrInIpAccessRule(String omadacId, @Nonnull HttpServletRequest request) {
        if (OmadacType.s() && this.properties.getEnable().booleanValue()) {
            String userIp = WebUtils.getRemoteAddress(request);
            OperationResponse<IpAccessStatusBO> operationResponseStatus = this.getIpAccessStatusBO(omadacId);
            if (!operationResponseStatus.success() || Objects.isNull(operationResponseStatus.getResult())) {
                log.error("omadacId:{}, getIpAccessStatusBO failed.", (Object)omadacId);
                return new OperationResponse(b.aA);
            }
            if (((IpAccessStatusBO)operationResponseStatus.getResult()).getEnable().booleanValue()) {
                if (!IpFilterUtils.isIpv4OrLoopbackAddress(userIp)) {
                    log.warn("omadacId:{}, is not Ipv4 Or LoopbackAddress.", (Object)omadacId);
                    return new OperationResponse(b.n);
                }
                if (!IpFilterUtils.isAddressNeedOpen(userIp, request) && !this.inIpAccessWhiteIp(omadacId, userIp).success()) {
                    return new OperationResponse(b.n);
                }
            }
        }
        return OperationResponse.SUCCESS;
    }

    @Autowired
    public void setCacheService(CacheService cacheService) {
        this.cacheService = cacheService;
    }

    @Autowired
    @Lazy
    public void setOmadacInternalApiService(l omadacInternalApiService) {
        this.omadacInternalApiService = omadacInternalApiService;
    }

    @Autowired
    @Lazy
    public void setIdentityAccessWebInternalApiService(h identityAccessInternalApiService) {
        this.identityAccessInternalApiService = identityAccessInternalApiService;
    }

    @Autowired
    @Lazy
    public void setIpAccessFilterProperties(IpAccessFilterProperties properties) {
        this.properties = properties;
    }

    @Autowired
    @Lazy
    public void setApiMeters(ApiMeters apiMeters) {
        this.apiMeters = apiMeters;
    }
}

