/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.tplink.smb.omada.apigateway.dispatch.configuration.BusySiteProperties;
import com.tplink.smb.omada.client.api.internal.a;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.spring.b;
import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@b
@Component
public class BusySiteCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BusySiteCache.class);
    private static final long FLUSH_INTERVAL_MS = 10000L;
    private static final long LOCAL_FLUSH_INTERVAL_MS = 60000L;
    private static final long BUSY_OMADAC_INTERVAL_MS = 1500000L;
    private static final Object SET_VALUE = new Object();
    private Map<String, Object> localCache;
    private boolean needLocalCache;
    private Cache<String, Long> busyOmadaCache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build();
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.site.a siteInternalApiService;
    @Autowired
    private a clientBusySiteInternalApiService;
    @Autowired
    private BusySiteProperties busySiteProperties;

    @PostConstruct
    private void init() {
        if (Boolean.FALSE.equals(this.busySiteProperties.getEnable())) {
            log.info("busy site has turn off");
            return;
        }
        this.needLocalCache = true;
        long flushInterval = OmadacType.s() ? 10000L : 60000L;
        this.localCache = new ConcurrentHashMap<String, Object>(128);
        com.tplink.smb.omada.common.concurrent.thread.b.b(() -> {
            log.trace("Starting to flush busy omadac cache {}", this.localCache);
            try {
                this.flushToManager();
            }
            catch (Exception e) {
                log.warn("Failed to flush busy omadac cache", (Throwable)e);
            }
        }, (long)flushInterval, (long)flushInterval, (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public void put(String omadacId) {
        if (Boolean.FALSE.equals(this.busySiteProperties.getEnable())) {
            return;
        }
        if (!this.needLocalCache) {
            return;
        }
        Long startTime = (Long)this.busyOmadaCache.getIfPresent((Object)omadacId);
        if (startTime != null && System.currentTimeMillis() - startTime < 1500000L) {
            return;
        }
        this.busyOmadaCache.put((Object)omadacId, (Object)System.currentTimeMillis());
        this.localCache.put(omadacId, SET_VALUE);
    }

    private void flushToManager() {
        Iterator<Map.Entry<String, Object>> iterator = this.localCache.entrySet().iterator();
        ArrayList<String> omadacs = new ArrayList<String>();
        while (iterator.hasNext()) {
            String omadacId = iterator.next().getKey();
            omadacs.add(omadacId);
            iterator.remove();
            log.trace("Removed OmadacId:{} from buf", (Object)omadacId);
        }
        if (!omadacs.isEmpty()) {
            this.siteInternalApiService.a(omadacs);
            this.clientBusySiteInternalApiService.a(omadacs);
        }
    }
}

