/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch;

import com.fasterxml.jackson.core.type.TypeReference;
import com.tplink.nbu.common.utils.CollectionUtil;
import com.tplink.smb.omada.apigateway.dispatch.UserOperationForIam;
import com.tplink.smb.omada.apigateway.dispatch.cache.IpAccessCache;
import com.tplink.smb.omada.apigateway.dispatch.cache.LoginCache;
import com.tplink.smb.omada.apigateway.dispatch.dto.TenantLoginResultDTO;
import com.tplink.smb.omada.apigateway.dispatch.log.AddLogService;
import com.tplink.smb.omada.apigateway.dispatch.meter.ApiMeters;
import com.tplink.smb.omada.apigateway.dispatch.shiro.security.CloudUserToken;
import com.tplink.smb.omada.apigateway.dispatch.shiro.security.LocalUserToken;
import com.tplink.smb.omada.apigateway.dispatch.util.WebUtils;
import com.tplink.smb.omada.apigateway.openapi.OauthGenerateService;
import com.tplink.smb.omada.apigateway.openapi.OauthToken;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.UserTypeEnumDTO;
import com.tplink.smb.omada.common.access.e;
import com.tplink.smb.omada.common.gridquery.c;
import com.tplink.smb.omada.common.h.d;
import com.tplink.smb.omada.common.obfuscate.KeepMethod;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.ad;
import com.tplink.smb.omada.common.util.o;
import com.tplink.smb.omada.common.util.system.a;
import com.tplink.smb.omada.common.util.system.c;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.dispatcher.common.util.SessionUtils;
import com.tplink.smb.omada.dispatcher.common.util.UserIpUtils;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.OmadaClusterUniversalMethodResolveClient;
import com.tplink.smb.omada.dispatcher.support.local.grpc.common.OmadaClusterUniversalRequestDTO;
import com.tplink.smb.omada.iam.api.internal.dto.IamLoginRequestDTO;
import com.tplink.smb.omada.iam.api.internal.dto.IamLoginResponseDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.GetRoleInfoDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.GetUserInfoDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.OmadaRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.OmadacDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.QueryCloudUserDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.QueryLocalUserDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.QueryTenantByIdRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.QueryTenantDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.QueryUserWithTenantIdDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.SaveSessionDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.TenantDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.UserDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.omadacloud.CheckLoginByTPCloudRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.omadacloud.CheckLoginByTPCloudResponseDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.omadacloud.HandleCloudUserLoginRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.openapi.AuthCodeModeInfo;
import com.tplink.smb.omada.identityaccess.api.internal.dto.openapi.CacheOauthCodeInfoRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.openapi.CacheOauthTokenInfoRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.openapi.CacheOauthUserInfoRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.openapi.CheckOpenApiClientIdDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.openapi.GetUserInfoRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.openapi.GlobalApiApplicationDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.openapi.GlobalClientModeInfo;
import com.tplink.smb.omada.identityaccess.api.internal.dto.openapi.MspApiApplicationDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.openapi.MspClientModeInfo;
import com.tplink.smb.omada.identityaccess.api.internal.dto.openapi.OauthCodeCacheDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.openapi.OauthTokenCacheDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.openapi.OauthUserCacheDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.openapi.OpenApiApplicationDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.openapi.UpdateAccessTokenListDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.openapi.UpdateRefreshTokenListDTO;
import com.tplink.smb.omada.identityaccess.api.internal.g;
import com.tplink.smb.omada.identityaccess.api.internal.h;
import com.tplink.smb.omada.identityaccess.api.internal.l;
import com.tplink.smb.omada.identityaccess.api.internal.m;
import com.tplink.smb.omada.logmanager.api.internal.dto.AuditLogResourceEnumDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.omadac.b;
import com.tplink.smb.omada.manager.configuration.api.internal.omadac.dto.QueryUserCloudDomainDTO;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.RequestEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Hidden
public class SpeedUpLoginController {
    @Generated
    private static final Logger log = LogManager.getLogger(SpeedUpLoginController.class);
    @Autowired
    private AddLogService addLogService;
    @Autowired
    private LoginCache loginCache;
    @Autowired
    @Lazy
    private g identityAccessInternalApiService;
    @Autowired
    private h identityAccessWebInternalApiService;
    @Autowired
    @Lazy
    private ApiMeters apiMeters;
    @Autowired
    private com.tplink.smb.omada.identityaccess.api.internal.x tenantInternalApiService;
    @Autowired
    private l omadacInternalApiService;
    @Autowired
    @Lazy
    private m openApiInternalApiService;
    @Autowired
    private IpAccessCache ipAccessCache;
    @Autowired
    @Lazy
    private b managerOmadaInternalService;
    @Autowired
    private UserOperationForIam userOperationForIam;
    @Autowired
    private OmadaClusterUniversalMethodResolveClient omadaClusterUniversalMethodResolveClient;

    @GetMapping(value={"/{omadacId}/login"})
    public String login() {
        return "index";
    }

    @GetMapping(value={"/{omadacId}/openapi/login"})
    public String loginByOpenApi() {
        return "index";
    }

    @GetMapping(value={"/login"})
    public String localLogin() {
        return "index";
    }

    @PostMapping(value={"/{omadacId}/api/v2/login"})
    @ResponseBody
    public OperationResponse login(HttpServletRequest request, HttpServletResponse response, @RequestBody String body, @PathVariable(name="omadacId") String omadacId) {
        Map paramMap;
        log.info("start login with omadacId");
        RequestEntity<String> requestEntity = WebUtils.getStringRequestEntity(body, request);
        if (ad.a(requestEntity)) {
            return OperationResponse.REQUEST_CONTAIN_XSS;
        }
        try {
            paramMap = x.a((String)body);
        }
        catch (d e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            return OperationResponse.PARAM_ERROR;
        }
        String username = String.valueOf(paramMap.get("username"));
        String password = String.valueOf(paramMap.get("password"));
        Boolean supportMsp = (Boolean)paramMap.get("supportMsp");
        if (!com.tplink.smb.omada.common.util.f.c.bU.matcher(username).matches()) {
            log.warn("Invalid user name pt or password, omadacId {}.", (Object)omadacId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.cc);
        }
        UserIpUtils.setLocalUserIp((String)WebUtils.getRemoteAddress(request));
        OperationResponse lockRsp = this.loginCache.checkLockStatus(username, new HashMap<String, Object>(4));
        if (!lockRsp.success()) {
            return lockRsp;
        }
        log.info("query userDTO.");
        OperationResponse optResp = this.identityAccessInternalApiService.a(new QueryLocalUserDTO(username, omadacId));
        log.info("end query userDTO.");
        if (!optResp.success() || optResp.getResult() == null) {
            return this.cloudUserLoginByTpCloud(request, response, omadacId, username, password, false, "", supportMsp);
        }
        UserDTO user = (UserDTO)optResp.getResult();
        if (!Boolean.TRUE.equals(supportMsp) && this.appRequest(request)) {
            if (!user.isDefaultRole()) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.h);
            }
            if (CollectionUtils.isEmpty((Collection)user.getSiteIds())) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.ae);
            }
        }
        if (OmadacType.s() && !user.isCloudUser()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.h);
        }
        log.info("query tenant.");
        OperationResponse tenantResp = this.tenantInternalApiService.a(QueryTenantByIdRequestDTO.builder().tenantId(user.getTenantId()).build());
        if (!tenantResp.success()) {
            return tenantResp;
        }
        log.info("query omadac.");
        OperationResponse omadacRes = this.omadacInternalApiService.a(OmadaRequestDTO.builder().build());
        if (!omadacRes.success()) {
            return omadacRes;
        }
        log.info("local tenant login");
        return this.localTenantLogin((TenantDTO)tenantResp.getResult(), omadacId, password, request, response, (OmadacDTO)omadacRes.getResult());
    }

    private boolean appRequest(HttpServletRequest request) {
        String sources = request.getHeader("Omada-Request-Source");
        if (sources != null) {
            e controlType = e.a((String)sources);
            return e.c.equals((Object)controlType) || e.d.equals((Object)controlType);
        }
        return false;
    }

    @PostMapping(value={"/api/v2/login"})
    @ResponseBody
    public OperationResponse loginWithoutOmadacId(HttpServletRequest request, HttpServletResponse response, @RequestBody String body) {
        Map paramMap;
        log.info("start login...");
        RequestEntity<String> requestEntity = WebUtils.getStringRequestEntity(body, request);
        if (ad.a(requestEntity)) {
            return OperationResponse.REQUEST_CONTAIN_XSS;
        }
        try {
            paramMap = x.a((String)body);
        }
        catch (d e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            return OperationResponse.PARAM_ERROR;
        }
        String username = String.valueOf(paramMap.get("username"));
        String password = String.valueOf(paramMap.get("password"));
        if (!com.tplink.smb.omada.common.util.f.c.bU.matcher(username).matches()) {
            log.warn("Invalid user name pt or password.");
            return new OperationResponse(com.tplink.smb.omada.common.g.b.cc);
        }
        UserIpUtils.setLocalUserIp((String)WebUtils.getRemoteAddress(request));
        OperationResponse lockRsp = this.loginCache.checkLockStatus(username, new HashMap<String, Object>(4));
        if (!lockRsp.success()) {
            return lockRsp;
        }
        QueryTenantDTO queryTenantDTO = new QueryTenantDTO();
        queryTenantDTO.setName(username, c.a.a, true);
        queryTenantDTO.setUserType(Integer.valueOf(UserTypeEnumDTO.LOCAL_USER.getValue()), c.a.a, true);
        log.info("query tenant.");
        OperationResponse optResp = this.tenantInternalApiService.a(queryTenantDTO);
        log.info("query omadac.");
        OperationResponse omadacRes = this.omadacInternalApiService.a(OmadaRequestDTO.builder().build());
        log.info("end query omadac.");
        if (!omadacRes.success() || omadacRes.getResult() == null) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.aA);
        }
        String omadacId = ((OmadacDTO)omadacRes.getResult()).getId();
        com.tplink.smb.omada.common.f.c omadacPattern = com.tplink.smb.omada.common.f.c.a((Integer)((OmadacDTO)omadacRes.getResult()).getPattern());
        if (!optResp.success() || optResp.getResult() == null) {
            return this.cloudUserLoginByTpCloud(request, response, omadacId, username, password, false, "", true);
        }
        TenantDTO tenantDTO = (TenantDTO)optResp.getResult();
        if (OmadacType.s() && Objects.equals(UserTypeEnumDTO.LOCAL_USER.getValue(), tenantDTO.getType())) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.h);
        }
        AtomicReference<String> finalOmadacId = new AtomicReference<String>();
        if (tenantDTO.hasAccessToOmadac(omadacId)) {
            finalOmadacId.set(omadacId);
        } else if (com.tplink.smb.omada.common.f.c.b.a(omadacPattern)) {
            Set customerList = ((OmadacDTO)omadacRes.getResult()).getCustomers();
            if (customerList == null || customerList.isEmpty()) {
                log.warn("No customer in this mspId={}, current user {} can not access this controller", (Object)omadacId, (Object)username);
                this.addLogService.addLoginLog(omadacId, omadacPattern, username, WebUtils.getRemoteAddress(request), false, AuditLogResourceEnumDTO.WEB.getResourceCode());
                return new OperationResponse(com.tplink.smb.omada.common.g.b.h);
            }
            for (String customerId : tenantDTO.getOmadacs()) {
                if (!new ArrayList(customerList).contains(customerId)) continue;
                finalOmadacId.set(customerId);
                break;
            }
        }
        if (finalOmadacId.get() == null) {
            log.warn("current user {} has no access to this controller, default omadacId={}, controller working pattern is {}", (Object)username, (Object)((OmadacDTO)omadacRes.getResult()).getId(), (Object)((OmadacDTO)omadacRes.getResult()).getPattern());
            this.addLogService.addLoginLog(omadacId, omadacPattern, username, WebUtils.getRemoteAddress(request), false, AuditLogResourceEnumDTO.WEB.getResourceCode());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.h);
        }
        log.info("local user login start...");
        return this.localTenantLogin(tenantDTO, (String)finalOmadacId.get(), password, request, response, (OmadacDTO)omadacRes.getResult());
    }

    private OperationResponse cloudUserLoginByTpCloud(HttpServletRequest request, HttpServletResponse response, String omadacId, String username, String password, boolean ignoreCloudRes, String roleName, Boolean supportMsp) {
        if (!com.tplink.smb.omada.common.util.f.a.b((String)username)) {
            this.addLogService.addLoginLog(omadacId, username, WebUtils.getRemoteAddress(request), false, AuditLogResourceEnumDTO.WEB.getResourceCode());
            this.apiMeters.loginFailCount(ApiMeters.LoginFailureReason.INVALID_USERNAME_OR_PASSWORD);
            return this.loginCache.checkLoginLimit(username, new HashMap<String, Object>(2));
        }
        OperationResponse optRes = this.identityAccessWebInternalApiService.a(CheckLoginByTPCloudRequestDTO.builder().omadacId(omadacId).password(password).username(username).build());
        log.info("omadacId={} check login by TP CLOUD response:{}", (Object)omadacId, (Object)optRes.toString());
        if (!optRes.success()) {
            if (optRes.getErrorCode() == com.tplink.smb.omada.common.g.b.cE.b()) {
                return optRes;
            }
            this.addLogService.addLoginLog(omadacId, username, WebUtils.getRemoteAddress(request), false, AuditLogResourceEnumDTO.WEB.getResourceCode());
            this.apiMeters.loginFailCount(ApiMeters.LoginFailureReason.SERVICE_ERROR);
            return ignoreCloudRes ? this.loginCache.checkLoginLimit(username, new HashMap<String, Object>(2)) : optRes;
        }
        OperationResponse omadacRes = this.omadacInternalApiService.a(OmadaRequestDTO.builder().omadacId(omadacId).build());
        if (!omadacRes.success() || omadacRes.getResult() == null) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.aA);
        }
        if (Boolean.TRUE.equals(((OmadacDTO)omadacRes.getResult()).getEnableMFA())) {
            HashMap<String, String> result = new HashMap<String, String>();
            OperationResponse domainRes = this.managerOmadaInternalService.a(QueryUserCloudDomainDTO.builder().email(username).build());
            if (!domainRes.success()) {
                log.warn("Fail to find omada cloud domain, omadacId={}", (Object)omadacId);
            } else {
                result.put("url", (String)domainRes.getResult());
            }
            return new OperationResponse(com.tplink.smb.omada.common.g.b.dv, result);
        }
        CheckLoginByTPCloudResponseDTO result = (CheckLoginByTPCloudResponseDTO)optRes.getResult();
        String token = result.getToken();
        SessionUtils.setThreadSessionId((String)token);
        OperationResponse<Map<String, Object>> handleRes = this.handleCloudUserLogin(request, response, HandleCloudUserLoginRequestDTO.builder().omadacId(omadacId).accountId(((CheckLoginByTPCloudResponseDTO)optRes.getResult()).getAccountId()).email(username).build(), supportMsp, null);
        if (handleRes.success()) {
            ((Map)handleRes.getResult()).remove("sessionId");
        }
        return handleRes;
    }

    public OperationResponse localTenantLogin(TenantDTO tenant, String omadacId, String password, HttpServletRequest request, HttpServletResponse response, OmadacDTO omadacDTO) {
        log.info("check iam user.");
        if (Objects.nonNull(tenant)) {
            this.tenantInternalApiService.a(tenant);
        }
        log.info("login for iam.");
        IamLoginRequestDTO iamLoginRequestDTO = IamLoginRequestDTO.builder().loginType(com.tplink.smb.omada.iam.api.a.b.c.a.b()).username(tenant.getName()).password(password).build();
        com.tplink.smb.omada.iam.api.a.a.c<IamLoginResponseDTO> validPasswordRes = this.userOperationForIam.loginV1(iamLoginRequestDTO);
        if (!validPasswordRes.b()) {
            return this.cloudUserLoginByTpCloud(request, response, omadacId, tenant.getName(), password, true, "", false);
        }
        log.info("end login for iam.");
        IamLoginResponseDTO iamLoginResponseDTO = (IamLoginResponseDTO)validPasswordRes.f();
        String token = iamLoginResponseDTO.getToken();
        SessionUtils.setThreadSessionId((String)token);
        if (Boolean.TRUE.equals(omadacDTO.getEnableMFA()) && !Boolean.TRUE.equals(tenant.getEnableMFA())) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.du);
        }
        if (Boolean.TRUE.equals(tenant.getEnableMFA())) {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("email", tenant.getEmail());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.df, result);
        }
        log.info("handle local tenant login.");
        return this.handleLocalTenantLogin(omadacId, tenant.getName(), password, tenant, request, response, omadacDTO.getPattern());
    }

    public OperationResponse handleLocalTenantLogin(String omadacId, String username, String password, TenantDTO tenant, HttpServletRequest request, HttpServletResponse response, Integer omadacPattern) {
        String sessionId;
        HashMap<String, String> result = new HashMap<String, String>(4);
        LocalUserToken token = new LocalUserToken(tenant.getName(), password);
        Subject curUser = SecurityUtils.getSubject();
        if (curUser.getSession(false) != null) {
            curUser.getSession(false).stop();
        }
        GetUserInfoDTO getUserInfoDTO = new GetUserInfoDTO();
        getUserInfoDTO.setOmadacId(omadacId);
        getUserInfoDTO.setTenantId(tenant.getTenantId());
        OperationResponse userResp = this.identityAccessInternalApiService.a(getUserInfoDTO);
        if (!userResp.success()) {
            if (Objects.equals(com.tplink.smb.omada.common.g.b.dG.b(), userResp.getErrorCode()) && a.b()) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.j);
            }
            log.debug("verify the user error.errCode:{}", (Object)userResp.getErrorCode());
            return userResp;
        }
        UserDTO userDTO = (UserDTO)userResp.getResult();
        if (!userDTO.verifyTemporaryUser()) {
            log.warn("The temporary user account already expires.OmadacId:{},TenantId:{}", (Object)omadacId, (Object)tenant.getTenantId());
            this.addLogService.addLoginLog(omadacId, username, WebUtils.getRemoteAddress(request), false, AuditLogResourceEnumDTO.WEB.getResourceCode());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.dL);
        }
        try {
            curUser.login((AuthenticationToken)token);
            sessionId = (String)((Object)curUser.getSession().getId());
            log.debug("main login, username: {}, sessionId: {}", (Object)username, (Object)sessionId);
        }
        catch (Exception e2) {
            return this.cloudUserLoginByTpCloud(request, response, omadacId, username, password, true, "", false);
        }
        if (curUser.getSession().getAttribute((Object)"Csrf-Token") == null) {
            curUser.getSession().setAttribute((Object)"Csrf-Token", (Object)WebUtils.buildRandomUUID());
        }
        log.info("save session.");
        String csrfToken = (String)curUser.getSession().getAttribute((Object)"Csrf-Token");
        result.put("token", csrfToken);
        result.put("omadacId", userDTO.getOmadacId());
        SaveSessionDTO saveLocalSession = new SaveSessionDTO();
        saveLocalSession.setTenantId(tenant.getTenantId());
        saveLocalSession.setOmadacId(userDTO.getOmadacId());
        saveLocalSession.setSessionId(sessionId);
        this.identityAccessWebInternalApiService.a(saveLocalSession);
        curUser.getSession().setAttribute((Object)"omadacId", (Object)userDTO.getOmadacId());
        log.info("end save session.");
        this.loginCache.remove(tenant.getName());
        this.addLogService.addLoginLog(userDTO.getOmadacId(), com.tplink.smb.omada.common.f.c.a((Integer)omadacPattern), username, WebUtils.getRemoteAddress(request), true, AuditLogResourceEnumDTO.WEB.getResourceCode());
        log.info("login OK");
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, "Log in successfully.", result);
    }

    OperationResponse<Map<String, Object>> handleCloudUserLogin(HttpServletRequest request, HttpServletResponse response, HandleCloudUserLoginRequestDTO handleCloudUserLoginRequest, Boolean supportMsp, String iamCsrfToken) {
        QueryCloudUserDTO queryUserDTO = new QueryCloudUserDTO();
        queryUserDTO.setOmadacId(handleCloudUserLoginRequest.getOmadacId());
        queryUserDTO.setAccountId(handleCloudUserLoginRequest.getAccountId());
        OperationResponse userOptRes = this.identityAccessInternalApiService.b(queryUserDTO);
        if (!userOptRes.success() || userOptRes.getResult() == null) {
            log.warn("omadacId={},Failed to find cloud user {} info from local database.", (Object)handleCloudUserLoginRequest.getOmadacId(), (Object)o.a((String)handleCloudUserLoginRequest.getEmail()));
            this.addLogService.addLoginLog(handleCloudUserLoginRequest.getOmadacId(), handleCloudUserLoginRequest.getEmail(), WebUtils.getRemoteAddress(request), false, AuditLogResourceEnumDTO.WEB.getResourceCode());
            if (userOptRes.getErrorCode() == com.tplink.smb.omada.common.g.b.b.b()) {
                this.apiMeters.loginFailCount(ApiMeters.LoginFailureReason.SERVICE_ERROR);
            } else {
                this.apiMeters.loginFailCount(ApiMeters.LoginFailureReason.INVALID_USERNAME_OR_PASSWORD);
            }
            if (Objects.equals(com.tplink.smb.omada.common.g.b.aV.b(), userOptRes.getErrorCode()) && a.b()) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.j);
            }
            return new OperationResponse(com.tplink.smb.omada.common.g.b.cc);
        }
        UserDTO user = (UserDTO)userOptRes.getResult();
        if (!Boolean.TRUE.equals(supportMsp) && this.appRequest(request)) {
            if (!user.isDefaultRole()) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.h);
            }
            if (CollectionUtils.isEmpty((Collection)user.getSiteIds())) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.ae);
            }
        }
        CloudUserToken cloudUserToken = new CloudUserToken(handleCloudUserLoginRequest.getEmail(), handleCloudUserLoginRequest.getAccountId());
        Subject curUser = SecurityUtils.getSubject();
        String sessionId = (String)((Object)curUser.getSession().getId());
        OperationResponse verifyUserOps = this.identityAccessInternalApiService.a(new QueryUserWithTenantIdDTO(user.getControllerId(), user.getTenantId()));
        if (!verifyUserOps.success()) {
            if (Objects.equals(com.tplink.smb.omada.common.g.b.dG.b(), verifyUserOps.getErrorCode()) && a.b()) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.j);
            }
            log.debug("verify the user error.errCode:{}", (Object)verifyUserOps.getErrorCode());
            return verifyUserOps;
        }
        if (Boolean.FALSE.equals(verifyUserOps.getResult())) {
            log.warn("The temporary user account already expires.OmadacId:{},TenantId:{}", (Object)user.getControllerId(), (Object)user.getTenantId());
            this.addLogService.addLoginLog(handleCloudUserLoginRequest.getOmadacId(), handleCloudUserLoginRequest.getEmail(), WebUtils.getRemoteAddress(request), false, AuditLogResourceEnumDTO.WEB.getResourceCode());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.dL);
        }
        try {
            curUser.login((AuthenticationToken)cloudUserToken);
        }
        catch (Exception e2) {
            log.warn("omadacId={},email={} Cloud login failed,error msg:{}", new Supplier[]{() -> handleCloudUserLoginRequest.getOmadacId(), () -> com.tplink.smb.omada.common.util.e.a.c((String)handleCloudUserLoginRequest.getEmail()), () -> e2.getMessage()});
            this.addLogService.addLoginLog(handleCloudUserLoginRequest.getOmadacId(), handleCloudUserLoginRequest.getEmail(), WebUtils.getRemoteAddress(request), false, AuditLogResourceEnumDTO.WEB.getResourceCode());
            this.apiMeters.loginFailCount(ApiMeters.LoginFailureReason.FROZEN);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.cl);
        }
        log.debug("curUser get session request Csrf-Token {} curUser Csrf-Token {}, omadacId {}", request.getSession().getAttribute("Csrf-Token"), curUser.getSession().getAttribute((Object)"Csrf-Token"), (Object)handleCloudUserLoginRequest.getOmadacId());
        if (curUser.getSession().getAttribute((Object)"Csrf-Token") == null) {
            String randomUUID = WebUtils.buildRandomUUID();
            curUser.getSession().setAttribute((Object)"Csrf-Token", (Object)(T.a((Object)iamCsrfToken) ? iamCsrfToken : randomUUID));
            log.debug("get session Csrf-Token is null {}, new request Csrf-Token {} curUser Csrf-Token {}, omadacId {}", (Object)randomUUID, request.getSession().getAttribute("Csrf-Token"), curUser.getSession().getAttribute((Object)"Csrf-Token"), (Object)handleCloudUserLoginRequest.getOmadacId());
        }
        String csrfToken = (String)curUser.getSession().getAttribute((Object)"Csrf-Token");
        SaveSessionDTO saveCloudSession = new SaveSessionDTO();
        saveCloudSession.setOmadacId(user.getOmadacId());
        saveCloudSession.setSessionId(sessionId);
        saveCloudSession.setUserDTO(user);
        saveCloudSession.setTenantId(user.getTenantId());
        saveCloudSession.setIdleTimeout(handleCloudUserLoginRequest.getIdleTimeout());
        this.identityAccessWebInternalApiService.a(saveCloudSession);
        handleCloudUserLoginRequest.setUserId(user.getId());
        handleCloudUserLoginRequest.setOmadacId(user.getOmadacId());
        OperationResponse optRes = this.identityAccessWebInternalApiService.a(handleCloudUserLoginRequest);
        if (!optRes.success()) {
            log.warn("omadacId={} identityaccess handle cloudUser login error,msg:{}", (Object)user.getControllerId(), (Object)optRes.getMsg());
        }
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        result.put("roleType", user.getRoleType());
        result.put("token", csrfToken);
        result.put("sessionId", sessionId);
        result.put("omadacId", user.getControllerId());
        try {
            OperationResponse roleRes = this.identityAccessInternalApiService.b(GetRoleInfoDTO.builder().omadacId(user.getControllerId()).roleId(user.getRoleId()).build());
            if (!roleRes.success()) {
                log.warn("omadacId={} identityaccess get role info error,msg:{}", (Object)user.getControllerId(), (Object)roleRes.getMsg());
            }
            result.put("roleDetail", roleRes.getResult());
        }
        catch (RuntimeException e3) {
            log.info("Fail to get grpc service method getRoleDetail", (Throwable)e3);
        }
        curUser.getSession().setAttribute((Object)"omadacId", (Object)user.getControllerId());
        this.loginCache.remove(user.getName());
        this.addLogService.addLoginLog(handleCloudUserLoginRequest.getOmadacId(), handleCloudUserLoginRequest.getEmail(), WebUtils.getRemoteAddress(request), true, AuditLogResourceEnumDTO.WEB.getResourceCode());
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, "Log in successfully.", result);
    }

    @PostMapping(value={"/openapi/authorize/login"})
    @ResponseBody
    public OperationResponse loginByOpenApi(HttpServletRequest request, HttpServletResponse response, @RequestBody String body) {
        OperationResponse<TenantLoginResultDTO> loginResp;
        Map paramMap;
        String omadacId = request.getParameter("omadac_id");
        String clientId = request.getParameter("client_id");
        OperationResponse inIpAccessRule = this.ipAccessCache.isOpenIpFilterOrInIpAccessRule(omadacId, request);
        if (!inIpAccessRule.success()) {
            return inIpAccessRule;
        }
        RequestEntity<String> requestEntity = WebUtils.getStringRequestEntity(body, request);
        if (ad.a(requestEntity)) {
            return OperationResponse.REQUEST_CONTAIN_XSS;
        }
        try {
            paramMap = x.a((String)body);
        }
        catch (d e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            return OperationResponse.PARAM_ERROR;
        }
        String username = String.valueOf(paramMap.get("username"));
        String password = String.valueOf(paramMap.get("password"));
        if (!com.tplink.smb.omada.common.util.f.c.bU.matcher(username).matches()) {
            log.warn("Invalid user name pt or password, omadacId {}.", (Object)omadacId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.cc);
        }
        UserIpUtils.setLocalUserIp((String)WebUtils.getRemoteAddress(request));
        OperationResponse lockRsp = this.loginCache.checkLockStatus(username, new HashMap<String, Object>(4));
        if (!lockRsp.success()) {
            return lockRsp;
        }
        OperationResponse checkClientIdResp = this.identityAccessInternalApiService.a(CheckOpenApiClientIdDTO.builder().omadacIds(Collections.singleton(omadacId)).clientId(clientId).build());
        if (!checkClientIdResp.success() || Objects.isNull(checkClientIdResp.getResult())) {
            log.warn("check client id failed, omadacId={}, errorMsg {}", (Object)omadacId, (Object)checkClientIdResp.getMsg());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.Nv);
        }
        OpenApiApplicationDTO openApiApplicationDTO = (OpenApiApplicationDTO)checkClientIdResp.getResult();
        if (!Objects.equals(0, openApiApplicationDTO.getMode())) {
            log.warn("mode is not oauth code, omadacId={}", (Object)omadacId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.Nv);
        }
        String applicationOmadacId = openApiApplicationDTO.getOmadacId();
        OperationResponse omadacRes = this.omadacInternalApiService.a(OmadaRequestDTO.builder().omadacId(omadacId).build());
        if (!omadacRes.success() || omadacRes.getResult() == null) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.aA);
        }
        String mspId = null;
        com.tplink.smb.omada.common.f.c omadacPattern = com.tplink.smb.omada.common.f.c.a((Integer)((OmadacDTO)omadacRes.getResult()).getPattern());
        if (Objects.equals(com.tplink.smb.omada.common.f.c.b.a(), omadacPattern.a())) {
            mspId = ((OmadacDTO)omadacRes.getResult()).getId();
        } else if (Objects.equals(com.tplink.smb.omada.common.f.c.a.a(), omadacPattern.a())) {
            mspId = ((OmadacDTO)omadacRes.getResult()).getMspId();
        }
        QueryTenantDTO queryTenantDTO = new QueryTenantDTO();
        queryTenantDTO.setName(username, c.a.a, true);
        OperationResponse optResp = this.tenantInternalApiService.a(queryTenantDTO);
        if (!optResp.success() || optResp.getResult() == null) {
            loginResp = this.cloudUserLoginByTpCloudByOpenApi(request, response, omadacId, username, password, false, "", omadacPattern);
        } else {
            TenantDTO tenantDTO = (TenantDTO)optResp.getResult();
            if (OmadacType.s() && Objects.equals(UserTypeEnumDTO.LOCAL_USER.getValue(), tenantDTO.getType())) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.h);
            }
            if (!tenantDTO.hasAccessToOmadac(applicationOmadacId) || !tenantDTO.hasAccessToOmadac(omadacId)) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.h);
            }
            loginResp = this.localTenantLoginByOpenApi(tenantDTO, omadacId, password, request);
        }
        if (!loginResp.success() || Objects.isNull(loginResp.getResult())) {
            return loginResp;
        }
        TenantLoginResultDTO tenantLoginResult = (TenantLoginResultDTO)loginResp.getResult();
        OauthUserCacheDTO oauthUserInfoDTO = new OauthUserCacheDTO();
        oauthUserInfoDTO.setApplicationOmadacId(applicationOmadacId);
        oauthUserInfoDTO.setMspId(mspId);
        oauthUserInfoDTO.setClientId(openApiApplicationDTO.getClientId());
        oauthUserInfoDTO.setRedirectUrl(openApiApplicationDTO.getRedirectUrl());
        oauthUserInfoDTO.setMsp(openApiApplicationDTO.getMsp());
        oauthUserInfoDTO.setCsrfToken(tenantLoginResult.getCsrfToken());
        oauthUserInfoDTO.setSessionId(tenantLoginResult.getSessionId());
        oauthUserInfoDTO.setTenantId(tenantLoginResult.getTenantId());
        CacheOauthUserInfoRequestDTO cacheOauthUserInfoRequestDTO = new CacheOauthUserInfoRequestDTO();
        cacheOauthUserInfoRequestDTO.setSessionId(tenantLoginResult.getSessionId());
        cacheOauthUserInfoRequestDTO.setApplicationOmadacId(applicationOmadacId);
        cacheOauthUserInfoRequestDTO.setOauthUserCacheDTO(oauthUserInfoDTO);
        this.openApiInternalApiService.a(cacheOauthUserInfoRequestDTO);
        tenantLoginResult.setTenantId(null);
        return loginResp;
    }

    private OperationResponse<TenantLoginResultDTO> localTenantLoginByOpenApi(TenantDTO tenant, String omadacId, String password, HttpServletRequest request) {
        IamLoginRequestDTO iamLoginRequestDTO = IamLoginRequestDTO.builder().loginType(com.tplink.smb.omada.iam.api.a.b.c.a.b()).username(tenant.getName()).password(password).build();
        com.tplink.smb.omada.iam.api.a.a.c<IamLoginResponseDTO> validPasswordRes = this.userOperationForIam.loginV1(iamLoginRequestDTO);
        if (!validPasswordRes.b()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.cc);
        }
        IamLoginResponseDTO iamLoginResponseDTO = (IamLoginResponseDTO)validPasswordRes.f();
        String iamSessionId = iamLoginResponseDTO.getToken();
        SessionUtils.setThreadSessionId((String)iamSessionId);
        LocalUserToken token = new LocalUserToken(tenant.getName(), password);
        Subject curUser = SecurityUtils.getSubject();
        String sessionId = (String)((Object)curUser.getSession().getId());
        OperationResponse verifyUserOps = this.identityAccessInternalApiService.a(new QueryUserWithTenantIdDTO(omadacId, tenant.getTenantId()));
        if (!verifyUserOps.success()) {
            log.debug("verify the user error.errCode:{}", (Object)verifyUserOps.getErrorCode());
            return verifyUserOps;
        }
        if (Boolean.FALSE.equals(verifyUserOps.getResult())) {
            log.warn("The temporary user account already expires.OmadacId:{},TenantId:{}", (Object)omadacId, (Object)tenant.getTenantId());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.dL);
        }
        try {
            curUser.login((AuthenticationToken)token);
            log.debug("main login, username: {}, sessionId: {}", (Object)tenant.getName(), (Object)sessionId);
        }
        catch (Exception e2) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.cc);
        }
        if (request.getSession().getAttribute("Csrf-Token") == null) {
            request.getSession().setAttribute("Csrf-Token", (Object)WebUtils.buildRandomUUID());
        }
        String csrfToken = (String)request.getSession().getAttribute("Csrf-Token");
        SaveSessionDTO saveLocalSession = new SaveSessionDTO();
        saveLocalSession.setTenantId(tenant.getTenantId());
        saveLocalSession.setOmadacId(omadacId);
        saveLocalSession.setSessionId(sessionId);
        this.identityAccessWebInternalApiService.a(saveLocalSession);
        curUser.getSession().setAttribute((Object)"omadacId", (Object)omadacId);
        this.loginCache.remove(tenant.getName());
        OmadaClusterUniversalRequestDTO requestDTO = new OmadaClusterUniversalRequestDTO(SpeedUpLoginController.class, (TypeReference)new TypeReference<Void>(){}, "loginCacheRemoveCluster", new Class[]{String.class}, new Object[]{tenant.getName()});
        this.handleLocalCluster(requestDTO);
        this.addLogService.addLoginLog(omadacId, tenant.getName(), WebUtils.getRemoteAddress(request), true, AuditLogResourceEnumDTO.OPEN_API.getResourceCode());
        TenantLoginResultDTO tenantLoginResultDTO = new TenantLoginResultDTO();
        tenantLoginResultDTO.setCsrfToken(csrfToken);
        tenantLoginResultDTO.setTenantId(tenant.getTenantId());
        tenantLoginResultDTO.setSessionId(sessionId);
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, "Open API Log in successfully.", (Object)tenantLoginResultDTO);
    }

    @KeepMethod
    public void loginCacheRemoveCluster(String username) {
        log.debug("Node id: " + a.h() + "\u2014\u2014> loginCacheRemoveCluster");
        this.loginCache.remove(username);
    }

    public <T> void handleLocalCluster(OmadaClusterUniversalRequestDTO<?, T> requestDTO) {
        if (!a.b() || CollectionUtil.isEmpty(c.a().keySet())) {
            return;
        }
        Set nodeIds = c.a().keySet();
        for (String nodeId : nodeIds) {
            if (Objects.equals(nodeId, a.h())) continue;
            this.omadaClusterUniversalMethodResolveClient.resolveSpringBeanCall(nodeId, requestDTO);
        }
    }

    private OperationResponse<TenantLoginResultDTO> cloudUserLoginByTpCloudByOpenApi(HttpServletRequest request, HttpServletResponse response, String omadacId, String username, String password, boolean ignoreCloudRes, String roleName, com.tplink.smb.omada.common.f.c omadacPattern) {
        if (!com.tplink.smb.omada.common.util.f.a.b((String)username)) {
            this.addLogService.addLoginLog(omadacId, username, WebUtils.getRemoteAddress(request), false, AuditLogResourceEnumDTO.OPEN_API.getResourceCode());
            this.apiMeters.loginFailCount(ApiMeters.LoginFailureReason.INVALID_USERNAME_OR_PASSWORD);
            return this.loginCache.checkLoginLimit(username, new HashMap<String, Object>(2));
        }
        OperationResponse optRes = this.identityAccessWebInternalApiService.a(CheckLoginByTPCloudRequestDTO.builder().omadacId(omadacId).password(password).username(username).build());
        log.info("omadacId={} check login by TP CLOUD response:{}", (Object)omadacId, (Object)optRes.toString());
        if (!optRes.success()) {
            if (optRes.getErrorCode() == com.tplink.smb.omada.common.g.b.cE.b()) {
                return new OperationResponse(optRes.getErrorCode(), optRes.getMsg(), null);
            }
            this.addLogService.addLoginLog(omadacId, username, WebUtils.getRemoteAddress(request), false, AuditLogResourceEnumDTO.OPEN_API.getResourceCode());
            this.apiMeters.loginFailCount(ApiMeters.LoginFailureReason.SERVICE_ERROR);
            return ignoreCloudRes ? this.loginCache.checkLoginLimit(username, new HashMap<String, Object>(2)) : new OperationResponse(optRes.getErrorCode(), optRes.getMsg(), null);
        }
        CheckLoginByTPCloudResponseDTO result = (CheckLoginByTPCloudResponseDTO)optRes.getResult();
        String token = result.getToken();
        SessionUtils.setThreadSessionId((String)token);
        return this.handleCloudUserLoginByOpenApi(request, response, HandleCloudUserLoginRequestDTO.builder().omadacId(omadacId).accountId(result.getAccountId()).email(username).build());
    }

    OperationResponse<TenantLoginResultDTO> handleCloudUserLoginByOpenApi(HttpServletRequest request, HttpServletResponse response, HandleCloudUserLoginRequestDTO handleCloudUserLoginRequest) {
        QueryCloudUserDTO queryUserDTO = new QueryCloudUserDTO();
        queryUserDTO.setOmadacId(handleCloudUserLoginRequest.getOmadacId());
        queryUserDTO.setAccountId(handleCloudUserLoginRequest.getAccountId());
        OperationResponse userOptRes = this.identityAccessInternalApiService.b(queryUserDTO);
        if (!userOptRes.success() || userOptRes.getResult() == null) {
            log.warn("omadacId={},Failed to find cloud user {} info from local database.", (Object)handleCloudUserLoginRequest.getOmadacId(), (Object)o.a((String)handleCloudUserLoginRequest.getEmail()));
            this.addLogService.addLoginLog(handleCloudUserLoginRequest.getOmadacId(), handleCloudUserLoginRequest.getEmail(), WebUtils.getRemoteAddress(request), false, AuditLogResourceEnumDTO.OPEN_API.getResourceCode());
            if (userOptRes.getErrorCode() == com.tplink.smb.omada.common.g.b.b.b()) {
                this.apiMeters.loginFailCount(ApiMeters.LoginFailureReason.SERVICE_ERROR);
            } else {
                this.apiMeters.loginFailCount(ApiMeters.LoginFailureReason.INVALID_USERNAME_OR_PASSWORD);
            }
            return new OperationResponse(com.tplink.smb.omada.common.g.b.cc, null);
        }
        UserDTO user = (UserDTO)userOptRes.getResult();
        CloudUserToken cloudUserToken = new CloudUserToken(handleCloudUserLoginRequest.getEmail(), handleCloudUserLoginRequest.getAccountId());
        Subject curUser = SecurityUtils.getSubject();
        String sessionId = (String)((Object)curUser.getSession().getId());
        OperationResponse verifyUserOps = this.identityAccessInternalApiService.a(new QueryUserWithTenantIdDTO(user.getControllerId(), user.getTenantId()));
        if (!verifyUserOps.success()) {
            log.debug("verify the user error.errCode:{}", (Object)verifyUserOps.getErrorCode());
            return verifyUserOps;
        }
        if (Boolean.FALSE.equals(verifyUserOps.getResult())) {
            log.warn("The temporary user account already expires.OmadacId:{},TenantId:{}", (Object)user.getControllerId(), (Object)user.getTenantId());
            this.addLogService.addLoginLog(handleCloudUserLoginRequest.getOmadacId(), handleCloudUserLoginRequest.getEmail(), WebUtils.getRemoteAddress(request), false, AuditLogResourceEnumDTO.OPEN_API.getResourceCode());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.dL);
        }
        try {
            curUser.login((AuthenticationToken)cloudUserToken);
        }
        catch (Exception e2) {
            log.warn("omadacId={},email={} Cloud login failed,error msg:{}", new Supplier[]{() -> handleCloudUserLoginRequest.getOmadacId(), () -> com.tplink.smb.omada.common.util.e.a.c((String)handleCloudUserLoginRequest.getEmail()), () -> e2.getMessage()});
            this.addLogService.addLoginLog(handleCloudUserLoginRequest.getOmadacId(), handleCloudUserLoginRequest.getEmail(), WebUtils.getRemoteAddress(request), false, AuditLogResourceEnumDTO.OPEN_API.getResourceCode());
            this.apiMeters.loginFailCount(ApiMeters.LoginFailureReason.FROZEN);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.cl, null);
        }
        if (request.getSession().getAttribute("Csrf-Token") == null) {
            request.getSession().setAttribute("Csrf-Token", (Object)WebUtils.buildRandomUUID());
        }
        String csrfToken = (String)request.getSession().getAttribute("Csrf-Token");
        SaveSessionDTO saveCloudSession = new SaveSessionDTO();
        saveCloudSession.setOmadacId(user.getOmadacId());
        saveCloudSession.setSessionId(sessionId);
        saveCloudSession.setUserDTO(user);
        saveCloudSession.setTenantId(user.getTenantId());
        this.identityAccessWebInternalApiService.a(saveCloudSession);
        handleCloudUserLoginRequest.setUserId(user.getId());
        OperationResponse optRes = this.identityAccessWebInternalApiService.a(handleCloudUserLoginRequest);
        if (!optRes.success()) {
            log.warn("omadacId={} identityaccess handle cloudUser login error,msg:{}", (Object)user.getControllerId(), (Object)optRes.getMsg());
        }
        TenantLoginResultDTO tenantLoginResultDTO = new TenantLoginResultDTO();
        tenantLoginResultDTO.setCsrfToken(csrfToken);
        tenantLoginResultDTO.setSessionId(sessionId);
        tenantLoginResultDTO.setTenantId(user.getTenantId());
        try {
            OperationResponse roleRes = this.identityAccessInternalApiService.b(GetRoleInfoDTO.builder().omadacId(user.getControllerId()).roleId(user.getRoleId()).build());
            if (!roleRes.success()) {
                log.warn("omadacId={} identityaccess get role info error,msg:{}", (Object)user.getControllerId(), (Object)roleRes.getMsg());
            }
        }
        catch (RuntimeException e3) {
            log.info("Fail to get grpc service method getRoleDetail", (Throwable)e3);
        }
        curUser.getSession().setAttribute((Object)"omadacId", (Object)user.getControllerId());
        this.loginCache.remove(user.getName());
        this.addLogService.addLoginLog(handleCloudUserLoginRequest.getOmadacId(), handleCloudUserLoginRequest.getEmail(), WebUtils.getRemoteAddress(request), true, AuditLogResourceEnumDTO.OPEN_API.getResourceCode());
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, "Open API TP Cloud Log in successfully.", (Object)tenantLoginResultDTO);
    }

    @PostMapping(value={"/openapi/authorize/code"})
    @ResponseBody
    @CrossOrigin(origins={"*"}, allowedHeaders={"*"}, methods={RequestMethod.POST})
    public OperationResponse authorizeByOpenApi(HttpServletRequest request, HttpServletResponse response, @RequestBody(required=false) String body) {
        String omadacId = request.getParameter("omadac_id");
        String clientId = request.getParameter("client_id");
        String responseType = request.getParameter("response_type");
        OperationResponse inIpAccessRule = this.ipAccessCache.isOpenIpFilterOrInIpAccessRule(omadacId, request);
        if (!inIpAccessRule.success()) {
            return inIpAccessRule;
        }
        RequestEntity<String> requestEntity = WebUtils.getStringRequestEntity(body, request);
        if (ad.a(requestEntity)) {
            return OperationResponse.REQUEST_CONTAIN_XSS;
        }
        if (!"code".equals(responseType)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.Nw);
        }
        String requestCsrfToken = request.getHeader("Csrf-Token");
        String requestSessionId = WebUtils.getSessionId(request);
        OperationResponse userResp = this.openApiInternalApiService.a(new GetUserInfoRequestDTO(omadacId, requestSessionId));
        if (!userResp.success() || Objects.isNull(userResp.getResult())) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        OauthUserCacheDTO oauthUserCacheDTO = (OauthUserCacheDTO)userResp.getResult();
        String cacheCsrfToken = oauthUserCacheDTO.getCsrfToken();
        String cacheSessionId = oauthUserCacheDTO.getSessionId();
        String cacheClientId = oauthUserCacheDTO.getClientId();
        if (!T.a((String)requestCsrfToken, (String)cacheCsrfToken)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.Nx);
        }
        if (!T.a((String)requestSessionId, (String)cacheSessionId)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.Ny);
        }
        if (!T.a((String)clientId, (String)cacheClientId)) {
            log.warn("invalid clientId {}, not equals cache clientId {}", (Object)clientId, (Object)cacheClientId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.Nv);
        }
        String authCode = OauthGenerateService.generateCode();
        OauthCodeCacheDTO oauthCodeCacheDTO = new OauthCodeCacheDTO(oauthUserCacheDTO.getApplicationOmadacId(), oauthUserCacheDTO.getMspId(), oauthUserCacheDTO.getTenantId(), ((OauthUserCacheDTO)userResp.getResult()).getMsp());
        CacheOauthCodeInfoRequestDTO cacheOauthCodeInfoRequestDTO = new CacheOauthCodeInfoRequestDTO(authCode, oauthCodeCacheDTO);
        this.openApiInternalApiService.a(cacheOauthCodeInfoRequestDTO);
        String redirectUrl = oauthUserCacheDTO.getRedirectUrl();
        if (!T.a((String)redirectUrl)) {
            try {
                response.sendRedirect(this.getRedirectUrlWithCode(redirectUrl, authCode));
            }
            catch (IOException e2) {
                log.error("Open API authorize redirect failed.", (Throwable)e2);
            }
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, "Open API Authorize successfully.", (Object)authCode);
    }

    private String getRedirectUrlWithCode(String redirectUri, String code) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(redirectUri);
        if (StringUtils.containsIgnoreCase((CharSequence)redirectUri, (CharSequence)"?")) {
            stringBuilder.append("&");
        } else {
            stringBuilder.append("?");
        }
        stringBuilder.append("code");
        stringBuilder.append("=");
        stringBuilder.append(code);
        return stringBuilder.toString();
    }

    @PostMapping(value={"/openapi/authorize/token"})
    @ResponseBody
    public OperationResponse getTokenByOpenApi(HttpServletRequest request, @RequestBody(required=false) String body) {
        Map paramMap;
        RequestEntity<String> requestEntity = WebUtils.getStringRequestEntity(body, request);
        if (ad.a(requestEntity)) {
            return OperationResponse.REQUEST_CONTAIN_XSS;
        }
        String grantType = request.getParameter("grant_type");
        String requestClientId = request.getParameter("client_id");
        String requestClientSecret = request.getParameter("client_secret");
        try {
            paramMap = body == null ? new HashMap() : x.a((String)body);
        }
        catch (d e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            return OperationResponse.PARAM_ERROR;
        }
        requestClientId = String.valueOf(paramMap.getOrDefault("client_id", requestClientId));
        requestClientSecret = String.valueOf(paramMap.getOrDefault("client_secret", requestClientSecret));
        if (T.a((String)"authorization_code", (String)grantType)) {
            String code = request.getParameter("code");
            return this.handleOauthCode(code, requestClientId, requestClientSecret);
        }
        if (T.a((String)"client_credentials", (String)grantType)) {
            if (Objects.isNull(body)) {
                log.debug("ClientId:{} failed to get token by open api, body is null", (Object)requestClientId);
                return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
            }
            String omadacId = String.valueOf(paramMap.get("omadacId"));
            OperationResponse inIpAccessRule = this.ipAccessCache.isOpenIpFilterOrInIpAccessRule(omadacId, request);
            if (!inIpAccessRule.success()) {
                return inIpAccessRule;
            }
            return this.handleOauthClient(omadacId, requestClientId, requestClientSecret);
        }
        if (T.a((String)"refresh_token", (String)grantType)) {
            String requestRefreshToken = request.getParameter("refresh_token");
            return this.handleRefreshToken(requestRefreshToken, requestClientId, requestClientSecret);
        }
        log.warn("invalid outh mode");
        return new OperationResponse(com.tplink.smb.omada.common.g.b.NA);
    }

    private OperationResponse handleOauthCode(String code, String requestClientId, String requestClientSecret) {
        OperationResponse codeResp = this.openApiInternalApiService.a(code);
        if (!codeResp.success() || Objects.isNull(codeResp.getResult())) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.Nz);
        }
        OauthCodeCacheDTO oauthCodeCacheDTO = (OauthCodeCacheDTO)codeResp.getResult();
        String tenantId = oauthCodeCacheDTO.getTenantId();
        OperationResponse checkClientIdResp = this.identityAccessInternalApiService.a(CheckOpenApiClientIdDTO.builder().omadacIds(Collections.singleton(oauthCodeCacheDTO.getApplicationOmadacId())).clientId(requestClientId).build());
        if (!checkClientIdResp.success() || Objects.isNull(checkClientIdResp.getResult())) {
            log.warn("check clientId failed omadacId={}, msg={}", (Object)oauthCodeCacheDTO.getApplicationOmadacId(), (Object)checkClientIdResp.getMsg());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.Nv);
        }
        OpenApiApplicationDTO openApiApplicationDTO = (OpenApiApplicationDTO)checkClientIdResp.getResult();
        if (!Objects.equals(0, openApiApplicationDTO.getMode())) {
            log.warn("application is not auth omadacId={}", (Object)oauthCodeCacheDTO.getApplicationOmadacId());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.Nv);
        }
        if (!T.a((String)requestClientId, (String)openApiApplicationDTO.getClientId()) || !T.a((String)requestClientSecret, (String)openApiApplicationDTO.getClientSecret())) {
            log.warn("check clientId failed omadacId={}", (Object)oauthCodeCacheDTO.getApplicationOmadacId());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.Nv);
        }
        OauthToken oauthToken = OauthGenerateService.generateOauthTokenInfo((boolean)true);
        String accessToken = oauthToken.getAccessToken();
        String refreshToken = oauthToken.getRefreshToken();
        OauthTokenCacheDTO oauthTokenCacheDTO = OauthTokenCacheDTO.builder().omadacId(oauthCodeCacheDTO.getApplicationOmadacId()).mspId(oauthCodeCacheDTO.getMspId()).clientId(requestClientId).grantType(Integer.valueOf(0)).msp(oauthCodeCacheDTO.getMsp()).accessToken(oauthToken.getAccessToken()).codeMode(new AuthCodeModeInfo(tenantId)).time(Long.valueOf(System.currentTimeMillis())).build();
        this.openApiInternalApiService.a(CacheOauthTokenInfoRequestDTO.builder().accessToken(accessToken).oauthTokenCacheDTO(oauthTokenCacheDTO).build());
        this.openApiInternalApiService.b(CacheOauthTokenInfoRequestDTO.builder().refreshToken(refreshToken).oauthTokenCacheDTO(oauthTokenCacheDTO).build());
        this.openApiInternalApiService.a(UpdateAccessTokenListDTO.builder().clientId(requestClientId).accessToken(accessToken).build());
        this.openApiInternalApiService.a(UpdateRefreshTokenListDTO.builder().clientId(requestClientId).refreshToken(refreshToken).build());
        this.openApiInternalApiService.b(code);
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, "Open API Get Access Token successfully.", (Object)oauthToken);
    }

    private OperationResponse handleOauthClient(String omadacId, String requestClientId, String requestClientSecret) {
        if (T.a((String)omadacId)) {
            log.debug("ClientId:{} failed to get token by open api, omadacId is null", (Object)requestClientId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        OperationResponse checkClientIdResp = this.identityAccessInternalApiService.a(CheckOpenApiClientIdDTO.builder().omadacIds(Collections.singleton(omadacId)).clientId(requestClientId).build());
        if (!checkClientIdResp.success() || Objects.isNull(checkClientIdResp.getResult())) {
            log.warn("check client id failed, omadacId={}, errorMsg {}", (Object)omadacId, (Object)checkClientIdResp.getMsg());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.Nv);
        }
        OpenApiApplicationDTO openApiApplicationDTO = (OpenApiApplicationDTO)checkClientIdResp.getResult();
        if (!Objects.equals(1, openApiApplicationDTO.getMode())) {
            log.warn("not client mode, omadacId={}", (Object)omadacId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.Nv);
        }
        if (!Objects.equals(requestClientSecret, openApiApplicationDTO.getClientSecret())) {
            log.warn("check client secret failed, request {}, db {}, omadacId={}", (Object)requestClientSecret, (Object)openApiApplicationDTO.getClientSecret(), (Object)omadacId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.Nv);
        }
        OperationResponse<OauthTokenCacheDTO> response = this.buildTokenCacheDTO(omadacId, requestClientId, openApiApplicationDTO);
        if (!response.success() || Objects.isNull(response.getResult())) {
            log.debug("ClientId:{} failed to build token by open api, openApiApplicationDTO:{}", (Object)requestClientId, (Object)openApiApplicationDTO);
            return response;
        }
        OauthTokenCacheDTO oauthTokenCacheDTO = (OauthTokenCacheDTO)response.getResult();
        OauthToken oauthToken = OauthGenerateService.generateOauthTokenInfo((boolean)true);
        String accessToken = oauthToken.getAccessToken();
        String refreshToken = oauthToken.getRefreshToken();
        oauthTokenCacheDTO.setAccessToken(oauthToken.getAccessToken());
        this.openApiInternalApiService.a(CacheOauthTokenInfoRequestDTO.builder().accessToken(accessToken).oauthTokenCacheDTO(oauthTokenCacheDTO).build());
        this.openApiInternalApiService.b(CacheOauthTokenInfoRequestDTO.builder().refreshToken(refreshToken).oauthTokenCacheDTO(oauthTokenCacheDTO).build());
        this.openApiInternalApiService.a(UpdateAccessTokenListDTO.builder().clientId(requestClientId).accessToken(accessToken).build());
        this.openApiInternalApiService.a(UpdateRefreshTokenListDTO.builder().clientId(requestClientId).refreshToken(refreshToken).build());
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, "Open API Get Access Token successfully.", (Object)oauthToken);
    }

    private OperationResponse<OauthTokenCacheDTO> buildTokenCacheDTO(String omadacId, String requestClientId, OpenApiApplicationDTO openApiApplicationDTO) {
        OauthTokenCacheDTO oauthTokenCacheDTO = OauthTokenCacheDTO.builder().omadacId(omadacId).clientId(requestClientId).grantType(Integer.valueOf(1)).msp(openApiApplicationDTO.getMsp()).time(Long.valueOf(System.currentTimeMillis())).build();
        if (Boolean.TRUE.equals(openApiApplicationDTO.getMsp())) {
            MspApiApplicationDTO mspApiApplicationDTO = openApiApplicationDTO.getMspPermission();
            if (Objects.isNull(mspApiApplicationDTO) || Objects.isNull(mspApiApplicationDTO.getMspRoleId()) || Objects.isNull(mspApiApplicationDTO.getCustomerPrivilege())) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
            }
            oauthTokenCacheDTO.setMspClientMode(new MspClientModeInfo(mspApiApplicationDTO.getMspRoleId(), mspApiApplicationDTO.getCustomerPrivilege(), mspApiApplicationDTO.getCustomers(), mspApiApplicationDTO.getCustomerRoleId()));
        } else {
            GlobalApiApplicationDTO globalApiApplicationDTO = openApiApplicationDTO.getGlobalPermission();
            if (Objects.isNull(globalApiApplicationDTO) || Objects.isNull(globalApiApplicationDTO.getRoleId()) || Objects.isNull(globalApiApplicationDTO.getSitePrivilege())) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
            }
            oauthTokenCacheDTO.setGlobalClientMode(new GlobalClientModeInfo(globalApiApplicationDTO.getRoleId(), globalApiApplicationDTO.getSitePrivilege(), globalApiApplicationDTO.getSiteIds()));
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)oauthTokenCacheDTO);
    }

    private OperationResponse handleRefreshToken(String requestRefreshToken, String requestClientId, String requestClientSecret) {
        if (T.a((String)requestRefreshToken)) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        OperationResponse refreshResp = this.openApiInternalApiService.d(requestRefreshToken);
        if (!refreshResp.success() || Objects.isNull(refreshResp.getResult())) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.ND);
        }
        OauthTokenCacheDTO refreshTokenInfo = (OauthTokenCacheDTO)refreshResp.getResult();
        OperationResponse checkClientIdResp = this.identityAccessInternalApiService.a(CheckOpenApiClientIdDTO.builder().omadacIds(Collections.singleton(refreshTokenInfo.getOmadacId())).clientId(requestClientId).build());
        if (!checkClientIdResp.success() || Objects.isNull(checkClientIdResp.getResult())) {
            log.warn("check client id failed, omadacId={}, errorMsg {}", (Object)refreshTokenInfo.getOmadacId(), (Object)checkClientIdResp.getMsg());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.Nv);
        }
        OpenApiApplicationDTO openApiApplicationDTO = (OpenApiApplicationDTO)checkClientIdResp.getResult();
        if (!T.a((String)requestClientId, (String)openApiApplicationDTO.getClientId()) || !T.a((String)requestClientSecret, (String)openApiApplicationDTO.getClientSecret())) {
            log.warn("check client id or secret failed, omadacId={}", (Object)refreshTokenInfo.getOmadacId());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.Nv);
        }
        String accessToken = refreshTokenInfo.getAccessToken();
        OperationResponse accessResp = this.openApiInternalApiService.c(accessToken);
        if (!accessResp.success() || Objects.isNull(accessResp.getResult())) {
            return this.refreshToken(refreshTokenInfo, requestRefreshToken);
        }
        OauthTokenCacheDTO accessTokenInfo = (OauthTokenCacheDTO)accessResp.getResult();
        long expiresIn = this.calculateExpireTime(accessTokenInfo.getTime());
        if (expiresIn > 0L) {
            OauthToken oauthToken = new OauthToken(accessToken, "bearer", Integer.valueOf((int)expiresIn), requestRefreshToken);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, "Open API Get Access Token successfully.", (Object)oauthToken);
        }
        return this.refreshToken(accessTokenInfo, requestRefreshToken);
    }

    private OperationResponse refreshToken(OauthTokenCacheDTO oauthTokenCacheDTO, String oldRefreshToken) {
        this.openApiInternalApiService.e(oldRefreshToken);
        OmadaClusterUniversalRequestDTO deleteRequestDTO = new OmadaClusterUniversalRequestDTO(SpeedUpLoginController.class, (TypeReference)new TypeReference<Void>(){}, "deleteRefreshTokenInfo", new Class[]{String.class}, new Object[]{oldRefreshToken});
        this.handleLocalCluster(deleteRequestDTO);
        OauthToken oauthToken = OauthGenerateService.generateOauthTokenInfo((boolean)true);
        String accessToken = oauthToken.getAccessToken();
        String refreshToken = oauthToken.getRefreshToken();
        this.openApiInternalApiService.a(CacheOauthTokenInfoRequestDTO.builder().accessToken(accessToken).oauthTokenCacheDTO(oauthTokenCacheDTO).build());
        this.openApiInternalApiService.b(CacheOauthTokenInfoRequestDTO.builder().refreshToken(refreshToken).oauthTokenCacheDTO(oauthTokenCacheDTO).build());
        String clientId = oauthTokenCacheDTO.getClientId();
        this.openApiInternalApiService.a(UpdateAccessTokenListDTO.builder().clientId(clientId).accessToken(accessToken).build());
        this.openApiInternalApiService.a(UpdateRefreshTokenListDTO.builder().clientId(clientId).refreshToken(refreshToken).build());
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, "Open API Refresh Token successfully.", (Object)oauthToken);
    }

    @KeepMethod
    public void deleteRefreshTokenInfo(String oldRefreshToken) {
        log.debug("Node id: " + a.h() + "\u2014\u2014> deleteRefreshTokenInfo");
        this.openApiInternalApiService.e(oldRefreshToken);
    }

    private long calculateExpireTime(Long saveTime) {
        long time = (System.currentTimeMillis() - saveTime) / 1000L;
        long expireTime = 7200L - time;
        return expireTime < 0L ? 0L : expireTime;
    }
}

