/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch;

import com.google.common.base.Strings;
import com.tplink.smb.component.cache.api.CacheService;
import com.tplink.smb.omada.apigateway.dispatch.SpeedUpLoginController;
import com.tplink.smb.omada.apigateway.dispatch.UserOperationForIam;
import com.tplink.smb.omada.apigateway.dispatch.cache.IpAccessCache;
import com.tplink.smb.omada.apigateway.dispatch.cache.LoginCache;
import com.tplink.smb.omada.apigateway.dispatch.dto.CloudUserLoginByTokenRequestDTO;
import com.tplink.smb.omada.apigateway.dispatch.dto.SendEmailByResetPwdForUserInfo;
import com.tplink.smb.omada.apigateway.dispatch.dto.SsoUserDTO;
import com.tplink.smb.omada.apigateway.dispatch.dto.WebResetPasswordRequestDTO;
import com.tplink.smb.omada.apigateway.dispatch.dto.WebSendEmailByResetPwdRequestDTO;
import com.tplink.smb.omada.apigateway.dispatch.dto.WebSendEmailByResetPwdResponseDTO;
import com.tplink.smb.omada.apigateway.dispatch.log.AddLogService;
import com.tplink.smb.omada.apigateway.dispatch.log.SendAuditLogService;
import com.tplink.smb.omada.apigateway.dispatch.meter.ApiMeters;
import com.tplink.smb.omada.apigateway.dispatch.shiro.security.CloudUserToken;
import com.tplink.smb.omada.apigateway.dispatch.shiro.security.HotspotToken;
import com.tplink.smb.omada.apigateway.dispatch.shiro.security.SsoToken;
import com.tplink.smb.omada.apigateway.dispatch.stomp.port.cache.StompSessionCache;
import com.tplink.smb.omada.apigateway.dispatch.util.WebUtils;
import com.tplink.smb.omada.central.components.common.util.b.b;
import com.tplink.smb.omada.common.access.OperationResponse;
import com.tplink.smb.omada.common.access.UserTypeEnumDTO;
import com.tplink.smb.omada.common.access.e;
import com.tplink.smb.omada.common.gridquery.c;
import com.tplink.smb.omada.common.h.d;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.common.util.ad;
import com.tplink.smb.omada.common.util.system.a;
import com.tplink.smb.omada.common.util.x;
import com.tplink.smb.omada.dispatcher.common.util.SessionUtils;
import com.tplink.smb.omada.dispatcher.common.util.UserIpUtils;
import com.tplink.smb.omada.iam.api.a.a.c;
import com.tplink.smb.omada.iam.api.internal.dto.IamCheckPasswordRequestDTO;
import com.tplink.smb.omada.iam.api.internal.dto.IamCheckPasswordResponseDTO;
import com.tplink.smb.omada.iam.api.internal.dto.IamLoginResponseDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.CreateExternalUserDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.DeleteSessionByIdRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.DisableMFARequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.DisableMfaLocalUserDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.GetCurrentInfoDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.GetExternalUserDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.GetExternalUserResDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.GetLoginStatusDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.GetOperatorRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.GetSessionRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.HotspotSessionRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.LoginStatusDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.OmadaRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.OmadacDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.OmadacVO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.OperatorDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.QueryCloudUserDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.QueryTenantDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.QueryUserDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.QueryUserWithGroupNameDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.QueryUserWithSessionIdDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.QueryUserWithTenantIdDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.ResetPasswordRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.SaveSessionDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.SaveSsoSessionDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.SendEmailByResetPasswordRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.SsoAssertionDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.SsoSubjectInfoDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.SwitchLastCustomerAndViewDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.TenantDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.UserDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.omadacloud.CheckLoginByOmadaCloudRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.omadacloud.CheckLoginByOmadaCloudResponseDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.omadacloud.CheckLoginByTPCloudResponseDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.omadacloud.CheckMFACodeAndLoginRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.omadacloud.GetMFAStatusDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.omadacloud.HandleCloudUserLoginRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.dto.omadacloud.SaveTokenMappingSessionRequestDTO;
import com.tplink.smb.omada.identityaccess.api.internal.g;
import com.tplink.smb.omada.identityaccess.api.internal.h;
import com.tplink.smb.omada.identityaccess.api.internal.i;
import com.tplink.smb.omada.identityaccess.api.internal.k;
import com.tplink.smb.omada.identityaccess.api.internal.l;
import com.tplink.smb.omada.logmanager.api.internal.dto.AuditLogResourceEnumDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.OmadaLogKeyEnumDTO;
import com.tplink.smb.omada.logmanager.api.internal.dto.audit.AuditLogKeyEnumDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.omadac.dto.GetOmadacBasicConfigDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.omadac.dto.OmadacBasicConfigDTO;
import com.tplink.smb.omada.manager.configuration.api.internal.omadac.dto.QueryUserCloudDomainDTO;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.http.HttpStatus;
import org.springframework.http.RequestEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@Hidden
public class LoginController {
    @Generated
    private static final Logger log = LogManager.getLogger(LoginController.class);
    public static final String SESSION_ID = "sessionId";
    private static final int MFA_TYPE_TOTP = 3;
    private static final int DEFAULT_TIMEOUT_SECONDS = 1200;
    private static final String PARAM_NAME_RELAY_STATE = "RelayState";
    private static final String PARAM_NAME_SAML_REQUEST = "SAMLRequest";
    private static final String PARAM_NAME_SAML_RESPONSE = "SAMLResponse";
    @Autowired
    @Lazy
    private h identityAccessWebInternalApiService;
    @Autowired
    @Lazy
    private g identityAccessInternalApiService;
    @Autowired
    @Lazy
    private i identityHotspotInternalApiService;
    @Autowired
    @Lazy
    private LoginCache loginCache;
    @Autowired
    @Lazy
    private k omadacCloudApiService;
    @Autowired
    @Lazy
    private com.tplink.smb.omada.logmanager.api.internal.i logApiService;
    @Autowired
    private AddLogService addLogService;
    @Autowired
    @Lazy
    private SpeedUpLoginController speedUpLoginController;
    @Autowired
    @Lazy
    private ApiMeters apiMeters;
    @Autowired
    @Lazy
    private SendAuditLogService sendAuditLogService;
    @Autowired
    @Lazy
    private CacheService cacheService;
    @Autowired
    @Lazy
    private com.tplink.smb.omada.identityaccess.api.internal.a.c omadacLocalInternalApiService;
    @Autowired
    @Lazy
    private l omadacInternalApiService;
    @Autowired
    private IpAccessCache ipAccessCache;
    @Autowired
    @Lazy
    private UserOperationForIam userOperationForIam;
    @Autowired
    private com.tplink.smb.omada.manager.configuration.api.internal.omadac.b managerOmadaInternalService;

    @GetMapping(value={"/{omadacId}/hotspot/login"})
    public String hotspotLogin() {
        log.debug("hotspot login");
        return "index";
    }

    @PostMapping(value={"/{omadacId}/api/v2/checkMFACodeAndLogin", "/api/v2/checkMFACodeAndLogin", "/{omadacId}/api/v2/app/checkMFACodeAndLogin"})
    @ResponseBody
    public OperationResponse checkMFACodeAndLogin(HttpServletRequest request, HttpServletResponse response, @RequestBody String body, @PathVariable(name="omadacId", required=false) String omadacId) {
        Map paramMap;
        RequestEntity<String> requestEntity = WebUtils.getStringRequestEntity(body, request);
        if (ad.a(requestEntity)) {
            return OperationResponse.REQUEST_CONTAIN_XSS;
        }
        try {
            paramMap = x.a((String)body);
        }
        catch (d e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            return OperationResponse.PARAM_ERROR;
        }
        String username = String.valueOf(paramMap.get("username"));
        String password = String.valueOf(paramMap.get("password"));
        String mfaId = String.valueOf(paramMap.get("MFAId"));
        String code = String.valueOf(paramMap.get("code"));
        Integer mfaType = (Integer)paramMap.get("mfaType");
        Boolean supportMsp = (Boolean)paramMap.get("supportMsp");
        OperationResponse omadacRes = this.omadacInternalApiService.a(OmadaRequestDTO.builder().omadacId(omadacId).build());
        if (!omadacRes.success()) {
            return omadacRes;
        }
        if (omadacId == null) {
            omadacId = ((OmadacDTO)omadacRes.getResult()).getId();
        }
        if (!com.tplink.smb.omada.common.util.f.c.bU.matcher(username).matches()) {
            this.apiMeters.loginFailCount(ApiMeters.LoginFailureReason.INVALID_USERNAME_OR_PASSWORD);
            log.warn("Invalid user name pt or password, omadacId {}.", (Object)omadacId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.cc);
        }
        OperationResponse lockRsp = this.loginCache.checkLockStatus(username, new HashMap<String, Object>(4));
        if (!lockRsp.success()) {
            this.apiMeters.loginFailCount(ApiMeters.LoginFailureReason.FROZEN);
            return lockRsp;
        }
        UserIpUtils.setLocalUserIp((String)WebUtils.getRemoteAddress(request));
        OperationResponse optRes = this.identityAccessWebInternalApiService.a(((CheckMFACodeAndLoginRequestDTO.CheckMFACodeAndLoginRequestDTOBuilder)((CheckMFACodeAndLoginRequestDTO.CheckMFACodeAndLoginRequestDTOBuilder)((CheckMFACodeAndLoginRequestDTO.CheckMFACodeAndLoginRequestDTOBuilder)CheckMFACodeAndLoginRequestDTO.builder().omadacId(omadacId)).username(username)).password(password)).MFAId(mfaId).MFAType(Integer.valueOf(Objects.isNull(mfaType) ? 3 : mfaType)).code(code).build());
        log.info("omadacId={} check MFA code and login response:{}", (Object)omadacId, (Object)optRes.toString());
        if (!optRes.success()) {
            this.addLogService.addLoginLog(omadacId, username, WebUtils.getRemoteAddress(request), false, AuditLogResourceEnumDTO.WEB.getResourceCode());
            this.apiMeters.loginFailCount(ApiMeters.LoginFailureReason.SERVICE_ERROR);
            OperationResponse res = this.loginCache.checkLoginLimit(username, new HashMap<String, Object>(2));
            if (Objects.equals(com.tplink.smb.omada.common.g.b.cc.b(), res.getErrorCode())) {
                return optRes;
            }
            return res;
        }
        CheckLoginByTPCloudResponseDTO result = (CheckLoginByTPCloudResponseDTO)optRes.getResult();
        String token = result.getToken();
        SessionUtils.setThreadSessionId((String)token);
        if (Objects.equals(UserTypeEnumDTO.LOCAL_USER.getValue(), result.getUserType())) {
            IamCheckPasswordRequestDTO iamLoginRequestDTO = IamCheckPasswordRequestDTO.builder().username(username).password(password).build();
            c<IamCheckPasswordResponseDTO> checkPassword = this.userOperationForIam.checkPassword(iamLoginRequestDTO);
            if (!checkPassword.b()) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.aT);
            }
            return this.speedUpLoginController.handleLocalTenantLogin(omadacId, username, password, result.getTenantDTO(), request, response, ((OmadacDTO)omadacRes.getResult()).getPattern());
        }
        OperationResponse<Map<String, Object>> handleRes = this.speedUpLoginController.handleCloudUserLogin(request, response, HandleCloudUserLoginRequestDTO.builder().omadacId(omadacId).accountId(result.getAccountId()).email(username).build(), supportMsp, null);
        if (handleRes.success()) {
            ((Map)handleRes.getResult()).remove(SESSION_ID);
        }
        return handleRes;
    }

    @PostMapping(value={"/{omadacId}/api/v2/hotspot/login"})
    @ResponseBody
    public OperationResponse hotspotLogin(HttpServletRequest request, HttpServletResponse response, @RequestBody JSONObject params, @PathVariable(name="omadacId") String omadacId) {
        RequestEntity<String> requestEntity = WebUtils.getStringRequestEntity(params.toString(), request);
        if (ad.a(requestEntity)) {
            return OperationResponse.REQUEST_CONTAIN_XSS;
        }
        String username = params.optString("name");
        String password = params.optString("password");
        if (!com.tplink.smb.omada.common.util.f.c.bU.matcher(username).matches()) {
            log.warn("Invalid user name pt or password, omadacId {}.", (Object)omadacId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.cc);
        }
        HashMap<String, Object> result = new HashMap<String, Object>(4);
        OperationResponse lockRsp = this.loginCache.checkLockStatus(username, result);
        if (!lockRsp.success()) {
            return lockRsp;
        }
        UserIpUtils.setLocalUserIp((String)WebUtils.getRemoteAddress(request));
        HotspotToken token = new HotspotToken(omadacId, username, password);
        Subject curUser = SecurityUtils.getSubject();
        String sessionId = (String)((Object)curUser.getSession().getId());
        OperationResponse optResp = this.identityHotspotInternalApiService.a(new GetOperatorRequestDTO(omadacId, username));
        try {
            curUser.login((AuthenticationToken)token);
            log.debug("hotspot login, omadacId:{}, name: {}, sessionId: {}", (Object)omadacId, (Object)username, (Object)sessionId);
        }
        catch (Exception e2) {
            if (optResp.success() && optResp.getResult() != null) {
                this.logApiService.a(omadacId, OmadaLogKeyEnumDTO.HS_LOGIN_FL, OmadaLogKeyEnumDTO.HS_LOGIN_FL.build(omadacId, null, null, null, new String[]{username, WebUtils.getRemoteAddress(request)}).toJson());
                this.sendAuditLogService.sendAuditLog(omadacId, null, AuditLogKeyEnumDTO.HOTSPOT_LOGIN.name(), username, false, AuditLogResourceEnumDTO.WEB.getResourceCode(), username);
                return this.loginCache.checkLoginLimit(username, result);
            }
            this.logApiService.a(omadacId, OmadaLogKeyEnumDTO.HS_LOGIN_FL, OmadaLogKeyEnumDTO.HS_LOGIN_FL.build(omadacId, null, null, null, new String[]{username, WebUtils.getRemoteAddress(request)}).toJson());
            this.sendAuditLogService.sendAuditLog(omadacId, null, AuditLogKeyEnumDTO.HOTSPOT_LOGIN.name(), username, false, AuditLogResourceEnumDTO.WEB.getResourceCode(), username);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.cc);
        }
        List sitesPermission = ((OperatorDTO)optResp.getResult()).getSiteIds();
        if (CollectionUtils.isEmpty((Collection)sitesPermission)) {
            this.logApiService.a(omadacId, OmadaLogKeyEnumDTO.HS_LOGIN_FL, OmadaLogKeyEnumDTO.HS_LOGIN_FL.build(omadacId, null, null, null, new String[]{username, WebUtils.getRemoteAddress(request)}).toJson());
            this.sendAuditLogService.sendAuditLog(omadacId, null, AuditLogKeyEnumDTO.HOTSPOT_LOGIN.name(), username, false, AuditLogResourceEnumDTO.WEB.getResourceCode(), username);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.cd);
        }
        this.identityHotspotInternalApiService.a(new HotspotSessionRequestDTO(omadacId, username, sessionId));
        if (request.getSession().getAttribute("Csrf-Token") == null) {
            request.getSession().setAttribute("Csrf-Token", (Object)WebUtils.buildRandomUUID());
        }
        String csrfToken = (String)request.getSession().getAttribute("Csrf-Token");
        result.put("token", csrfToken);
        this.loginCache.remove(username);
        this.logApiService.a(omadacId, OmadaLogKeyEnumDTO.HS_LOGIN_OK, OmadaLogKeyEnumDTO.HS_LOGIN_OK.build(omadacId, null, null, null, new String[]{username, WebUtils.getRemoteAddress(request)}).toJson());
        this.sendAuditLogService.sendAuditLog(omadacId, null, AuditLogKeyEnumDTO.HOTSPOT_LOGIN.name(), username, true, AuditLogResourceEnumDTO.WEB.getResourceCode(), username);
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, "Hotspot log in successfully.", result);
    }

    @CrossOrigin(origins={"*"}, allowedHeaders={"*"}, methods={RequestMethod.POST, RequestMethod.GET})
    @RequestMapping(value={"/sso/saml/login"}, method={RequestMethod.POST, RequestMethod.GET})
    @ResponseBody
    public OperationResponse ssoLogin(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="RelayState", required=false) String relayState) throws IOException {
        String decodedRelayState;
        String samlResponse = request.getParameter(PARAM_NAME_SAML_REQUEST);
        if (Strings.isNullOrEmpty((String)samlResponse)) {
            samlResponse = request.getParameter(PARAM_NAME_SAML_RESPONSE);
        }
        log.info("ssoLogin start, requestMethod: {}, samlResponse: {}; relayState:{}", (Object)request.getMethod(), (Object)samlResponse, (Object)relayState);
        if (RequestMethod.GET.name().equals(request.getMethod())) {
            log.warn("ssoLogin not support GET request");
            response.setStatus(HttpStatus.METHOD_NOT_ALLOWED.value());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.g);
        }
        if (T.c((String)relayState) || T.c((String)samlResponse)) {
            log.warn("relayState or samlResponse is null.");
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        try {
            decodedRelayState = new String(Base64.getUrlDecoder().decode(relayState), StandardCharsets.UTF_8);
        }
        catch (Exception e2) {
            log.warn("resolve relay state failed. relayState:{}.", (Object)relayState);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        String[] array = decodedRelayState.split("_");
        if (array.length < 2) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        String omadacId = array[1];
        if (omadacId == null) {
            log.warn("resolve relay state get omadacId is null. relayState:{}.", (Object)relayState);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        OperationResponse omadacRes = this.omadacInternalApiService.a(OmadaRequestDTO.builder().omadacId(omadacId).build());
        if (!omadacRes.success()) {
            log.warn("resolve relay state get omadacId to get Omadac is null. relayState:{}.", (Object)relayState);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        log.info("omadacId:{}, resolve relay state result:{}, length:{}.", (Object)omadacId, (Object)decodedRelayState, (Object)decodedRelayState.length());
        OperationResponse inIpAccessRule = this.ipAccessCache.isOpenIpFilterOrInIpAccessRule(omadacId, request);
        if (!inIpAccessRule.success()) {
            return inIpAccessRule;
        }
        OperationResponse operationResponse = this.identityAccessInternalApiService.a(new SsoAssertionDTO(samlResponse, relayState));
        if (!operationResponse.success()) {
            log.warn("Failed to get sso subject info {}", (Object)operationResponse.getMsg());
            return operationResponse;
        }
        SsoSubjectInfoDTO ssoSubjectInfo = (SsoSubjectInfoDTO)operationResponse.getResult();
        Map attributes = ssoSubjectInfo.getAttributes();
        String controllerId = this.getAttributeValue(attributes, "resource_id");
        String userName = this.getAttributeValue(attributes, "username");
        String userGroupName = this.getAttributeValue(attributes, "usergroup_name");
        OperationResponse verifyGroupOps = this.identityAccessInternalApiService.a(new QueryUserWithGroupNameDTO(controllerId, userGroupName));
        if (!verifyGroupOps.success() || Boolean.FALSE.equals(verifyGroupOps.getResult())) {
            log.warn("The temporary user group already expires.OmadacId:{},GroupName:{}", (Object)controllerId, (Object)userGroupName);
            this.addLogService.addLoginLog(omadacId, userName, WebUtils.getRemoteAddress(request), false, AuditLogResourceEnumDTO.WEB.getResourceCode());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.dL);
        }
        CreateExternalUserDTO command = new CreateExternalUserDTO();
        command.setControllerId(controllerId);
        command.setUserName(userName);
        command.setExternalUserGroupName(userGroupName);
        command.setIdpId(this.getAttributeValue(attributes, "idp_id"));
        OperationResponse createExternalUserOps = this.identityAccessWebInternalApiService.a(command);
        if (!createExternalUserOps.success()) {
            log.warn("Create external user failed. omadacId: {}, msg: {}", (Object)controllerId, (Object)createExternalUserOps.getMsg());
            return createExternalUserOps;
        }
        String accessToken = ssoSubjectInfo.getAccessToken();
        SsoUserDTO ssoUserDTO = new SsoUserDTO(controllerId, (String)createExternalUserOps.getResult(), userName, userGroupName);
        this.cacheService.set("apigateway:sso:accesstoken", accessToken, (Object)ssoUserDTO, 1200L, TimeUnit.SECONDS);
        String redirectUrl = ssoSubjectInfo.getRedirectUrl() + accessToken;
        log.info("ssoLogin end. omadacId:{}", (Object)controllerId);
        response.sendRedirect(redirectUrl);
        return OperationResponse.SUCCESS;
    }

    private String getAttributeValue(Map<String, Object> attributes, String name) {
        return (String)attributes.get(name);
    }

    @GetMapping(value={"{omadacId}/sso/saml2/user/{accessToken}"})
    @ResponseBody
    public OperationResponse ssoLoginWithAccessToken(@PathVariable(value="omadacId") String omadacId, @PathVariable(value="accessToken") String accessToken, HttpServletRequest request, HttpServletResponse response) {
        OperationResponse inIpAccessRule = this.ipAccessCache.isOpenIpFilterOrInIpAccessRule(omadacId, request);
        if (!inIpAccessRule.success()) {
            return inIpAccessRule;
        }
        SsoUserDTO ssoUserDTO = (SsoUserDTO)this.cacheService.get("apigateway:sso:accesstoken", accessToken, SsoUserDTO.class);
        if (ssoUserDTO == null) {
            log.warn("loginSamlUser. get access token cache failed. omadacId: {}. accessToken: {}.", new Supplier[]{() -> omadacId, () -> com.tplink.smb.omada.common.util.e.a.c((String)accessToken)});
            return OperationResponse.PARAM_ERROR;
        }
        String controllerId = ssoUserDTO.getOmadacId();
        String username = ssoUserDTO.getUserName();
        String userGroupName = ssoUserDTO.getUserGroupName();
        UserIpUtils.setLocalUserIp((String)WebUtils.getRemoteAddress(request));
        this.cacheService.deleteKey("apigateway:sso:accesstoken", accessToken);
        SsoToken ssoToken = new SsoToken(controllerId, username, userGroupName);
        Subject curUser = SecurityUtils.getSubject();
        String sessionId = (String)((Object)curUser.getSession().getId());
        DeleteSessionByIdRequestDTO deleteSessionByIdRequest = DeleteSessionByIdRequestDTO.builder().omadacId(controllerId).sessionId(sessionId).build();
        this.identityAccessWebInternalApiService.a(deleteSessionByIdRequest);
        try {
            log.debug("sso login, controllerId: {}, name: {}, sessionId: {}", (Object)controllerId, (Object)username, (Object)sessionId);
            curUser.login((AuthenticationToken)ssoToken);
        }
        catch (Exception e2) {
            log.warn("sso failed to login", (Throwable)e2);
            this.sendAuditLogService.sendMspOrGlobalAuditLog(controllerId, AuditLogKeyEnumDTO.EXTERNAL_USERS_LOGIN, AuditLogKeyEnumDTO.MSP_EXTERNAL_USERS_LOGIN, username, false, AuditLogResourceEnumDTO.WEB.getResourceCode(), username);
            return OperationResponse.PARAM_ERROR;
        }
        if (curUser.getSession().getAttribute((Object)"Csrf-Token") == null) {
            curUser.getSession().setAttribute((Object)"Csrf-Token", (Object)WebUtils.buildRandomUUID());
        }
        UserDTO userDTO = UserDTO.builder().id(ssoUserDTO.getUserId()).omadacId(controllerId).name(username).build();
        SaveSsoSessionDTO saveSsoSession = new SaveSsoSessionDTO(controllerId, sessionId, userDTO);
        this.identityAccessWebInternalApiService.a(saveSsoSession);
        curUser.getSession().setAttribute((Object)"omadacId", (Object)controllerId);
        this.loginCache.remove(username);
        String csrfToken = (String)request.getSession().getAttribute("Csrf-Token");
        HashMap<String, String> result = new HashMap<String, String>(2);
        result.put("token", csrfToken);
        this.sendAuditLogService.sendMspOrGlobalAuditLog(controllerId, AuditLogKeyEnumDTO.EXTERNAL_USERS_LOGIN, AuditLogKeyEnumDTO.MSP_EXTERNAL_USERS_LOGIN, username, true, AuditLogResourceEnumDTO.WEB.getResourceCode(), username);
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, result);
    }

    @GetMapping(value={"/sso/saml2/user/{accessToken}"})
    @ResponseBody
    public OperationResponse ssoLoginWithAccessTokenForLocal(@PathVariable(value="accessToken") String accessToken, HttpServletRequest request) {
        c<IamLoginResponseDTO> iamResponse;
        if (OmadacType.s()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        SsoUserDTO ssoUserDTO = (SsoUserDTO)this.cacheService.get("apigateway:sso:accesstoken", accessToken, SsoUserDTO.class);
        if (ssoUserDTO == null) {
            log.warn("loginSamlUserForLocal. get access token cache failed. accessToken:{}", (Object)accessToken);
            return OperationResponse.PARAM_ERROR;
        }
        String controllerId = ssoUserDTO.getOmadacId();
        String username = ssoUserDTO.getUserName();
        String userGroupName = ssoUserDTO.getUserGroupName();
        UserIpUtils.setLocalUserIp((String)WebUtils.getRemoteAddress(request));
        this.cacheService.deleteKey("apigateway:sso:accesstoken", accessToken);
        Subject curUser = SecurityUtils.getSubject();
        if (curUser.getSession() != null) {
            curUser.getSession().stop();
        }
        if ((iamResponse = this.userOperationForIam.applyToken(com.tplink.smb.omada.iam.api.a.c.a.a((String)controllerId, (String)username))).b()) {
            IamLoginResponseDTO iamLoginResponseDTO = (IamLoginResponseDTO)iamResponse.f();
            SessionUtils.setThreadSessionId((String)iamLoginResponseDTO.getToken());
        }
        SsoToken ssoToken = new SsoToken(controllerId, username, userGroupName);
        String sessionId = (String)((Object)curUser.getSession().getId());
        try {
            log.debug("sso login, controllerId: {}, name: {}, sessionId: {}", (Object)controllerId, (Object)username, (Object)sessionId);
            curUser.login((AuthenticationToken)ssoToken);
        }
        catch (Exception e2) {
            log.warn("sso failed to login", (Throwable)e2);
            this.sendAuditLogService.sendMspOrGlobalAuditLog(controllerId, AuditLogKeyEnumDTO.EXTERNAL_USERS_LOGIN, AuditLogKeyEnumDTO.MSP_EXTERNAL_USERS_LOGIN, username, false, AuditLogResourceEnumDTO.WEB.getResourceCode(), username);
            return OperationResponse.PARAM_ERROR;
        }
        if (curUser.getSession().getAttribute((Object)"Csrf-Token") == null) {
            curUser.getSession().setAttribute((Object)"Csrf-Token", (Object)WebUtils.buildRandomUUID());
        }
        UserDTO userDTO = UserDTO.builder().id(ssoUserDTO.getUserId()).omadacId(controllerId).name(username).build();
        SaveSsoSessionDTO saveSsoSession = new SaveSsoSessionDTO(controllerId, sessionId, userDTO);
        this.identityAccessWebInternalApiService.a(saveSsoSession);
        curUser.getSession().setAttribute((Object)"omadacId", (Object)controllerId);
        this.loginCache.remove(username);
        String csrfToken = (String)curUser.getSession().getAttribute((Object)"Csrf-Token");
        HashMap<String, String> result = new HashMap<String, String>(2);
        result.put("token", csrfToken);
        this.sendAuditLogService.sendMspOrGlobalAuditLog(controllerId, AuditLogKeyEnumDTO.EXTERNAL_USERS_LOGIN, AuditLogKeyEnumDTO.MSP_EXTERNAL_USERS_LOGIN, username, true, AuditLogResourceEnumDTO.WEB.getResourceCode(), username);
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, result);
    }

    @PostMapping(value={"/{omadacId}/api/v2/loginWithToken"})
    @ResponseBody
    public OperationResponse cloudUserLoginByToken(HttpServletRequest request, HttpServletResponse response, @PathVariable(name="omadacId") String omadacId, @RequestBody @Valid CloudUserLoginByTokenRequestDTO cloudUserLoginByTokenRequest) {
        RequestEntity<String> requestEntity = WebUtils.getStringRequestEntity(x.a((Object)cloudUserLoginByTokenRequest), request);
        if (ad.a(requestEntity)) {
            return OperationResponse.REQUEST_CONTAIN_XSS;
        }
        cloudUserLoginByTokenRequest.setOmadacId(omadacId);
        if (!cloudUserLoginByTokenRequest.validate()) {
            return OperationResponse.PARAM_ERROR;
        }
        UserIpUtils.setLocalUserIp((String)WebUtils.getRemoteAddress(request));
        OperationResponse omadac = this.omadacInternalApiService.a(new OmadaRequestDTO(omadacId));
        if (!omadac.success()) {
            log.warn("find omadac failed. omadacId: {}.", (Object)omadac);
            return omadac;
        }
        if (Objects.equals(com.tplink.smb.omada.common.f.c.a.a(), ((OmadacDTO)omadac.getResult()).getPattern())) {
            cloudUserLoginByTokenRequest.setCustomerId(omadacId);
            cloudUserLoginByTokenRequest.setOmadacId(((OmadacDTO)omadac.getResult()).getMspId());
        }
        log.debug("omadac pattern is {}.", (Object)((OmadacDTO)omadac.getResult()).getPattern());
        log.debug("omadacId: {}, customerId: {}.", (Object)cloudUserLoginByTokenRequest.getOmadacId(), (Object)cloudUserLoginByTokenRequest.getCustomerId());
        OperationResponse optRes = this.identityAccessWebInternalApiService.a(new CheckLoginByOmadaCloudRequestDTO(cloudUserLoginByTokenRequest.getOmadacId(), cloudUserLoginByTokenRequest.getToken(), cloudUserLoginByTokenRequest.getCustomerId()));
        if (!optRes.success()) {
            if (optRes.getErrorCode() == com.tplink.smb.omada.common.g.b.b.b()) {
                this.apiMeters.loginFailCount(ApiMeters.LoginFailureReason.SERVICE_ERROR);
            } else {
                this.apiMeters.loginFailCount(ApiMeters.LoginFailureReason.TOKEN_INVALID);
            }
            return optRes;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        OperationResponse checkRes = this.checkMFA(omadacId, ((CheckLoginByOmadaCloudResponseDTO)optRes.getResult()).getAccountId(), ((CheckLoginByOmadaCloudResponseDTO)optRes.getResult()).getEmail(), result);
        if (!checkRes.success()) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a((int)checkRes.getErrorCode()), result);
        }
        String iamToken = this.resolveCloudToken(cloudUserLoginByTokenRequest.getToken());
        String iamCsrfToken = null;
        if (this.isCentralSession(iamToken)) {
            SessionUtils.setThreadSessionId((String)iamToken);
            OperationResponse<IamLoginResponseDTO> iamAccountInfo = this.userOperationForIam.loginWithToken(iamToken);
            if (iamAccountInfo.success()) {
                iamCsrfToken = ((IamLoginResponseDTO)iamAccountInfo.getResult()).getCsrfToken();
            } else {
                log.warn("get user info from iam failed. sessionId:{}.", (Object)iamToken);
            }
        }
        log.debug("cloud token: {}, resolved session id: {}.", (Object)cloudUserLoginByTokenRequest.getToken(), (Object)iamToken);
        OperationResponse<Map<String, Object>> handleRes = this.speedUpLoginController.handleCloudUserLogin(request, response, HandleCloudUserLoginRequestDTO.builder().accountId(((CheckLoginByOmadaCloudResponseDTO)optRes.getResult()).getAccountId()).email(((CheckLoginByOmadaCloudResponseDTO)optRes.getResult()).getEmail()).siteId(cloudUserLoginByTokenRequest.getSiteKey()).omadacId(omadacId).idleTimeout(((CheckLoginByOmadaCloudResponseDTO)optRes.getResult()).getIdleTimeout()).build(), true, iamCsrfToken);
        if (handleRes.success() && !CollectionUtils.isEmpty((Map)((Map)handleRes.getResult()))) {
            this.omadacCloudApiService.a(new SaveTokenMappingSessionRequestDTO(cloudUserLoginByTokenRequest.getOmadacId(), cloudUserLoginByTokenRequest.getToken(), String.valueOf(((Map)handleRes.getResult()).get(SESSION_ID))));
            if (Objects.equals(com.tplink.smb.omada.common.f.c.a.a(), ((OmadacDTO)omadac.getResult()).getPattern())) {
                log.debug("launch to customer, update user's last customer and view. customerId: {}.", (Object)omadacId);
                OperationResponse rsp = this.identityAccessWebInternalApiService.a(new SwitchLastCustomerAndViewDTO(cloudUserLoginByTokenRequest.getOmadacId(), cloudUserLoginByTokenRequest.getCustomerId(), String.valueOf(((Map)handleRes.getResult()).get(SESSION_ID)), Integer.valueOf(((CheckLoginByOmadaCloudResponseDTO)optRes.getResult()).getUserLevel().getLevel())));
                if (!rsp.success()) {
                    log.warn("update user's last customer and view failed. customerId: {}.", (Object)omadacId);
                }
            }
            ((Map)handleRes.getResult()).remove(SESSION_ID);
        }
        return handleRes;
    }

    private String resolveCloudToken(String token) {
        String rawToken;
        String decryptTokenData;
        try {
            token = URLDecoder.decode(token, StandardCharsets.UTF_8.name()).replaceAll(" ", "+");
        }
        catch (UnsupportedEncodingException e2) {
            log.error("failed to URLDecoder token: {}", (Object)token, (Object)e2);
            return null;
        }
        try {
            decryptTokenData = b.i((String)token);
        }
        catch (Exception e3) {
            log.error("failed to decrypt token: {}, error: {}", (Object)token, (Object)e3);
            return null;
        }
        try {
            StringTokenizer st = new StringTokenizer(decryptTokenData, ",");
            rawToken = st.nextToken();
        }
        catch (NoSuchElementException e4) {
            log.warn("failed to split token: {}", (Object)token);
            return null;
        }
        return rawToken;
    }

    @PostMapping(value={"/{omadacId}/api/v2/sendResetEmail", "/{omadacId}/api/v2/app/sendResetEmail"})
    @ResponseBody
    public OperationResponse sendResetEmail(@RequestBody @Valid WebSendEmailByResetPwdRequestDTO sendResetPwdEmailRequest, @PathVariable(name="omadacId") String omadacId) {
        if (ad.a((String)sendResetPwdEmailRequest.toString())) {
            return OperationResponse.REQUEST_CONTAIN_XSS;
        }
        QueryUserDTO queryUserDTO = new QueryUserDTO();
        queryUserDTO.setOmadacId(omadacId, c.a.a);
        queryUserDTO.setEmail(sendResetPwdEmailRequest.getEmail(), c.a.a, true);
        queryUserDTO.setUserType(Integer.valueOf(UserTypeEnumDTO.LOCAL_USER.getValue()), c.a.a, true);
        OperationResponse findByEmailResOpt = this.identityAccessInternalApiService.b(queryUserDTO);
        if (!findByEmailResOpt.success() || CollectionUtils.isEmpty((Collection)((Collection)findByEmailResOpt.getResult()))) {
            log.warn("omadacId={},email={} has not been registered.", new Supplier[]{() -> omadacId, () -> com.tplink.smb.omada.common.util.e.a.c((String)sendResetPwdEmailRequest.getEmail())});
            return new OperationResponse(com.tplink.smb.omada.common.g.b.ce);
        }
        List userDTOList = (List)findByEmailResOpt.getResult();
        WebSendEmailByResetPwdResponseDTO sendResetPwdEmailResponse = new WebSendEmailByResetPwdResponseDTO();
        sendResetPwdEmailResponse.setMultiuser(userDTOList.size() > 1);
        SendEmailByResetPasswordRequestDTO generateResetPasswordUrlRequest = null;
        if (!T.a((String)sendResetPwdEmailRequest.getUserId())) {
            generateResetPasswordUrlRequest = SendEmailByResetPasswordRequestDTO.builder().omadacId(omadacId).userId(sendResetPwdEmailRequest.getUserId()).build();
        } else {
            if (sendResetPwdEmailResponse.getMultiuser().booleanValue()) {
                sendResetPwdEmailResponse.setUser(userDTOList.stream().map(SendEmailByResetPwdForUserInfo::buildByDTO).collect(Collectors.toList()));
                return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)sendResetPwdEmailResponse);
            }
            UserDTO user = (UserDTO)userDTOList.get(0);
            generateResetPasswordUrlRequest = SendEmailByResetPasswordRequestDTO.builder().omadacId(omadacId).userId(user.getId()).build();
        }
        OperationResponse response = this.identityAccessWebInternalApiService.a(generateResetPasswordUrlRequest);
        if (!response.success()) {
            return response;
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)sendResetPwdEmailResponse);
    }

    @PostMapping(value={"/api/v2/sendResetEmail"})
    @ResponseBody
    public OperationResponse sendResetEmailWithoutOmadacId(@RequestBody @Valid WebSendEmailByResetPwdRequestDTO sendResetPwdEmailRequest) {
        if (ad.a((String)sendResetPwdEmailRequest.toString())) {
            return OperationResponse.REQUEST_CONTAIN_XSS;
        }
        QueryTenantDTO queryTenantDTO = new QueryTenantDTO();
        queryTenantDTO.setEmail(sendResetPwdEmailRequest.getEmail(), c.a.a, true);
        queryTenantDTO.setUserType(Integer.valueOf(UserTypeEnumDTO.LOCAL_USER.getValue()), c.a.a, true);
        OperationResponse findByEmailResOpt = this.identityAccessInternalApiService.b(queryTenantDTO);
        if (!findByEmailResOpt.success() || CollectionUtils.isEmpty((Collection)((Collection)findByEmailResOpt.getResult()))) {
            log.warn("email={} has not been registered.", new Supplier[]{() -> com.tplink.smb.omada.common.util.e.a.c((String)sendResetPwdEmailRequest.getEmail())});
            return new OperationResponse(com.tplink.smb.omada.common.g.b.ce);
        }
        List tenantDTOList = (List)findByEmailResOpt.getResult();
        WebSendEmailByResetPwdResponseDTO sendResetPwdEmailResponse = new WebSendEmailByResetPwdResponseDTO();
        sendResetPwdEmailResponse.setMultiuser(tenantDTOList.size() > 1);
        OperationResponse omadacRes = this.omadacLocalInternalApiService.b();
        if (!omadacRes.success()) {
            return omadacRes;
        }
        String omadacId = ((OmadacVO)omadacRes.getResult()).getId();
        SendEmailByResetPasswordRequestDTO generateResetPasswordUrlRequest = null;
        if (!T.a((String)sendResetPwdEmailRequest.getUserId())) {
            generateResetPasswordUrlRequest = SendEmailByResetPasswordRequestDTO.builder().omadacId(omadacId).tenantId(sendResetPwdEmailRequest.getUserId()).build();
        } else {
            if (sendResetPwdEmailResponse.getMultiuser().booleanValue()) {
                sendResetPwdEmailResponse.setUser(tenantDTOList.stream().map(SendEmailByResetPwdForUserInfo::buildByTenantDTO).collect(Collectors.toList()));
                return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)sendResetPwdEmailResponse);
            }
            TenantDTO tenantDTO = (TenantDTO)tenantDTOList.get(0);
            generateResetPasswordUrlRequest = SendEmailByResetPasswordRequestDTO.builder().omadacId(omadacId).tenantId(tenantDTO.getTenantId()).build();
        }
        OperationResponse response = this.identityAccessWebInternalApiService.a(generateResetPasswordUrlRequest);
        if (!response.success()) {
            return response;
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)sendResetPwdEmailResponse);
    }

    @PostMapping(value={"/{omadacId}/api/v2/resetPassword", "/api/v2/resetPassword", "/{omadacId}/api/v2/app/resetPassword"})
    @ResponseBody
    public OperationResponse resetPassword(HttpServletRequest request, HttpServletResponse response, @RequestBody @Valid WebResetPasswordRequestDTO webResetPasswordRequest, @PathVariable(name="omadacId", required=false) String omadacId) {
        if (ad.a((String)webResetPasswordRequest.toString())) {
            return OperationResponse.REQUEST_CONTAIN_XSS;
        }
        if (!webResetPasswordRequest.validate()) {
            return OperationResponse.PARAM_ERROR;
        }
        if (!T.a((String)webResetPasswordRequest.getPassword()) && !com.tplink.smb.omada.common.util.f.b.h((String)webResetPasswordRequest.getPassword())) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.bY);
        }
        if (omadacId == null) {
            OperationResponse omadacRes = this.omadacLocalInternalApiService.b();
            if (!omadacRes.success()) {
                return omadacRes;
            }
            omadacId = ((OmadacVO)omadacRes.getResult()).getId();
        }
        UserIpUtils.setLocalUserIp((String)WebUtils.getRemoteAddress(request));
        ResetPasswordRequestDTO resetPasswordRequest = new ResetPasswordRequestDTO();
        resetPasswordRequest.setOmadacId(omadacId);
        resetPasswordRequest.setPassword(webResetPasswordRequest.getPassword());
        resetPasswordRequest.setUserId(webResetPasswordRequest.getUserId());
        resetPasswordRequest.setTenantId(webResetPasswordRequest.getTenantId());
        resetPasswordRequest.setEmail(webResetPasswordRequest.getEmail());
        resetPasswordRequest.setVerifyCode(webResetPasswordRequest.getVerifyCode());
        if (!resetPasswordRequest.validate()) {
            return OperationResponse.PARAM_ERROR;
        }
        OperationResponse operationResponse = this.identityAccessWebInternalApiService.a(resetPasswordRequest);
        this.sendAuditLogService.sendAuditLog(omadacId, null, AuditLogKeyEnumDTO.RESET_PASSWORD.name(), webResetPasswordRequest.getEmail(), operationResponse.success(), AuditLogResourceEnumDTO.WEB.getResourceCode(), webResetPasswordRequest.getEmail());
        return operationResponse;
    }

    @GetMapping(value={"/{omadacId}/api/v2/resetPassword", "/api/v2/resetPassword", "/{omadacId}/api/v2/app/resetPassword"})
    @ResponseBody
    public OperationResponse checkResetLink(@PathVariable(name="omadacId", required=false) String omadacId, @RequestParam(value="email") String email, @RequestParam(value="verifyCode") String verifyCode, @RequestParam(value="tenantId", required=false) String tenantId) {
        if (ad.a((String)email) || ad.a((String)verifyCode) || ad.a((String)tenantId)) {
            return OperationResponse.REQUEST_CONTAIN_XSS;
        }
        if (T.a((String)email) || T.a((String)verifyCode)) {
            return OperationResponse.PARAM_ERROR;
        }
        if (omadacId == null) {
            OperationResponse omadacRes = this.omadacLocalInternalApiService.b();
            if (!omadacRes.success()) {
                return omadacRes;
            }
            omadacId = ((OmadacVO)omadacRes.getResult()).getId();
        }
        ResetPasswordRequestDTO resetPasswordRequest = new ResetPasswordRequestDTO();
        resetPasswordRequest.setOmadacId(omadacId);
        resetPasswordRequest.setTenantId(tenantId);
        resetPasswordRequest.setEmail(email);
        resetPasswordRequest.setPassword("");
        resetPasswordRequest.setVerifyCode(verifyCode);
        OperationResponse response = this.identityAccessWebInternalApiService.b(resetPasswordRequest);
        return new OperationResponse(response.getErrorCode(), response.getMsg(), null);
    }

    @PostMapping(value={"/{omadacId}/api/v2/sendDisableMFAEmail", "/api/v2/sendDisableMFAEmail", "/{omadacId}/api/v2/app/sendDisableMFAEmail"})
    @ResponseBody
    public OperationResponse sendDisableMFAEmail(HttpServletRequest request, HttpServletResponse response, @RequestBody String body, @PathVariable(name="omadacId", required=false) String omadacId) {
        Map paramMap;
        RequestEntity<String> requestEntity = WebUtils.getStringRequestEntity(body, request);
        if (ad.a(requestEntity)) {
            return OperationResponse.REQUEST_CONTAIN_XSS;
        }
        if (omadacId == null) {
            OperationResponse omadacRes = this.omadacLocalInternalApiService.b();
            if (!omadacRes.success()) {
                return omadacRes;
            }
            omadacId = ((OmadacVO)omadacRes.getResult()).getId();
        }
        try {
            paramMap = x.a((String)body);
        }
        catch (d e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            return OperationResponse.PARAM_ERROR;
        }
        String username = String.valueOf(paramMap.get("username"));
        String password = String.valueOf(paramMap.get("password"));
        if (!com.tplink.smb.omada.common.util.f.c.bU.matcher(username).matches()) {
            log.warn("Invalid user name pt or password, omadacId {}.", (Object)omadacId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.cc);
        }
        return this.identityAccessWebInternalApiService.a(((DisableMFARequestDTO.DisableMFARequestDTOBuilder)((DisableMFARequestDTO.DisableMFARequestDTOBuilder)((DisableMFARequestDTO.DisableMFARequestDTOBuilder)DisableMFARequestDTO.builder().omadacId(omadacId)).username(username)).password(password)).build());
    }

    @PostMapping(value={"/api/v2/disable-mfa"})
    @ResponseBody
    public OperationResponse disableMFA(HttpServletRequest request, HttpServletResponse response, @RequestBody String body) {
        Map paramMap;
        RequestEntity<String> requestEntity = WebUtils.getStringRequestEntity(body, request);
        if (ad.a(requestEntity)) {
            return OperationResponse.REQUEST_CONTAIN_XSS;
        }
        try {
            paramMap = x.a((String)body);
        }
        catch (d e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            return OperationResponse.PARAM_ERROR;
        }
        String tenantId = String.valueOf(paramMap.get("tenantId"));
        String token = String.valueOf(paramMap.get("code"));
        if (tenantId == null || token == null) {
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        return this.identityAccessWebInternalApiService.a(new DisableMfaLocalUserDTO(tenantId, token));
    }

    @GetMapping(value={"/{omadacId}/api/v2/loginStatus", "openapi/v1/{omadacId}/login-status"})
    @ResponseBody
    public OperationResponse getLoginStatus(HttpServletRequest request, HttpServletResponse response, @PathVariable(name="omadacId") String omadacId) {
        GetSessionRequestDTO getSessionRequest;
        OperationResponse sessionResp;
        OperationResponse<IamLoginResponseDTO> iamAccountInfo;
        Session session;
        RequestEntity<String> requestEntity = WebUtils.getStringRequestEntity(null, request);
        if (ad.a(requestEntity)) {
            return OperationResponse.REQUEST_CONTAIN_XSS;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("login", false);
        e controlType = e.a(requestEntity);
        if (controlType == null) {
            log.info("controlType is null. omadacId:{}.", (Object)omadacId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, result);
        }
        UserIpUtils.setLocalUserIp((String)WebUtils.getRemoteAddress(request));
        Subject curUser = SecurityUtils.getSubject();
        if (curUser.getPrincipal() == null) {
            log.info("user principal is null. omadacId:{}.", (Object)omadacId);
        }
        if ((session = curUser.getSession(false)) == null) {
            log.info("user session is null. omadacId:{}.", (Object)omadacId);
        }
        boolean needCheckFromIam = Boolean.TRUE.equals(Boolean.valueOf(request.getParameter("needToken")));
        String centralSessionId = this.getCentralSessionId(request);
        log.info("central sessionId:{}", (Object)centralSessionId);
        if (needCheckFromIam && this.isCentralSession(centralSessionId) && (iamAccountInfo = this.userOperationForIam.loginWithToken(centralSessionId)).success()) {
            if (session != null && centralSessionId.equals(String.valueOf(session.getId()))) {
                OperationResponse checkRes;
                if (Objects.equals(com.tplink.smb.omada.iam.api.a.b.c.b.b(), ((IamLoginResponseDTO)iamAccountInfo.getResult()).getLoginType()) && !(checkRes = this.checkMFA(omadacId, ((IamLoginResponseDTO)iamAccountInfo.getResult()).getAccountId(), ((IamLoginResponseDTO)iamAccountInfo.getResult()).getUsername(), result)).success()) {
                    log.warn("iam user {} check mfa failed, msg={}, omadacId={}", (Object)((IamLoginResponseDTO)iamAccountInfo.getResult()).getUserId(), (Object)checkRes.getMsg(), (Object)omadacId);
                    return new OperationResponse(com.tplink.smb.omada.common.g.b.a((int)checkRes.getErrorCode()), result);
                }
                OperationResponse verifyUserOps = this.identityAccessInternalApiService.b(new QueryUserWithSessionIdDTO(omadacId, centralSessionId));
                if (!verifyUserOps.success()) {
                    log.warn("verify current user failed. omadacId: {}. errorCode: {}.", (Object)omadacId, (Object)verifyUserOps.getErrorCode());
                    return verifyUserOps;
                }
                result.put("login", true);
                String csrfToken = (String)session.getAttribute((Object)"Csrf-Token");
                result.put("token", csrfToken);
                return new OperationResponse(com.tplink.smb.omada.common.g.b.a, result);
            }
            if (session != null && !centralSessionId.equals(String.valueOf(session.getId()))) {
                log.info("logout old session. omadacId:{}, sessionId:{}.", (Object)omadacId, (Object)session.getId());
                session.stop();
            }
            return this.loginByIam(request, response, curUser, omadacId, centralSessionId);
        }
        if (session != null && (sessionResp = this.identityAccessWebInternalApiService.b(getSessionRequest = GetSessionRequestDTO.builder().omadacId(omadacId).sessionId(String.valueOf(session.getId())).build())).success()) {
            if (((TenantDTO)sessionResp.getResult()).getAccountId() != null) {
                OperationResponse checkRes = this.checkMFA(omadacId, ((TenantDTO)sessionResp.getResult()).getAccountId(), ((TenantDTO)sessionResp.getResult()).getEmail(), result);
                if (!checkRes.success()) {
                    return new OperationResponse(com.tplink.smb.omada.common.g.b.a((int)checkRes.getErrorCode()), result);
                }
                String tenantId = ((TenantDTO)sessionResp.getResult()).getTenantId();
                OperationResponse verifyUserOps = this.identityAccessInternalApiService.a(new QueryUserWithTenantIdDTO(omadacId, tenantId));
                if (!verifyUserOps.success()) {
                    log.debug("getLoginStatus: Verify the user error.OmadacId:{}, errCode:{}", (Object)omadacId, (Object)verifyUserOps.getErrorCode());
                    return verifyUserOps;
                }
                if (!Boolean.TRUE.equals(verifyUserOps.getResult())) {
                    log.warn("getLoginStatus: The temporary user account already expires.OmadacId:{}, TenantId:{}", (Object)omadacId, (Object)tenantId);
                    return new OperationResponse(com.tplink.smb.omada.common.g.b.dL);
                }
            }
            result.put("login", true);
            String csrfToken = (String)session.getAttribute((Object)"Csrf-Token");
            result.put("token", csrfToken);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, result);
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, result);
    }

    private boolean isCentralSession(String sessionId) {
        if (sessionId == null) {
            return false;
        }
        return sessionId.contains("-");
    }

    private String getCentralSessionId(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        log.info("cookies:{}", (Object)x.a((Object)cookies));
        for (Cookie cookie : cookies) {
            if (!Objects.equals("TPEC_SID", cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    private OperationResponse loginByIam(HttpServletRequest request, HttpServletResponse response, Subject curUser, String omadacId, String centralSessionId) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("login", false);
        log.info("get user info from iam. central sessionId:{}", (Object)centralSessionId);
        OperationResponse<IamLoginResponseDTO> iamAccountInfo = this.userOperationForIam.loginWithToken(centralSessionId);
        if (!iamAccountInfo.success()) {
            log.info("get userInfo failed from iam. sessionId:{}.", (Object)centralSessionId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, result);
        }
        SessionUtils.setThreadSessionId((String)centralSessionId);
        IamLoginResponseDTO iamAccountInfoDTO = (IamLoginResponseDTO)iamAccountInfo.getResult();
        QueryCloudUserDTO queryUserDTO = new QueryCloudUserDTO();
        queryUserDTO.setOmadacId(omadacId);
        queryUserDTO.setAccountId(iamAccountInfoDTO.getAccountId());
        if (Objects.equals(iamAccountInfoDTO.getLoginType(), com.tplink.smb.omada.iam.api.a.b.c.c.b())) {
            log.debug("loginByIam sso omadacId:{} result={}.", (Object)omadacId, (Object)iamAccountInfoDTO);
            OperationResponse operationResponse = this.ssoLoginToController(request, curUser, omadacId, iamAccountInfoDTO, result);
            if (!operationResponse.success()) {
                log.warn("sso login failed. omadacId: {}, errorCode: {}.", (Object)omadacId, (Object)operationResponse.getErrorCode());
                return operationResponse;
            }
            result.put("login", true);
        } else {
            OperationResponse userDtoOpt = this.identityAccessInternalApiService.b(queryUserDTO);
            log.debug("loginByIam userDtoOpt: {}.", (Object)userDtoOpt);
            if (!userDtoOpt.success() || userDtoOpt.getResult() == null) {
                log.error("not find user. omadacId:{}, accountId:{}.", (Object)omadacId, (Object)iamAccountInfoDTO.getAccountId());
                return new OperationResponse(com.tplink.smb.omada.common.g.b.a, result);
            }
            OperationResponse checkRes = this.checkMFA(omadacId, iamAccountInfoDTO.getAccountId(), iamAccountInfoDTO.getUsername(), result);
            if (!checkRes.success()) {
                return new OperationResponse(com.tplink.smb.omada.common.g.b.a((int)checkRes.getErrorCode()), result);
            }
            String tenantId = ((UserDTO)userDtoOpt.getResult()).getTenantId();
            OperationResponse verifyUserOps = this.identityAccessInternalApiService.a(new QueryUserWithTenantIdDTO(omadacId, tenantId));
            if (!verifyUserOps.success()) {
                log.debug("verify the user error.omadacId:{}, errCode:{}", (Object)omadacId, (Object)verifyUserOps.getErrorCode());
                return verifyUserOps;
            }
            if (!Boolean.TRUE.equals(verifyUserOps.getResult())) {
                log.warn("The temporary user account already expires.OmadacId:{},TenantId:{}", (Object)omadacId, (Object)tenantId);
                return new OperationResponse(com.tplink.smb.omada.common.g.b.dL);
            }
            CloudUserToken cloudUserToken = new CloudUserToken(iamAccountInfoDTO.getUsername(), iamAccountInfoDTO.getAccountId());
            try {
                curUser.login((AuthenticationToken)cloudUserToken);
            }
            catch (Exception e2) {
                Supplier[] supplierArray = new Supplier[3];
                supplierArray[0] = () -> omadacId;
                supplierArray[1] = () -> com.tplink.smb.omada.common.util.e.a.c((String)iamAccountInfoDTO.getUsername());
                supplierArray[2] = e2::getMessage;
                log.info("cloud user login failed. omadacId:{}, email:{}, msg:{}.", supplierArray);
                return new OperationResponse(com.tplink.smb.omada.common.g.b.a, result);
            }
            log.info("login by iam success. omadacId:{}.", (Object)omadacId);
            Session session = curUser.getSession();
            if (session.getAttribute((Object)"Csrf-Token") == null) {
                log.info("session not contains CSRF token, set token:{}", (Object)iamAccountInfoDTO.getCsrfToken());
                session.setAttribute((Object)"Csrf-Token", (Object)iamAccountInfoDTO.getCsrfToken());
            }
            String csrfToken = (String)session.getAttribute((Object)"Csrf-Token");
            result.put("token", csrfToken);
            SaveSessionDTO saveCloudSession = new SaveSessionDTO();
            saveCloudSession.setOmadacId(omadacId);
            saveCloudSession.setSessionId(centralSessionId);
            saveCloudSession.setTenantId(((UserDTO)userDtoOpt.getResult()).getTenantId());
            saveCloudSession.setIdleTimeout(iamAccountInfoDTO.getLoginTtlMs() == null ? null : Long.valueOf(iamAccountInfoDTO.getLoginTtlMs() / 1000L));
            this.identityAccessWebInternalApiService.a(saveCloudSession);
            result.put("login", true);
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, result);
    }

    private OperationResponse checkMFA(String omadacId, String accountId, String email, Map<String, Object> result) {
        if (accountId == null) {
            log.info("accountId ins null, omadacId={}", (Object)omadacId);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.d);
        }
        OperationResponse optRes = this.identityAccessWebInternalApiService.a(accountId);
        log.info("omadacId={} getMFAFeatureStatus by TP CLOUD response:{}", (Object)omadacId, (Object)optRes.toString());
        if (!optRes.success() || optRes.getResult() == null) {
            return optRes;
        }
        OperationResponse omadacRes = this.omadacInternalApiService.a(OmadaRequestDTO.builder().omadacId(omadacId).build());
        if (!omadacRes.success() || omadacRes.getResult() == null) {
            log.error("omadacId={} not found", (Object)omadacId);
            return omadacRes;
        }
        if (Boolean.TRUE.equals(((OmadacDTO)omadacRes.getResult()).getEnableMFA()) && Boolean.FALSE.equals(((GetMFAStatusDTO)optRes.getResult()).getMfaFeatureEnabled())) {
            OperationResponse domainRes = this.managerOmadaInternalService.a(QueryUserCloudDomainDTO.builder().email(email).build());
            if (!domainRes.success()) {
                log.warn("Fail to find omada cloud domain, omadacId={}", (Object)omadacId);
            } else {
                result.put("url", domainRes.getResult());
            }
            return new OperationResponse(com.tplink.smb.omada.common.g.b.dv, result);
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, result);
    }

    private OperationResponse ssoLoginToController(HttpServletRequest request, Subject curUser, String omadacId, IamLoginResponseDTO iamAccountInfo, Map<String, Object> result) {
        String username = iamAccountInfo.getUsername();
        OperationResponse response = this.identityAccessWebInternalApiService.a(new GetExternalUserDTO(omadacId, username));
        if (!response.success() || response.getResult() == null) {
            log.warn("ssoLoginToController omadacId:{} result null.", (Object)omadacId);
            return OperationResponse.PARAM_ERROR;
        }
        GetExternalUserResDTO externalUser = (GetExternalUserResDTO)response.getResult();
        log.debug("ssoLoginToController omadacId:{} result={}.", (Object)omadacId, (Object)externalUser);
        String userGroupName = externalUser.getUserGroupName();
        UserIpUtils.setLocalUserIp((String)WebUtils.getRemoteAddress(request));
        OperationResponse verifyGroupOps = this.identityAccessInternalApiService.a(new QueryUserWithGroupNameDTO(omadacId, userGroupName));
        if (!verifyGroupOps.success() || verifyGroupOps.getResult() == null || Boolean.FALSE.equals(verifyGroupOps.getResult())) {
            log.warn("The temporary user group already expires.OmadacId:{},GroupName:{}", (Object)omadacId, (Object)userGroupName);
            this.addLogService.addLoginLog(omadacId, username, WebUtils.getRemoteAddress(request), false, AuditLogResourceEnumDTO.WEB.getResourceCode());
            return new OperationResponse(com.tplink.smb.omada.common.g.b.dL);
        }
        SsoToken ssoToken = new SsoToken(omadacId, username, userGroupName);
        String sessionId = SessionUtils.getSessionId();
        log.debug("ssoLoginToController omadacId:{} getSessionId={}.", (Object)omadacId, (Object)sessionId);
        DeleteSessionByIdRequestDTO deleteSessionByIdRequest = DeleteSessionByIdRequestDTO.builder().omadacId(omadacId).sessionId(sessionId).build();
        this.identityAccessWebInternalApiService.a(deleteSessionByIdRequest);
        try {
            log.debug("sso login, controllerId: {}, name: {}, sessionId: {}", (Object)omadacId, (Object)username, (Object)sessionId);
            curUser.login((AuthenticationToken)ssoToken);
        }
        catch (Exception e2) {
            log.warn("sso failed to login", (Throwable)e2);
            this.sendAuditLogService.sendMspOrGlobalAuditLog(omadacId, AuditLogKeyEnumDTO.EXTERNAL_USERS_LOGIN, AuditLogKeyEnumDTO.MSP_EXTERNAL_USERS_LOGIN, username, false, AuditLogResourceEnumDTO.WEB.getResourceCode(), username);
            return OperationResponse.PARAM_ERROR;
        }
        Session session = curUser.getSession();
        if (session.getAttribute((Object)"Csrf-Token") == null) {
            session.setAttribute((Object)"Csrf-Token", (Object)iamAccountInfo.getCsrfToken());
        }
        UserDTO userDTO = UserDTO.builder().id(externalUser.getUserId()).omadacId(omadacId).name(username).build();
        SaveSsoSessionDTO saveSsoSession = new SaveSsoSessionDTO(omadacId, sessionId, userDTO);
        this.identityAccessWebInternalApiService.a(saveSsoSession);
        session.setAttribute((Object)"omadacId", (Object)omadacId);
        this.loginCache.remove(username);
        String csrfToken = (String)session.getAttribute((Object)"Csrf-Token");
        result.put("token", csrfToken);
        this.sendAuditLogService.sendMspOrGlobalAuditLog(omadacId, AuditLogKeyEnumDTO.EXTERNAL_USERS_LOGIN, AuditLogKeyEnumDTO.MSP_EXTERNAL_USERS_LOGIN, username, true, AuditLogResourceEnumDTO.WEB.getResourceCode(), username);
        return OperationResponse.SUCCESS;
    }

    @GetMapping(value={"/api/v2/loginStatus"})
    @ResponseBody
    public OperationResponse getLoginStatusWithoutOmadacId(HttpServletRequest request, HttpServletResponse response) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        RequestEntity<String> requestEntity = WebUtils.getStringRequestEntity(null, request);
        if (ad.a(requestEntity)) {
            return OperationResponse.REQUEST_CONTAIN_XSS;
        }
        e controlType = e.a(requestEntity);
        if (controlType == null) {
            result.put("login", false);
            return new OperationResponse(com.tplink.smb.omada.common.g.b.a, result);
        }
        Subject curUser = SecurityUtils.getSubject();
        if (curUser.getPrincipal() == null) {
            result.put("login", false);
        } else {
            result.put("login", false);
            Optional.ofNullable(curUser.getSession(false)).ifPresent(session -> {
                GetSessionRequestDTO getSessionRequest = GetSessionRequestDTO.builder().sessionId(String.valueOf(session.getId())).build();
                OperationResponse sessionRsp = this.identityAccessWebInternalApiService.b(getSessionRequest);
                if (sessionRsp.success()) {
                    String csrfToken = (String)session.getAttribute((Object)"Csrf-Token");
                    result.put("token", (Boolean)((Object)csrfToken));
                }
                result.put("login", sessionRsp.success());
            });
        }
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, result);
    }

    @GetMapping(value={"/{omadacId}/api/v2/hotspot/loginStatus"})
    @ResponseBody
    public OperationResponse getHotspotLoginStatus(HttpServletRequest request, @PathVariable(name="omadacId") String omadacId) {
        RequestEntity<String> requestEntity = WebUtils.getStringRequestEntity(null, request);
        if (ad.a(requestEntity)) {
            return OperationResponse.REQUEST_CONTAIN_XSS;
        }
        LoginStatusDTO loginStatusDTO = new LoginStatusDTO();
        loginStatusDTO.setOrgType(Integer.valueOf(OmadacType.b().getValue()));
        loginStatusDTO.setRegisteredRoot(Boolean.valueOf(true));
        GetOmadacBasicConfigDTO getOmadacBasicConfigDTO = new GetOmadacBasicConfigDTO();
        getOmadacBasicConfigDTO.setOmadacId(omadacId);
        OperationResponse omadacBasicConfigResp = this.managerOmadaInternalService.a(getOmadacBasicConfigDTO);
        if (!omadacBasicConfigResp.success()) {
            log.warn("can not find omadac in manager. omadacId:{}", (Object)omadacId);
            loginStatusDTO.setConfigured(Boolean.valueOf(false));
            return OperationResponse.success((Object)loginStatusDTO);
        }
        OmadacBasicConfigDTO omadacBasicConfigDTO = (OmadacBasicConfigDTO)omadacBasicConfigResp.getResult();
        loginStatusDTO.setConfigured(omadacBasicConfigDTO.getConfigured());
        loginStatusDTO.setOrgCategory(omadacBasicConfigDTO.getOrgCategory());
        if (!Boolean.TRUE.equals(loginStatusDTO.getConfigured())) {
            log.info("controller not init. omadacId:{}", (Object)omadacId);
            return OperationResponse.success((Object)loginStatusDTO);
        }
        loginStatusDTO.setLogin(Boolean.valueOf(false));
        e controlType = e.a(requestEntity);
        if (controlType == null) {
            log.warn("controller type is null. omadacId:{}", (Object)omadacId);
            return OperationResponse.success((Object)loginStatusDTO);
        }
        switch (controlType) {
            case a: 
            case c: {
                Subject curUser = SecurityUtils.getSubject();
                if (curUser.getPrincipal() == null) {
                    log.debug("get current hotspot user null");
                    break;
                }
                HotspotSessionRequestDTO hotspotSessionRequestDTO = HotspotSessionRequestDTO.builder().omadacId(omadacId).name(String.valueOf(curUser.getPrincipal())).sessionId(String.valueOf(curUser.getSession().getId())).build();
                OperationResponse optHotspotRes = this.identityHotspotInternalApiService.b(hotspotSessionRequestDTO);
                log.debug("hotspot is logged {}", (Object)optHotspotRes);
                loginStatusDTO.setLogin(Boolean.valueOf(Boolean.TRUE.equals(optHotspotRes.getResult())));
                break;
            }
            case b: 
            case d: {
                loginStatusDTO.setLogin(Boolean.valueOf(true));
                break;
            }
            default: {
                log.warn("Invalid controlType {}", (Object)controlType.b());
                loginStatusDTO.setLogin(Boolean.valueOf(false));
            }
        }
        if (Boolean.TRUE.equals(loginStatusDTO.getLogin())) {
            String csrfToken = Optional.ofNullable(request.getSession()).map(session -> (String)session.getAttribute("Csrf-Token")).orElse(null);
            loginStatusDTO.setCsrfToken(csrfToken);
        }
        Map result = x.c((Object)loginStatusDTO);
        result.put("token", loginStatusDTO.getCsrfToken());
        return new OperationResponse(com.tplink.smb.omada.common.g.b.a, (Object)result);
    }

    @PostMapping(value={"/{omadacId}/api/v2/logout"})
    @ResponseBody
    public OperationResponse logout(HttpServletRequest request, HttpServletResponse response, @PathVariable(name="omadacId") String omadacId) {
        return this.logoutCommon(request, response, omadacId);
    }

    private OperationResponse logoutCommon(HttpServletRequest request, HttpServletResponse response, String omadacId) {
        RequestEntity<String> requestEntity = WebUtils.getStringRequestEntity(null, request);
        if (ad.a(requestEntity)) {
            return OperationResponse.REQUEST_CONTAIN_XSS;
        }
        UserIpUtils.setLocalUserIp((String)WebUtils.getRemoteAddress(request));
        e controlType = e.a(requestEntity);
        if (controlType == null) {
            log.warn("controlType is null.");
            return new OperationResponse(com.tplink.smb.omada.common.g.b.e);
        }
        if (!controlType.equals((Object)e.c) && !controlType.equals((Object)e.a)) {
            log.warn("logout only support local control");
            return new OperationResponse(com.tplink.smb.omada.common.g.b.e);
        }
        AtomicReference operator = new AtomicReference();
        AtomicReference userType = new AtomicReference();
        AtomicReference userRealOmadacId = new AtomicReference();
        Subject curUser = SecurityUtils.getSubject();
        Optional.ofNullable(curUser.getSession(false)).ifPresent(session -> {
            String sessionId = String.valueOf(session.getId());
            OperationResponse curRes = this.identityAccessInternalApiService.a(GetCurrentInfoDTO.builder().omadacId(omadacId).sessionId(sessionId).build());
            if (curRes.success()) {
                operator.set(((UserDTO)curRes.getResult()).getName() != null ? ((UserDTO)curRes.getResult()).getName() : ((UserDTO)curRes.getResult()).getEmail());
                userType.set(((UserDTO)curRes.getResult()).getUserType());
                userRealOmadacId.set(((UserDTO)curRes.getResult()).getOmadacId());
            }
            curUser.logout();
            DeleteSessionByIdRequestDTO deleteSessionByIdRequest = DeleteSessionByIdRequestDTO.builder().sessionId(sessionId).build();
            this.identityAccessWebInternalApiService.a(deleteSessionByIdRequest);
            if (this.isCentralSession(sessionId)) {
                this.userOperationForIam.logout(sessionId);
            }
            StompSessionCache.removeAndCloseSessionByHttpSessionId(sessionId);
        });
        if (Objects.equals(UserTypeEnumDTO.EXTERNAL_USER.getValue(), userType.get())) {
            this.sendAuditLogService.sendMspOrGlobalAuditLog((String)userRealOmadacId.get(), AuditLogKeyEnumDTO.EXTERNAL_USERS_LOGOUT, AuditLogKeyEnumDTO.MSP_EXTERNAL_USERS_LOGOUT, (String)operator.get(), true, AuditLogResourceEnumDTO.WEB.getResourceCode(), (String)operator.get());
        } else {
            this.sendAuditLogService.sendMspOrGlobalAuditLog((String)userRealOmadacId.get(), AuditLogKeyEnumDTO.USERS_LOGOUT, AuditLogKeyEnumDTO.USERS_LOGOUT, (String)operator.get(), true, AuditLogResourceEnumDTO.WEB.getResourceCode(), (String)operator.get());
        }
        return OperationResponse.SUCCESS;
    }

    @PostMapping(value={"/api/v2/logout"})
    @ResponseBody
    public OperationResponse logoutWithoutOmadacId(HttpServletRequest request, HttpServletResponse response) {
        return this.logoutCommon(request, response, null);
    }

    @PostMapping(value={"/api/v2/msp/{mspId}/logout"})
    @ResponseBody
    public OperationResponse MSPlogout(HttpServletRequest request, HttpServletResponse response, @PathVariable(name="mspId") String mspId) {
        return this.logoutCommon(request, response, mspId);
    }

    @PostMapping(value={"/{omadacId}/api/v2/hotspot/logout"})
    @ResponseBody
    public OperationResponse hotspotLogout(HttpServletRequest request, HttpServletResponse response, @PathVariable(name="omadacId") String omadacId) {
        RequestEntity<String> requestEntity = WebUtils.getStringRequestEntity(null, request);
        if (ad.a(requestEntity)) {
            return OperationResponse.REQUEST_CONTAIN_XSS;
        }
        UserIpUtils.setLocalUserIp((String)WebUtils.getRemoteAddress(request));
        e controlType = e.a(requestEntity);
        if (controlType == null) {
            log.warn("controlType is null.");
            return new OperationResponse(com.tplink.smb.omada.common.g.b.e);
        }
        if (!controlType.equals((Object)e.c) && !controlType.equals((Object)e.a)) {
            log.warn("logout only support local control");
            return new OperationResponse(com.tplink.smb.omada.common.g.b.e);
        }
        AtomicReference operator = new AtomicReference();
        Subject curUser = SecurityUtils.getSubject();
        Optional.ofNullable(curUser.getSession(false)).ifPresent(session -> {
            String sessionId = String.valueOf(session.getId());
            OperationResponse curRes = this.identityAccessInternalApiService.a(GetCurrentInfoDTO.builder().omadacId(omadacId).sessionId(sessionId).build());
            if (curRes.success()) {
                operator.set(((UserDTO)curRes.getResult()).getName());
            }
            curUser.logout();
            this.identityHotspotInternalApiService.f(HotspotSessionRequestDTO.builder().omadacId(omadacId).sessionId(sessionId).build());
            StompSessionCache.removeAndCloseSessionByHttpSessionId(sessionId);
        });
        this.sendAuditLogService.sendAuditLog(omadacId, null, AuditLogKeyEnumDTO.HOTSPOT_LOGOUT.name(), (String)operator.get(), true, AuditLogResourceEnumDTO.WEB.getResourceCode(), (String)operator.get());
        return OperationResponse.SUCCESS;
    }

    @GetMapping(value={"/api/v2/current/login-status"})
    @ResponseBody
    public OperationResponse getLoginStatusForLocal(HttpServletRequest request, HttpServletResponse response) {
        try {
            e controlType;
            RequestEntity<String> requestEntity = WebUtils.getStringRequestEntity(null, request);
            if (ad.a(requestEntity)) {
                return OperationResponse.REQUEST_CONTAIN_XSS;
            }
            Subject curUser = SecurityUtils.getSubject();
            Session session = curUser.getSession(false);
            GetLoginStatusDTO getLoginStatusDTO = new GetLoginStatusDTO();
            getLoginStatusDTO.setOmadacSessionId(session == null ? null : String.valueOf(session.getId()));
            OperationResponse loginStatusResp = this.identityAccessInternalApiService.a(getLoginStatusDTO);
            if (!loginStatusResp.success()) {
                log.info("check login status failed\uff0c errorCode:{}.", (Object)loginStatusResp.getErrorCode());
                return loginStatusResp;
            }
            if (loginStatusResp.getResult() == null) {
                log.warn("login status is null.");
            }
            LoginStatusDTO loginStatusDTO = new LoginStatusDTO();
            loginStatusDTO.setLogin(Boolean.valueOf(false));
            loginStatusDTO.setOrgType(Integer.valueOf(OmadacType.b().getValue()));
            if (loginStatusResp.getResult() != null) {
                loginStatusDTO = (LoginStatusDTO)loginStatusResp.getResult();
            }
            if ((controlType = e.a(requestEntity)) == null) {
                log.info("controlType is null");
                loginStatusDTO.setLogin(Boolean.valueOf(false));
                return OperationResponse.success((Object)loginStatusDTO);
            }
            if (Boolean.TRUE.equals(loginStatusDTO.getLogin())) {
                String csrfToken = (String)session.getAttribute((Object)"Csrf-Token");
                loginStatusDTO.setCsrfToken(csrfToken);
                LoginStatusDTO finalLoginStatusDTO = loginStatusDTO;
                log.debug("user is login. {}", new Supplier[]{() -> com.tplink.smb.omada.common.util.e.a.a((Object)finalLoginStatusDTO)});
                return OperationResponse.success((Object)loginStatusDTO);
            }
            LoginStatusDTO finalLoginStatusDTO = loginStatusDTO;
            log.debug("user is login. {}", new Supplier[]{() -> com.tplink.smb.omada.common.util.e.a.a((Object)finalLoginStatusDTO)});
            return OperationResponse.success((Object)loginStatusDTO);
        }
        catch (Exception e2) {
            if (a.d() && a.u()) {
                log.warn("mongodb has crashed and cannot read or write from the node");
                return new OperationResponse(com.tplink.smb.omada.common.g.b.Rj);
            }
            log.error("login-status interface call encountered an exception:", (Throwable)e2);
            return OperationResponse.GENERAL_ERROR;
        }
    }

    @GetMapping(value={"/{omadacId}/api/v2/current/login-status"})
    @ResponseBody
    public OperationResponse getLoginStatusForCbc(HttpServletRequest request, HttpServletResponse response, @PathVariable(name="omadacId") String omadacId) {
        e controlType;
        RequestEntity<String> requestEntity = WebUtils.getStringRequestEntity(null, request);
        if (ad.a(requestEntity)) {
            return OperationResponse.REQUEST_CONTAIN_XSS;
        }
        Subject curUser = SecurityUtils.getSubject();
        Session session = curUser.getSession(false);
        String omadaSessionId = session == null ? null : String.valueOf(session.getId());
        String centralSessionId = this.getCentralSessionId(request);
        UserIpUtils.setLocalUserIp((String)WebUtils.getRemoteAddress(request));
        GetLoginStatusDTO getLoginStatusDTO = new GetLoginStatusDTO();
        getLoginStatusDTO.setOmadacId(omadacId);
        getLoginStatusDTO.setOmadacSessionId(omadaSessionId);
        getLoginStatusDTO.setCentralSessionId(centralSessionId);
        getLoginStatusDTO.setUserIp(WebUtils.getRemoteAddress(request));
        OperationResponse loginStatusResp = this.identityAccessInternalApiService.b(getLoginStatusDTO);
        if (!loginStatusResp.success()) {
            log.info("check login status failed. errorCode:{}, omadacId: {}", (Object)loginStatusResp.getErrorCode(), (Object)omadacId);
            return loginStatusResp;
        }
        if (loginStatusResp.getResult() == null) {
            log.warn("login status is null. omadacId: {}", (Object)omadacId);
        }
        LoginStatusDTO loginStatusDTO = new LoginStatusDTO();
        loginStatusDTO.setLogin(Boolean.valueOf(false));
        loginStatusDTO.setOrgType(Integer.valueOf(OmadacType.b().getValue()));
        if (loginStatusResp.getResult() != null) {
            loginStatusDTO = (LoginStatusDTO)loginStatusResp.getResult();
        }
        if ((controlType = e.a(requestEntity)) == null) {
            log.info("controlType is null. omadacId:{}.", (Object)omadacId);
            loginStatusDTO.setLogin(Boolean.valueOf(false));
            return OperationResponse.success((Object)loginStatusDTO);
        }
        if (!Boolean.TRUE.equals(loginStatusDTO.getLogin())) {
            log.info("user not login. omadacId:{}, omadaSession:{}, centrallSession:{}", (Object)omadacId, (Object)omadaSessionId, (Object)centralSessionId);
            return OperationResponse.success((Object)loginStatusDTO);
        }
        if (session != null && Boolean.TRUE.equals(loginStatusDTO.getOmadaSessionInvalid())) {
            log.info("logout invalid omada session. omadacId:{}, sessionId:{}", (Object)omadacId, (Object)session.getId());
            session.stop();
        }
        if (Boolean.TRUE.equals(loginStatusDTO.getNeedShiroLogin())) {
            SessionUtils.setThreadSessionId((String)centralSessionId);
            CloudUserToken cloudUserToken = new CloudUserToken(loginStatusDTO.getUserName(), loginStatusDTO.getUserName());
            try {
                curUser.login((AuthenticationToken)cloudUserToken);
            }
            catch (Exception e2) {
                LoginStatusDTO finalLoginStatusDTO = loginStatusDTO;
                Supplier[] supplierArray = new Supplier[3];
                supplierArray[0] = () -> omadacId;
                supplierArray[1] = () -> com.tplink.smb.omada.common.util.e.a.c((String)finalLoginStatusDTO.getUserName());
                supplierArray[2] = e2::getMessage;
                log.info("user login failed. omadacId:{}, name:{}, msg:{}.", supplierArray);
                loginStatusDTO.setLogin(Boolean.valueOf(false));
                return OperationResponse.success((Object)loginStatusDTO);
            }
            session = curUser.getSession();
            if (session.getAttribute((Object)"Csrf-Token") == null) {
                log.info("session not contains CSRF token, set token:{}", (Object)loginStatusDTO.getCsrfToken());
                session.setAttribute((Object)"Csrf-Token", (Object)loginStatusDTO.getCsrfToken());
            }
            if (loginStatusDTO.getSessionTimeout() != null) {
                session.setTimeout(loginStatusDTO.getSessionTimeout() * 1000L);
            }
        }
        if (Boolean.TRUE.equals(loginStatusDTO.getLogin()) && T.c((String)loginStatusDTO.getCsrfToken())) {
            loginStatusDTO.setCsrfToken((String)session.getAttribute((Object)"Csrf-Token"));
        }
        LoginStatusDTO finalLoginStatusDTO1 = loginStatusDTO;
        log.debug("get login status. omadacId:{}, result:{}", new Supplier[]{() -> omadacId, () -> com.tplink.smb.omada.common.util.e.a.a((Object)finalLoginStatusDTO1)});
        return OperationResponse.success((Object)loginStatusDTO);
    }

    @PostMapping(value={"/api/v2/account/mfa/email/code", "/{omadacId}/api/v2/account/mfa/email/code"})
    @ResponseBody
    public OperationResponse sendMfaCode(HttpServletRequest request, HttpServletResponse response, @RequestBody String body, @PathVariable(name="omadacId", required=false) String omadacId) {
        Map paramMap;
        RequestEntity<String> requestEntity = WebUtils.getStringRequestEntity(body, request);
        if (ad.a(requestEntity)) {
            return OperationResponse.REQUEST_CONTAIN_XSS;
        }
        try {
            paramMap = x.a((String)body);
        }
        catch (d e2) {
            log.error(e2.getMessage(), (Throwable)e2);
            return OperationResponse.PARAM_ERROR;
        }
        String username = String.valueOf(paramMap.get("username"));
        String password = String.valueOf(paramMap.get("password"));
        UserIpUtils.setLocalUserIp((String)WebUtils.getRemoteAddress(request));
        OperationResponse optRes = this.identityAccessWebInternalApiService.a(new com.tplink.smb.omada.identityaccess.api.internal.dto.omadacloud.b().a(omadacId).b(username).c(password));
        log.info("omadacId={} send email mfa code response:{}", (Object)omadacId, (Object)optRes);
        if (!optRes.success()) {
            log.error("Send email mfa code failed, response {}", (Object)optRes);
            return optRes;
        }
        return OperationResponse.SUCCESS;
    }
}

