/*
 * Decompiled with CFR 0.152.
 */
package com.tplink.smb.omada.apigateway.dispatch;

import com.tplink.smb.omada.apigateway.dispatch.interceptor.RateLimiterHandler;
import com.tplink.smb.omada.apigateway.dispatch.util.WebUtils;
import com.tplink.smb.omada.common.g.b;
import com.tplink.smb.omada.common.omadac.OmadacType;
import com.tplink.smb.omada.common.util.T;
import com.tplink.smb.omada.dispatcher.RestDispatcher;
import com.tplink.smb.omada.dispatcher.chain.AttributeRequestEntity;
import com.tplink.smb.omada.dispatcher.common.access.OperationResponse;
import com.tplink.smb.omada.dispatcher.common.response.ApiResponseWrapper;
import com.tplink.smb.omada.dispatcher.common.util.UserIpUtils;
import com.tplink.smb.omada.dispatcher.response.ApiHttpServletResponseWrapper;
import com.tplink.smb.omada.identityaccess.api.internal.a.c;
import com.tplink.smb.omada.identityaccess.api.internal.dto.OmadacVO;
import io.swagger.v3.oas.annotations.Hidden;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.RequestEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@Hidden
public class ApiController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ApiController.class);
    @Autowired
    private RestDispatcher restDispatcher;
    @Autowired
    private RateLimiterHandler rateLimiterHandler;
    @Autowired
    private c omadacLocalInternalApiService;

    @GetMapping(value={"/api/info"})
    public Object apiInfoHandler(HttpServletRequest request, HttpServletResponse response) {
        if (OmadacType.s()) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            return null;
        }
        com.tplink.smb.omada.common.access.OperationResponse omadacRes = this.omadacLocalInternalApiService.b();
        if (!omadacRes.success() || omadacRes.getResult() == null) {
            return null;
        }
        String omadacId = ((OmadacVO)omadacRes.getResult()).getId();
        if (T.a((String)omadacId)) {
            log.error("Failed to find Local OmadacId!");
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            return null;
        }
        return this.doHandleApiInfo(request, response, omadacId);
    }

    @RequestMapping(path={"/api/v2/**"}, method={RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.PATCH, RequestMethod.DELETE})
    public Object apiAnonHandler(@RequestBody(required=false) String body, HttpServletRequest request, HttpServletResponse response) {
        if (OmadacType.s()) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            return null;
        }
        com.tplink.smb.omada.common.access.OperationResponse omadacRes = this.omadacLocalInternalApiService.b();
        if (!omadacRes.success() || omadacRes.getResult() == null) {
            return null;
        }
        String omadacId = ((OmadacVO)omadacRes.getResult()).getId();
        if (T.a((String)omadacId)) {
            log.error("Failed to find Local OmadacId!");
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            return null;
        }
        return this.doApiHandler(body, request, response, omadacId);
    }

    @GetMapping(value={"/{omadacId}/api/info"})
    public Object apiInfoHandlerWithOmadacId(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="omadacId") String omadacId) {
        return this.doHandleApiInfo(request, response, omadacId);
    }

    @GetMapping(value={"/api/msp/{mspId}/info"})
    public Object apiInfoHandlerWithMspId(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="mspId") String mspId) {
        return this.doHandleApiInfo(request, response, mspId);
    }

    @RequestMapping(path={"/{omadacId}/api/**"}, method={RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.PATCH, RequestMethod.DELETE})
    public Object apiHandler(@RequestBody(required=false) String body, HttpServletRequest request, HttpServletResponse response, @PathVariable(name="omadacId") String omadacId) {
        return this.doApiHandler(body, request, response, omadacId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doApiHandler(String body, HttpServletRequest request, HttpServletResponse response, String omadacId) {
        try {
            UserIpUtils.setLocalUserIp((String)WebUtils.getRemoteAddress(request));
            if (!this.rateLimiterHandler.preHandle(request, omadacId)) {
                OperationResponse operationResponse = new OperationResponse(b.aB.b(), "");
                return operationResponse;
            }
            AttributeRequestEntity<String> requestEntity = WebUtils.getStringAttributeRequestEntity(body, request);
            request.setAttribute("OMADA_REST_DISPATCHER_ATTRIBUTES", (Object)requestEntity.getAttributes());
            Object result = this.restDispatcher.dispatch(requestEntity, WebUtils.getSessionId(request), omadacId, null, (ApiResponseWrapper)new ApiHttpServletResponseWrapper(response));
            Object object = this.tryEraseFileDownloadResponse(request, response, result);
            return object;
        }
        finally {
            UserIpUtils.setLocalUserIp(null);
        }
    }

    @RequestMapping(path={"/api/v2/msp/{mspId}/**"}, method={RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.PATCH, RequestMethod.DELETE})
    public Object mspApiHandler(@RequestBody(required=false) String body, HttpServletRequest request, HttpServletResponse response, @PathVariable(name="mspId") String mspId) {
        return this.doApiHandler(body, request, response, mspId);
    }

    @RequestMapping(path={"/api/v2/app/msp/{mspId}/**"}, method={RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.PATCH, RequestMethod.DELETE})
    public Object mspAppApiHandler(@RequestBody(required=false) String body, HttpServletRequest request, HttpServletResponse response, @PathVariable(name="mspId") String mspId) {
        return this.doApiHandler(body, request, response, mspId);
    }

    @PostMapping(value={"/{omadacId}/api/v2/files/**", "/{omadacId}/api/v2/app/files/**"}, consumes={"multipart/form-data"})
    public Object uploadFileHandler(@RequestParam(value="data", required=false) String data, HttpServletRequest request, HttpServletResponse response, @PathVariable(name="omadacId") String omadacId) {
        return this.uploadFile(data, request, response, omadacId);
    }

    @PostMapping(value={"/{omadacId}/api/v2/anon/files/**"}, consumes={"multipart/form-data"})
    public Object anonUploadFileHandler(@RequestParam(value="data", required=false) String data, HttpServletRequest request, HttpServletResponse response, @PathVariable(name="omadacId") String omadacId) {
        return this.uploadFile(data, request, response, omadacId);
    }

    @PostMapping(value={"/api/v2/anon/files/**"}, consumes={"multipart/form-data"})
    public Object anonUploadFileHandler(@RequestParam(value="data", required=false) String data, HttpServletRequest request, HttpServletResponse response) {
        if (OmadacType.s()) {
            response.setStatus(HttpStatus.NOT_FOUND.value());
            return null;
        }
        com.tplink.smb.omada.common.access.OperationResponse omadacRes = this.omadacLocalInternalApiService.b();
        if (!omadacRes.success() || omadacRes.getResult() == null) {
            return null;
        }
        String omadacId = ((OmadacVO)omadacRes.getResult()).getId();
        if (T.a((String)omadacId)) {
            log.error("Failed to find Local OmadacId!");
            response.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
            return null;
        }
        return this.uploadFile(data, request, response, omadacId);
    }

    @GetMapping(value={"/{omadacId}/api/v2/anon/files/**"})
    public Object downloadFileHandlerAnon(HttpServletRequest request, HttpServletResponse response, @PathVariable(name="omadacId") String omadacId) {
        return this.downloadFileHandler(request, response, omadacId);
    }

    private Object uploadFile(String data, HttpServletRequest request, HttpServletResponse response, String omadacId) {
        return this.doUploadHandler(data, request, response, omadacId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doUploadHandler(String data, HttpServletRequest request, HttpServletResponse response, String omadacId) {
        try {
            UserIpUtils.setLocalUserIp((String)WebUtils.getRemoteAddress(request));
            if (!this.rateLimiterHandler.preHandle(request, omadacId)) {
                OperationResponse operationResponse = new OperationResponse(b.aB.b(), "");
                return operationResponse;
            }
            Map multipartFileMap = null;
            if (request instanceof MultipartHttpServletRequest) {
                multipartFileMap = ((MultipartHttpServletRequest)request).getFileMap();
            }
            AttributeRequestEntity<String> requestEntity = WebUtils.getStringAttributeRequestEntity(data, request);
            request.setAttribute("OMADA_REST_DISPATCHER_ATTRIBUTES", (Object)requestEntity.getAttributes());
            Object result = this.restDispatcher.dispatch(requestEntity, WebUtils.getSessionId(request), omadacId, multipartFileMap, (ApiResponseWrapper)new ApiHttpServletResponseWrapper(response));
            Object object = this.tryEraseFileDownloadResponse(request, response, result);
            return object;
        }
        finally {
            UserIpUtils.setLocalUserIp(null);
        }
    }

    @PostMapping(value={"/api/v2/msp/{mspId}/files/**"}, consumes={"multipart/form-data"})
    public Object mspUploadFileHandler(@RequestParam(value="data", required=false) String data, HttpServletRequest request, HttpServletResponse response, @PathVariable(name="mspId") String mspId) {
        return this.doUploadHandler(data, request, response, mspId);
    }

    @GetMapping(value={"/{omadacId}/api/v2/files/**", "/{omadacId}/api/v2/app/files/**"})
    public Object downloadFileHandler(HttpServletRequest request, HttpServletResponse response, @PathVariable(name="omadacId") String omadacId) {
        return this.doDownloadHandler(request, response, omadacId);
    }

    @GetMapping(value={"/api/v2/msp/{mspId}/files/**"})
    public Object mspDownloadFileHandler(HttpServletRequest request, HttpServletResponse response, @PathVariable(name="mspId") String mspId) {
        return this.doDownloadHandler(request, response, mspId);
    }

    @GetMapping(value={"/api/v2/msp/{mspId}/anon/files/**"})
    public Object mspDownloadFileHandlerAnon(HttpServletRequest request, HttpServletResponse response, @PathVariable(name="mspId") String mspId) {
        return this.doDownloadHandler(request, response, mspId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doDownloadHandler(HttpServletRequest request, HttpServletResponse response, String omadacId) {
        try {
            UserIpUtils.setLocalUserIp((String)WebUtils.getRemoteAddress(request));
            if (!this.rateLimiterHandler.preHandle(request, omadacId)) {
                OperationResponse operationResponse = new OperationResponse(b.aB.b(), "");
                return operationResponse;
            }
            AttributeRequestEntity<String> requestEntity = WebUtils.getStringAttributeRequestEntity(null, request);
            request.setAttribute("OMADA_REST_DISPATCHER_ATTRIBUTES", (Object)requestEntity.getAttributes());
            Object result = this.restDispatcher.dispatch(requestEntity, WebUtils.getSessionId(request), omadacId, null, (ApiResponseWrapper)new ApiHttpServletResponseWrapper(response));
            if (result instanceof OperationResponse) {
                Object object = ((OperationResponse)result).success() ? null : result;
                return object;
            }
            if (result instanceof DeferredResult) {
                DeferredResult fileDownloadResult = new DeferredResult();
                ((DeferredResult)result).setResultHandler(res -> {
                    if (!(res instanceof OperationResponse)) {
                        fileDownloadResult.setResult((Object)OperationResponse.GENERAL_ERROR);
                        log.error("Failed to handle Download file request: {}, unknown async result type: {}", (Object)request.getServletPath(), res.getClass());
                        return;
                    }
                    if (((OperationResponse)res).success()) {
                        fileDownloadResult.setResult(null);
                    } else {
                        fileDownloadResult.setResult((Object)((OperationResponse)res));
                    }
                });
                DeferredResult deferredResult = fileDownloadResult;
                return deferredResult;
            }
            log.error("Failed to handle Download file request: {}, unknown result type {}", (Object)request.getServletPath(), result.getClass());
            OperationResponse operationResponse = OperationResponse.GENERAL_ERROR;
            return operationResponse;
        }
        finally {
            UserIpUtils.setLocalUserIp(null);
        }
    }

    @PostMapping(value={"/{omadacId}/api/v2/filesWithData/**"})
    public Object downloadFileWithDataHandler(@RequestBody(required=false) String body, HttpServletRequest request, HttpServletResponse response, @PathVariable(name="omadacId") String omadacId) {
        return this.doDownloadWithDataHandler(body, request, response, omadacId);
    }

    @PostMapping(value={"/api/v2/msp/{mspId}/filesWithData/**"})
    public Object mspDownloadFileWithDataHandler(@RequestBody(required=false) String body, HttpServletRequest request, HttpServletResponse response, @PathVariable(name="mspId") String mspId) {
        return this.doDownloadWithDataHandler(body, request, response, mspId);
    }

    @PostMapping(value={"/{omadacId}/api/v2/global/files/**"}, consumes={"multipart/form-data"})
    public Object globalUploadFileHandler(@RequestParam(value="data", required=false) String data, HttpServletRequest request, HttpServletResponse response, @PathVariable(name="omadacId") String centralId) {
        return this.uploadFile(data, request, response, centralId);
    }

    @PostMapping(value={"/api/v2/msp/{mspId}/global/files/**"}, consumes={"multipart/form-data"})
    public Object globalUploadFileHandlerMsp(@RequestParam(value="data", required=false) String data, HttpServletRequest request, HttpServletResponse response, @PathVariable(name="mspId") String centralId) {
        return this.uploadFile(data, request, response, centralId);
    }

    @GetMapping(value={"/{omadacId}/api/v2/global/files/**", "/{omadacId}/api/v2/anon/global/files/**"})
    public Object globalDownloadFileHandler(HttpServletRequest request, HttpServletResponse response, @PathVariable(name="omadacId") String centralId) {
        return this.doDownloadHandler(request, response, centralId);
    }

    @GetMapping(value={"/api/v2/msp/{mspId}/global/files/**", "/api/v2/msp/{mspId}/anon/global/files/**"})
    public Object globalDownloadFileHandlerMsp(HttpServletRequest request, HttpServletResponse response, @PathVariable(name="mspId") String centralId) {
        return this.doDownloadHandler(request, response, centralId);
    }

    @PostMapping(value={"/{omadacId}/api/v2/global/filesWithData/**"})
    public Object globalDownloadFileWithDataHandler(@RequestBody(required=false) String body, HttpServletRequest request, HttpServletResponse response, @PathVariable(name="omadacId") String centralId) {
        return this.doDownloadWithDataHandler(body, request, response, centralId);
    }

    @PostMapping(value={"/api/v2/msp/{mspId}/global/filesWithData/**"})
    public Object globalDownloadFileWithDataHandlerMsp(@RequestBody(required=false) String body, HttpServletRequest request, HttpServletResponse response, @PathVariable(name="mspId") String centralId) {
        return this.doDownloadWithDataHandler(body, request, response, centralId);
    }

    @RequestMapping(path={"/{omadacId}/api/v2/global/**"}, method={RequestMethod.GET, RequestMethod.POST, RequestMethod.PUT, RequestMethod.PATCH, RequestMethod.DELETE})
    public Object globalApiHandler(@RequestBody(required=false) String body, HttpServletRequest request, HttpServletResponse response, @PathVariable(name="omadacId") String centralId) {
        return this.doApiHandler(body, request, response, centralId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doDownloadWithDataHandler(String body, HttpServletRequest request, HttpServletResponse response, String omadacId) {
        try {
            UserIpUtils.setLocalUserIp((String)WebUtils.getRemoteAddress(request));
            if (!this.rateLimiterHandler.preHandle(request, omadacId)) {
                OperationResponse operationResponse = new OperationResponse(b.aB.b(), "");
                return operationResponse;
            }
            RequestEntity<String> requestEntity = WebUtils.getStringRequestEntity(body, request);
            Object result = this.restDispatcher.dispatch(requestEntity, WebUtils.getSessionId(request), omadacId, null, (ApiResponseWrapper)new ApiHttpServletResponseWrapper(response));
            if (result instanceof OperationResponse) {
                Object object = ((OperationResponse)result).success() ? null : result;
                return object;
            }
            if (result instanceof DeferredResult) {
                DeferredResult fileDownloadResult = new DeferredResult();
                ((DeferredResult)result).setResultHandler(res -> {
                    if (!(res instanceof OperationResponse)) {
                        fileDownloadResult.setResult((Object)OperationResponse.GENERAL_ERROR);
                        log.error("Failed to handle Download file request: {}, unknown async result type: {}", (Object)request.getServletPath(), res.getClass());
                        return;
                    }
                    if (((OperationResponse)res).success()) {
                        fileDownloadResult.setResult(null);
                    } else {
                        fileDownloadResult.setResult((Object)((OperationResponse)res));
                    }
                });
                DeferredResult deferredResult = fileDownloadResult;
                return deferredResult;
            }
            log.error("Failed to handle Download file request: {}, unknown result type {}", (Object)request.getServletPath(), result.getClass());
            OperationResponse operationResponse = OperationResponse.GENERAL_ERROR;
            return operationResponse;
        }
        finally {
            UserIpUtils.setLocalUserIp(null);
        }
    }

    @Nullable
    private Object tryEraseFileDownloadResponse(HttpServletRequest request, HttpServletResponse response, Object result) {
        if (result instanceof OperationResponse) {
            if (((OperationResponse)result).success() && response.containsHeader("Content-Disposition")) {
                log.trace("Successfully downloaded file, ignoring OperationResponse:{}", result);
                return null;
            }
            return result;
        }
        if (result instanceof DeferredResult) {
            DeferredResult deferredResult = new DeferredResult();
            ((DeferredResult)result).setResultHandler(res -> {
                if (!(res instanceof OperationResponse)) {
                    deferredResult.setResult((Object)OperationResponse.GENERAL_ERROR);
                    log.error("Failed to handle request: {}, unknown async result type: {}", (Object)request.getServletPath(), res.getClass());
                    return;
                }
                if (((OperationResponse)res).success() && response.containsHeader("Content-Disposition")) {
                    log.trace("Successfully downloaded file, ignoring DeferredResult OperationResponse:{}", res);
                    deferredResult.setResult(null);
                } else {
                    deferredResult.setResult((Object)((OperationResponse)res));
                }
            });
            return deferredResult;
        }
        log.error("Failed to handle request: {}, unknown result type {}", (Object)request.getServletPath(), result.getClass());
        return OperationResponse.GENERAL_ERROR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object doHandleApiInfo(HttpServletRequest request, HttpServletResponse response, @Nonnull String omadacId) {
        try {
            UserIpUtils.setLocalUserIp((String)WebUtils.getRemoteAddress(request));
            AttributeRequestEntity<String> requestEntity = WebUtils.getStringAttributeRequestEntity(null, request);
            request.setAttribute("OMADA_REST_DISPATCHER_ATTRIBUTES", (Object)requestEntity.getAttributes());
            if (!this.rateLimiterHandler.preHandle(request, omadacId)) {
                OperationResponse operationResponse = new OperationResponse(b.aB.b(), "");
                return operationResponse;
            }
            Object object = this.restDispatcher.dispatch(requestEntity, WebUtils.getSessionId(request), omadacId, null, (ApiResponseWrapper)new ApiHttpServletResponseWrapper(response));
            return object;
        }
        finally {
            UserIpUtils.setLocalUserIp(null);
        }
    }
}

