/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.transport;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ruiyun.jvppeteer.api.core.CDPSession;
import com.ruiyun.jvppeteer.api.core.Connection;
import com.ruiyun.jvppeteer.api.events.ConnectionEvents;
import com.ruiyun.jvppeteer.cdp.entities.TargetInfo;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.common.ParamsFactory;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.exception.ProtocolException;
import com.ruiyun.jvppeteer.transport.Callback;
import com.ruiyun.jvppeteer.transport.CallbackRegistry;
import com.ruiyun.jvppeteer.transport.CdpCDPSession;
import com.ruiyun.jvppeteer.transport.ConnectionTransport;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CdpConnection
extends Connection {
    public CdpConnection(String url, ConnectionTransport transport, int delay, int timeout) {
        super(url, transport, delay, timeout);
    }

    @Override
    protected Runnable handleMessageRunnable(JsonNode response) {
        return () -> {
            try {
                CDPSession cdpSession;
                JsonNode paramsNode;
                String method = response.hasNonNull("method") ? response.get("method").asText() : null;
                String sessionId = null;
                if (response.hasNonNull("params")) {
                    paramsNode = response.get("params");
                    if (paramsNode.hasNonNull("sessionId")) {
                        sessionId = paramsNode.get("sessionId").asText();
                    }
                } else {
                    paramsNode = null;
                }
                String parentSessionId = "";
                if (response.hasNonNull("sessionId")) {
                    parentSessionId = response.get("sessionId").asText();
                }
                if ("Target.attachedToTarget".equals(method)) {
                    assert (paramsNode != null);
                    JsonNode typeNode = paramsNode.get("targetInfo").get("type");
                    CdpCDPSession cdpSession2 = new CdpCDPSession(this, typeNode.asText(), sessionId, parentSessionId);
                    this.sessions.put(sessionId, cdpSession2);
                    this.emit(ConnectionEvents.sessionAttached, cdpSession2);
                    CDPSession parentSession = (CDPSession)this.sessions.get(parentSessionId);
                    if (Objects.nonNull(parentSession)) {
                        parentSession.emit(ConnectionEvents.sessionAttached, cdpSession2);
                    }
                } else if ("Target.detachedFromTarget".equals(method) && Objects.nonNull(cdpSession = (CDPSession)this.sessions.get(sessionId))) {
                    cdpSession.onClosed();
                    this.sessions.remove(sessionId);
                    this.emit(ConnectionEvents.sessionDetached, cdpSession);
                    CDPSession parentSession = (CDPSession)this.sessions.get(parentSessionId);
                    if (Objects.nonNull(parentSession)) {
                        parentSession.emit(ConnectionEvents.sessionDetached, cdpSession);
                    }
                }
                if (StringUtil.isNotEmpty(parentSessionId)) {
                    CdpCDPSession parentSession = (CdpCDPSession)this.sessions.get(parentSessionId);
                    if (Objects.nonNull(parentSession)) {
                        parentSession.onMessage(response, this.callbacks);
                    }
                } else if (response.hasNonNull("id")) {
                    long id = response.get("id").asLong();
                    CdpConnection.handleCdpCallback(this.callbacks, response, id, false);
                } else {
                    boolean match = Constant.EVENTS.contains(method);
                    if (match) {
                        assert (method != null);
                        this.emit(ConnectionEvents.valueOf(method.replace(".", "_")), Constant.LISTENER_CLASSES.get(method) == null ? Boolean.valueOf(true) : Constant.OBJECTMAPPER.treeToValue((TreeNode)paramsNode, Constant.LISTENER_CLASSES.get(method)));
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Handle message error: ", (Throwable)e);
            }
        };
    }

    @Override
    public boolean isAutoAttached(String targetId) {
        return !this.manuallyAttached.remove(targetId);
    }

    @Override
    public JsonNode rawSend(String method, Object params, String sessionId, Integer timeout, boolean isBlocking) {
        ValidateUtil.assertArg(!this.closed, "Protocol error: Connection closed.");
        if (timeout == null) {
            timeout = this.timeout;
        }
        Callback callback = new Callback(this.id.incrementAndGet(), method, timeout);
        return this.callbacks.create(callback, id -> {
            String stringifiedMessage;
            ObjectNode objectNode = Constant.OBJECTMAPPER.createObjectNode();
            objectNode.put("method", method);
            if (Objects.nonNull(params)) {
                Helper.removeNull(params);
                objectNode.putPOJO("params", params);
            }
            objectNode.put("id", id);
            if (StringUtil.isNotEmpty(sessionId)) {
                objectNode.put("sessionId", sessionId);
            }
            try {
                stringifiedMessage = Constant.OBJECTMAPPER.writeValueAsString((Object)objectNode);
            }
            catch (JsonProcessingException e) {
                throw new JvppeteerException(e);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("jvppeteer:protocol:SEND \u25ba {}", (Object)stringifiedMessage);
            }
            this.transport.send(stringifiedMessage);
        }, isBlocking);
    }

    @Override
    public void onMessage(String message) {
        try {
            JsonNode readTree;
            if (StringUtil.isEmpty(message)) {
                return;
            }
            if (this.delay > 0) {
                Helper.justWait(this.delay);
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("jvppeteer:protocol:RECV \u25c0 {}", (Object)message);
            }
            if ((readTree = Constant.OBJECTMAPPER.readTree(message)).hasNonNull("id")) {
                long id = readTree.get("id").asLong();
                CdpConnection.handleCdpCallback(this.callbacks, readTree, id, true);
            }
            this.handleMessageExecutorService.submit(this.handleMessageRunnable(readTree));
        }
        catch (Exception e) {
            LOGGER.error("jvppeteer error:", (Throwable)e);
        }
    }

    static void handleCdpCallback(CallbackRegistry callbacks, JsonNode response, long id, boolean handleListenerThread) {
        if (response.hasNonNull("error")) {
            callbacks.reject(id, Helper.createProtocolErrorMessage(response), response.get("error").hasNonNull("code") ? response.get("error").get("code").asInt() : 0, handleListenerThread);
        } else {
            callbacks.resolve(id, response.get("result"), handleListenerThread);
        }
    }

    public static Connection fromSession(CdpCDPSession client) {
        return client.connection();
    }

    public CDPSession createSession(TargetInfo targetInfo) {
        return this._createSession(targetInfo, false);
    }

    @Override
    public CDPSession _createSession(TargetInfo targetInfo, boolean isAutoAttachEmulated) {
        if (!isAutoAttachEmulated) {
            this.manuallyAttached.add(targetInfo.getTargetId());
        }
        Map<String, Object> params = ParamsFactory.create();
        params.put("targetId", targetInfo.getTargetId());
        params.put("flatten", true);
        JsonNode response = this.send("Target.attachToTarget", params, null, true);
        if (response.hasNonNull("sessionId")) {
            String sessionId = response.get("sessionId").asText();
            CDPSession cdpSession = (CDPSession)this.sessions.get(sessionId);
            if (cdpSession == null) {
                throw new JvppeteerException("CDPSession creation failed.");
            }
            return cdpSession;
        }
        throw new JvppeteerException("CDPSession creation failed.");
    }

    @Override
    public String url() {
        return this.url;
    }

    @Override
    public CDPSession session(String sessionId) {
        return (CDPSession)this.sessions.get(sessionId);
    }

    @Override
    public void dispose() {
        this.onClose();
        this.transport.close();
    }

    @Override
    public void onClose() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.transport.setConnection(null);
        this.handleMessageExecutorService.shutdown();
        this.callbacks.clear();
        for (CDPSession session : this.sessions.values()) {
            session.onClosed();
        }
        this.sessions.clear();
        this.emit(ConnectionEvents.CDPSession_Disconnected, true);
    }

    @Override
    public List<ProtocolException> getPendingProtocolErrors() {
        return new ArrayList<ProtocolException>(this.callbacks.getPendingProtocolErrors());
    }

    @Override
    public boolean closed() {
        return this.closed;
    }
}

