/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.cdp.core;

import com.ruiyun.jvppeteer.api.core.Browser;
import com.ruiyun.jvppeteer.cdp.core.BrowserFetcher;
import com.ruiyun.jvppeteer.cdp.entities.ConnectOptions;
import com.ruiyun.jvppeteer.cdp.entities.FetcherOptions;
import com.ruiyun.jvppeteer.cdp.entities.LaunchOptions;
import com.ruiyun.jvppeteer.cdp.entities.Protocol;
import com.ruiyun.jvppeteer.cdp.entities.RevisionInfo;
import com.ruiyun.jvppeteer.common.BrowserRevision;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.common.Environment;
import com.ruiyun.jvppeteer.common.Product;
import com.ruiyun.jvppeteer.exception.LaunchException;
import com.ruiyun.jvppeteer.launch.BrowserLauncher;
import com.ruiyun.jvppeteer.launch.ChromeLauncher;
import com.ruiyun.jvppeteer.launch.FirefoxLauncher;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.io.IOException;
import java.util.Objects;

public class Puppeteer {
    private Product product = Product.Chrome;
    private BrowserLauncher launcher;
    private Environment env = null;
    private String cacheDir;

    public Puppeteer() {
        this.cacheDir = Helper.join(System.getProperty("user.dir"), ".local-browser");
    }

    public Puppeteer(String cacheDir, Product product) {
        this.cacheDir = StringUtil.isBlank(cacheDir) ? Helper.join(System.getProperty("user.dir"), ".local-browser") : cacheDir;
        this.product = product;
    }

    public static Browser launch() throws IOException {
        return Puppeteer.launch(true);
    }

    public static Browser launch(boolean headless) throws IOException {
        return Puppeteer.launch(LaunchOptions.builder().headless(headless).build());
    }

    public static Browser launch(LaunchOptions options) throws IOException {
        Puppeteer puppeteer = new Puppeteer();
        return Puppeteer.rawLaunch(options, puppeteer);
    }

    public static Browser rawLaunch(LaunchOptions options, Puppeteer puppeteer) throws IOException {
        if (options.getProduct() != null) {
            puppeteer.setProduct(options.getProduct());
        }
        if (StringUtil.isNotBlank(options.getCacheDir())) {
            puppeteer.setCacheDir(options.getCacheDir());
        }
        if (Objects.isNull((Object)options.getProtocol())) {
            if (Objects.equals((Object)options.getProduct(), (Object)Product.Firefox)) {
                options.setProtocol(Protocol.WebDriverBiDi);
            } else {
                options.setProtocol(Protocol.CDP);
            }
        }
        if (Objects.equals((Object)options.getProtocol(), (Object)Protocol.CDP) && Objects.equals((Object)options.getProduct(), (Object)Product.Firefox)) {
            throw new LaunchException("Connecting to Firefox using CDP is no longer supported");
        }
        Puppeteer.adoptLauncher(puppeteer);
        return puppeteer.getLauncher().launch(options);
    }

    public static Browser connect(ConnectOptions options) throws Exception {
        Puppeteer puppeteer = new Puppeteer();
        Puppeteer.adoptLauncher(puppeteer);
        return puppeteer.getLauncher().connect(options);
    }

    private static void adoptLauncher(Puppeteer puppeteer) {
        BrowserLauncher launcher;
        Product product = puppeteer.getProduct();
        if (product == null) {
            Environment env = puppeteer.getEnv();
            if (env == null) {
                env = System::getenv;
                puppeteer.setEnv(env);
            }
            for (String envProductName : Constant.PRODUCT_ENV) {
                String productName = env.getEnv(envProductName);
                if (!StringUtil.isNotEmpty(productName)) continue;
                product = Product.valueOf(productName);
                puppeteer.setProduct(product);
                break;
            }
        }
        if (product == null) {
            product = Product.Chrome;
            puppeteer.setProduct(product);
        }
        switch (product) {
            case Firefox: {
                launcher = new FirefoxLauncher(puppeteer.getCacheDir(), product);
                break;
            }
            default: {
                launcher = new ChromeLauncher(puppeteer.getCacheDir(), product);
            }
        }
        puppeteer.setLauncher(launcher);
    }

    public static RevisionInfo downloadBrowser() throws IOException, InterruptedException {
        return Puppeteer.downloadBrowser(BrowserRevision.getVersion(Product.Chrome));
    }

    public static RevisionInfo downloadBrowser(FetcherOptions options) throws IOException, InterruptedException {
        if (StringUtil.isBlank(options.getCacheDir())) {
            options.setCacheDir(Helper.join(System.getProperty("user.dir"), ".local-browser"));
        }
        BrowserFetcher fetcher = new BrowserFetcher(options);
        return fetcher.downloadBrowser();
    }

    public static RevisionInfo downloadBrowser(String version) throws IOException, InterruptedException {
        ValidateUtil.assertArg(StringUtil.isNotBlank(version), "Browser version must be specified");
        FetcherOptions options = new FetcherOptions();
        options.setVersion(version);
        return Puppeteer.downloadBrowser(options);
    }

    private BrowserLauncher getLauncher() {
        return this.launcher;
    }

    private void setLauncher(BrowserLauncher launcher) {
        this.launcher = launcher;
    }

    private Environment getEnv() {
        return this.env;
    }

    private void setEnv(Environment env) {
        this.env = env;
    }

    public String getCacheDir() {
        return this.cacheDir;
    }

    public void setCacheDir(String cacheDir) {
        this.cacheDir = cacheDir;
    }

    public Product getProduct() {
        return this.product;
    }

    public void setProduct(Product product) {
        this.product = product;
    }
}

