/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.cdp.core;

import com.ruiyun.jvppeteer.api.core.Frame;
import com.ruiyun.jvppeteer.common.AwaitableResult;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;

public class FrameTree<FrameType extends Frame> {
    private final Map<String, FrameType> frames = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<String, String> parentIds = new ConcurrentHashMap<String, String>();
    private final Map<String, Set<String>> childIds = new ConcurrentHashMap<String, Set<String>>();
    private FrameType mainFrame;
    private volatile boolean isMainFrameStale = false;
    final Map<String, Set<AwaitableResult<FrameType>>> waitRequests = new ConcurrentHashMap<String, Set<AwaitableResult<FrameType>>>();

    public FrameType getMainFrame() {
        return this.mainFrame;
    }

    public FrameType getById(String frameId) {
        return (FrameType)((Frame)this.frames.get(frameId));
    }

    public FrameType waitForFrame(String frameId) {
        AwaitableResult awaitableResult = AwaitableResult.create();
        this.waitRequests.computeIfAbsent(frameId, k -> new CopyOnWriteArraySet()).add(awaitableResult);
        FrameType frame = this.getById(frameId);
        if (Objects.nonNull(frame)) {
            return frame;
        }
        return (FrameType)((Frame)awaitableResult.waitingGetResult(30000, TimeUnit.MILLISECONDS));
    }

    public List<FrameType> frames() {
        return new ArrayList<FrameType>(this.frames.values());
    }

    public void addFrame(FrameType frame) {
        this.frames.put(((Frame)frame).id(), frame);
        if (StringUtil.isNotEmpty(((Frame)frame).parentId())) {
            this.parentIds.put(((Frame)frame).id(), ((Frame)frame).parentId());
            this.childIds.computeIfAbsent(((Frame)frame).parentId(), k -> new HashSet()).add(((Frame)frame).id());
        } else if (this.mainFrame == null || this.isMainFrameStale) {
            this.mainFrame = frame;
            this.isMainFrameStale = false;
        }
        Set<AwaitableResult<FrameType>> callbacks = this.waitRequests.remove(((Frame)frame).id());
        if (ValidateUtil.isNotEmpty(callbacks)) {
            callbacks.forEach(request -> request.onSuccess(frame));
        }
    }

    public void removeFrame(FrameType frame) {
        String frameId = ((Frame)frame).id();
        this.frames.remove(frameId);
        this.parentIds.remove(frameId);
        if (StringUtil.isNotEmpty(((Frame)frame).parentId())) {
            Set<String> children = this.childIds.get(((Frame)frame).parentId());
            if (children != null) {
                children.remove(frameId);
            }
        } else {
            this.isMainFrameStale = true;
        }
    }

    public List<FrameType> childFrames(String frameId) {
        Set<String> childIds = this.childIds.get(frameId);
        if (childIds == null) {
            return new ArrayList();
        }
        ArrayList<FrameType> frames = new ArrayList<FrameType>();
        for (String id : childIds) {
            FrameType frame = this.getById(id);
            if (frame == null) continue;
            frames.add(frame);
        }
        return frames;
    }

    public FrameType parentFrame(String frameId) {
        String parentId = this.parentIds.get(frameId);
        return StringUtil.isNotEmpty(parentId) ? (FrameType)this.getById(parentId) : null;
    }
}

