/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.cdp.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.ruiyun.jvppeteer.api.core.ElementHandle;
import com.ruiyun.jvppeteer.exception.EvaluateException;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.util.List;

public class FileChooser {
    private final ElementHandle element;
    private volatile boolean handled;
    private final boolean multiple;

    public FileChooser(ElementHandle element, boolean multiple) {
        this.element = element;
        this.multiple = multiple;
        this.handled = false;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public void accept(List<String> filePaths) throws JsonProcessingException, EvaluateException {
        ValidateUtil.assertArg(!this.handled, "Cannot accept FileChooser which is already handled!");
        this.handled = true;
        this.element.uploadFile(filePaths);
    }

    public void cancel() throws JsonProcessingException {
        ValidateUtil.assertArg(!this.handled, "Cannot cancel FileChooser which is already handled!");
        this.handled = true;
        this.element.evaluate("element => {\n      element.dispatchEvent(new Event('cancel', {bubbles: true}));\n    }");
    }
}

