/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.cdp.core;

import com.ruiyun.jvppeteer.api.core.BrowserContext;
import com.ruiyun.jvppeteer.api.core.CDPSession;
import com.ruiyun.jvppeteer.api.core.Page;
import com.ruiyun.jvppeteer.api.core.Target;
import com.ruiyun.jvppeteer.cdp.core.CdpBrowser;
import com.ruiyun.jvppeteer.cdp.core.CdpBrowserContext;
import com.ruiyun.jvppeteer.cdp.core.CdpPage;
import com.ruiyun.jvppeteer.cdp.core.CdpWebWorker;
import com.ruiyun.jvppeteer.cdp.core.TargetManager;
import com.ruiyun.jvppeteer.cdp.entities.TargetInfo;
import com.ruiyun.jvppeteer.cdp.entities.TargetType;
import com.ruiyun.jvppeteer.common.AwaitableResult;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.transport.CdpCDPSession;
import com.ruiyun.jvppeteer.transport.SessionFactory;
import com.ruiyun.jvppeteer.util.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CdpTarget
implements Target {
    private CdpBrowserContext cdpBrowserContext;
    private CDPSession session;
    protected TargetInfo targetInfo;
    private TargetManager targetManager;
    protected SessionFactory sessionFactory;
    private final List<CdpTarget> childTargets = new ArrayList<CdpTarget>();
    public final AwaitableResult<Boolean> isClosedResult = AwaitableResult.create();
    final AwaitableResult<InitializationStatus> initializedResult = AwaitableResult.create();
    private String targetId;
    protected CdpWebWorker webWorker;
    private Runnable onCloseRunner;

    public CdpTarget() {
        this.onCloseRunner = () -> {};
    }

    public CdpTarget(TargetInfo targetInfo, CDPSession session, CdpBrowserContext cdpBrowserContext, TargetManager targetManager, SessionFactory sessionFactory) {
        this.onCloseRunner = () -> {};
        this.session = session;
        this.targetManager = targetManager;
        this.targetInfo = targetInfo;
        this.cdpBrowserContext = cdpBrowserContext;
        this.targetId = targetInfo.getTargetId();
        this.sessionFactory = sessionFactory;
        if (this.session != null) {
            ((CdpCDPSession)this.session).setTarget(this);
        }
    }

    public void setInitializedResult(InitializationStatus status) {
        this.initializedResult.onSuccess(status);
    }

    @Override
    public Page asPage() {
        CDPSession session = this.session();
        if (session == null) {
            session = this.createCDPSession();
            return CdpPage.create(session, this, null);
        }
        return CdpPage.create(session, this, null);
    }

    public String subtype() {
        return this.targetInfo.getSubtype();
    }

    public CDPSession session() {
        return this.session;
    }

    public void addChildTarget(CdpTarget target) {
        this.childTargets.add(target);
    }

    public void removeChildTarget(CdpTarget target) {
        this.childTargets.remove(target);
    }

    public List<CdpTarget> childTargets() {
        return this.childTargets;
    }

    public SessionFactory sessionFactory() {
        if (this.sessionFactory == null) {
            throw new JvppeteerException("sessionFactory is not initialized");
        }
        return this.sessionFactory;
    }

    @Override
    public CDPSession createCDPSession() {
        if (this.sessionFactory == null) {
            throw new JvppeteerException("sessionFactory is not initialized");
        }
        CdpCDPSession cdpSession = (CdpCDPSession)this.sessionFactory.create(false);
        cdpSession.setTarget(this);
        return cdpSession;
    }

    @Override
    public String url() {
        return this.targetInfo.getUrl();
    }

    @Override
    public TargetType type() {
        String type;
        switch (type = this.targetInfo.getType()) {
            case "page": {
                return TargetType.PAGE;
            }
            case "background_page": {
                return TargetType.BACKGROUND_PAGE;
            }
            case "service_worker": {
                return TargetType.SERVICE_WORKER;
            }
            case "shared_worker": {
                return TargetType.SHARED_WORKER;
            }
            case "browser": {
                return TargetType.BROWSER;
            }
            case "webview": {
                return TargetType.WEBVIEW;
            }
            case "tab": {
                return TargetType.TAB;
            }
        }
        return TargetType.OTHER;
    }

    public TargetManager targetManager() {
        if (this.targetManager == null) {
            throw new JvppeteerException("targetManager is not initialized");
        }
        return this.targetManager;
    }

    public TargetInfo getTargetInfo() {
        return this.targetInfo;
    }

    @Override
    public CdpBrowser browser() {
        if (this.cdpBrowserContext == null) {
            throw new JvppeteerException("browserContext is not initialized");
        }
        return this.cdpBrowserContext.browser();
    }

    @Override
    public BrowserContext browserContext() {
        if (this.cdpBrowserContext == null) {
            throw new JvppeteerException("browserContext is not initialized");
        }
        return this.cdpBrowserContext;
    }

    @Override
    public Target opener() {
        String openerId = this.targetInfo.getOpenerId();
        if (StringUtil.isEmpty(openerId)) {
            return null;
        }
        for (CdpTarget target : this.browser().targets()) {
            if (!target.getTargetId().equals(openerId)) continue;
            return target;
        }
        return null;
    }

    public void targetInfoChanged(TargetInfo targetInfo) {
        this.targetInfo = targetInfo;
        this.checkIfInitialized();
    }

    public void initialize() {
        this.setInitializedResult(InitializationStatus.SUCCESS);
    }

    public boolean isTargetExposed() {
        return this.type() != TargetType.TAB && this.subtype() == null;
    }

    private void checkIfInitialized() {
        if (!this.initializedResult.isDone()) {
            this.setInitializedResult(InitializationStatus.SUCCESS);
        }
    }

    public String getTargetId() {
        return this.targetId;
    }

    public void waitForTargetClose() {
        this.isClosedResult.waiting(30000, TimeUnit.MILLISECONDS);
    }

    public void close() {
        this.isClosedResult.onSuccess(true);
        if (this.onCloseRunner != null) {
            this.onCloseRunner.run();
        }
    }

    public void setOnCloseRunner(Runnable onCloseRunner) {
        this.onCloseRunner = onCloseRunner;
    }

    public static enum InitializationStatus {
        SUCCESS("success"),
        ABORTED("aborted");

        private final String status;

        private InitializationStatus(String status) {
            this.status = status;
        }

        public String getStatus() {
            return this.status;
        }
    }
}

