/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.cdp.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.api.core.CDPSession;
import com.ruiyun.jvppeteer.api.core.ElementHandle;
import com.ruiyun.jvppeteer.api.core.JSHandle;
import com.ruiyun.jvppeteer.api.core.Realm;
import com.ruiyun.jvppeteer.cdp.core.IsolatedWorld;
import com.ruiyun.jvppeteer.cdp.entities.RemoteObject;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.exception.EvaluateException;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StringUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class CdpJSHandle
extends JSHandle {
    private final RemoteObject remoteObject;
    private boolean disposed = false;
    private final IsolatedWorld world;

    CdpJSHandle(IsolatedWorld world, RemoteObject remoteObject) {
        this.world = world;
        this.remoteObject = remoteObject;
    }

    @Override
    public boolean disposed() {
        return this.disposed;
    }

    @Override
    public Map<String, JSHandle> getProperties() throws JsonProcessingException {
        JsonNode response = this.client().send("Runtime.getProperties", Constant.OBJECTMAPPER.createObjectNode().put("objectId", this.remoteObject.getObjectId()).put("ownProperties", true));
        LinkedHashMap<String, JSHandle> result = new LinkedHashMap<String, JSHandle>();
        for (JsonNode property : response.get("result")) {
            if (!property.get("enumerable").asBoolean() || !property.hasNonNull("value")) continue;
            result.put(property.get("name").asText(), this.world.createJSHandle((RemoteObject)Constant.OBJECTMAPPER.treeToValue((TreeNode)property.get("value"), RemoteObject.class)));
        }
        return result;
    }

    @Override
    public Realm realm() {
        return this.world;
    }

    public CDPSession client() {
        return this.realm().environment().client();
    }

    @Override
    public Object jsonValue() throws JsonProcessingException, EvaluateException {
        if (StringUtil.isNotEmpty(this.remoteObject.getObjectId())) {
            Object value = this.evaluate("object => {\n      return object;\n    }", new ArrayList<Object>());
            if (value == null) {
                throw new JvppeteerException("Could not serialize referenced object");
            }
            return value;
        }
        return Helper.valueFromRemoteObject(this.remoteObject);
    }

    @Override
    public ElementHandle asElement() {
        return null;
    }

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        this.disposed = true;
        Helper.releaseObject(this.client(), this.remoteObject);
    }

    @Override
    public String toString() {
        if (StringUtil.isNotEmpty(this.remoteObject.getObjectId())) {
            String type = StringUtil.isNotEmpty(this.remoteObject.getSubtype()) ? this.remoteObject.getSubtype() : this.remoteObject.getType();
            return "JSHandle@" + type;
        }
        return "JSHandle:" + Helper.valueFromRemoteObject(this.remoteObject);
    }

    @Override
    public RemoteObject remoteObject() {
        return this.remoteObject;
    }

    @Override
    public String id() {
        return this.remoteObject.getObjectId();
    }
}

