/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.cdp.core;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ruiyun.jvppeteer.api.core.BrowserContext;
import com.ruiyun.jvppeteer.api.core.Connection;
import com.ruiyun.jvppeteer.api.core.Page;
import com.ruiyun.jvppeteer.api.core.Target;
import com.ruiyun.jvppeteer.cdp.core.CdpBrowser;
import com.ruiyun.jvppeteer.cdp.entities.Cookie;
import com.ruiyun.jvppeteer.cdp.entities.CookieData;
import com.ruiyun.jvppeteer.cdp.entities.TargetType;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.common.ParamsFactory;
import com.ruiyun.jvppeteer.common.WebPermission;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class CdpBrowserContext
extends BrowserContext {
    private Connection connection;
    private CdpBrowser cdpBrowser;
    private String id;

    public CdpBrowserContext() {
    }

    public CdpBrowserContext(Connection connection, CdpBrowser cdpBrowser, String contextId) {
        this.connection = connection;
        this.cdpBrowser = cdpBrowser;
        this.id = contextId;
    }

    @Override
    public List<Target> targets() {
        return this.cdpBrowser.targets().stream().filter(target -> target.browserContext() == this).collect(Collectors.toList());
    }

    @Override
    public List<Page> pages() {
        return this.targets().stream().filter(target -> TargetType.PAGE.equals((Object)target.type()) || !TargetType.OTHER.equals((Object)target.type()) || this.cdpBrowser.getIsPageTargetCallback() == null || this.cdpBrowser.getIsPageTargetCallback().apply((Target)target) != false).map(Target::page).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public void overridePermissions(String origin, WebPermission ... webPermissions) {
        ArrayList<String> protocolPermissions = new ArrayList<String>();
        if (webPermissions != null) {
            for (WebPermission permission : webPermissions) {
                String protocolPermission = Constant.WEB_PERMISSION_TO_PROTOCOL_PERMISSION.get((Object)permission);
                ValidateUtil.assertArg(protocolPermission != null, "Unknown permission: " + (Object)((Object)permission));
                protocolPermissions.add(protocolPermission);
            }
        }
        Map<String, Object> params = ParamsFactory.create();
        params.put("origin", origin);
        if (StringUtil.isNotEmpty(this.id)) {
            params.put("browserContextId", this.id);
        }
        params.put("permissions", protocolPermissions);
        this.connection.send("Browser.grantPermissions", params);
    }

    @Override
    public void clearPermissionOverrides() {
        Map<String, Object> params = ParamsFactory.create();
        params.put("browserContextId", this.id);
        this.connection.send("Browser.resetPermissions", params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page newPage() {
        CdpBrowserContext cdpBrowserContext = this;
        synchronized (cdpBrowserContext) {
            return this.cdpBrowser.createPageInContext(this.id);
        }
    }

    @Override
    public void close() {
        ValidateUtil.assertArg(StringUtil.isNotEmpty(this.id), "Default BrowserContext cannot be closed!");
        this.cdpBrowser.disposeContext(this.id);
    }

    @Override
    public List<Cookie> cookies() {
        Map<String, Object> params = ParamsFactory.create();
        if (StringUtil.isNotEmpty(this.id)) {
            params.put("browserContextId", this.id);
        }
        JsonNode cookies = this.connection.send("Storage.getCookies", params).get("cookies");
        Iterator elements = cookies.elements();
        ArrayList<Cookie> cookieList = new ArrayList<Cookie>();
        while (elements.hasNext()) {
            JsonNode cookie = (JsonNode)elements.next();
            Cookie convertCookie = (Cookie)Constant.OBJECTMAPPER.convertValue((Object)cookie, Cookie.class);
            JsonNode partitionKey = cookie.path("partitionKey");
            if (!partitionKey.isMissingNode()) {
                ObjectNode objectNode = Constant.OBJECTMAPPER.createObjectNode();
                objectNode.put("sourceOrigin", partitionKey.get("topLevelSite").asText());
                objectNode.put("hasCrossSiteAncestor", partitionKey.get("hasCrossSiteAncestor").asBoolean());
                convertCookie.setPartitionKey((JsonNode)objectNode);
            }
            cookieList.add(convertCookie);
        }
        return cookieList;
    }

    @Override
    public void setCookie(CookieData ... cookies) {
        if (Objects.isNull(cookies)) {
            return;
        }
        for (CookieData cookie : cookies) {
            cookie.setPartitionKey((JsonNode)Helper.convertCookiesPartitionKeyFromPuppeteerToCdp(cookie.getPartitionKey()));
        }
        Map<String, Object> params = ParamsFactory.create();
        params.put("cookies", cookies);
        if (StringUtil.isNotEmpty(this.id)) {
            params.put("browserContextId", this.id);
        }
        this.connection.send("Storage.setCookies", params);
    }

    @Override
    public CdpBrowser browser() {
        return this.cdpBrowser;
    }

    @Override
    public String id() {
        return this.id;
    }
}

