/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.cdp.core;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.ruiyun.jvppeteer.api.core.Browser;
import com.ruiyun.jvppeteer.api.core.BrowserContext;
import com.ruiyun.jvppeteer.api.core.Connection;
import com.ruiyun.jvppeteer.api.core.Page;
import com.ruiyun.jvppeteer.api.core.Target;
import com.ruiyun.jvppeteer.api.events.BrowserContextEvents;
import com.ruiyun.jvppeteer.api.events.BrowserEvents;
import com.ruiyun.jvppeteer.api.events.ConnectionEvents;
import com.ruiyun.jvppeteer.cdp.core.CdpBrowserContext;
import com.ruiyun.jvppeteer.cdp.core.CdpTarget;
import com.ruiyun.jvppeteer.cdp.core.DevToolsTarget;
import com.ruiyun.jvppeteer.cdp.core.OtherTarget;
import com.ruiyun.jvppeteer.cdp.core.PageTarget;
import com.ruiyun.jvppeteer.cdp.core.TargetManager;
import com.ruiyun.jvppeteer.cdp.core.WorkerTarget;
import com.ruiyun.jvppeteer.cdp.entities.BrowserContextOptions;
import com.ruiyun.jvppeteer.cdp.entities.DebugInfo;
import com.ruiyun.jvppeteer.cdp.entities.DownloadOptions;
import com.ruiyun.jvppeteer.cdp.entities.DownloadPolicy;
import com.ruiyun.jvppeteer.cdp.entities.GetVersionResponse;
import com.ruiyun.jvppeteer.cdp.entities.TargetInfo;
import com.ruiyun.jvppeteer.cdp.entities.TargetType;
import com.ruiyun.jvppeteer.cdp.entities.Viewport;
import com.ruiyun.jvppeteer.common.ParamsFactory;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.transport.SessionFactory;
import com.ruiyun.jvppeteer.util.Helper;
import com.ruiyun.jvppeteer.util.StringUtil;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CdpBrowser
extends Browser {
    private final Viewport defaultViewport;
    private final Process process;
    private final Connection connection;
    private final Runnable closeCallback;
    private Function<Target, Boolean> isPageTargetCallback;
    private final CdpBrowserContext defaultContext;
    private final Map<String, CdpBrowserContext> contexts = new HashMap<String, CdpBrowserContext>();
    private final TargetManager targetManager;
    private String executablePath;
    private List<String> defaultArgs;
    private final boolean networkEnabled;
    private final Consumer<Object> emitDisconnected = ignore -> this.emit(BrowserEvents.Disconnected, true);
    private final Consumer<Object> emitDownloadProgress = event -> this.emit(BrowserEvents.DownloadProgress, event);
    private final Consumer<Object> emitDownloadWillBegin = event -> this.emit(BrowserEvents.DownloadWillBegin, event);
    private final Consumer<CdpTarget> onAttachedToTarget = target -> {
        if (target.isTargetExposed() && Objects.equals((Object)target.initializedResult.waitingGetResult(), (Object)CdpTarget.InitializationStatus.SUCCESS)) {
            this.emit(BrowserEvents.TargetCreated, target);
            target.browserContext().emit(BrowserContextEvents.TargetCreated, target);
        }
    };
    private final Consumer<CdpTarget> onDetachedFromTarget = target -> {
        boolean initializedSuccess = Objects.equals((Object)target.initializedResult.waitingGetResult(), (Object)CdpTarget.InitializationStatus.SUCCESS);
        target.setInitializedResult(CdpTarget.InitializationStatus.ABORTED);
        target.close();
        if (target.isTargetExposed() && initializedSuccess) {
            this.emit(BrowserEvents.TargetDestroyed, target);
            target.browserContext().emit(BrowserContextEvents.TargetDestroyed, target);
        }
    };
    private final Consumer<CdpTarget> onTargetChanged = target -> {
        this.emit(BrowserEvents.TargetChanged, target);
        target.browserContext().emit(BrowserContextEvents.TargetChanged, target);
    };
    private final Consumer<TargetInfo> onTargetDiscovered = target -> this.emit(BrowserEvents.TargetDiscovered, target);

    protected CdpBrowser(Connection connection, List<String> contextIds, Viewport viewport, Process process, Runnable closeCallback, Function<Target, Boolean> targetFilterCallback, Function<Target, Boolean> isPageTargetCallback, boolean waitForInitiallyDiscoveredTargets, boolean networkEnabled) {
        this.networkEnabled = networkEnabled;
        this.defaultViewport = viewport;
        this.process = process;
        this.connection = connection;
        if (closeCallback == null) {
            closeCallback = () -> {};
        }
        this.closeCallback = closeCallback;
        if (targetFilterCallback == null) {
            targetFilterCallback = ignore -> true;
        }
        this.setIsPageTargetCallback(isPageTargetCallback);
        this.targetManager = new TargetManager(connection, this.createTarget(), targetFilterCallback, waitForInitiallyDiscoveredTargets);
        this.defaultContext = new CdpBrowserContext(connection, this, "");
        if (ValidateUtil.isNotEmpty(contextIds)) {
            for (String contextId : contextIds) {
                this.contexts.putIfAbsent(contextId, new CdpBrowserContext(this.connection, this, contextId));
            }
        }
    }

    private void attach() {
        this.connection.on(ConnectionEvents.CDPSession_Disconnected, this.emitDisconnected);
        this.connection.on(ConnectionEvents.Browser_downloadProgress, this.emitDownloadProgress);
        this.connection.on(ConnectionEvents.Browser_downloadWillBegin, this.emitDownloadWillBegin);
        this.targetManager.on(TargetManager.TargetManagerEvent.TargetAvailable, this.onAttachedToTarget);
        this.targetManager.on(TargetManager.TargetManagerEvent.TargetGone, this.onDetachedFromTarget);
        this.targetManager.on(TargetManager.TargetManagerEvent.TargetChanged, this.onTargetChanged);
        this.targetManager.on(TargetManager.TargetManagerEvent.TargetDiscovered, this.onTargetDiscovered);
        this.targetManager.initialize();
    }

    private void detach() {
        this.connection.off(ConnectionEvents.CDPSession_Disconnected, this.emitDisconnected);
        this.connection.off(ConnectionEvents.Browser_downloadProgress, this.emitDownloadProgress);
        this.connection.off(ConnectionEvents.Browser_downloadWillBegin, this.emitDownloadWillBegin);
        this.targetManager.off(TargetManager.TargetManagerEvent.TargetAvailable, this.onAttachedToTarget);
        this.targetManager.off(TargetManager.TargetManagerEvent.TargetGone, this.onDetachedFromTarget);
        this.targetManager.off(TargetManager.TargetManagerEvent.TargetChanged, this.onTargetChanged);
        this.targetManager.off(TargetManager.TargetManagerEvent.TargetDiscovered, this.onTargetDiscovered);
    }

    @Override
    public Process process() {
        return this.process;
    }

    public String executablePath() {
        return this.executablePath;
    }

    public TargetManager targetManager() {
        return this.targetManager;
    }

    private void setIsPageTargetCallback(Function<Target, Boolean> isPageTargetCallback) {
        if (isPageTargetCallback == null) {
            isPageTargetCallback = target -> TargetType.PAGE.equals((Object)target.type()) || TargetType.BACKGROUND_PAGE.equals((Object)target.type()) || TargetType.WEBVIEW.equals((Object)target.type());
        }
        this.isPageTargetCallback = isPageTargetCallback;
    }

    Function<Target, Boolean> getIsPageTargetCallback() {
        return this.isPageTargetCallback;
    }

    @Override
    public CdpBrowserContext createBrowserContext(BrowserContextOptions options) {
        Map<String, Object> params = ParamsFactory.create();
        params.put("proxyServer", options.getProxyServer());
        if (ValidateUtil.isNotEmpty(options.getProxyBypassList())) {
            params.put("proxyBypassList", String.join((CharSequence)",", options.getProxyBypassList()));
        }
        JsonNode result = this.connection.send("Target.createBrowserContext", params);
        CdpBrowserContext context = new CdpBrowserContext(this.connection, this, result.get("browserContextId").asText());
        this.contexts.put(result.get("browserContextId").asText(), context);
        return context;
    }

    @Override
    public List<BrowserContext> browserContexts() {
        ArrayList<BrowserContext> contexts = new ArrayList<BrowserContext>();
        contexts.add(this.defaultBrowserContext());
        contexts.addAll(this.contexts.values());
        return contexts;
    }

    @Override
    public CdpBrowserContext defaultBrowserContext() {
        return this.defaultContext;
    }

    void disposeContext(String contextId) {
        if (StringUtil.isEmpty(contextId)) {
            return;
        }
        Map<String, Object> params = ParamsFactory.create();
        params.put("browserContextId", contextId);
        this.connection.send("Target.disposeBrowserContext", params);
        this.contexts.remove(contextId);
    }

    private TargetManager.TargetFactory createTarget() {
        return (targetInfo, session, parentSession) -> {
            String browserContextId = targetInfo.getBrowserContextId();
            CdpBrowserContext context = StringUtil.isNotEmpty(browserContextId) && this.contexts.containsKey(browserContextId) ? this.contexts.get(browserContextId) : this.defaultContext;
            if (context == null) {
                throw new JvppeteerException("Missing browser context");
            }
            SessionFactory createSession = isAutoAttachEmulated -> this.connection._createSession(targetInfo, isAutoAttachEmulated);
            OtherTarget otherTarget = new OtherTarget(targetInfo, session, context, this.targetManager, createSession);
            if (StringUtil.isNotEmpty(targetInfo.getUrl()) && targetInfo.getUrl().startsWith("devtools://")) {
                return new DevToolsTarget(targetInfo, session, context, this.targetManager, createSession, this.defaultViewport);
            }
            if (this.isPageTargetCallback.apply(otherTarget).booleanValue()) {
                return new PageTarget(targetInfo, session, context, this.targetManager, createSession, this.defaultViewport);
            }
            if ("service_worker".equals(targetInfo.getType()) || "shared_worker".equals(targetInfo.getType())) {
                return new WorkerTarget(targetInfo, session, context, this.targetManager, createSession);
            }
            return otherTarget;
        };
    }

    @Override
    public String wsEndpoint() {
        return this.connection.url();
    }

    @Override
    public Page newPage() {
        return this.defaultContext.newPage();
    }

    Page createPageInContext(String contextId) {
        JsonNode result;
        Map<String, Object> params = ParamsFactory.create();
        params.put("url", "about:blank");
        if (StringUtil.isNotEmpty(contextId)) {
            params.put("browserContextId", contextId);
        }
        if ((result = this.connection.send("Target.createTarget", params)) != null) {
            String targetId = result.get("targetId").asText();
            CdpTarget target = (CdpTarget)this.waitForTarget(t -> ((CdpTarget)t).getTargetId().equals(targetId), 30000);
            if (target == null) {
                throw new JvppeteerException("Missing target for page (id = " + targetId + ")");
            }
            if (!Objects.equals((Object)target.initializedResult.waitingGetResult(), (Object)CdpTarget.InitializationStatus.SUCCESS)) {
                throw new JvppeteerException("Failed to create target for page (id =" + targetId + ")");
            }
            Page page = target.page();
            if (page == null) {
                throw new JvppeteerException("Failed to create a page for context (id = " + contextId + ")");
            }
            return page;
        }
        throw new JvppeteerException("Failed to create target for page (id =" + contextId + ")");
    }

    @Override
    public Target target() {
        for (Target target : this.targets()) {
            if (!TargetType.BROWSER.equals((Object)target.type())) continue;
            return target;
        }
        throw new JvppeteerException("Browser target is not found");
    }

    public List<CdpTarget> targets() {
        return this.targetManager.getAvailableTargets().values().stream().filter(target -> target.isTargetExposed() && Objects.equals((Object)target.initializedResult.waitingGetResult(), (Object)CdpTarget.InitializationStatus.SUCCESS)).collect(Collectors.toList());
    }

    @Override
    public String version() throws JsonProcessingException {
        GetVersionResponse version = Helper.getVersion(this.connection);
        return version.getProduct();
    }

    @Override
    public String userAgent() {
        GetVersionResponse version = Helper.getVersion(this.connection);
        return version.getUserAgent();
    }

    @Override
    public void close() {
        this.autoClose = true;
        this.closeCallback.run();
        this.disconnect();
    }

    @Override
    public void disconnect() {
        this.autoClose = true;
        this.targetManager.dispose();
        this.connection.dispose();
        this.detach();
    }

    @Override
    public boolean connected() {
        return !this.connection.closed();
    }

    @Override
    public DebugInfo debugInfo() {
        return new DebugInfo(this.connection.getPendingProtocolErrors());
    }

    public static CdpBrowser create(Connection connection, List<String> contextIds, boolean acceptInsecureCerts, Viewport defaultViewport, Process process, Runnable closeCallback, Function<Target, Boolean> targetFilterCallback, Function<Target, Boolean> IsPageTargetCallback, boolean waitForInitiallyDiscoveredTargets, boolean networkEnabled) {
        CdpBrowser cdpBrowser = new CdpBrowser(connection, contextIds, defaultViewport, process, closeCallback, targetFilterCallback, IsPageTargetCallback, waitForInitiallyDiscoveredTargets, networkEnabled);
        if (acceptInsecureCerts) {
            Map<String, Object> params = ParamsFactory.create();
            params.put("ignore", true);
            connection.send("Security.setIgnoreCertificateErrors", params);
        }
        cdpBrowser.attach();
        return cdpBrowser;
    }

    public void setExecutablePath(String executablePath) {
        this.executablePath = executablePath;
    }

    public List<String> defaultArgs() {
        return this.defaultArgs;
    }

    public void setDefaultArgs(List<String> defaultArgs) {
        this.defaultArgs = defaultArgs;
    }

    @Override
    public void setDownloadBehavior(DownloadOptions options) {
        if (Objects.isNull((Object)options.getBehavior())) {
            options.setBehavior(DownloadPolicy.Default);
        }
        if ((options.getBehavior().equals((Object)DownloadPolicy.Allow) || options.getBehavior().equals((Object)DownloadPolicy.AllowAndName)) && StringUtil.isBlank(options.getDownloadPath())) {
            throw new JvppeteerException("This is required if behavior is set to 'allow' or 'allowAndName'.");
        }
        Map<String, Object> params = ParamsFactory.create();
        params.put("behavior", options.getBehavior().getBehavior());
        params.put("downloadPath", options.getDownloadPath());
        params.put("browserContextId", options.getBrowserContextId());
        params.put("eventsEnabled", options.getEventsEnabled());
        this.connection.send("Browser.setDownloadBehavior", params);
    }

    @Override
    public void cancelDownload(String guid, String browserContextId) {
        Map<String, Object> params = ParamsFactory.create();
        params.put("guid", guid);
        params.put("browserContextId", browserContextId);
        this.connection.send("Browser.cancelDownload", params);
    }

    @Override
    public boolean isNetworkEnabled() {
        return this.networkEnabled;
    }
}

