/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.bidi.core;

import com.ruiyun.jvppeteer.api.events.ConnectionEvents;
import com.ruiyun.jvppeteer.bidi.core.BidiRealmCore;
import com.ruiyun.jvppeteer.bidi.core.BrowsingContext;
import com.ruiyun.jvppeteer.bidi.core.DedicatedWorkerRealm;
import com.ruiyun.jvppeteer.bidi.core.Session;
import com.ruiyun.jvppeteer.bidi.entities.RealmInfo;
import com.ruiyun.jvppeteer.bidi.entities.RealmType;
import com.ruiyun.jvppeteer.bidi.entities.Target;
import com.ruiyun.jvppeteer.bidi.events.ClosedEvent;
import com.ruiyun.jvppeteer.common.DisposableStack;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class WindowRealm
extends BidiRealmCore {
    private final BrowsingContext browsingContext;
    String sandbox;
    private final Map<String, DedicatedWorkerRealm> workers = new ConcurrentHashMap<String, DedicatedWorkerRealm>();

    protected WindowRealm(BrowsingContext context, String sandbox) {
        super("", "");
        this.browsingContext = context;
        this.sandbox = sandbox;
    }

    public static WindowRealm from(BrowsingContext browsingContext, String sandbox) {
        WindowRealm realm = new WindowRealm(browsingContext, sandbox);
        realm.initialize();
        return realm;
    }

    private void initialize() {
        Consumer<ClosedEvent> closedEventConsumer = event -> this.dispose(event.getReason());
        this.browsingContext.on(BrowsingContext.BrowsingContextEvents.closed, closedEventConsumer);
        this.disposables.add(new DisposableStack<BrowsingContext.BrowsingContextEvents>(this.browsingContext, BrowsingContext.BrowsingContextEvents.closed, closedEventConsumer));
        Consumer<RealmInfo> realmCreatedEventConsumer1 = info -> {
            if (!(Objects.equals((Object)RealmType.Window, (Object)info.getType()) && Objects.equals(info.getContext(), this.browsingContext.id()) && Objects.equals(info.getSandbox(), this.sandbox))) {
                return;
            }
            this.id = info.getRealm();
            this.origin = info.getOrigin();
            this.executionContextId = null;
            this.emit(BidiRealmCore.RealmCoreEvents.updated, this);
        };
        this.session().on(ConnectionEvents.script_realmCreated, realmCreatedEventConsumer1);
        this.disposables.add(new DisposableStack<ConnectionEvents>(this.session(), ConnectionEvents.script_realmCreated, realmCreatedEventConsumer1));
        Consumer<RealmInfo> realmCreatedEventConsumer2 = info -> {
            if (!Objects.equals((Object)RealmType.DedicatedWorker, (Object)info.getType()) || !info.getOwners().contains(this.id)) {
                return;
            }
            DedicatedWorkerRealm dedicatedWorkerRealm = DedicatedWorkerRealm.from(this, info.getRealm(), info.getOrigin());
            this.workers.put(dedicatedWorkerRealm.id, dedicatedWorkerRealm);
            Consumer<Object> destroyedConsumer = ignored -> {
                dedicatedWorkerRealm.removeAllListeners(null);
                this.workers.remove(dedicatedWorkerRealm.id);
            };
            this.emit(BidiRealmCore.RealmCoreEvents.worker, dedicatedWorkerRealm);
            dedicatedWorkerRealm.once(BidiRealmCore.RealmCoreEvents.destroyed, destroyedConsumer);
            this.disposables.add(new DisposableStack<BidiRealmCore.RealmCoreEvents>(dedicatedWorkerRealm, BidiRealmCore.RealmCoreEvents.destroyed, destroyedConsumer));
        };
        this.session().on(ConnectionEvents.script_realmCreated, realmCreatedEventConsumer2);
        this.disposables.add(new DisposableStack<ConnectionEvents>(this.session(), ConnectionEvents.script_realmCreated, realmCreatedEventConsumer2));
    }

    @Override
    public Session session() {
        return this.browsingContext.userContext.session();
    }

    @Override
    public Target target() {
        Target target = new Target();
        target.setContext(this.browsingContext.id());
        target.setSandbox(this.sandbox);
        return target;
    }
}

