/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.bidi.core;

import com.ruiyun.jvppeteer.api.events.ConnectionEvents;
import com.ruiyun.jvppeteer.bidi.core.BidiRealmCore;
import com.ruiyun.jvppeteer.bidi.core.Session;
import com.ruiyun.jvppeteer.bidi.entities.RealmDestroyedParameters;
import com.ruiyun.jvppeteer.bidi.entities.RealmInfo;
import com.ruiyun.jvppeteer.bidi.entities.RealmType;
import com.ruiyun.jvppeteer.common.DisposableStack;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class DedicatedWorkerRealm
extends BidiRealmCore {
    private final Set<BidiRealmCore> owners;
    private final Map<String, DedicatedWorkerRealm> workers = new ConcurrentHashMap<String, DedicatedWorkerRealm>();

    protected DedicatedWorkerRealm(BidiRealmCore owner, String id, String origin) {
        super(id, origin);
        this.owners = new HashSet<BidiRealmCore>();
        this.owners.add(owner);
    }

    public static DedicatedWorkerRealm from(BidiRealmCore owner, String id, String origin) {
        DedicatedWorkerRealm dedicatedWorkerRealm = new DedicatedWorkerRealm(owner, id, origin);
        dedicatedWorkerRealm.initialize();
        return dedicatedWorkerRealm;
    }

    private void initialize() {
        Consumer<RealmDestroyedParameters> realmDestroyedParametersConsumer = info -> {
            if (!Objects.equals(info.getRealm(), this.id)) {
                return;
            }
            this.dispose("Realm already destroyed.");
        };
        this.session().on(ConnectionEvents.script_realmDestroyed, realmDestroyedParametersConsumer);
        this.disposables.add(new DisposableStack<ConnectionEvents>(this.session(), ConnectionEvents.script_realmDestroyed, realmDestroyedParametersConsumer));
        Consumer<RealmInfo> realmCreatedEventConsumer = info -> {
            if (!Objects.equals((Object)RealmType.DedicatedWorker, (Object)info.getType()) || !info.getOwners().contains(this.id)) {
                return;
            }
            DedicatedWorkerRealm dedicatedWorkerRealm = DedicatedWorkerRealm.from(this, info.getRealm(), info.getOrigin());
            this.workers.put(dedicatedWorkerRealm.id, dedicatedWorkerRealm);
            Consumer<Object> destroyedConsumer = ignored -> this.workers.remove(dedicatedWorkerRealm.id);
            dedicatedWorkerRealm.once(BidiRealmCore.RealmCoreEvents.destroyed, destroyedConsumer);
            this.disposables.add(new DisposableStack<BidiRealmCore.RealmCoreEvents>(dedicatedWorkerRealm, BidiRealmCore.RealmCoreEvents.destroyed, destroyedConsumer));
            this.emit(BidiRealmCore.RealmCoreEvents.worker, dedicatedWorkerRealm);
        };
        this.session().on(ConnectionEvents.script_realmCreated, realmCreatedEventConsumer);
        this.disposables.add(new DisposableStack<ConnectionEvents>(this.session(), ConnectionEvents.script_realmCreated, realmCreatedEventConsumer));
    }

    @Override
    public Session session() {
        return this.owners.iterator().next().session();
    }
}

