/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.bidi.core;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.ruiyun.jvppeteer.bidi.entities.LocalValue;
import com.ruiyun.jvppeteer.common.Constant;
import com.ruiyun.jvppeteer.common.PrimitiveValue;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import java.lang.reflect.Field;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class BidiSerializer {
    public static LocalValue serialize(Object arg) {
        if (arg == null) {
            return new LocalValue("undefined", null);
        }
        switch (arg.getClass().getName()) {
            case "java.lang.Byte": 
            case "java.lang.Short": 
            case "java.lang.Double": 
            case "java.lang.Integer": 
            case "java.lang.Long": 
            case "java.lang.Float": {
                return new LocalValue("number", arg);
            }
            case "java.math.BigInteger": {
                return new LocalValue("bigint", arg);
            }
            case "java.lang.String": {
                return BidiSerializer.serializeString(arg);
            }
            case "java.lang.Boolean": {
                return new LocalValue("boolean", arg);
            }
            case "com.ruiyun.jvppeteer.common.PrimitiveValue": {
                return BidiSerializer.serializePrimitiveValue((PrimitiveValue)((Object)arg));
            }
        }
        return BidiSerializer.serializeObject(arg);
    }

    private static LocalValue serializePrimitiveValue(PrimitiveValue arg) {
        return new LocalValue(arg.getValue(), null);
    }

    private static LocalValue serializeObject(Object arg) {
        if (arg instanceof List || arg instanceof Set) {
            ArrayList<LocalValue> parsedArray = new ArrayList<LocalValue>();
            for (Object subArg : (Collection)arg) {
                parsedArray.add(BidiSerializer.serialize(subArg));
            }
            return new LocalValue("array", parsedArray);
        }
        if (arg instanceof Map) {
            ArrayList parsedObject = new ArrayList();
            for (Map.Entry entry : ((Map)arg).entrySet()) {
                ArrayList<LocalValue> arrayList = new ArrayList<LocalValue>();
                arrayList.add(BidiSerializer.serialize(entry.getKey()));
                arrayList.add(BidiSerializer.serialize(entry.getValue()));
                parsedObject.add(arrayList);
            }
            return new LocalValue("object", parsedObject);
        }
        if (arg instanceof Pattern) {
            Pattern pattern = (Pattern)arg;
            ObjectNode value = Constant.OBJECTMAPPER.createObjectNode();
            value.put("pattern", pattern.pattern());
            value.put("flags", pattern.flags());
            return new LocalValue("regexp", value);
        }
        if (arg instanceof Date) {
            LocalDateTime localDateTime = ((Date)arg).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
            String isoString = localDateTime.format(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
            return new LocalValue("date", isoString);
        }
        Field[] fields = arg.getClass().getDeclaredFields();
        ArrayList parsedObject = new ArrayList();
        for (Field field : fields) {
            field.setAccessible(true);
            ArrayList<LocalValue> mappingList = new ArrayList<LocalValue>();
            mappingList.add(BidiSerializer.serialize(field.getName()));
            try {
                mappingList.add(BidiSerializer.serialize(field.get(arg)));
            }
            catch (IllegalAccessException e) {
                throw new JvppeteerException(e);
            }
            parsedObject.add(mappingList);
        }
        return new LocalValue("object", parsedObject);
    }

    private static LocalValue serializeString(Object arg) {
        if (Objects.equals("-0", arg)) {
            return new LocalValue("number", "-0");
        }
        if (Objects.equals("NaN", arg)) {
            return new LocalValue("number", "NaN");
        }
        if (Objects.equals("Infinity", arg)) {
            return new LocalValue("number", "Infinity");
        }
        if (Objects.equals("-Infinity", arg)) {
            return new LocalValue("number", "-Infinity");
        }
        return new LocalValue("string", arg);
    }
}

