/*
 * Decompiled with CFR 0.152.
 */
package com.ruiyun.jvppeteer.bidi.core;

import com.ruiyun.jvppeteer.api.core.Frame;
import com.ruiyun.jvppeteer.api.events.PageEvents;
import com.ruiyun.jvppeteer.bidi.core.BidiFrame;
import com.ruiyun.jvppeteer.bidi.core.BidiRequest;
import com.ruiyun.jvppeteer.bidi.core.BidiResponse;
import com.ruiyun.jvppeteer.bidi.core.BrowsingContext;
import com.ruiyun.jvppeteer.bidi.core.Navigation;
import com.ruiyun.jvppeteer.bidi.core.RequestCore;
import com.ruiyun.jvppeteer.cdp.entities.WaitForOptions;
import com.ruiyun.jvppeteer.common.AwaitableResult;
import com.ruiyun.jvppeteer.common.PuppeteerLifeCycle;
import com.ruiyun.jvppeteer.exception.JvppeteerException;
import com.ruiyun.jvppeteer.util.ValidateUtil;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class BidiLifeCycleWatch {
    private final BidiFrame frame;
    private final WaitForOptions options;
    private final AwaitableResult<Navigation> navigationWaitFor = new AwaitableResult();
    private final AwaitableResult<Boolean> loadWaitFor = new AwaitableResult();
    private final AwaitableResult<Boolean> domWaitFor = new AwaitableResult();
    private final AwaitableResult<Boolean> detachedWaitFor = new AwaitableResult();
    private final AwaitableResult<String> navigationFailedWaitFor = new AwaitableResult();
    private final AwaitableResult<Navigation> navigationFragmentWaitFor = new AwaitableResult();
    private final AwaitableResult<String> navigationErrorWaitFor = new AwaitableResult();
    private final AwaitableResult<Boolean> requestWaitFor = new AwaitableResult();
    private BidiResponse response;
    private final Consumer<Frame> detachedListener;
    private volatile boolean started;

    public BidiLifeCycleWatch(BidiFrame frame, WaitForOptions options) {
        this.frame = frame;
        this.options = options;
        this.detachedListener = detachedFrame -> {
            if (detachedFrame == this.frame || this.frame.detached()) {
                this.detachedWaitFor.complete(true);
            }
        };
        this.startWatch();
    }

    public void startWatch() {
        List<PuppeteerLifeCycle> waitUntil;
        ValidateUtil.assertArg(!this.frame.detached(), "Attempted to use detached Frame " + this.frame.id());
        this.frame.page().trustedEmitter().once(PageEvents.FrameDetached, this.detachedListener);
        Consumer<Navigation> navigationConsumer = navigation -> {
            this.completeNavigation((Navigation)navigation);
            navigation.once(Navigation.NavigationEvents.fragment, info -> this.navigationFragmentWaitFor.complete((Navigation)navigation));
            navigation.once(Navigation.NavigationEvents.failed, info -> this.navigationFailedWaitFor.complete("Navigation fail: " + info.getUrl()));
            navigation.once(Navigation.NavigationEvents.aborted, info -> this.navigationErrorWaitFor.complete("Navigation aborted: " + info.getUrl()));
        };
        this.frame.browsingContext.once(BrowsingContext.BrowsingContextEvents.navigation, navigationConsumer);
        List<PuppeteerLifeCycle> list = waitUntil = Objects.nonNull(this.options.getWaitUntil()) ? this.options.getWaitUntil() : Collections.singletonList(PuppeteerLifeCycle.load);
        if (ValidateUtil.isEmpty(waitUntil)) {
            waitUntil = Collections.singletonList(PuppeteerLifeCycle.load);
        }
        Consumer<Object> loadListener = event -> this.completeLoad();
        Consumer<Object> domListener = event -> this.completeDom();
        waitUntil.forEach(value -> {
            switch (value) {
                case load: {
                    this.frame.browsingContext.once(BrowsingContext.BrowsingContextEvents.load, loadListener);
                    break;
                }
                case domcontentloaded: {
                    this.frame.browsingContext.once(BrowsingContext.BrowsingContextEvents.DOMContentLoaded, domListener);
                }
            }
        });
        if (!waitUntil.contains((Object)PuppeteerLifeCycle.load)) {
            this.completeLoad();
        }
        if (!waitUntil.contains((Object)PuppeteerLifeCycle.domcontentloaded)) {
            this.completeDom();
        }
    }

    private void completeNavigation(Navigation result) {
        this.navigationWaitFor.complete(result);
    }

    private void completeLoad() {
        this.loadWaitFor.complete(true);
    }

    private void completeDom() {
        this.domWaitFor.complete(true);
    }

    private void completeRequest() {
        this.requestWaitFor.complete(true);
    }

    public boolean loadFinished() {
        return this.loadWaitFor.isDone() && this.domWaitFor.isDone();
    }

    public boolean requestFinished() {
        return this.requestWaitFor.isDone();
    }

    private void requestFinished(RequestCore request) {
        if (Objects.nonNull(request)) {
            if (Objects.nonNull(request.response()) || Objects.nonNull(request.error())) {
                this.completeRequest();
            }
            if (Objects.nonNull(request.redirect())) {
                this.requestFinished(request.redirect());
            }
            request.once(RequestCore.RequestCoreEvents.success, info -> this.completeRequest());
            request.once(RequestCore.RequestCoreEvents.error, errorMsg -> this.completeRequest());
            request.once(RequestCore.RequestCoreEvents.redirect, requestCore -> this.completeRequest());
        }
        this.completeRequest();
    }

    public boolean navigationFinished() {
        return this.navigationWaitFor.isDone();
    }

    public boolean checkNavigationFinished() {
        if (this.detachedWaitFor.isDone()) {
            throw new JvppeteerException("Frame detached.");
        }
        if (this.navigationFragmentWaitFor.isDone()) {
            RequestCore request = this.navigationFragmentWaitFor.get().request();
            if (Objects.isNull(request)) {
                this.response = null;
            } else {
                RequestCore lastRequest = request.lastRedirect();
                if (Objects.isNull(lastRequest)) {
                    lastRequest = request;
                }
                BidiRequest httpRequest = BidiRequest.requests.get(lastRequest);
                this.response = httpRequest.response();
            }
            return true;
        }
        if (this.navigationFailedWaitFor.isDone()) {
            throw new JvppeteerException(this.navigationFailedWaitFor.get());
        }
        if (this.navigationErrorWaitFor.isDone()) {
            throw new JvppeteerException(this.navigationErrorWaitFor.get());
        }
        if (this.navigationFinished() && this.loadFinished() && this.requestFinished()) {
            RequestCore request = this.navigationWaitFor.get().request();
            if (Objects.isNull(request)) {
                this.response = null;
            } else {
                RequestCore lastRequest = request.lastRedirect();
                if (Objects.isNull(lastRequest)) {
                    lastRequest = request;
                }
                BidiRequest httpRequest = BidiRequest.requests.get(lastRequest);
                this.response = httpRequest.response();
            }
            return true;
        }
        if (this.navigationWaitFor.isDone() && !this.started) {
            this.requestFinished(this.navigationWaitFor.get().request());
            this.started = true;
        }
        return false;
    }

    public BidiResponse getResponse() {
        return this.response;
    }

    public void dispose() {
        this.frame.page().trustedEmitter().off(PageEvents.FrameDetached, this.detachedListener);
    }
}

